/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.properties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultParameterParser {
    private static final String COMMENT = "#";
    private static final String DATABASE_OVERRIDABLE = "DatabaseOverridable:";
    private static final String TAGS = "Tags:";
    private static final String TYPE = "Type:";
    private String propertiesFilePath;
    private InputStream inputStream;
    final Logger log = LoggerFactory.getLogger(this.getClass());

    public DefaultParameterParser(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public DefaultParameterParser(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
    }

    public Map<String, ParameterMetaData> parse() {
        return this.parse(this.propertiesFilePath);
    }

    public Map<String, ParameterMetaData> parse(String fileName) {
        TreeMap<String, ParameterMetaData> metaData = new TreeMap<String, ParameterMetaData>();
        try {
            if (this.inputStream == null) {
                this.inputStream = this.getClass().getResourceAsStream(fileName);
            }
            List lines = IOUtils.readLines((InputStream)this.inputStream, (Charset)Charset.defaultCharset());
            boolean extraLine = false;
            ParameterMetaData currentMetaData = new ParameterMetaData();
            for (String line : lines) {
                if (extraLine) {
                    extraLine = false;
                    if (currentMetaData != null) {
                        if (line.endsWith("\\")) {
                            extraLine = true;
                            line = line.substring(0, line.length() - 1);
                        }
                        line = StringEscapeUtils.unescapeJava((String)line);
                        currentMetaData.setDefaultValue(currentMetaData.getDefaultValue() + line);
                    }
                    if (extraLine) continue;
                    currentMetaData = new ParameterMetaData();
                    continue;
                }
                if (line.trim().startsWith(COMMENT) && line.length() > 1) {
                    if ((line = line.substring(line.indexOf(COMMENT) + 1)).contains(DATABASE_OVERRIDABLE)) {
                        currentMetaData.setDatabaseOverridable(Boolean.parseBoolean(line.substring(line.indexOf(DATABASE_OVERRIDABLE) + DATABASE_OVERRIDABLE.length()).trim()));
                        continue;
                    }
                    if (line.contains(TAGS)) {
                        String[] tags;
                        for (String tag : tags = line.substring(line.indexOf(TAGS) + TAGS.length()).trim().split(",")) {
                            currentMetaData.addTag(tag.trim());
                        }
                        continue;
                    }
                    if (line.contains(TYPE)) {
                        String type = line.substring(line.indexOf(TYPE) + TYPE.length());
                        currentMetaData.setType(type.trim());
                        continue;
                    }
                    currentMetaData.appendDescription(line);
                    continue;
                }
                if (!line.trim().startsWith(COMMENT) && line.contains("=")) {
                    String key = line.substring(0, line.indexOf("="));
                    String defaultValue = line.substring(line.indexOf("=") + 1);
                    currentMetaData.setKey(key);
                    if (defaultValue.endsWith("\\")) {
                        extraLine = true;
                        defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                    }
                    defaultValue = StringEscapeUtils.unescapeJava((String)defaultValue);
                    currentMetaData.setDefaultValue(defaultValue);
                    metaData.put(key, currentMetaData);
                    if (extraLine) continue;
                    currentMetaData = new ParameterMetaData();
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)line)) continue;
                currentMetaData = new ParameterMetaData();
            }
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
        }
        return metaData;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: <input_properties_file> <output_docbook_file> [true|false]");
        }
        ArrayList<DefaultParameterParser> parmParsers = new ArrayList<DefaultParameterParser>();
        if (args[0].startsWith("classpath:")) {
            for (String path : paths = args[0].replaceAll("classpath:", "").split(",")) {
                parmParsers.add(new DefaultParameterParser(path));
            }
        } else {
            for (String path : paths = args[0].split(",")) {
                parmParsers.add(new DefaultParameterParser(FileUtils.openInputStream((File)new File(path))));
            }
        }
        File file = new File(args[1]);
        file.getParentFile().mkdirs();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean isDatabaseOverridable = Boolean.parseBoolean(args[2]);
        boolean isAsciiDocFormat = args.length > 3 && "asciidoc".equals(args[3]);
        TreeMap<String, ParameterMetaData> map = new TreeMap<String, ParameterMetaData>();
        for (DefaultParameterParser parser : parmParsers) {
            map.putAll(parser.parse());
        }
        if (!isAsciiDocFormat) {
            writer.write("<variablelist>\n");
        }
        for (ParameterMetaData parm : map.values()) {
            if ((!isDatabaseOverridable || !parm.isDatabaseOverridable()) && (isDatabaseOverridable || parm.isDatabaseOverridable())) continue;
            if (!isAsciiDocFormat) {
                writer.write("<varlistentry>\n<term><command>" + parm.getKey() + "</command></term>\n");
                writer.write("<listitem><para>" + parm.getDescription() + " [ Default: " + (parm.isXmlType() ? StringEscapeUtils.escapeXml10((String)parm.getDefaultValue()) : parm.getDefaultValue()) + " ]</para></listitem>\n</varlistentry>\n");
                continue;
            }
            writer.write(parm.getKey() + ":: " + parm.getDescription() + "\n\n_Default:_ " + (parm.isXmlType() ? "\n\n[source, xml]\n----\n" + parm.getDefaultValue() + "\n----\n\n" : (String)(StringUtils.isBlank((CharSequence)parm.getDefaultValue()) ? "" : "_" + parm.getDefaultValue() + "_") + "\n\n"));
        }
        if (!isAsciiDocFormat) {
            writer.write("</variablelist>\n");
        }
        ((Writer)writer).close();
    }

    public static class ParameterMetaData
    implements Serializable {
        public static final String TYPE_BOOLEAN = "boolean";
        public static final String TYPE_INT = "integer";
        public static final String TYPE_TEXT_BOX = "textbox";
        public static final String TYPE_SQL = "sql";
        public static final String TYPE_CODE = "code";
        public static final String TYPE_XML = "xml";
        public static final String TYPE_ENCRYPTED = "encrypted";
        public static final String TAG_TRIGGER = "trigger";
        private static final long serialVersionUID = 1L;
        private String key;
        private String description;
        private Set<String> tags = new HashSet<String>();
        private boolean databaseOverridable;
        private String defaultValue;
        private String type = "";

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public void setTags(Set<String> tags) {
            this.tags = tags;
        }

        public boolean isDatabaseOverridable() {
            return this.databaseOverridable;
        }

        public void setDatabaseOverridable(boolean databaseOverridable) {
            this.databaseOverridable = databaseOverridable;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void appendDescription(String value) {
            this.description = this.description == null ? value : this.description + value;
        }

        public boolean isXmlType() {
            return this.type != null && this.type.equals(TYPE_XML);
        }

        public boolean isSqlType() {
            return this.type != null && this.type.equals(TYPE_SQL);
        }

        public boolean isCodeType() {
            return this.type != null && this.type.equals(TYPE_CODE);
        }

        public boolean isBooleanType() {
            return this.type != null && this.type.equals(TYPE_BOOLEAN);
        }

        public boolean isIntType() {
            return this.type != null && this.type.equals(TYPE_INT);
        }

        public boolean isTextBoxType() {
            return this.type != null && this.type.equals(TYPE_TEXT_BOX);
        }

        public boolean isEncryptedType() {
            return this.type != null && this.type.equals(TYPE_ENCRYPTED);
        }

        public void addTag(String tag) {
            this.tags.add(tag);
        }
    }
}

