/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.security;

import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityServiceFactory {
    protected static Logger log = LoggerFactory.getLogger(SecurityServiceFactory.class);

    public static ISecurityService create() {
        return SecurityServiceFactory.create(SecurityServiceType.CLIENT, null);
    }

    public static ISecurityService create(SecurityServiceType serviceType, TypedProperties properties) {
        try {
            String className;
            if (properties == null) {
                properties = new TypedProperties(System.getProperties());
            }
            log.debug("security class name from properties: {}", (Object)((className = properties.get("security.service.class.name")) == null ? "null" : className));
            if (className == null || className.trim().equals("")) {
                className = serviceType == SecurityServiceType.SERVER ? "org.jumpmind.security.BouncyCastleSecurityService" : SecurityService.class.getName();
            }
            log.debug("Instantiating security using class name: {}", (Object)className);
            ISecurityService securityService = (ISecurityService)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            securityService.init();
            return securityService;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum SecurityServiceType {
        CLIENT,
        SERVER;

    }
}

