/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.util.HashMap;
import java.util.Map;

public class Statistics {
    Map<String, Long> stats = new HashMap<String, Long>();
    Map<String, Long> timers = new HashMap<String, Long>();
    Map<String, Map<String, Long>> tableStats = new HashMap<String, Map<String, Long>>();

    public void increment(String category) {
        this.increment(category, 1L);
    }

    public long get(String category) {
        Long value = this.stats.get(category);
        if (value != null) {
            return value;
        }
        return 0L;
    }

    public void set(String category, long value) {
        this.stats.put(category, value);
    }

    public boolean contains(String category) {
        return this.stats.containsKey(category);
    }

    public void increment(String category, long increment) {
        Long value = this.stats.get(category);
        value = value == null ? Long.valueOf(increment) : Long.valueOf(value + increment);
        this.stats.put(category, value);
    }

    public void incrementTableStats(String tableName, String dmlType, long increment) {
        Long value;
        Map<String, Long> tableStatMap = this.tableStats.get(tableName);
        if (tableStatMap == null) {
            tableStatMap = new HashMap<String, Long>();
        }
        value = (value = tableStatMap.get(dmlType)) == null ? Long.valueOf(increment) : Long.valueOf(value + increment);
        tableStatMap.put(dmlType, value);
        this.tableStats.put(tableName, tableStatMap);
    }

    public Map<String, Map<String, Long>> getTableStats() {
        return this.tableStats;
    }

    public void startTimer(String category) {
        this.timers.put(category, System.currentTimeMillis());
    }

    public long stopTimer(String category) {
        long time = 0L;
        Long startTime = this.timers.get(category);
        if (startTime != null) {
            time = System.currentTimeMillis() - startTime;
            this.increment(category, time);
        }
        this.timers.remove(category);
        return time;
    }

    public String toString() {
        return this.stats.toString();
    }
}

