/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mssql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.mssql.MsSqlTriggerTemplate;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IParameterService;

public class MsSqlSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    protected static final String SQL_DROP_FUNCTION = "drop function dbo.$(functionName)";
    protected static final String SQL_FUNCTION_INSTALLED = "select count(object_name(object_id('$(functionName)')))";
    static final String SQL_NOCOUNT = "select @@OPTIONS & 512";
    protected Boolean supportsDisableTriggers = null;
    protected int noCount = 0;

    public MsSqlSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new MsSqlTriggerTemplate(this);
        try {
            this.noCount = platform.getSqlTemplate().queryForInt(SQL_NOCOUNT, new Object[0]);
        }
        catch (Exception se) {
            this.log.warn("Unable to query nocount", (Throwable)se);
        }
        if (this.noCount != 0) {
            throw new SymmetricException("Incompatible setting for nocount detected.  Add the following to your\r\nengine properties file: db.init.sql=set nocount off", new Object[0]);
        }
    }

    public Database readSymmetricSchemaFromXml() {
        Database db = super.readSymmetricSchemaFromXml();
        if (this.parameterService.is("mssql.use.ntypes.for.sync")) {
            Table symTable = db.findTable(TableConstants.getTableName((String)this.getTablePrefix(), (String)"data"));
            this.setColumnToNtext(symTable.getColumnWithName("row_data"));
            this.setColumnToNtext(symTable.getColumnWithName("old_data"));
            this.setColumnToNtext(symTable.getColumnWithName("pk_data"));
        }
        if (this.parameterService.is("mssql.use.varchar.for.lob.in.sync")) {
            for (Table table : db.getTables()) {
                for (Column column : table.getColumns()) {
                    if (column.getMappedTypeCode() != -16 && column.getMappedTypeCode() != -1) continue;
                    this.setColumnToVarChar(column, this.parameterService.is("mssql.use.ntypes.for.sync"));
                }
            }
        }
        return db;
    }

    protected void setColumnToNtext(Column column) {
        column.setMappedType("LONGNVARCHAR");
    }

    protected void setColumnToVarChar(Column column, boolean forceNtype) {
        if (column.getMappedTypeCode() == -16 || forceNtype && column.getMappedTypeCode() == -1) {
            column.setMappedType("NVARCHAR");
        } else if (column.getMappedTypeCode() == -1) {
            column.setMappedType("VARCHAR");
        }
        column.setSize("100000");
    }

    public boolean createOrAlterTablesIfNecessary(String ... tableNames) {
        boolean altered = super.createOrAlterTablesIfNecessary(tableNames);
        return altered |= this.alterLockEscalation();
    }

    protected boolean alterLockEscalation() {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        String tablePrefix = this.getTablePrefix();
        try {
            String lockEscalationClause = "";
            if (this.parameterService.is("mssql.lock.escalation.disabled", true)) {
                lockEscalationClause = "or t.lock_escalation != 1  or i.allow_page_locks = 'true' ";
            }
            if (this.parameterService.is("mssql.allow.only.row.level.locks.on.runtime.tables", true) && sqlTemplate.queryForInt("select count(*) from sys.indexes i inner join sys.tables t on t.object_id=i.object_id where t.name in ('" + tablePrefix.toLowerCase() + "_outgoing_batch','" + tablePrefix.toLowerCase() + "_data', '" + tablePrefix.toLowerCase() + "_data_event', '" + tablePrefix.toLowerCase() + "_monitor_event', '" + tablePrefix.toLowerCase() + "_table_reload_status', '" + tablePrefix.toLowerCase() + "_extract_request', '" + tablePrefix.toLowerCase() + "_table_reload_request', '" + tablePrefix.toLowerCase() + "_trigger_hist') and (i.allow_row_locks !='true' " + lockEscalationClause + ")", new Object[0]) > 0) {
                this.log.info("Updating indexes to prevent lock escalation");
                String dataTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_data");
                String dataEventTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_data_event");
                String outgoingBatchTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_outgoing_batch");
                String monitorEventTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_monitor_event");
                String tableReloadStatusTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_table_reload_status");
                String extractRequestTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_extract_request");
                String tableReloadRequestTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_table_reload_request");
                String triggerHistTable = this.platform.alterCaseToMatchDatabaseDefaultCase(tablePrefix + "_trigger_hist");
                sqlTemplate.update("ALTER INDEX ALL ON " + dataTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                sqlTemplate.update("ALTER INDEX ALL ON " + dataEventTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                sqlTemplate.update("ALTER INDEX ALL ON " + outgoingBatchTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                sqlTemplate.update("ALTER INDEX ALL ON " + monitorEventTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                sqlTemplate.update("ALTER INDEX ALL ON " + tableReloadStatusTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                sqlTemplate.update("ALTER INDEX ALL ON " + extractRequestTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                sqlTemplate.update("ALTER INDEX ALL ON " + tableReloadRequestTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                sqlTemplate.update("ALTER INDEX ALL ON " + triggerHistTable + " SET (ALLOW_ROW_LOCKS = ON)", new Object[0]);
                if (this.parameterService.is("mssql.lock.escalation.disabled", true)) {
                    sqlTemplate.update("ALTER INDEX ALL ON " + dataTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER INDEX ALL ON " + dataEventTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER INDEX ALL ON " + outgoingBatchTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER INDEX ALL ON " + monitorEventTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER INDEX ALL ON " + tableReloadStatusTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER INDEX ALL ON " + extractRequestTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER INDEX ALL ON " + tableReloadRequestTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER INDEX ALL ON " + triggerHistTable + " SET (ALLOW_PAGE_LOCKS = OFF)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + dataTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + dataEventTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + outgoingBatchTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + monitorEventTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + tableReloadStatusTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + extractRequestTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + tableReloadRequestTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                    sqlTemplate.update("ALTER TABLE " + triggerHistTable + " SET (LOCK_ESCALATION = DISABLE)", new Object[0]);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.warn("Failed to disable lock escalation");
            this.log.debug("", (Throwable)e);
            return false;
        }
    }

    public void verifyDatabaseIsCompatible() {
        super.verifyDatabaseIsCompatible();
        ISqlTemplate template = this.getPlatform().getSqlTemplate();
        if (template.queryForInt("select case when (512 & @@options) = 512 then 1 else 0 end", new Object[0]) == 1) {
            throw new SymmetricException("NOCOUNT is currently turned ON.  SymmetricDS will not function with NOCOUNT turned ON.", new Object[0]);
        }
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        this.createBase64EncodeFunction(ddl);
        this.createTriggersDisabledFunction(ddl);
        this.createNodeDisabledFunction(ddl);
    }

    protected void createBase64EncodeFunction(StringBuilder ddl) {
        String encode = this.parameterService.getTablePrefix() + "_base64_encode";
        if (!this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            String sql = "create function dbo.$(functionName)(@data varbinary(max)) returns varchar(max)                                                                                                                         \n  with schemabinding, returns null on null input                                                                                                                       \n  begin                                                                                                                                                                \n    return ( select [text()] = @data for xml path('') )                                                                                                                \n  end                                                                                                                                                                  ";
            this.install(sql, encode, ddl);
        }
    }

    protected void createTriggersDisabledFunction(StringBuilder ddl) {
        String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
        if (!this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled)) {
            String sql = "create function dbo.$(functionName)() returns smallint                                                                                                                                                 \n  begin                                                                                                                                                                  \n    declare @disabled varchar(1);                                                                                                                                        \n    set @disabled = coalesce(replace(substring(cast(context_info() as varchar), 1, 1), 0x0, ''), '');                                                                    \n    if @disabled is null or @disabled != '1'                                                                                                                             \n      return 0;                                                                                                                                                          \n    return 1;                                                                                                                                                            \n  end                                                                                                                                                                    ";
            this.install(sql, triggersDisabled, ddl);
        }
    }

    protected void createNodeDisabledFunction(StringBuilder ddl) {
        String nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled";
        if (!this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled)) {
            String sql = "create function dbo.$(functionName)() returns varchar(50)                                                                                                                                              \n  begin                                                                                                                                                                  \n    declare @node varchar(50);                                                                                                                                           \n    set @node = coalesce(replace(substring(cast(context_info() as varchar) collate SQL_Latin1_General_CP1_CI_AS, 2, 50), 0x0, ''), '');                                  \n    return @node;                                                                                                                                                        \n  end                                                                                                                                                                    ";
            this.install(sql, nodeDisabled, ddl);
        }
    }

    public void dropRequiredDatabaseObjects() {
        this.dropBase64EncodeFunction();
        this.dropTriggersDisabledFunction();
        this.dropNodeDisabledFunction();
    }

    protected void dropBase64EncodeFunction() {
        String encode = this.parameterService.getTablePrefix() + "_base64_encode";
        if (this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            this.uninstall(SQL_DROP_FUNCTION, encode);
        }
    }

    protected void dropTriggersDisabledFunction() {
        String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
        if (this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled)) {
            this.uninstall(SQL_DROP_FUNCTION, triggersDisabled);
        }
    }

    protected void dropNodeDisabledFunction() {
        String nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled";
        if (this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled)) {
            this.uninstall(SQL_DROP_FUNCTION, nodeDisabled);
        }
    }

    protected boolean supportsDisableTriggers() {
        if (this.supportsDisableTriggers == null) {
            try {
                this.getPlatform().getSqlTemplate().update("set context_info 0x0", new Object[0]);
                this.log.info("This database DOES support disabling triggers during a symmetricds data load");
                this.supportsDisableTriggers = true;
            }
            catch (Exception ex) {
                this.log.warn("This database does NOT support disabling triggers during a symmetricds data load");
                this.supportsDisableTriggers = false;
            }
        }
        return this.supportsDisableTriggers == null ? false : this.supportsDisableTriggers;
    }

    public void removeTrigger(StringBuilder sqlBuffer, final String catalogName, String schemaName, final String triggerName, String tableName, ISqlTransaction transaction) {
        schemaName = StringUtils.isBlank((CharSequence)schemaName) ? "" : this.platform.getDatabaseInfo().getDelimiterToken() + schemaName + this.platform.getDatabaseInfo().getDelimiterToken() + ".";
        final String sql = "drop trigger " + schemaName + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
            ((JdbcSqlTransaction)transaction).executeCallback((IConnectionCallback)new IConnectionCallback<Boolean>(){

                public Boolean execute(Connection con) throws SQLException {
                    String previousCatalog = con.getCatalog();
                    Statement stmt = null;
                    try {
                        if (StringUtils.isNotBlank((CharSequence)catalogName)) {
                            con.setCatalog(catalogName);
                        }
                        stmt = con.createStatement();
                        stmt.execute(sql);
                    }
                    catch (Exception e) {
                        MsSqlSymmetricDialect.this.log.warn("Error removing {}: {}", (Object)triggerName, (Object)e.getMessage());
                        throw e;
                    }
                    finally {
                        if (StringUtils.isNotBlank((CharSequence)catalogName) && StringUtils.isNotBlank((CharSequence)previousCatalog)) {
                            con.setCatalog(previousCatalog);
                        }
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    return Boolean.FALSE;
                }
            });
        }
    }

    protected String switchCatalogForTriggerInstall(String catalog, ISqlTransaction transaction) {
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            Connection c = ((JdbcSqlTransaction)transaction).getConnection();
            String previousCatalog = null;
            try {
                previousCatalog = c.getCatalog();
                c.setCatalog(catalog);
                return previousCatalog;
            }
            catch (SQLException e) {
                if (StringUtils.isNotBlank((CharSequence)catalog) && StringUtils.isNotBlank((CharSequence)previousCatalog)) {
                    try {
                        c.setCatalog(previousCatalog);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new SqlException((Throwable)e);
            }
        }
        return null;
    }

    protected void postCreateTrigger(ISqlTransaction transaction, StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory hist, Channel channel, String tablePrefix, Table table) {
        if (this.parameterService.is("mssql.trigger.order.first", false)) {
            String triggerNameFirst;
            Object schemaName = "";
            if (StringUtils.isNotBlank((CharSequence)trigger.getSourceSchemaName())) {
                schemaName = trigger.getSourceSchemaName() + ".";
            }
            if (StringUtils.isNotBlank((CharSequence)(triggerNameFirst = (String)transaction.queryForObject("select tr.name from sys.triggers tr with (nolock) inner join sys.trigger_events te with (nolock) on te.object_id = tr.object_id inner join sys.tables t with (nolock) on t.object_id = tr.parent_id where t.name = ? and te.type_desc = ? and te.is_first = 1", String.class, new Object[]{table.getName(), dml.name()})))) {
                String sql = "exec sys.sp_settriggerorder @triggername = '" + (String)schemaName + triggerNameFirst + "', @order = 'None', @stmttype = '" + dml.name() + "'";
                this.logSql(sql, sqlBuffer);
                if (sqlBuffer == null) {
                    this.log.warn("Existing first trigger '{}{}' is being set to order of 'None'", schemaName, (Object)triggerNameFirst);
                    transaction.execute(sql);
                }
            }
            String triggerName = null;
            triggerName = dml == DataEventType.INSERT ? hist.getNameForInsertTrigger() : (dml == DataEventType.UPDATE ? hist.getNameForUpdateTrigger() : hist.getNameForDeleteTrigger());
            String sql = "exec sys.sp_settriggerorder @triggername = '" + (String)schemaName + triggerName + "', @order = 'First', @stmttype = '" + dml.name() + "'";
            this.logSql(sql, sqlBuffer);
            if (sqlBuffer == null) {
                transaction.execute(sql);
            }
        }
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, final String catalogName, String schema, String tableName, final String triggerName) {
        return (Boolean)((JdbcSqlTemplate)this.platform.getSqlTemplate()).execute((IConnectionCallback)new IConnectionCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean execute(Connection con) throws SQLException {
                String previousCatalog = con.getCatalog();
                PreparedStatement stmt = con.prepareStatement("select count(*) from sysobjects where type = 'TR' AND name = ?");
                try {
                    if (StringUtils.isNotBlank((CharSequence)catalogName)) {
                        con.setCatalog(catalogName);
                    }
                    stmt.setString(1, triggerName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        int count = rs.getInt(1);
                        Boolean bl = count > 0;
                        return bl;
                    }
                }
                finally {
                    if (StringUtils.isNotBlank((CharSequence)catalogName) && StringUtils.isNotBlank((CharSequence)previousCatalog)) {
                        con.setCatalog(previousCatalog);
                    }
                    stmt.close();
                }
                return Boolean.FALSE;
            }
        });
    }

    public void removeDdlTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName) {
        String sql = "drop trigger " + triggerName + " on database";
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            try {
                this.log.info("Removing DDL trigger " + triggerName);
                this.platform.getSqlTemplate().update(sql, new Object[0]);
            }
            catch (Exception e) {
                this.log.warn("Tried to remove DDL trigger using: {} and failed because: {}", (Object)sql, (Object)e.getMessage());
            }
        }
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        if (this.supportsDisableTriggers()) {
            if (nodeId == null) {
                nodeId = "";
            }
            transaction.prepareAndExecute("DECLARE @CI VarBinary(128);SET @CI=cast ('1" + nodeId + "' as varbinary(128));SET context_info @CI;", new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        if (this.supportsDisableTriggers()) {
            transaction.prepareAndExecute("set context_info 0x0", new Object[0]);
        }
    }

    public String getSyncTriggersExpression() {
        String catalog = this.parameterService.is("mssql.include.catalog.in.triggers", true) ? "$(defaultCatalog)" : "";
        return catalog + "dbo." + this.parameterService.getTablePrefix() + "_triggers_disabled() = 0";
    }

    public String getSyncTriggersOnIncomingExpression() {
        String catalog = this.parameterService.is("mssql.include.catalog.in.triggers", true) ? "$(defaultCatalog)" : "";
        return catalog + "dbo." + this.parameterService.getTablePrefix() + "_triggers_disabled() != 2";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "@TransactionId";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public boolean isTransactionIdOverrideSupported() {
        return false;
    }

    public void cleanDatabase() {
    }

    public boolean needsToSelectLobData() {
        return true;
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "$(anyNonBlobColumnChanged)";
    }

    public long getCurrentSequenceValue(SequenceIdentifier identifier) {
        return this.platform.getSqlTemplate().queryForLong("select ident_current('" + this.parameterService.getTablePrefix() + "_" + identifier + "')", new Object[0]);
    }

    public PermissionType[] getSymTablePermissions() {
        PermissionType[] permissions = new PermissionType[]{PermissionType.CREATE_TABLE, PermissionType.DROP_TABLE, PermissionType.CREATE_TRIGGER, PermissionType.DROP_TRIGGER, PermissionType.CREATE_FUNCTION};
        return permissions;
    }
}

