/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.mysql.MySqlTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.FormatUtils;

public class MySqlSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    private static final String PRE_5_1_23 = "_pre_5_1_23";
    private static final String PRE_5_7_6 = "_pre_5_7_6";
    private static final String POST_5_7_6 = "_post_5_7_6";
    private static final String TRANSACTION_ID = "transaction_id";
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "@sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "@sync_node_disabled";
    static final String SQL_DROP_FUNCTION = "drop function $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from information_schema.routines where routine_name='$(functionName)' and routine_schema in (select database())";
    static final String SQL_FUNCTION_EQUALS = "select count(*) from information_schema.routines where routine_name='$(functionName)' and routine_schema in (select database()) and trim(routine_definition)=trim('$(functionBody)')";
    private String functionTemplateKeySuffix = null;
    private boolean isConvertZeroDateToNull;
    private String characterSet;

    public MySqlSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        String defaultEngine;
        this.parameterService = parameterService;
        String version = this.getProductVersion();
        if (!(Version.isOlderThanVersion((String)version, (String)"5.1.5") || platform.getName().equals("singlestore") || StringUtils.equalsIgnoreCase((CharSequence)(defaultEngine = platform.getSqlTemplate().queryForString("select engine from information_schema.engines where support='DEFAULT';", new Object[0])), (CharSequence)"innodb"))) {
            String message = "Please ensure that the default storage engine is set to InnoDB";
            throw new SymmetricException(message, new Object[0]);
        }
        if (parameterService.getString("db.url").contains("zeroDateTimeBehavior=convertToNull")) {
            try {
                String sqlMode = platform.getSqlTemplate().queryForString("select @@sql_mode", new Object[0]);
                boolean bl = this.isConvertZeroDateToNull = sqlMode == null || !sqlMode.contains("NO_ZERO_DATE") && !sqlMode.contains("NO_ZERO_IN_DATE");
                if (this.isConvertZeroDateToNull) {
                    this.log.info("Zero dates will be converted to null");
                }
            }
            catch (Exception e) {
                this.log.warn("Cannot convert zero dates to null because unable to verify sql_mode: {}", (Object)e.getMessage());
            }
        }
        this.functionTemplateKeySuffix = Version.isOlderThanVersion((String)version, (String)"5.1.23") ? PRE_5_1_23 : (Version.isOlderThanVersion((String)version, (String)"5.7.6") ? PRE_5_7_6 : POST_5_7_6);
        this.characterSet = parameterService.getString("db.master.collation", Version.isOlderThanVersion((String)this.getProductVersion(), (String)"5.5.3") ? "utf8" : "utf8mb4");
        this.triggerTemplate = new MySqlTriggerTemplate(this, this.isConvertZeroDateToNull, this.characterSet);
        platform.getDatabaseInfo().setGeneratedColumnsSupported(!Version.isOlderThanVersion((String)version, (String)"5.7.0"));
        platform.getDatabaseInfo().setExpressionsAsDefaultValuesSupported(!Version.isOlderThanVersion((String)version, (String)"8.0.13"));
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        String function = null;
        String functionBody = null;
        String sql = null;
        if (this.functionTemplateKeySuffix.equals(PRE_5_1_23)) {
            function = this.parameterService.getTablePrefix() + "_transaction_id" + this.functionTemplateKeySuffix;
            functionBody = " begin                                                         declare comm_name varchar(50);                                                         declare comm_value varchar(50);                                                         declare comm_cur cursor for show status like 'Com_commit';                                                         if @@autocommit = 0 then                                                         open comm_cur;                                                         fetch comm_cur into comm_name, comm_value;                                                         close comm_cur;                                                         return concat(concat(connection_id(), '.'), comm_value);                                                         else                                                         return null;                                                         end if;                                                           end                                                             ";
            sql = "create function $(functionName)()                                                         returns varchar(50) NOT DETERMINISTIC READS SQL DATA                                                        " + functionBody;
        } else if (this.functionTemplateKeySuffix.equals(PRE_5_7_6)) {
            function = this.parameterService.getTablePrefix() + "_transaction_id" + this.functionTemplateKeySuffix;
            functionBody = " begin                                                                                                                          \n    declare comm_value varchar(50);                                                                                             \n    declare comm_cur cursor for select VARIABLE_VALUE from INFORMATION_SCHEMA.SESSION_STATUS where VARIABLE_NAME='COM_COMMIT';  \n    open comm_cur;                                                                                                              \n    fetch comm_cur into comm_value;                                                                                             \n    close comm_cur;                                                                                                             \n    return concat(concat(connection_id(), '.'), comm_value);                                                                    \n end                                                                                                                            ";
            sql = "create function $(functionName)()                                                                                          \n returns varchar(50) NOT DETERMINISTIC READS SQL DATA                                                                           \n" + functionBody;
        } else {
            function = this.parameterService.getTablePrefix() + "_transaction_id" + this.functionTemplateKeySuffix;
            functionBody = " begin                                                                                                                           \n    declare done int default 0;                                                                                                  \n    declare comm_value varchar(50);                                                                                              \n    declare comm_cur cursor for select TRX_ID from INFORMATION_SCHEMA.INNODB_TRX where TRX_MYSQL_THREAD_ID = CONNECTION_ID();    \n    declare continue handler for not found set done = 1;                                                                         \n    open comm_cur;                                                                                                               \n    fetch comm_cur into comm_value;                                                                                              \n    close comm_cur;                                                                                                              \n    return concat(concat(connection_id(), '.'), comm_value);                                                                     \n end                                                                                                                             ";
            sql = "create function $(functionName)()                                                                                           \n returns varchar(50) NOT DETERMINISTIC READS SQL DATA                                                                            \n" + functionBody;
        }
        if (!this.functionEquals(SQL_FUNCTION_EQUALS, function, functionBody)) {
            if (this.installed(SQL_FUNCTION_INSTALLED, function)) {
                this.uninstall(SQL_DROP_FUNCTION, function, ddl);
            }
            this.install(sql, function, ddl);
        }
    }

    private boolean functionEquals(String sqlFunctionEquals, String functionName, String functionBody) {
        return this.platform.getSqlTemplate().queryForInt(this.replaceTokens(sqlFunctionEquals, functionName, functionBody), new Object[0]) > 0;
    }

    private String replaceTokens(String sql, String objectName, String functionBody) {
        String ddl = super.replaceTokens(sql, objectName);
        ddl = FormatUtils.replace((String)"functionBody", (String)StringUtils.replace((String)functionBody, (String)"'", (String)"''"), (String)ddl);
        return ddl;
    }

    public void dropRequiredDatabaseObjects() {
        String function = this.parameterService.getTablePrefix() + "_transaction_id" + this.functionTemplateKeySuffix;
        if (this.installed(SQL_FUNCTION_INSTALLED, function)) {
            this.uninstall(SQL_DROP_FUNCTION, function);
        }
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalog, String schema, String tableName, String triggerName) {
        catalog = catalog == null ? (this.platform.getDefaultCatalog() == null ? null : this.platform.getDefaultCatalog()) : catalog;
        String checkCatalogSql = catalog != null && catalog.length() > 0 ? " and trigger_schema='" + catalog + "'" : "";
        return this.platform.getSqlTemplate().queryForInt("select count(*) from information_schema.triggers where trigger_name like ? and event_object_table like ?" + checkCatalogSql, new Object[]{triggerName, tableName}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        String quote = this.platform.getDatabaseInfo().getDelimiterToken();
        String catalogPrefix = StringUtils.isBlank((CharSequence)catalogName) ? "" : quote + catalogName + quote + ".";
        String sql = "drop trigger if exists " + catalogPrefix + triggerName;
        if (Version.isOlderThanVersion((String)this.getProductVersion(), (String)"5.0.32")) {
            sql = "drop trigger " + catalogPrefix + triggerName;
        }
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
            transaction.execute(sql);
        }
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("set @sync_triggers_disabled=1", new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute("set @sync_node_disabled='" + nodeId + "'", new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("set @sync_triggers_disabled=null", new Object[0]);
        transaction.prepareAndExecute("set @sync_node_disabled=null", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "@sync_triggers_disabled is null";
    }

    public String getSyncTriggersOnIncomingExpression() {
        return "coalesce(@sync_triggers_disabled, 0) != 2";
    }

    private final String getTransactionFunctionName() {
        return SymmetricUtils.quote((ISymmetricDialect)this, (String)this.platform.getDefaultCatalog()) + "." + this.parameterService.getTablePrefix() + "_transaction_id" + this.functionTemplateKeySuffix;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.getTransactionFunctionName() + "()";
    }

    public String getTransactionId(ISqlTransaction transaction) {
        String gtid;
        int index;
        List list;
        String xid = null;
        if (this.supportsTransactionId() && (list = transaction.query("select @@gtid_executed", (ISqlRowMapper)new StringMapper(), null, null)) != null && list.size() > 0 && (index = (gtid = (String)list.get(0)).indexOf(58)) != -1) {
            xid = gtid.substring(index + 1);
        }
        return xid;
    }

    public void cleanDatabase() {
    }

    protected String switchCatalogForTriggerInstall(String catalog, ISqlTransaction transaction) {
        if (catalog != null) {
            Connection c = ((JdbcSqlTransaction)transaction).getConnection();
            try {
                String previousCatalog = c.getCatalog();
                c.setCatalog(catalog);
                return previousCatalog;
            }
            catch (SQLException e) {
                throw new SqlException((Throwable)e);
            }
        }
        return null;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "var_old_data is null or var_row_data != var_old_data";
    }

    public long getCurrentSequenceValue(SequenceIdentifier identifier) {
        return this.platform.getSqlTemplate().queryForLong("select auto_increment from information_schema.tables where table_schema = ? and table_name = ?", new Object[]{this.platform.getDefaultCatalog(), this.parameterService.getTablePrefix() + "_" + identifier});
    }

    public PermissionType[] getSymTablePermissions() {
        PermissionType[] permissions = new PermissionType[]{PermissionType.CREATE_TABLE, PermissionType.DROP_TABLE, PermissionType.CREATE_TRIGGER, PermissionType.DROP_TRIGGER, PermissionType.CREATE_ROUTINE};
        return permissions;
    }

    public Database readSymmetricSchemaFromXml() {
        Database database = super.readSymmetricSchemaFromXml();
        if (Version.isOlderThanVersion((String)this.getProductVersion(), (String)"5.5")) {
            String prefix = this.parameterService.getTablePrefix() + "_";
            this.reconfigureTableColumn(database, prefix, "file_snapshot", "relative_dir", "55");
            this.reconfigureTableColumn(database, prefix, "file_snapshot", "file_name", "55");
            this.reconfigureTableColumn(database, prefix, "file_incoming", "relative_dir", "55");
            this.reconfigureTableColumn(database, prefix, "file_incoming", "file_name", "55");
        }
        return database;
    }

    protected void reconfigureTableColumn(Database database, String prefix, String tableName, String columnName, String size) {
        Column column;
        Table table = database.findTable(prefix + tableName);
        if (table != null && (column = table.findColumn(columnName)) != null) {
            column.setSize(size);
        }
    }
}

