/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mysql;

import java.util.HashMap;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.util.SymmetricUtils;

public class MySqlTriggerTemplate
extends AbstractTriggerTemplate {
    public MySqlTriggerTemplate(ISymmetricDialect symmetricDialect, boolean isConvertZeroDateToNull, String characterSet) {
        super(symmetricDialect);
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "cast(if($(tableAlias).`$(columnName)` is null,'',concat('\"',replace(replace($(tableAlias).`$(columnName)`,'\\\\','\\\\\\\\'),'\"','\\\\\"'),'\"')) as char)\n";
        this.geometryColumnTemplate = "if($(tableAlias).`$(columnName)` is null,'',concat('\"',replace(replace(astext($(tableAlias).`$(columnName)`),'\\\\','\\\\\\\\'),'\"','\\\\\"'),'\"'))\n";
        this.numberColumnTemplate = "if($(tableAlias).`$(columnName)` is null,'',concat('\"',cast($(tableAlias).`$(columnName)` as char),'\"'))\n";
        this.datetimeColumnTemplate = "if($(tableAlias).`$(columnName)` is null" + (isConvertZeroDateToNull ? " or $(tableAlias).`$(columnName)` = '0000-00-00'" : "") + ",'',concat('\"',cast($(tableAlias).`$(columnName)` as char),'\"'))\n";
        this.clobColumnTemplate = this.stringColumnTemplate;
        this.blobColumnTemplate = "if($(tableAlias).`$(columnName)` is null,'',concat('\"',hex($(tableAlias).`$(columnName)`),'\"'))\n";
        this.booleanColumnTemplate = "if($(tableAlias).`$(columnName)` is null,'',concat('\"',cast($(tableAlias).`$(columnName)` as unsigned),'\"'))\n";
        this.triggerConcatCharacter = ",";
        this.newTriggerValue = "new";
        this.oldTriggerValue = "old";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "create trigger $(triggerName) after insert on $(schemaName)$(tableName)                                                                                                                                \n                                for each row begin                                                                                                                                                     \n                                  $(custom_before_insert_text) \n                                  if $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    insert into $(defaultCatalog)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'I',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      concat($(columns)                                                                                                                                                \n                                       ),                                                                                                                                                              \n                                      $(channelExpression), $(txIdExpression), @sync_node_disabled,                                                                                                        \n                                      $(externalSelect),                                                                                                                                               \n                                      CURRENT_TIMESTAMP                                                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_insert_text)                                                                                                                                                \n                                end                                                                                                                                                                    ");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "create trigger $(triggerName) after insert on $(schemaName)$(tableName)                                                                                                                                \n                                for each row begin                                                                                                                                                     \n                                  $(custom_before_insert_text) \n                                  if $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    insert into $(defaultCatalog)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'R',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      concat($(newKeys)),                                                                                                                                             \n                                      $(channelExpression), $(txIdExpression), @sync_node_disabled,                                                                                                        \n                                      $(externalSelect),                                                                                                                                               \n                                      CURRENT_TIMESTAMP                                                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_insert_text)                                                                                                                                                \n                                end                                                                                                                                                                    ");
        this.sqlTemplates.put("updateTriggerTemplate", "create trigger $(triggerName) after update on $(schemaName)$(tableName)                                                                                                                                \n                                for each row begin                                                                                                                                                     \n                                  DECLARE var_row_data longtext character set " + characterSet + ";\n                                  DECLARE var_old_data longtext character set " + characterSet + ";\n                                  $(custom_before_update_text) \n                                  if $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                   set var_row_data = concat($(columns));                                                                                                                              \n                                   set var_old_data = concat($(oldColumns));                                                                                                                           \n                                   if $(dataHasChangedCondition) then                                                                                                                                  \n                                        insert into $(defaultCatalog)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n                                        values(                                                                                                                                                           \n                                          '$(targetTableName)',                                                                                                                                           \n                                          'U',                                                                                                                                                            \n                                          $(triggerHistoryId),                                                                                                                                            \n                                          concat($(oldKeys)                                                                                                                                               \n                                           ),                                                                                                                                                             \n                                          var_row_data,                                                                                                                                                   \n                                          var_old_data,                                                                                                                                                   \n                                          $(channelExpression), $(txIdExpression), @sync_node_disabled,                                                                                                       \n                                          $(externalSelect),                                                                                                                                              \n                                          CURRENT_TIMESTAMP                                                                                                                                               \n                                        );                                                                                                                                                                \n                                    end if;                                                                                                                                                               \n                                  end if;                                                                                                                                                                \n                                  $(custom_on_update_text)                                                                                                                                                  \n                                end                                                                                                                                                                      ");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "create trigger $(triggerName) after update on $(schemaName)$(tableName)                                                                                                                                \n                                for each row begin                                                                                                                                                     \n                                  $(custom_before_update_text) \n                                  if $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                   if $(dataHasChangedCondition) then                                                                                                                                  \n                                       insert into $(defaultCatalog)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n                                       values(                                                                                                                                                           \n                                         '$(targetTableName)',                                                                                                                                           \n                                         'R',                                                                                                                                                            \n                                         $(triggerHistoryId),                                                                                                                                            \n                                         concat($(oldKeys)                                                                                                                                               \n                                          ),                                                                                                                                            \n                                         $(channelExpression), $(txIdExpression), @sync_node_disabled,                                                                                                       \n                                         $(externalSelect),                                                                                                                                              \n                                         CURRENT_TIMESTAMP                                                                                                                                               \n                                       );                                                                                                                                                                \n                                   end if;                                                                                                                                                               \n                                  end if;                                                                                                                                                                \n                                  $(custom_on_update_text)                                                                                                                                                  \n                                end                                                                                                                                                                      ");
        this.sqlTemplates.put("deleteTriggerTemplate", "create trigger $(triggerName) after delete on $(schemaName)$(tableName)                                                                                                                                \n                                for each row begin                                                                                                                                                     \n                                  $(custom_before_delete_text) \n                                  if $(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    insert into $(defaultCatalog)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)\n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'D',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      concat($(oldKeys)                                                                                                                                                \n                                       ),                                                                                                                                                              \n                                       concat($(oldColumns)                                                                                                                                            \n                                       ),                                                                                                                                                              \n                                      $(channelExpression), $(txIdExpression), @sync_node_disabled,                                                                                                        \n                                      $(externalSelect),                                                                                                                                               \n                                      CURRENT_TIMESTAMP                                                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_delete_text)                                                                                                                                                \n                                end                                                                                                                                                                    ");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select concat($(columns)) from $(schemaName)$(tableName) t where $(whereClause)                                                                                                                        ");
    }

    protected String castDatetimeColumnToString(String columnName) {
        return "cast(\n" + SymmetricUtils.quote((ISymmetricDialect)this.symmetricDialect, (String)columnName) + " as char)";
    }
}

