/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.oracle;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.oracle.OracleTriggerTemplate;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IParameterService;

public class OracleSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String ORACLE_OBJECT_TYPE = "FUNCTION";
    static final String SQL_SELECT_TRIGGERS = "from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name = upper(?) and table_owner = upper(?)";
    static final String SQL_SELECT_DDL_TRIGGERS = "from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name is null and table_owner = upper(?)";
    static final String SQL_SELECT_TRANSACTIONS = "select min(start_time) from gv$transaction where status = 'ACTIVE'";
    static final String SQL_OBJECT_INSTALLED = "select count(*) from user_source where line = 1 and (((type = 'FUNCTION' or type = 'PACKAGE') and name=upper('$(functionName)')) or (name||'_'||type=upper('$(functionName)')))";
    static final String SQL_DROP_FUNCTION = "DROP FUNCTION $(functionName)";

    public OracleSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new OracleTriggerTemplate(this);
        this.supportsDdlTriggers = true;
        if (parameterService.is("oracle.use.transaction.view")) {
            try {
                this.areDatabaseTransactionsPendingSince(System.currentTimeMillis());
                this.supportsTransactionViews = true;
            }
            catch (Exception ex) {
                this.log.warn("Was not able to enable the use of transaction views.  You might not have access to select from gv$transaction", (Throwable)ex);
            }
        }
        platform.getDatabaseInfo().setGeneratedColumnsSupported(this.databaseMajorVersion >= 11);
    }

    public Database readSymmetricSchemaFromXml() {
        Database db = super.readSymmetricSchemaFromXml();
        if (this.parameterService.is("oracle.use.ntypes.for.sync")) {
            Table table = db.findTable(TableConstants.getTableName((String)this.getTablePrefix(), (String)"data"));
            table.getColumnWithName("row_data").setMappedType("NCLOB");
            table.getColumnWithName("old_data").setMappedType("NCLOB");
            table.getColumnWithName("pk_data").setMappedType("NCLOB");
        }
        return db;
    }

    protected void buildSqlReplacementTokens() {
        super.buildSqlReplacementTokens();
        if (this.parameterService.is("oracle.use.hints", true)) {
            this.sqlReplacementTokens.put("selectDataUsingGapsSqlHint", "/*+ index(d " + this.parameterService.getTablePrefix() + "_IDX_D_CHANNEL_ID) */");
        }
        if (this.parameterService.is("oracle.use.select.data.using.start.data.id.hint", false)) {
            this.sqlReplacementTokens.put("selectDataUsingStartDataIdHint", "/*+ full (d) */");
        }
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalog, String schema, String tableName, String triggerName) {
        if (StringUtils.isBlank((CharSequence)schema)) {
            schema = this.platform.getDefaultSchema();
        }
        return this.platform.getSqlTemplate().queryForInt("select count(*) from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name = upper(?) and table_owner = upper(?)", new Object[]{triggerName, tableName, schema}) > 0;
    }

    protected String getDropTriggerSql(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName) {
        return "drop trigger " + triggerName;
    }

    public void createTrigger(StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table table, ISqlTransaction transaction) {
        try {
            super.createTrigger(sqlBuffer, dml, trigger, history, channel, this.parameterService.getTablePrefix(), table, transaction);
        }
        catch (SqlException ex) {
            if (ex.getErrorCode() == 4095) {
                try {
                    Map map = this.platform.getSqlTemplate().queryForMap("select * from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name = upper(?) and table_owner = upper(?)", new Object[]{history.getTriggerNameForDmlType(dml), history.getSourceTableName(), history.getSourceSchemaName()});
                    if (map != null) {
                        this.log.warn("Trigger named {} already exists on table {}.{} and it cannot be replaced", new Object[]{history.getTriggerNameForDmlType(dml), map.get("TABLE_OWNER"), map.get("TABLE_NAME")});
                    } else {
                        this.log.warn("Trigger named {} already exists on another table and it cannot be replaced", (Object)history.getTriggerNameForDmlType(dml));
                    }
                }
                catch (SqlException sqlException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public boolean doesDdlTriggerExist(String catalogName, String schema, String triggerName) {
        if (StringUtils.isBlank((CharSequence)schema)) {
            return this.platform.getSqlTemplate().queryForInt("select count(*) from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name is null and table_owner = upper(?)", new Object[]{triggerName, this.platform.getDefaultSchema()}) > 0;
        }
        return this.platform.getSqlTemplate().queryForInt("select count(*) from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name is null and table_owner = upper(?)", new Object[]{triggerName, schema}) > 0;
    }

    public void removeDdlTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName) {
        String sql = "drop trigger " + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            try {
                this.log.info("Removing DDL trigger " + triggerName);
                this.platform.getSqlTemplate().update(sql, new Object[0]);
            }
            catch (Exception e) {
                this.log.warn("Tried to remove DDL trigger using: {} and failed because: {}", (Object)sql, (Object)e.getMessage());
            }
        }
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        String wkt2geom;
        String pkgPackage;
        String triggerDisabled;
        String transactionId;
        String blobToClob = this.parameterService.getTablePrefix() + "_blob2clob";
        if (!this.installed(SQL_OBJECT_INSTALLED, blobToClob)) {
            String sql = "CREATE OR REPLACE FUNCTION $(functionName) (blob_in IN BLOB)                                                                                                                                                RETURN CLOB                                                                                                                                                             AS                                                                                                                                                                            v_clob    CLOB := null;                                                                                                                                                   v_varchar VARCHAR2(32767);                                                                                                                                                v_start   PLS_INTEGER := 1;                                                                                                                                               v_buffer  PLS_INTEGER := 999;                                                                                                                                         BEGIN                                                                                                                                                                         IF blob_in IS NOT NULL THEN                                                                                                                                                   IF DBMS_LOB.GETLENGTH(blob_in) > 0 THEN                                                                                                                                       DBMS_LOB.CREATETEMPORARY(v_clob, TRUE);                                                                                                                                   FOR i IN 1..CEIL(DBMS_LOB.GETLENGTH(blob_in) / v_buffer)                                                                                                                  LOOP                                                                                                                                                                          v_varchar := UTL_RAW.CAST_TO_VARCHAR2(UTL_ENCODE.base64_encode(DBMS_LOB.SUBSTR(blob_in, v_buffer, v_start)));                                                             v_varchar := REPLACE(v_varchar,CHR(13)||CHR(10));                                                                                                                         DBMS_LOB.WRITEAPPEND(v_clob, LENGTH(v_varchar), v_varchar);                                                                                                               v_start := v_start + v_buffer;                                                                                                                                        END LOOP;                                                                                                                                                             END IF;                                                                                                                                                               END IF;                                                                                                                                                                   RETURN v_clob;                                                                                                                                                        END $(functionName);                                                                                                                                                   ";
            this.install(sql, blobToClob, ddl);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, transactionId = this.parameterService.getTablePrefix() + "_transaction_id")) {
            String sql = "CREATE OR REPLACE function $(functionName)                                                                                                                                                                return varchar is                                                                                                                                                     begin                                                                                                                                                                    return DBMS_TRANSACTION.local_transaction_id(false);                                                                                                               end;                                                                                                                                                               ";
            this.install(sql, transactionId, ddl);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, triggerDisabled = this.parameterService.getTablePrefix() + "_trigger_disabled")) {
            String sql = "CREATE OR REPLACE function $(functionName) return varchar is                                                                                                                                              begin                                                                                                                                                                      return " + this.getSymmetricPackageName() + ".disable_trigger;                                                                                                                                      end;                                                                                                                                                                 ";
            this.install(sql, triggerDisabled, ddl);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, pkgPackage = this.parameterService.getTablePrefix() + "_pkg")) {
            String sql = "CREATE OR REPLACE package $(functionName) as                                                                                                                                                                         disable_trigger pls_integer;                                                                                                                                             disable_node_id varchar(50);                                                                                                                                             procedure setValue (a IN number);                                                                                                                                        procedure setNodeValue (node_id IN varchar);                                                                                                                         end " + this.getSymmetricPackageName() + ";                                                                                                                                                           ";
            this.install(sql, pkgPackage, ddl);
            sql = "CREATE OR REPLACE package body $(functionName) as                                                                                                                                                                   procedure setValue(a IN number) is                                                                                                                                      begin                                                                                                                                                                       $(functionName).disable_trigger:=a;                                                                                                                                        end;                                                                                                                                                                    procedure setNodeValue(node_id IN varchar) is                                                                                                                           begin                                                                                                                                                                       $(functionName).disable_node_id := node_id;                                                                                                                                end;                                                                                                                                                                end " + this.getSymmetricPackageName() + ";                                                                                                                                                           ";
            this.install(sql, pkgPackage, ddl);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, wkt2geom = this.parameterService.getTablePrefix() + "_wkt2geom") && this.isSpatialTypesEnabled) {
            String sql = "  CREATE OR REPLACE FUNCTION $(functionName) (  \r\n        clob_in IN CLOB,                           \r\n        srid_in IN INTEGER)                        \r\n      RETURN SDO_GEOMETRY                          \r\n    AS                                             \r\n      v_out SDO_GEOMETRY := NULL;                  \r\n    BEGIN                                          \r\n      IF clob_in IS NOT NULL THEN                  \r\n        IF DBMS_LOB.GETLENGTH(clob_in) > 0 THEN    \r\n          v_out := SDO_GEOMETRY(clob_in, srid_in); \r\n        END IF;                                    \r\n      END IF;                                      \r\n      RETURN v_out;                                \r\n    END $(functionName);                           \r\n";
            this.install(sql, wkt2geom, ddl);
        }
    }

    public boolean createOrAlterTablesIfNecessary(String ... tableNames) {
        boolean isAltered = super.createOrAlterTablesIfNecessary(tableNames);
        boolean isNoOrder = this.parameterService.is("oracle.sequence.noorder", false);
        String seqName = this.getSequenceName(SequenceIdentifier.DATA).toUpperCase();
        String orderFlag = this.platform.getSqlTemplate().queryForString("select order_flag from user_sequences where sequence_name = ?", new Object[]{seqName});
        String sql = null;
        if (orderFlag != null && orderFlag.equals("N") && !isNoOrder) {
            sql = "alter sequence " + seqName + " order";
        } else if (orderFlag != null && orderFlag.equals("Y") && isNoOrder) {
            sql = "alter sequence " + seqName + " noorder";
        }
        if (sql != null) {
            this.log.info("DDL applied: " + sql);
            this.platform.getSqlTemplate().update(sql, new Object[0]);
        }
        return isAltered;
    }

    public void dropRequiredDatabaseObjects() {
        String pkgPackage;
        String wkt2geom;
        String triggerDisabled;
        String transactionId;
        String blobToClob = this.parameterService.getTablePrefix() + "_blob2clob";
        if (this.installed(SQL_OBJECT_INSTALLED, blobToClob)) {
            this.uninstall(SQL_DROP_FUNCTION, blobToClob);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, transactionId = this.parameterService.getTablePrefix() + "_transaction_id")) {
            this.uninstall(SQL_DROP_FUNCTION, transactionId);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, triggerDisabled = this.parameterService.getTablePrefix() + "_trigger_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, triggerDisabled);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, wkt2geom = this.parameterService.getTablePrefix() + "_wkt2geom")) {
            this.uninstall(SQL_DROP_FUNCTION, wkt2geom);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, pkgPackage = this.parameterService.getTablePrefix() + "_pkg")) {
            this.uninstall("DROP PACKAGE $(functionName)", pkgPackage);
        }
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.parameterService.getTablePrefix() + "_transaction_id()";
    }

    public String getTransactionId(ISqlTransaction transaction) {
        List list;
        if (this.supportsTransactionId() && (list = transaction.query("select DBMS_TRANSACTION.local_transaction_id() from dual", (ISqlRowMapper)new StringMapper(), null, null)) != null && list.size() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case REQUEST: {
                return "SEQ_" + this.parameterService.getTablePrefix() + "_EXTRACT_EST_REQUEST_ID";
            }
            case DATA: {
                return "SEQ_" + this.parameterService.getTablePrefix() + "_DATA_DATA_ID";
            }
            case TRIGGER_HIST: {
                return "SEQ_" + this.parameterService.getTablePrefix() + "_TRIGGER_RIGGER_HIST_ID";
            }
        }
        return null;
    }

    public long getCurrentSequenceValue(SequenceIdentifier identifier) {
        long id = this.platform.getSqlTemplate().queryForLong("select last_number from user_sequences where sequence_name = ?", new Object[]{this.getSequenceName(identifier).toUpperCase()});
        return id < 0L ? 0L : id;
    }

    public void cleanDatabase() {
        this.platform.getSqlTemplate().update("purge recyclebin", new Object[0]);
    }

    protected String getSymmetricPackageName() {
        return this.parameterService.getTablePrefix() + "_pkg";
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute(String.format("call %s.setValue(1)", this.getSymmetricPackageName()), new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute(String.format("call %s.setNodeValue('" + nodeId + "')", this.getSymmetricPackageName()), new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute(String.format("call %s.setValue(null)", this.getSymmetricPackageName()), new Object[0]);
        transaction.prepareAndExecute(String.format("call %s.setNodeValue(null)", this.getSymmetricPackageName()), new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return this.parameterService.getTablePrefix() + "_trigger_disabled() is null";
    }

    public String getSyncTriggersOnIncomingExpression() {
        return "nvl(" + this.parameterService.getTablePrefix() + "_trigger_disabled(), 0) != 2";
    }

    public final boolean areDatabaseTransactionsPendingSince(long time) {
        String returnValue = (String)this.platform.getSqlTemplate().queryForObject(SQL_SELECT_TRANSACTIONS, String.class, new Object[0]);
        if (returnValue != null) {
            try {
                Date date = DateUtils.parseDate((String)returnValue, (String[])new String[]{"MM/dd/yy HH:mm:ss"});
                return date.getTime() < time;
            }
            catch (ParseException e) {
                this.log.error("Could not parse the pending transactions date", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    public Date getEarliestTransactionStartTime() {
        Date date = null;
        String returnValue = (String)this.platform.getSqlTemplate().queryForObject(SQL_SELECT_TRANSACTIONS, String.class, new Object[0]);
        if (returnValue != null) {
            try {
                date = DateUtils.parseDate((String)returnValue, (String[])new String[]{"MM/dd/yy HH:mm:ss"});
            }
            catch (ParseException e) {
                this.log.error("", (Throwable)e);
                date = new Date();
            }
        }
        return date;
    }

    public String massageDataExtractionSql(String sql, boolean isContainsBigLob) {
        if (!isContainsBigLob) {
            sql = StringUtils.replace((String)sql, (String)"d.row_data", (String)"dbms_lob.substr(d.row_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.old_data", (String)"dbms_lob.substr(d.old_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.pk_data", (String)"dbms_lob.substr(d.pk_data, 4000, 1 )");
        }
        sql = super.massageDataExtractionSql(sql, isContainsBigLob);
        return sql;
    }

    public String massageForLob(String sql, boolean isContainsBigLob) {
        if (!isContainsBigLob) {
            return String.format("dbms_lob.substr(%s, 4000, 1)", sql);
        }
        return super.massageForLob(sql, isContainsBigLob);
    }

    public boolean isInitialLoadTwoPassLob(Table table) {
        boolean initialLoadTwoPassLob = false;
        if (this.parameterService.is("initial.load.extract.use.two.pass.lob") && !TableConstants.getTables((String)this.parameterService.getTablePrefix()).contains(table.getNameLowerCase())) {
            for (Column column : table.getLobColumns(this.platform)) {
                if (!this.isInitialLoadTwoPassLobColumn(column)) continue;
                initialLoadTwoPassLob = true;
                break;
            }
        }
        return initialLoadTwoPassLob;
    }

    private boolean isInitialLoadTwoPassLobColumn(Column column) {
        String typeName = column.getJdbcTypeName();
        boolean isLob = typeName.equalsIgnoreCase("CLOB") || typeName.equalsIgnoreCase("BLOB");
        boolean isVariableBinary = typeName.equalsIgnoreCase("BINARY") || typeName.equalsIgnoreCase("VARBINARY");
        return isLob || isVariableBinary && column.getSizeAsInt() > 4000;
    }

    public String getInitialLoadTwoPassLobLengthSql(Column column, boolean isFirstPass) {
        String quote = this.platform.getDdlBuilder().getDatabaseInfo().getDelimiterToken();
        if (!this.isInitialLoadTwoPassLobColumn(column)) {
            return null;
        }
        if (isFirstPass) {
            return "(t." + quote + column.getName() + quote + " is null or dbms_lob.getlength(t." + quote + column.getName() + quote + ") <= 4000)";
        }
        if (this.parameterService.is("extract.check.row.size", false)) {
            return "dbms_lob.getlength(t." + quote + column.getName() + quote + ") between 4001 and " + this.parameterService.getLong("extract.row.max.length", 1000000000L);
        }
        return "dbms_lob.getlength(t." + quote + column.getName() + quote + ") > 4000";
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        if (!trigger.isUseCaptureLobs()) {
            return "var_old_data is null or var_row_data != var_old_data";
        }
        return "dbms_lob.compare(nvl(var_row_data,'Null'),nvl(var_old_data,'Null')) != 0 ";
    }

    public String getTemplateNumberPrecisionSpec() {
        return this.parameterService.getString("oracle.template.precision", "30,10");
    }

    public PermissionType[] getSymTablePermissions() {
        PermissionType[] permissions = new PermissionType[]{PermissionType.CREATE_TABLE, PermissionType.DROP_TABLE, PermissionType.CREATE_TRIGGER, PermissionType.DROP_TRIGGER, PermissionType.EXECUTE};
        return permissions;
    }

    public String getDatabaseTimeSQL() {
        return "select current_timestamp from dual";
    }
}

