/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;

public class JdbcBatchBulkDatabaseWriter
extends AbstractBulkDatabaseWriter {
    private int lastRowCount = 0;
    private int expectedRowCount = 0;

    public JdbcBatchBulkDatabaseWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String tablePrefix, DatabaseWriterSettings writerSettings) {
        super(symmetricPlatform, targetPlatform, tablePrefix, writerSettings);
    }

    @Override
    public void start(Batch batch) {
        super.start(batch);
        if (this.context.get("bulkWriterToUse") == null || !this.context.get("bulkWriterToUse").equals("default")) {
            this.getTransaction().setInBatchMode(true);
            ((JdbcSqlTransaction)this.getTransaction()).setBatchSize(((JdbcSqlTemplate)this.getPlatform().getSqlTemplate()).getSettings().getBatchBulkLoaderSize());
        }
    }

    @Override
    protected void bulkWrite(CsvData data) {
        this.writeDefault(data);
    }

    protected AbstractDatabaseWriter.LoadStatus delete(CsvData data, boolean useConflictDetection) {
        AbstractDatabaseWriter.LoadStatus loadStatus = super.delete(data, useConflictDetection);
        if (!this.getTransaction().isInBatchMode()) {
            return loadStatus;
        }
        this.checkForConflict(true);
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected AbstractDatabaseWriter.LoadStatus insert(CsvData data) {
        AbstractDatabaseWriter.LoadStatus loadStatus = super.insert(data);
        if (!this.getTransaction().isInBatchMode()) {
            return loadStatus;
        }
        this.checkForConflict(true);
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected AbstractDatabaseWriter.LoadStatus update(CsvData data, boolean applyChangesOnly, boolean useConflictDetection) {
        AbstractDatabaseWriter.LoadStatus loadStatus = super.update(data, applyChangesOnly, useConflictDetection);
        if (!this.getTransaction().isInBatchMode()) {
            return loadStatus;
        }
        this.checkForConflict(true);
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected void checkForConflict(boolean isDml) {
        if (isDml) {
            ++this.expectedRowCount;
        }
        if (this.getTransaction().getUnflushedMarkers(false).size() == 0) {
            if (this.expectedRowCount != this.lastRowCount) {
                throw new SymmetricException("JdbcBatchBulkDataWriter was in conflict, will attempt to fallback using default writer.", new Object[0]);
            }
            this.expectedRowCount = 0;
            this.lastRowCount = 0;
        }
    }

    protected void prepare() {
        if (this.getTransaction().isInBatchMode()) {
            this.lastRowCount = this.getTransaction().flush();
            this.checkForConflict(false);
        }
        super.prepare();
    }

    protected int execute(CsvData data, String[] values) {
        this.lastRowCount = super.execute(data, values);
        return this.lastRowCount;
    }

    @Override
    public void end(Batch batch, boolean inError) {
        if (this.getTransaction().isInBatchMode()) {
            this.lastRowCount = this.getTransaction().flush();
            this.checkForConflict(false);
        }
        super.end(batch, inError);
    }

    protected boolean requireNewStatement(DmlStatement.DmlType currentType, CsvData data, boolean applyChangesOnly, boolean useConflictDetection, Conflict.DetectConflict detectType) {
        if (currentType == DmlStatement.DmlType.DELETE) {
            applyChangesOnly = false;
        }
        return super.requireNewStatement(currentType, data, applyChangesOnly, useConflictDetection, detectType);
    }
}

