/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.ClassUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.BshJob;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.JavaJob;
import org.jumpmind.symmetric.job.SqlJob;
import org.jumpmind.symmetric.model.JobDefinition;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class JobCreator {
    public IJob createJob(JobDefinition jobDefinition, ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        AbstractJob job = null;
        if (jobDefinition.getJobType() == JobDefinition.JobType.BSH) {
            job = new BshJob(jobDefinition.getJobName(), engine, taskScheduler);
        } else if (jobDefinition.getJobType() == JobDefinition.JobType.SQL) {
            job = new SqlJob(jobDefinition.getJobName(), engine, taskScheduler);
        } else if (jobDefinition.getJobType() == JobDefinition.JobType.BUILT_IN) {
            job = this.instantiateJavaJob(jobDefinition, engine, taskScheduler);
        } else if (jobDefinition.getJobType() == JobDefinition.JobType.JAVA) {
            job = new JavaJob(jobDefinition.getJobName(), engine, taskScheduler);
        } else {
            throw new SymmetricException("Unknown job type " + jobDefinition.getJobType(), new Object[0]);
        }
        job.setJobDefinition(jobDefinition);
        return job;
    }

    protected AbstractJob instantiateJavaJob(JobDefinition jobDefinition, ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        String className = jobDefinition.getJobExpression();
        try {
            Constructor<?>[] constructors;
            Class jobClass = ClassUtils.getClass((String)className);
            for (Constructor<?> constructor : constructors = jobClass.getConstructors()) {
                if (constructor.getParameterTypes().length != 3 || !constructor.getParameterTypes()[0].isAssignableFrom(String.class) || !constructor.getParameterTypes()[1].isAssignableFrom(ISymmetricEngine.class) || !constructor.getParameterTypes()[2].isAssignableFrom(ThreadPoolTaskScheduler.class)) continue;
                return (AbstractJob)constructor.newInstance(jobDefinition.getJobName(), engine, taskScheduler);
            }
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterTypes().length != 2 || !constructor.getParameterTypes()[0].isAssignableFrom(ISymmetricEngine.class) || !constructor.getParameterTypes()[1].isAssignableFrom(ThreadPoolTaskScheduler.class)) continue;
                return (AbstractJob)constructor.newInstance(engine, taskScheduler);
            }
            return (AbstractJob)jobClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new SymmetricException("Failed to load and instantiate job class '" + className + "'", (Throwable)ex);
        }
    }
}

