/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.job.OracleNoOrderHeartbeatSqlMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class OracleNoOrderHeartbeat
implements IHeartbeatListener,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISymmetricEngine engine;
    private IParameterService parameterService;
    private ISqlMap sqlMap;

    public OracleNoOrderHeartbeat(ISymmetricEngine engine) {
        this.engine = engine;
        this.parameterService = engine.getParameterService();
        this.sqlMap = new OracleNoOrderHeartbeatSqlMap(engine.getDatabasePlatform(), this.parameterService.getTablePrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartbeat(Node me) {
        String dbUrls = this.parameterService.getString("oracle.sequence.noorder.nextvalue.db.urls");
        if (this.parameterService.is("heartbeat.sync.on.push.enabled") && StringUtils.isNotBlank((CharSequence)dbUrls)) {
            String user = this.parameterService.getString("db.user");
            String password = this.parameterService.getString("db.password");
            if (password != null && password.startsWith("enc:")) {
                try {
                    password = this.engine.getSecurityService().decrypt(password.substring("enc:".length()));
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to decrypt the database password from the engine properties file", ex);
                }
            }
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            String[] dbUrlArray = dbUrls.split(",");
            this.log.info("Connecting for heartbeat on {} RAC nodes", (Object)dbUrlArray.length);
            for (String dbUrl : dbUrlArray) {
                SingleConnectionDataSource ds = null;
                try {
                    this.log.debug("Connecting to {}", (Object)dbUrl);
                    Connection conn = DriverManager.getConnection(dbUrl.trim(), user, password);
                    ds = new SingleConnectionDataSource(conn, true);
                    JdbcTemplate sqlTemplate = new JdbcTemplate((DataSource)ds);
                    int count = sqlTemplate.update(this.sqlMap.getSql(new String[]{"updateNodeHost"}), new Object[]{new Timestamp(cal.getTimeInMillis()), me.getNodeId(), AppUtils.getHostName()});
                    this.log.debug("Updated {} rows for heartbeat", (Object)count);
                }
                catch (Exception e) {
                    this.log.error("Unable to update heartbeat time", (Throwable)e);
                }
                finally {
                    if (ds != null) {
                        ds.destroy();
                    }
                }
            }
        }
    }

    public long getTimeBetweenHeartbeatsInSeconds() {
        return this.engine.getParameterService().getLong("heartbeat.sync.on.push.period.sec");
    }
}

