/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.model.NetworkedNode;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class ReportStatusJob
extends AbstractJob {
    private static Map<String, Integer> lastBatchCountPerChannel = Collections.synchronizedMap(new HashMap());

    public ReportStatusJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Report Status", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().schedule("0 0/5 * * * *").enabled(false).description("Related to hybrid-pull");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        NetworkedNode remote = this.engine.getNodeService().getRootNetworkedNode();
        Node identity = this.engine.getNodeService().findIdentity();
        if (remote.getNode().getNodeId().equals(identity.getNodeId())) {
            this.log.debug("Skipping report status job because this node is the root node. identity={}, remote={}", (Object)identity, (Object)remote);
            return;
        }
        Map batchCountPerChannel = this.engine.getOutgoingBatchService().countOutgoingBatchesPendingByChannel(remote.getNode().getNodeId());
        this.log.debug("identity={} batchCountPerChannel='{}', lastBatchCountPerChannel='{}'", new Object[]{identity, batchCountPerChannel, lastBatchCountPerChannel});
        if (force || this.shouldSendStatus(batchCountPerChannel)) {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put("Batch-To-Send-Count", TransportUtils.toCSV((Map)batchCountPerChannel));
            this.engine.getTransportManager().sendStatusRequest(identity, requestParams);
            this.updateLastSentStatus(batchCountPerChannel);
        }
    }

    protected boolean shouldSendStatus(Map<String, Integer> batchCountPerChannel) {
        if (batchCountPerChannel == null || batchCountPerChannel.isEmpty()) {
            return false;
        }
        if (lastBatchCountPerChannel.equals(batchCountPerChannel)) {
            return false;
        }
        if (this.engine.getParameterService().is("hybrid.push.pull.buffer.status.updates")) {
            for (String channelId : batchCountPerChannel.keySet()) {
                Integer lastCount = lastBatchCountPerChannel.get(channelId);
                if (lastCount == null) {
                    lastCount = 0;
                }
                Integer currentCount = batchCountPerChannel.get(channelId);
                if (!lastCount.equals(0) || lastCount.equals(currentCount)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void updateLastSentStatus(Map<String, Integer> batchesToSendByChannel) {
        lastBatchCountPerChannel.clear();
        lastBatchCountPerChannel.putAll(batchesToSendByChannel);
    }
}

