/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DdlBuilderFactory;
import org.jumpmind.db.platform.DmlStatementFactory;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.io.IoVersion;

public class DbExport {
    private Format format = Format.SQL;
    private Compatible compatible;
    private boolean addDropTable;
    private boolean noCreateInfo;
    private boolean noIndices;
    private boolean noForeignKeys;
    private boolean noData;
    private boolean ignoreMissingTables;
    private boolean useVariableDates;
    private boolean comments;
    private String whereClause;
    private String[] excludeColumns;
    private String catalog;
    private String schema;
    private String dir;
    private int maxRows = Integer.MAX_VALUE;
    private boolean useQuotedIdentifiers = true;
    private boolean useJdbcTimestampFormat = true;
    private boolean useReadUncommitted;
    private IDatabasePlatform platform;

    public DbExport(IDatabasePlatform platform) {
        this.platform = platform;
        this.compatible = Compatible.valueOf(platform.getName().toUpperCase());
    }

    public String exportTables() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.exportTables(output);
        output.close();
        return output.toString();
    }

    public String exportTables(String[] tableNames) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.exportTables((OutputStream)output, tableNames);
        output.close();
        return output.toString();
    }

    public String exportTables(Table[] tables) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.exportTables((OutputStream)output, tables);
        output.close();
        return output.toString();
    }

    public void exportTables(OutputStream output) throws IOException {
        Database database = this.platform.readDatabase(this.getCatalogToUse(), this.getSchemaToUse(), new String[]{"TABLE"});
        this.exportTables(output, database.getTables());
    }

    public void exportTables(OutputStream output, String[] tableNames) throws IOException {
        ArrayList<Table> tableList = new ArrayList<Table>();
        for (String tableName : tableNames) {
            Table table = this.platform.readTableFromDatabase(this.getCatalogToUse(), this.getSchemaToUse(), tableName);
            if (table != null) {
                tableList.add(table);
                continue;
            }
            if (this.ignoreMissingTables) continue;
            throw new RuntimeException("Cannot find table " + tableName + " in catalog " + this.getCatalogToUse() + " and schema " + this.getSchemaToUse());
        }
        this.exportTables(output, tableList.toArray(new Table[tableList.size()]));
    }

    public void exportTable(OutputStream output, String tableName, String sql) throws IOException {
        Table table = this.platform.readTableFromDatabase(this.getCatalogToUse(), this.getSchemaToUse(), tableName);
        this.exportTables(output, new Table[]{table}, sql);
    }

    public void exportTables(OutputStream output, Table[] tables) throws IOException {
        this.exportTables(output, tables, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTables(OutputStream output, Table[] tables, String sql) throws IOException {
        for (int i = 0; i < tables.length; ++i) {
            if (!tables[i].containsJdbcTypes()) {
                tables[i] = this.platform.readTableFromDatabase(this.getCatalogToUse(), this.getSchemaToUse(), tables[i].getName());
            }
            tables[i] = tables[i].copy();
        }
        try (WriterWrapper writerWrapper = null;){
            writerWrapper = new WriterWrapper(output);
            for (Table table : tables = Database.sortByForeignKeys((Table[])tables)) {
                this.writeTable(writerWrapper, table, sql);
            }
        }
    }

    protected String getSchemaToUse() {
        if (StringUtils.isBlank((CharSequence)this.schema)) {
            return this.platform.getDefaultSchema();
        }
        return this.schema;
    }

    protected String getCatalogToUse() {
        if (StringUtils.isBlank((CharSequence)this.catalog)) {
            return this.platform.getDefaultCatalog();
        }
        return this.catalog;
    }

    private void removeExcludedColumns(Table table) {
        if (this.excludeColumns != null) {
            for (String columnName : this.excludeColumns) {
                int colIndex = table.getColumnIndex(columnName);
                if (colIndex == -1) continue;
                table.removeColumn(colIndex);
            }
        }
    }

    protected void writeTable(final WriterWrapper writerWrapper, Table table, String sql) throws IOException {
        this.removeExcludedColumns(table);
        writerWrapper.startTable(table);
        if (!this.noData) {
            if (sql == null) {
                if (this.excludeColumns == null || this.excludeColumns.length == 0) {
                    sql = this.platform.createDmlStatement(DmlStatement.DmlType.SELECT_ALL, table, null).getSql();
                } else {
                    Column[] columnsToExport = this.getColumnsToExport(table);
                    sql = this.platform.createDmlStatement(DmlStatement.DmlType.SELECT_ALL, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), columnsToExport, null, null).getSql();
                }
            }
            if (table.getColumnCount() > 0) {
                if (StringUtils.isNotBlank((CharSequence)this.whereClause)) {
                    sql = String.format("%s %s", sql, this.whereClause);
                }
                ISqlTemplate sqlTemplate = this.useReadUncommitted ? this.platform.getSqlTemplateDirty() : this.platform.getSqlTemplate();
                sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Object>(){
                    int rows;
                    {
                        this.rows = DbExport.this.maxRows;
                    }

                    public Object mapRow(Row row) {
                        if (this.rows > 0) {
                            writerWrapper.writeRow(row);
                            --this.rows;
                        }
                        return Boolean.TRUE;
                    }
                }, new Object[0]);
            }
        }
        writerWrapper.finishTable(table);
    }

    protected Column[] getColumnsToExport(Table table) {
        Column[] tableColumns = table.getColumns();
        ArrayList<Column> columnsToExport = new ArrayList<Column>();
        for (int i = 0; i < tableColumns.length; ++i) {
            boolean excluded = false;
            for (int j = 0; j < this.excludeColumns.length; ++j) {
                if (!tableColumns[i].getName().equalsIgnoreCase(this.excludeColumns[j])) continue;
                excluded = true;
            }
            if (excluded) continue;
            try {
                columnsToExport.add((Column)tableColumns[i].clone());
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        Column[] columnArray = new Column[columnsToExport.size()];
        columnArray = columnsToExport.toArray(columnArray);
        return columnArray;
    }

    protected Database getDatabase(Table table) {
        return this.getDatabase(new Table[]{table});
    }

    protected Database getDatabase(Table[] tables) {
        Database db = new Database();
        try {
            if (!this.noCreateInfo) {
                for (Table table : tables) {
                    Table newTable = (Table)table.clone();
                    if (this.noIndices) {
                        newTable.removeAllIndices();
                    }
                    if (this.noForeignKeys) {
                        newTable.removeAllForeignKeys();
                    }
                    db.addTable(newTable);
                }
            } else if (this.addDropTable) {
                for (Table table : tables) {
                    Table newTable = (Table)table.clone();
                    db.addTable(newTable);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return db;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Compatible getCompatible() {
        return this.compatible;
    }

    public void setCompatible(Compatible compatible) {
        this.compatible = compatible;
    }

    public boolean isAddDropTable() {
        return this.addDropTable;
    }

    public void setAddDropTable(boolean addDropTable) {
        this.addDropTable = addDropTable;
    }

    public boolean isNoCreateInfo() {
        return this.noCreateInfo;
    }

    public void setNoCreateInfo(boolean noCreateInfo) {
        this.noCreateInfo = noCreateInfo;
    }

    public boolean isNoData() {
        return this.noData;
    }

    public void setNoData(boolean noData) {
        this.noData = noData;
    }

    public void setUseQuotedIdentifiers(boolean useQuotedIdentifiers) {
        this.useQuotedIdentifiers = useQuotedIdentifiers;
    }

    public boolean isUseQuotedIdentifiers() {
        return this.useQuotedIdentifiers;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setExcludeColumns(String[] excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public String[] getExcludeColumns() {
        return this.excludeColumns;
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isIgnoreMissingTables() {
        return this.ignoreMissingTables;
    }

    public void setIgnoreMissingTables(boolean ignoreMissingTables) {
        this.ignoreMissingTables = ignoreMissingTables;
    }

    public boolean isUseVariableDates() {
        return this.useVariableDates;
    }

    public void setUseVariableForDates(boolean useVariableDates) {
        this.useVariableDates = useVariableDates;
    }

    public boolean isNoIndices() {
        return this.noIndices;
    }

    public void setNoIndices(boolean noIndices) {
        this.noIndices = noIndices;
    }

    public boolean isNoForeignKeys() {
        return this.noForeignKeys;
    }

    public void setNoForeignKeys(boolean noForeignKeys) {
        this.noForeignKeys = noForeignKeys;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getDir() {
        return this.dir;
    }

    public void setUseJdbcTimestampFormat(boolean useJdbcTimestampFormat) {
        this.useJdbcTimestampFormat = useJdbcTimestampFormat;
    }

    public boolean isUseJdbcTimestampFormat() {
        return this.useJdbcTimestampFormat;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public boolean isUseReadUncommitted() {
        return this.useReadUncommitted;
    }

    public void setUseReadUncommitted(boolean useReadUncommitted) {
        this.useReadUncommitted = useReadUncommitted;
    }

    protected String getDatabaseName() {
        Compatible mappedCompatible = this.compatible;
        if (mappedCompatible == Compatible.MSSQL) {
            mappedCompatible = Compatible.MSSQL2000;
        }
        return mappedCompatible.toString().toLowerCase();
    }

    public static enum Format {
        SQL,
        CSV,
        XML,
        SYM_XML,
        CSV_DQUOTE;

    }

    public static enum Compatible {
        DB2,
        DB2AS400,
        DB2ZOS,
        DERBY,
        FIREBIRD,
        FIREBIRD_DIALECT1,
        GREENPLUM,
        H2,
        HSQLDB,
        HSQLDB2,
        INFORMIX,
        INGRES,
        INTERBASE,
        MSSQL,
        MSSQL2000,
        MSSQL2005,
        MSSQL2008,
        MSSQL2016,
        MYSQL,
        ORACLE,
        ORACLE122,
        ORACLE23,
        POSTGRES,
        POSTGRES95,
        RAIMA,
        SYBASE,
        SQLITE,
        MARIADB,
        ASE,
        SQLANYWHERE,
        REDSHIFT,
        VOLTDB,
        NUODB,
        TIBERO,
        SINGLESTORE,
        OPENEDGE,
        GENERIC,
        SNOWFLAKE;

    }

    class WriterWrapper {
        private final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private CsvWriter csvWriter;
        private Writer writer;
        private Table table;
        private DmlStatement insertSql;
        private boolean startedWriting = false;

        public WriterWrapper(OutputStream os) {
            if (StringUtils.isBlank((CharSequence)DbExport.this.dir) && os != null) {
                try {
                    this.writer = new OutputStreamWriter(os, Charset.defaultCharset().name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new IoException((Exception)e);
                }
            }
        }

        protected void startTable(Table table) {
            try {
                this.table = table;
                if (StringUtils.isNotBlank((CharSequence)DbExport.this.dir)) {
                    this.startedWriting = false;
                    File directory = new File(DbExport.this.dir);
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    File file = new File(DbExport.this.dir, String.format("%s.%s", table.getName(), DbExport.this.format.toString().replace('_', '.').toLowerCase()));
                    FileUtils.deleteQuietly((File)file);
                    try {
                        this.writer = new FileWriter(file);
                    }
                    catch (IOException e) {
                        throw new IoException((Exception)e);
                    }
                }
                if (!this.startedWriting) {
                    if (DbExport.this.format == Format.SYM_XML) {
                        this.write("<batch xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" encoding=\"" + Charset.defaultCharset().name() + "\">\n");
                    } else if (DbExport.this.format == Format.XML) {
                        this.write("<database xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" name=\"dbexport\"");
                        if (DbExport.this.catalog != null && !DbExport.this.catalog.equals(DbExport.this.platform.getDefaultCatalog())) {
                            this.write(" catalog=\"" + DbExport.this.catalog + "\"");
                        }
                        if (DbExport.this.schema != null && !DbExport.this.schema.equals(DbExport.this.platform.getDefaultSchema())) {
                            this.write(" schema=\"" + DbExport.this.schema + "\"");
                        }
                        this.write(" encoding=\"" + Charset.defaultCharset().name() + "\">\n");
                    }
                    this.startedWriting = true;
                }
                String databaseName = DbExport.this.getDatabaseName();
                if (DbExport.this.format == Format.CSV && this.csvWriter == null) {
                    this.csvWriter = new CsvWriter(this.writer, ',');
                    this.csvWriter.setEscapeMode(2);
                    this.csvWriter.setTextQualifier('\"');
                    this.csvWriter.setUseTextQualifier(true);
                    this.csvWriter.setForceQualifier(true);
                } else if (DbExport.this.format == Format.CSV_DQUOTE && this.csvWriter == null) {
                    this.csvWriter = new CsvWriter(this.writer, ',');
                    this.csvWriter.setEscapeMode(1);
                    this.csvWriter.setTextQualifier('\"');
                    this.csvWriter.setUseTextQualifier(true);
                    this.csvWriter.setForceQualifier(true);
                } else if (DbExport.this.format == Format.SQL) {
                    if (table.getCatalog() != null && table.getCatalog().equals(DbExport.this.platform.getDefaultCatalog())) {
                        table.setCatalog(null);
                    }
                    if (table.getCatalog() == null && table.getSchema() != null && table.getSchema().equals(DbExport.this.platform.getDefaultSchema())) {
                        table.setSchema(null);
                    }
                    Table targetTable = table.copy();
                    DmlStatementOptions options = new DmlStatementOptions(DmlStatement.DmlType.INSERT, targetTable);
                    if (DbExport.this.excludeColumns == null || DbExport.this.excludeColumns.length == 0) {
                        this.insertSql = DmlStatementFactory.getInstance().create(databaseName, options.quotedIdentifiers(DbExport.this.useQuotedIdentifiers));
                    } else {
                        Column[] columnsToExport = DbExport.this.getColumnsToExport(table);
                        this.insertSql = DmlStatementFactory.getInstance().create(databaseName, options.columns(columnsToExport).quotedIdentifiers(this.startedWriting));
                    }
                }
                if (!DbExport.this.noCreateInfo) {
                    if (DbExport.this.format == Format.SQL) {
                        target = DdlBuilderFactory.getInstance().create(databaseName);
                        target.setDelimitedIdentifierModeOn(DbExport.this.useQuotedIdentifiers);
                        this.write(this.cleanupSQL(target.createTables(DbExport.this.getDatabase(table), DbExport.this.addDropTable)));
                    } else if (DbExport.this.format == Format.XML) {
                        if (DbExport.this.noIndices) {
                            table.removeAllIndices();
                        }
                        if (DbExport.this.noForeignKeys) {
                            table.removeAllForeignKeys();
                        }
                        DatabaseXmlUtil.write((Table)table, (Writer)this.writer);
                    }
                } else if (DbExport.this.addDropTable && DbExport.this.format == Format.SQL) {
                    target = DdlBuilderFactory.getInstance().create(databaseName);
                    this.write(target.dropTables(DbExport.this.getDatabase(table)));
                }
                this.writeComment("DbExport: " + StringUtils.defaultString((String)IoVersion.getVersion().version()));
                this.writeComment("Catalog: " + StringUtils.defaultString((String)DbExport.this.getCatalogToUse()));
                this.writeComment("Schema: " + StringUtils.defaultString((String)DbExport.this.getSchemaToUse()));
                this.writeComment("Table: " + table.getName());
                this.writeComment("Table Columns: " + Arrays.deepToString(table.getColumnNames()));
                this.writeComment("Started on " + this.df.format(new Date()));
                if (DbExport.this.format == Format.CSV || DbExport.this.format == Format.CSV_DQUOTE) {
                    this.csvWriter.writeRecord(table.getColumnNames());
                } else if (!DbExport.this.noData && DbExport.this.format == Format.XML) {
                    this.write("<table_data name=\"", table.getName(), "\">\n");
                }
            }
            catch (IOException e) {
                throw new IoException((Exception)e);
            }
        }

        protected String cleanupSQL(String createTables) {
            String cleanedSQL = createTables.replaceAll("[;;\\s]+$", ";\n");
            return cleanedSQL;
        }

        protected void writeComment(String commentStr) {
            if (this.writer != null) {
                try {
                    if (DbExport.this.comments) {
                        if (DbExport.this.format == Format.CSV || DbExport.this.format == Format.CSV_DQUOTE) {
                            this.write("# ", commentStr, "\n");
                        } else if (DbExport.this.format == Format.XML) {
                            this.write("<!-- ", commentStr, " -->\n");
                        } else if (DbExport.this.format == Format.SQL) {
                            this.write("-- ", commentStr, "\n");
                        }
                        this.writer.flush();
                    }
                }
                catch (IOException e) {
                    throw new IoException((Exception)e);
                }
            }
        }

        protected void writeRow(Row row) {
            Column[] columns = this.table.getColumns();
            String[] values = DbExport.this.platform.getStringValues(BinaryEncoding.HEX, columns, row, DbExport.this.useVariableDates, false);
            try {
                if (DbExport.this.format == Format.CSV || DbExport.this.format == Format.CSV_DQUOTE) {
                    this.csvWriter.writeRecord(values, true);
                } else if (DbExport.this.format == Format.SQL) {
                    this.write(this.insertSql.buildDynamicSql(BinaryEncoding.HEX, row, DbExport.this.useVariableDates, DbExport.this.useJdbcTimestampFormat), "\n");
                } else if (DbExport.this.format == Format.XML) {
                    this.write("\t<row>\n");
                    for (int i = 0; i < columns.length; ++i) {
                        if (values[i] != null) {
                            this.write("\t\t<field name=\"", columns[i].getName(), "\">", StringEscapeUtils.escapeXml10((String)values[i]), "</field>\n");
                            continue;
                        }
                        this.write("\t\t<field name=\"", columns[i].getName(), "\" xsi:nil=\"true\" />\n");
                    }
                    this.write("\t</row>\n");
                } else if (DbExport.this.format == Format.SYM_XML) {
                    this.write("\t<row entity=\"", this.table.getName(), "\" dml=\"I\">\n");
                    for (int i = 0; i < columns.length; ++i) {
                        if (values[i] != null) {
                            this.write("\t\t<data key=\"", columns[i].getName(), "\">", StringEscapeUtils.escapeXml10((String)values[i]), "</data>\n");
                            continue;
                        }
                        this.write("\t\t<data key=\"", columns[i].getName(), "\" xsi:nil=\"true\" />\n");
                    }
                    this.write("\t</row>\n");
                }
            }
            catch (IOException e) {
                throw new IoException((Exception)e);
            }
        }

        protected void write(String ... data) {
            for (String string : data) {
                try {
                    this.writer.write(string);
                }
                catch (IOException e) {
                    throw new IoException((Exception)e);
                }
            }
        }

        protected void finishTable(Table table) {
            if (!DbExport.this.noData && DbExport.this.format == Format.XML) {
                this.write("</table_data>\n");
            }
            if (StringUtils.isNotBlank((CharSequence)DbExport.this.dir)) {
                this.close();
            }
        }

        public void close() {
            this.writeComment("Completed on " + this.df.format(new Date()));
            if (DbExport.this.format == Format.SYM_XML) {
                this.write("</batch>\n");
            } else if (DbExport.this.format == Format.XML) {
                this.write("</database>\n");
            }
            this.startedWriting = false;
            if (this.csvWriter != null) {
                this.csvWriter.flush();
                this.csvWriter.close();
                this.csvWriter = null;
            }
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
    }
}

