/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataReader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    protected long logDebugAndCountBytes(String[] tokens) {
        long bytesRead = 0L;
        if (tokens != null) {
            StringBuilder debugBuffer = this.log.isDebugEnabled() ? new StringBuilder() : null;
            for (String token : tokens) {
                bytesRead += token != null ? (long)token.length() : 0L;
                if (debugBuffer == null) continue;
                if (token != null) {
                    String tokenTrimmed = FormatUtils.abbreviateForLogging((String)token);
                    debugBuffer.append(tokenTrimmed);
                } else {
                    debugBuffer.append("<null>");
                }
                debugBuffer.append(",");
            }
            if (debugBuffer != null && debugBuffer.length() > 1) {
                this.log.debug("CSV parsed: {}", (Object)debugBuffer.substring(0, debugBuffer.length() - 1));
            }
        }
        return bytesRead;
    }

    protected static Batch toBatch(BinaryEncoding binaryEncoding) {
        return new Batch(Batch.BatchType.LOAD, -9999L, "default", binaryEncoding, null, null, true);
    }

    protected static Reader toReader(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader in = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8.name());
            return new BufferedReader(in);
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    protected static Reader toReader(InputStream is) {
        try {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8.name()));
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }
}

