/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMapColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "valueMap";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    private static String getValue(String value, String expression) {
        if (expression == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(expression);
        tokens.setQuoteChar('\"');
        tokens.setDelimiterMatcher(StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{' ', '='}));
        String defaultValue = null;
        String[] tokenArray = tokens.getTokenArray();
        for (int i = 0; i < tokenArray.length - 1; i += 2) {
            if (tokenArray[i].equals(value)) {
                return tokenArray[i + 1];
            }
            if (!tokenArray[i].equals("*")) continue;
            String targetValue = tokenArray[i + 1];
            defaultValue = targetValue.equals("*") ? value : targetValue;
        }
        return defaultValue;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String value = ValueMapColumnTransform.getValue(newValue, column.getTransformExpression());
        return new NewAndOldValue(column, data, value);
    }
}

