/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.IProtocolDataWriterListener;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtocolDataWriter
implements IDataWriter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected DataContext context;
    protected Batch batch;
    protected Table table;
    protected Map<String, String> processedTables = new HashMap<String, String>();
    protected String delimiter = ",";
    protected boolean flushNodeId = true;
    protected boolean flushBatchId = true;
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();
    protected List<IProtocolDataWriterListener> listeners;
    protected String sourceNodeId;
    protected boolean noBinaryOldData = false;
    protected boolean backwardsCompatible = false;
    protected boolean sendCaptureTime = false;
    protected boolean sendRowCaptureTime = false;
    protected long baseTime;
    protected long lastTime;

    public AbstractProtocolDataWriter(String sourceNodeId, List<IProtocolDataWriterListener> listeners, boolean backwardsCompatible, boolean sendCaptureTime, boolean sendRowCaptureTime) {
        this.listeners = listeners;
        this.sourceNodeId = sourceNodeId;
        this.backwardsCompatible = backwardsCompatible;
        this.sendCaptureTime = sendCaptureTime;
        this.sendRowCaptureTime = sendRowCaptureTime;
    }

    @Override
    public void open(DataContext context) {
        this.context = context;
    }

    @Override
    public void close() {
    }

    @Override
    public void start(Batch batch) {
        this.statistics.put(batch, new Statistics());
        this.batch = batch;
        this.baseTime = 0L;
        this.lastTime = 0L;
        if (this.listeners != null) {
            for (IProtocolDataWriterListener listener : this.listeners) {
                listener.start(this.context, batch);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.sourceNodeId)) {
            this.sourceNodeId = batch.getSourceNodeId();
        }
        if (this.flushNodeId) {
            if (StringUtils.isNotBlank((CharSequence)this.sourceNodeId)) {
                this.println("nodeid", this.sourceNodeId);
            }
            this.flushNodeId = false;
        }
        if (!this.backwardsCompatible && StringUtils.isNotBlank((CharSequence)batch.getChannelId())) {
            this.println("channel", batch.getChannelId());
        }
        this.flushBatchId = true;
    }

    private void printBinary() {
        BinaryEncoding binaryEncoding = this.batch.getBinaryEncoding();
        if (binaryEncoding != null) {
            this.println("binary", binaryEncoding.name());
        }
    }

    private void printBatchIfNeeded() {
        if (this.flushBatchId) {
            if (!this.backwardsCompatible) {
                this.printBinary();
            }
            this.println("batch", Long.toString(this.batch.getBatchId()));
            if (this.backwardsCompatible) {
                this.printBinary();
            }
            this.flushBatchId = false;
        }
    }

    @Override
    public boolean start(Table table) {
        this.printBatchIfNeeded();
        if (!this.batch.isIgnored()) {
            this.table = table;
            if (!this.backwardsCompatible) {
                String catalogName = table.getCatalog();
                this.println("catalog", StringUtils.isNotBlank((CharSequence)catalogName) ? catalogName : "");
                String schemaName = table.getSchema();
                this.println("schema", StringUtils.isNotBlank((CharSequence)schemaName) ? schemaName : "");
            }
            String tableKey = table.getTableKey();
            String fullyQualifiedTableName = table.getFullyQualifiedTableName();
            String previousTableKey = this.processedTables.get(fullyQualifiedTableName);
            this.println("table", CsvUtils.escapeAndQuoteCsvData(table.getName()));
            if (!tableKey.equals(previousTableKey)) {
                this.println("keys", table.getPrimaryKeyColumns());
                this.println("columns", table.getColumns());
                this.processedTables.put(fullyQualifiedTableName, tableKey);
            }
            return true;
        }
        return false;
    }

    @Override
    public void write(CsvData data) {
        if (!this.batch.isIgnored()) {
            if (this.noBinaryOldData != data.isNoBinaryOldData() && !this.backwardsCompatible) {
                this.noBinaryOldData = data.isNoBinaryOldData();
                this.println("no_binary_old_data", Boolean.toString(this.noBinaryOldData));
            }
            this.statistics.get(this.batch).increment("STATEMENTCOUNT");
            this.statistics.get(this.batch).increment("LINENUMBER");
            switch (data.getDataEventType()) {
                case INSERT: {
                    this.printTime(data);
                    this.println("insert", data.getCsvData("rowData"));
                    this.statistics.get(this.batch).increment("INSERTCOUNT");
                    this.statistics.get(this.batch).incrementTableStats(this.table.getNameLowerCase(), DataEventType.INSERT.getCode(), 1L);
                    break;
                }
                case UPDATE: {
                    String oldData;
                    this.printTime(data);
                    if (!this.backwardsCompatible && StringUtils.isNotBlank((CharSequence)(oldData = data.getCsvData("oldData")))) {
                        this.println("old", oldData);
                    }
                    this.println("update", data.getCsvData("rowData"), data.getCsvData("pkData"));
                    this.statistics.get(this.batch).increment("UPDATECOUNT");
                    this.statistics.get(this.batch).incrementTableStats(this.table.getNameLowerCase(), DataEventType.UPDATE.getCode(), 1L);
                    break;
                }
                case DELETE: {
                    String oldData;
                    this.printTime(data);
                    if (!this.backwardsCompatible && StringUtils.isNotBlank((CharSequence)(oldData = data.getCsvData("oldData")))) {
                        this.println("old", oldData);
                    }
                    this.println("delete", data.getCsvData("pkData"));
                    this.statistics.get(this.batch).increment("DELETECOUNT");
                    this.statistics.get(this.batch).incrementTableStats(this.table.getNameLowerCase(), DataEventType.DELETE.getCode(), 1L);
                    break;
                }
                case CREATE: {
                    this.println("create", data.getCsvData("rowData"));
                    break;
                }
                case BSH: {
                    this.println("bsh", data.getCsvData("rowData"));
                    break;
                }
                case SQL: {
                    this.println("sql", data.getCsvData("rowData"));
                    break;
                }
            }
        }
    }

    protected void printTime(CsvData data) {
        long thisTime;
        Date createTime = (Date)data.getAttribute("createTime");
        if (this.sendCaptureTime && this.baseTime == 0L && createTime != null) {
            this.baseTime = createTime.getTime();
            this.println("basetime", String.valueOf(this.baseTime));
        }
        if (this.sendCaptureTime && this.sendRowCaptureTime && createTime != null && (thisTime = createTime.getTime() - this.baseTime) != this.lastTime) {
            this.println("ts", String.valueOf(thisTime));
            this.lastTime = thisTime;
        }
    }

    @Override
    public void end(Table table) {
    }

    @Override
    public final void end(Batch batch, boolean inError) {
        this.printBatchIfNeeded();
        if (batch.isIgnored() && !this.backwardsCompatible) {
            this.println("ignore");
        }
        if (!inError) {
            this.println("commit", Long.toString(batch.getBatchId()));
            this.endBatch(batch);
        }
        if (this.listeners != null && !inError) {
            for (IProtocolDataWriterListener listener : this.listeners) {
                this.notifyEndBatch(batch, listener);
            }
        }
    }

    protected void endBatch(Batch batch) {
        this.printBatchIfNeeded();
    }

    protected abstract void notifyEndBatch(Batch var1, IProtocolDataWriterListener var2);

    protected int println(String key, List<Column> columns) {
        return this.println(key, columns.toArray(new Column[columns.size()]));
    }

    protected int println(String key, Column[] columns) {
        StringBuilder buffer = new StringBuilder(key);
        for (int i = 0; i < columns.length; ++i) {
            buffer.append(this.delimiter);
            String name = columns[i].getName();
            buffer.append(Table.escapeColumnNameForCsv((String)name));
        }
        this.println(buffer.toString());
        return buffer.length();
    }

    protected abstract void print(Batch var1, String var2);

    protected long println(String ... data) {
        long byteCount = 0L;
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                this.print(this.batch, this.delimiter);
                byteCount += (long)this.delimiter.length();
            }
            this.print(this.batch, data[i]);
            if (data[i] == null) continue;
            byteCount += (long)data[i].length();
        }
        this.print(this.batch, "\n");
        this.statistics.get(this.batch).increment("BYTECOUNT", byteCount += (long)"\n".length());
        return byteCount;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }
}

