/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.NonUniqueIndex;
import org.jumpmind.db.model.PlatformIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DataTruncationException;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.LogSqlBuilder;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlScriptReader;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.util.CollectionUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseWriter
extends AbstractDatabaseWriter {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseWriter.class);
    public static final String CUR_DATA = "DatabaseWriter.CurData";
    private final String ATTRIBUTE_CHANNEL_ID_RELOAD = "reload";
    private final String TRUNCATE_PATTERN = "^(truncate)( table)?.*";
    private final String DELETE_PATTERN = "^(delete from).*";
    private final String INSERT_PATTERN = "^(insert into).*";
    private final String UPDATE_PATTERN = "^(update ).*";
    private final String ALTER_DEF_CONSTRAINT_PATTERN = " *alter +table +[\\[\\\"]{0,1}(.*?)[\\]\\\"]{0,1} +drop +constraint +[\\[\\\"]{0,1}(df__.*?)[\\]\\\"]{0,1} *";
    private final String ALTER_TABLE_PATTERN = " *(alter|create) +.*";
    protected IDatabasePlatform platform;
    protected ISqlTransaction transaction;
    protected DmlStatement currentDmlStatement;
    protected Object[] currentDmlValues;
    protected LogSqlBuilder logSqlBuilder = new LogSqlBuilder();
    protected Boolean isCteExpression;
    protected boolean hasUncommittedDdl;

    public DefaultDatabaseWriter(IDatabasePlatform platform) {
        this(platform, null, null);
    }

    public DefaultDatabaseWriter(IDatabasePlatform platform, DatabaseWriterSettings settings) {
        this(platform, null, settings);
    }

    public DefaultDatabaseWriter(IDatabasePlatform platform, IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings) {
        super(conflictResolver, settings);
        this.platform = platform;
        this.isRequiresSavePointsInTransaction = platform.getDatabaseInfo().isRequiresSavePointsInTransaction();
    }

    public IDatabasePlatform getPlatform() {
        return this.platform;
    }

    public IDatabasePlatform getPlatform(Table table) {
        return this.platform;
    }

    public IDatabasePlatform getPlatform(String table) {
        return this.platform;
    }

    public IDatabasePlatform getTargetPlatform() {
        return this.platform;
    }

    public ISqlTransaction getTransaction() {
        return this.transaction;
    }

    public ISqlTransaction getTransaction(Table table) {
        return this.transaction;
    }

    public ISqlTransaction getTransaction(String table) {
        return this.transaction;
    }

    public ISqlTransaction getTargetTransaction() {
        return this.transaction;
    }

    @Override
    public void open(DataContext context) {
        super.open(context);
        this.transaction = this.platform.getSqlTemplate().startSqlTransaction();
    }

    @Override
    public boolean start(Table table) {
        this.currentDmlStatement = null;
        boolean process = super.start(table);
        if (process && this.targetTable != null) {
            this.allowInsertIntoAutoIncrementColumns(true, this.targetTable);
        }
        return process;
    }

    @Override
    public void end(Table table) {
        super.end(table);
        if (this.transaction.isAllowInsertIntoAutoIncrement()) {
            this.transaction.flush();
        }
        this.allowInsertIntoAutoIncrementColumns(false, this.targetTable);
    }

    @Override
    public void end(Batch batch, boolean inError) {
        this.currentDmlStatement = null;
        if (inError) {
            this.allowInsertIntoAutoIncrementColumns(false, this.targetTable);
        }
        super.end(batch, inError);
    }

    @Override
    public void close() {
        super.close();
        if (this.transaction != null) {
            this.transaction.close();
        }
    }

    @Override
    protected void commit(boolean earlyCommit) {
        if (this.transaction != null) {
            try {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                this.transaction.commit();
                if (!earlyCommit) {
                    this.notifyFiltersBatchCommitted();
                } else {
                    this.notifyFiltersEarlyCommit();
                }
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
            }
        }
        super.commit(earlyCommit);
        this.hasUncommittedDdl = false;
    }

    protected void commit(boolean earlyCommit, ISqlTransaction newTransaction) {
        if (this.transaction != null) {
            try {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                newTransaction.commit();
                if (!earlyCommit) {
                    this.notifyFiltersBatchCommitted();
                } else {
                    this.notifyFiltersEarlyCommit();
                }
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
            }
        }
        super.commit(earlyCommit);
        this.hasUncommittedDdl = false;
    }

    @Override
    protected void rollback() {
        if (this.transaction != null) {
            try {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                this.transaction.rollback();
                this.notifyFiltersBatchRolledback();
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
            }
        }
        super.rollback();
        this.hasUncommittedDdl = false;
    }

    protected boolean isCteExpression() {
        if (this.isCteExpression == null) {
            this.isCteExpression = this.getPlatform().getDdlBuilder().getDatabaseInfo().getCteExpression() != null;
        }
        return this.isCteExpression;
    }

    protected void replaceCteExpression() {
        if (this.isCteExpression()) {
            this.currentDmlStatement.updateCteExpression(this.batch.getSourceNodeId());
        }
    }

    protected String replaceCteExpression(String sql) {
        Object retSql = sql;
        if (this.isCteExpression()) {
            retSql = this.getPlatform().getDdlBuilder().getDatabaseInfo().getCteExpression() + " " + sql;
            retSql = DmlStatement.updateCteExpression((String)retSql, (String)this.batch.getSourceNodeId());
        }
        return retSql;
    }

    protected boolean isDml(String sql) {
        return sql.matches("^(insert into).*") || sql.matches("^(update ).*") || sql.matches("^(delete from).*");
    }

    @Override
    protected AbstractDatabaseWriter.LoadStatus insert(CsvData data) {
        String[] values = null;
        try {
            if (this.isRequiresSavePointsInTransaction && this.conflictResolver != null && this.conflictResolver.isIgnoreRow(this, data)) {
                ((Statistics)this.statistics.get(this.batch)).increment("IGNOREROWCOUNT");
                this.currentDmlStatement = null;
                AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                return loadStatus;
            }
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            if (this.requireNewStatement(DmlStatement.DmlType.INSERT, data, false, true, null)) {
                this.checkTargetTableHasColumns();
                this.lastUseConflictDetection = true;
                this.currentDmlStatement = this.getPlatform().createDmlStatement(DmlStatement.DmlType.INSERT, this.targetTable, this.writerSettings.getTextColumnExpression());
                this.replaceCteExpression();
                if (log.isDebugEnabled()) {
                    log.debug("Preparing dml: " + this.currentDmlStatement.getSql());
                }
                this.prepare();
            }
            boolean isFindAndThrowException = false;
            try {
                Conflict conflict = this.writerSettings.pickConflict(this.targetTable, this.batch);
                values = (String[])ArrayUtils.addAll((Object[])this.getRowData(data, "rowData"), (Object[])this.currentDmlStatement.getLookupKeyData(this.getLookupDataMap(data, conflict)));
                long count = this.execute(data, values);
                ((Statistics)this.statistics.get(this.batch)).increment("INSERTCOUNT", count);
                ((Statistics)this.statistics.get(this.batch)).incrementTableStats(this.targetTable.getName(), DataEventType.INSERT.getCode(), count);
                if (count > 0L) {
                    AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                    return loadStatus;
                }
                isFindAndThrowException = true;
            }
            catch (SqlException ex) {
                if (this.isRequiresSavePointsInTransaction && !isFindAndThrowException) {
                    this.context.put("DatabaseWriter.TransactionAborted", true);
                }
                if (this.getPlatform().getSqlTemplate().isUniqueKeyViolation((Throwable)ex)) {
                    this.context.put("DatabaseWriter.ConflictError", (Object)ex);
                    this.context.put(CUR_DATA, this.getCurData(this.getTransaction()));
                    this.context.setLastError(ex);
                    AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                    return loadStatus;
                }
                try {
                    throw ex;
                }
                catch (RuntimeException ex2) {
                    this.logFailureDetails(ex2, data, true, values);
                    throw ex2;
                }
            }
            this.findAndThrowInsertException(data, values);
            AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.CONFLICT;
            return loadStatus;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    private void findAndThrowInsertException(CsvData data, String[] values) throws SqlException {
        if (this.isRequiresSavePointsInTransaction && !this.getTransaction().isInBatchMode()) {
            try {
                this.getTransaction().execute("savepoint sym");
                this.getTransaction().prepare(this.currentDmlStatement.getSql(false));
                this.currentDmlValues = this.getPlatform().getObjectValues(this.batch.getBinaryEncoding(), values, this.currentDmlStatement.getMetaData(), false, this.writerSettings.isFitToColumn());
                this.getTransaction().addRow((Object)data, this.currentDmlValues, this.currentDmlStatement.getTypes());
            }
            catch (SqlException e) {
                this.getTransaction().execute("rollback to savepoint sym");
                throw e;
            }
            finally {
                this.getTransaction().execute("release savepoint sym");
                this.getTransaction().prepare(this.currentDmlStatement.getSql(true));
            }
        }
    }

    @Override
    protected AbstractDatabaseWriter.LoadStatus delete(CsvData data, boolean useConflictDetection) {
        try {
            AbstractDatabaseWriter.LoadStatus loadStatus;
            block31: {
                if (this.isRequiresSavePointsInTransaction && this.conflictResolver != null && this.conflictResolver.isIgnoreRow(this, data)) {
                    ((Statistics)this.statistics.get(this.batch)).increment("IGNOREROWCOUNT");
                    this.currentDmlStatement = null;
                    AbstractDatabaseWriter.LoadStatus loadStatus2 = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                    return loadStatus2;
                }
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                Conflict conflict = this.writerSettings.pickConflict(this.targetTable, this.batch);
                Map<String, String> lookupDataMap = null;
                if (this.requireNewStatement(DmlStatement.DmlType.DELETE, data, useConflictDetection, useConflictDetection, conflict.getDetectType())) {
                    this.lastUseConflictDetection = useConflictDetection;
                    ArrayList<Column> lookupKeys = null;
                    if (!useConflictDetection) {
                        lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                    } else {
                        switch (conflict.getDetectType()) {
                            case USE_OLD_DATA: 
                            case USE_CHANGED_DATA: {
                                if (data.contains("oldData")) {
                                    lookupKeys = this.targetTable.getColumnsAsList();
                                    break;
                                }
                                lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                                break;
                            }
                            case USE_VERSION: 
                            case USE_TIMESTAMP: {
                                Column[] pks;
                                ArrayList<Column> lookupColumns = new ArrayList<Column>();
                                Column versionColumn = this.targetTable.getColumnWithName(conflict.getDetectExpression());
                                if (versionColumn != null) {
                                    lookupColumns.add(versionColumn);
                                } else {
                                    log.error("Could not find the timestamp/version column with the name {} on table {}.  Defaulting to using primary keys for the lookup.", (Object)conflict.getDetectExpression(), (Object)this.targetTable.getName());
                                }
                                for (Column column : pks = this.targetTable.getPrimaryKeyColumns()) {
                                    lookupColumns.remove(column);
                                    lookupColumns.add(column);
                                }
                                lookupKeys = lookupColumns;
                                break;
                            }
                            default: {
                                lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                            }
                        }
                    }
                    if (lookupKeys == null || lookupKeys.size() == 0) {
                        lookupKeys = this.targetTable.getColumnsAsList();
                    }
                    int lookupKeyCountBeforeColumnRemoval = lookupKeys.size();
                    Iterator it = lookupKeys.iterator();
                    while (it.hasNext()) {
                        Column col = (Column)it.next();
                        if ((!this.getPlatform().isLob(col) || !data.isNoBinaryOldData()) && this.getPlatform().canColumnBeUsedInWhereClause(col)) continue;
                        it.remove();
                    }
                    if (lookupKeys.size() == 0) {
                        String msg = "There are no keys defined for " + this.targetTable.getFullyQualifiedTableName() + ".  Cannot build a delete statement.  ";
                        if (lookupKeyCountBeforeColumnRemoval > 0) {
                            msg = msg + "The only keys defined are binary and they have been removed.";
                        }
                        throw new IllegalStateException(msg);
                    }
                    lookupDataMap = this.getLookupDataMap(data, conflict);
                    boolean[] nullKeyValues = new boolean[lookupKeys.size()];
                    for (int i = 0; i < lookupKeys.size(); ++i) {
                        Column column = (Column)lookupKeys.get(i);
                        nullKeyValues[i] = !column.isRequired() && lookupDataMap.get(column.getName()) == null;
                    }
                    this.currentDmlStatement = this.getPlatform().createDmlStatement(DmlStatement.DmlType.DELETE, this.targetTable.getCatalog(), this.targetTable.getSchema(), this.targetTable.getName(), lookupKeys.toArray(new Column[lookupKeys.size()]), null, nullKeyValues, this.writerSettings.getTextColumnExpression());
                    this.replaceCteExpression();
                    if (log.isDebugEnabled()) {
                        log.debug("Preparing dml: " + this.currentDmlStatement.getSql());
                    }
                    this.prepare();
                }
                try {
                    lookupDataMap = lookupDataMap == null ? this.getLookupDataMap(data, conflict) : lookupDataMap;
                    long count = this.execute(data, this.currentDmlStatement.getLookupKeyData(lookupDataMap));
                    ((Statistics)this.statistics.get(this.batch)).increment("DELETECOUNT", count);
                    ((Statistics)this.statistics.get(this.batch)).incrementTableStats(this.targetTable.getName(), DataEventType.DELETE.getCode(), count);
                    if (count <= 0L) break block31;
                    loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                    return loadStatus;
                }
                catch (RuntimeException ex) {
                    if (this.isRequiresSavePointsInTransaction && ex instanceof SqlException) {
                        this.context.put("DatabaseWriter.TransactionAborted", true);
                    }
                    if (this.getPlatform().getSqlTemplate().isForeignKeyChildExistsViolation((Throwable)ex)) {
                        this.context.put("DatabaseWriter.ConflictError", ex);
                        this.context.put(CUR_DATA, null);
                        this.context.setLastError(ex);
                        AbstractDatabaseWriter.LoadStatus loadStatus3 = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                        return loadStatus3;
                    }
                    try {
                        throw ex;
                    }
                    catch (SqlException ex2) {
                        this.logFailureDetails(ex2, data, true);
                        throw ex2;
                    }
                }
            }
            this.context.put(CUR_DATA, null);
            loadStatus = AbstractDatabaseWriter.LoadStatus.CONFLICT;
            return loadStatus;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AbstractDatabaseWriter.LoadStatus update(CsvData data, boolean applyChangesOnly, boolean useConflictDetection) {
        try {
            if (this.isRequiresSavePointsInTransaction && this.conflictResolver != null && this.conflictResolver.isIgnoreRow(this, data)) {
                ((Statistics)this.statistics.get(this.batch)).increment("IGNOREROWCOUNT");
                this.currentDmlStatement = null;
                AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                return loadStatus;
            }
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            Object[] rowData = this.getRowData(data, "rowData");
            String[] oldData = this.getRowData(data, "oldData");
            ArrayList<String> changedColumnValueList = new ArrayList<String>();
            ArrayList<Column> changedColumnsList = new ArrayList<Column>();
            for (int i = 0; i < this.targetTable.getColumnCount(); ++i) {
                Column column = this.targetTable.getColumn(i);
                if (column == null || !this.doesColumnNeedUpdated(i, column, data, (String[])rowData, oldData, applyChangesOnly)) continue;
                changedColumnsList.add(column);
                changedColumnValueList.add(rowData[i]);
            }
            if (changedColumnsList.size() > 0) {
                block37: {
                    Map<String, String> lookupDataMap = null;
                    Conflict conflict = this.writerSettings.pickConflict(this.targetTable, this.batch);
                    if (this.requireNewStatement(DmlStatement.DmlType.UPDATE, data, applyChangesOnly, useConflictDetection, conflict.getDetectType())) {
                        this.lastApplyChangesOnly = applyChangesOnly;
                        this.lastUseConflictDetection = useConflictDetection;
                        ArrayList<Column> lookupKeys = null;
                        if (!useConflictDetection) {
                            lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                        } else {
                            switch (conflict.getDetectType()) {
                                case USE_CHANGED_DATA: {
                                    ArrayList<Column> lookupColumns;
                                    if (data.contains("oldData")) {
                                        Column[] pks;
                                        lookupColumns = new ArrayList(changedColumnsList);
                                        for (Column column : pks = this.targetTable.getPrimaryKeyColumns()) {
                                            lookupColumns.remove(column);
                                            lookupColumns.add(column);
                                        }
                                        this.removeExcludedColumns(conflict, lookupColumns);
                                        lookupKeys = lookupColumns;
                                        break;
                                    }
                                    lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                                    break;
                                }
                                case USE_OLD_DATA: {
                                    if (data.contains("oldData")) {
                                        lookupKeys = this.targetTable.getColumnsAsList();
                                        this.removeExcludedColumns(conflict, (List<Column>)lookupKeys);
                                        break;
                                    }
                                    lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                                    break;
                                }
                                case USE_VERSION: 
                                case USE_TIMESTAMP: {
                                    Column[] columnArray;
                                    ArrayList<Column> lookupColumns = new ArrayList<Column>();
                                    Column versionColumn = this.targetTable.getColumnWithName(conflict.getDetectExpression());
                                    if (versionColumn != null) {
                                        lookupColumns.add(versionColumn);
                                    } else {
                                        log.error("Could not find the timestamp/version column with the name {} on table {}.  Defaulting to using primary keys for the lookup.", (Object)conflict.getDetectExpression(), (Object)this.targetTable.getName());
                                    }
                                    for (Column column : columnArray = this.targetTable.getPrimaryKeyColumns()) {
                                        lookupColumns.remove(column);
                                        lookupColumns.add(column);
                                    }
                                    lookupKeys = lookupColumns;
                                    break;
                                }
                                default: {
                                    lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                                }
                            }
                        }
                        if (lookupKeys == null || lookupKeys.size() == 0) {
                            lookupKeys = this.targetTable.getColumnsAsList();
                        }
                        int lookupKeyCountBeforeColumnRemoval = lookupKeys.size();
                        Iterator it = lookupKeys.iterator();
                        while (it.hasNext()) {
                            Column column = (Column)it.next();
                            if ((!this.getPlatform().isLob(column) || !data.isNoBinaryOldData()) && this.getPlatform().canColumnBeUsedInWhereClause(column)) continue;
                            it.remove();
                        }
                        if (lookupKeys.size() == 0) {
                            void var13_27;
                            String string = "There are no keys defined for " + this.targetTable.getFullyQualifiedTableName() + ".  Cannot build an update statement.  ";
                            if (lookupKeyCountBeforeColumnRemoval > 0) {
                                String string2 = string + "The only keys defined are binary and they have been removed.";
                            }
                            throw new IllegalStateException((String)var13_27);
                        }
                        lookupDataMap = this.getLookupDataMap(data, conflict);
                        boolean[] blArray = new boolean[lookupKeys.size()];
                        for (int i = 0; i < lookupKeys.size(); ++i) {
                            Column column = (Column)lookupKeys.get(i);
                            blArray[i] = !column.isRequired() && lookupDataMap.get(column.getName()) == null;
                        }
                        this.currentDmlStatement = this.getPlatform().createDmlStatement(DmlStatement.DmlType.UPDATE, this.targetTable.getCatalog(), this.targetTable.getSchema(), this.targetTable.getName(), lookupKeys.toArray(new Column[lookupKeys.size()]), changedColumnsList.toArray(new Column[changedColumnsList.size()]), blArray, this.writerSettings.getTextColumnExpression());
                        this.replaceCteExpression();
                        if (log.isDebugEnabled()) {
                            log.debug("Preparing dml: " + this.currentDmlStatement.getSql());
                        }
                        this.prepare();
                    }
                    rowData = changedColumnValueList.toArray(new String[changedColumnValueList.size()]);
                    lookupDataMap = lookupDataMap == null ? this.getLookupDataMap(data, conflict) : lookupDataMap;
                    String[] values = (String[])ArrayUtils.addAll((Object[])rowData, (Object[])this.currentDmlStatement.getLookupKeyData(lookupDataMap));
                    try {
                        long count = this.execute(data, values);
                        ((Statistics)this.statistics.get(this.batch)).increment("UPDATECOUNT", count);
                        ((Statistics)this.statistics.get(this.batch)).incrementTableStats(this.targetTable.getName(), DataEventType.UPDATE.getCode(), count);
                        if (count <= 0L) break block37;
                        AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                        return loadStatus;
                    }
                    catch (SqlException ex) {
                        if (this.isRequiresSavePointsInTransaction) {
                            this.context.put("DatabaseWriter.TransactionAborted", true);
                        }
                        if (this.getPlatform().getSqlTemplate().isUniqueKeyViolation((Throwable)ex) || this.getPlatform().getSqlTemplate().isForeignKeyChildExistsViolation((Throwable)ex)) {
                            this.context.put("DatabaseWriter.ConflictError", (Object)ex);
                            this.context.put(CUR_DATA, this.getCurData(this.getTransaction()));
                            this.context.setLastError(ex);
                            AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                            return loadStatus;
                        }
                        throw ex;
                    }
                }
                this.context.put(CUR_DATA, this.getCurData(this.getTransaction()));
                AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                return loadStatus;
            }
            this.checkTargetTableHasColumns();
        }
        catch (RuntimeException ex) {
            this.logFailureDetails(ex, data, true);
            throw ex;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
        if (log.isDebugEnabled()) {
            log.debug("Not running update for table {} with pk of {}.  There was no change to apply", (Object)this.targetTable.getFullyQualifiedTableName(), (Object)data.getCsvData("pkData"));
        }
        AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
        return loadStatus;
    }

    protected void checkTargetTableHasColumns() {
        if (this.targetTable.getColumnCount() == 0) {
            throw new IllegalStateException("There are no columns defined for table " + this.targetTable.getFullyQualifiedTableName() + " that match with " + this.sourceTable.getColumnCount() + " columns in the batch");
        }
    }

    @Override
    protected boolean create(CsvData data) {
        return this.create(data, false);
    }

    protected boolean create(CsvData data, boolean withoutDefaults) {
        String xml = null;
        Database db = null;
        boolean hasMatchingPlatform = false;
        try {
            this.getTargetTransaction().commit();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            xml = data.getParsedData("rowData")[0];
            log.info("Incoming batch {} on channel {} contains the following table definition: {}", new Object[]{this.batch.getNodeBatchId(), this.batch.getChannelId(), xml});
            StringReader reader = new StringReader(xml);
            db = DatabaseXmlUtil.read((Reader)reader, (boolean)false);
            hasMatchingPlatform = this.getTargetPlatform().hasMatchingPlatform(db);
            if (this.writerSettings.isCreateTableAlterCaseToMatchDatabaseDefault() && !hasMatchingPlatform) {
                this.getTargetPlatform().alterCaseToMatchDatabaseDefaultCase(db);
            }
            this.getTargetPlatform().makePlatformSpecific(db);
            if (withoutDefaults) {
                for (Table table : db.getTables()) {
                    table.removeAllColumnDefaults();
                }
            }
            if (this.writerSettings.isCreateIndexConvertUniqueToNonuniqueWhenColumnsNotRequired() && !this.getTargetPlatform().allowsUniqueIndexDuplicatesWithNulls()) {
                for (Table table : db.getTables()) {
                    for (IIndex index : table.getUniqueIndices()) {
                        boolean needsFixed = false;
                        for (IndexColumn indexColumn : index.getColumns()) {
                            Column column = indexColumn.getColumn();
                            if (column == null || column.isRequired()) continue;
                            needsFixed = true;
                            log.warn("Detected Unique Index: {} with potential for multiple null values in table: {} on column: {}. Adjusting index to be NonUnique.", new Object[]{index.getName(), table.getName(), column.getName()});
                            break;
                        }
                        if (!needsFixed) continue;
                        table.removeIndex(index);
                        NonUniqueIndex newIndex = new NonUniqueIndex(index.getName());
                        for (IndexColumn indexColumn : index.getColumns()) {
                            newIndex.addColumn(indexColumn);
                        }
                        if (index.getPlatformIndexes() != null) {
                            for (PlatformIndex platformIndex : index.getPlatformIndexes().values()) {
                                newIndex.addPlatformIndex(platformIndex);
                            }
                        }
                        table.addIndex((IIndex)newIndex);
                    }
                }
            }
            if (this.writerSettings.isAlterTable()) {
                this.getTargetPlatform().alterTables(!this.writerSettings.isCreateTableFailOnError(), this.writerSettings.isCreateTableIncludeApplicationTriggers(), this.writerSettings.getRuntimeConfigTriggerPrefix(), this.writerSettings.getAlterDatabaseInterceptors(), db.getTables());
            } else {
                this.getTargetPlatform().createDatabase(db, this.writerSettings.isCreateTableDropFirst(), !this.writerSettings.isCreateTableFailOnError());
            }
            this.getTargetPlatform().resetCachedTableModel();
            ((Statistics)this.statistics.get(this.batch)).increment("CREATECOUNT");
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException ex) {
            if (!withoutDefaults && this.writerSettings.isCreateTableWithoutDefaultsOnError() && !hasMatchingPlatform) {
                log.info("Attempting to create table again without defaults");
                boolean bl = this.create(data, true);
                return bl;
            }
            throw ex;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sql(CsvData data) {
        try {
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            String[] parsedData = data.getParsedData("rowData");
            String script = parsedData[0];
            boolean captureChanges = parsedData.length > 1 && parsedData[1].equals("1");
            List<String> sqlStatements = this.getSqlStatements(script);
            long count = 0L;
            Pattern defConsPattern = Pattern.compile(" *alter +table +[\\[\\\"]{0,1}(.*?)[\\]\\\"]{0,1} +drop +constraint +[\\[\\\"]{0,1}(df__.*?)[\\]\\\"]{0,1} *", 2);
            Pattern alterPattern = Pattern.compile(" *(alter|create) +.*", 2);
            for (String sql : sqlStatements) {
                ISqlTransaction newTransaction = null;
                try {
                    sql = this.preprocessSqlStatement(sql);
                    Matcher defConsMatcher = defConsPattern.matcher(sql);
                    if (this.getPlatform().getName().startsWith("mssql") && defConsMatcher.matches()) {
                        String tableName = defConsMatcher.group(1);
                        String constraintName = defConsMatcher.group(2);
                        String constraintPrefix = constraintName.substring(0, constraintName.lastIndexOf("__"));
                        String querySql = "select c.name from sys.default_constraints c inner join sys.objects o on o.object_id = c.parent_object_id where c.name like ? and o.name = ?";
                        List names = this.getTransaction().query(querySql, (ISqlRowMapper)new StringMapper(), new Object[]{constraintPrefix + "%", tableName}, new int[]{12, 12});
                        if (names.size() > 0) {
                            sql = sql.replace(constraintName, (CharSequence)names.get(0));
                        }
                    }
                    if (captureChanges) {
                        newTransaction = this.getPlatform().getSqlTemplate().startSqlTransaction();
                        if (sql.matches("^(truncate)( table)?.*") && this.getPlatform().getName().equals("db2")) {
                            this.commit(true, newTransaction);
                        }
                        newTransaction.prepare(sql);
                        log.info("Running SQL event: {}", (Object)sql);
                        count += (long)newTransaction.prepareAndExecute(sql, new Object[0]);
                        if (log.isDebugEnabled()) {
                            log.debug("{} rows updated when running: {}", (Object)count, (Object)sql);
                        }
                    } else {
                        if (sql.matches("^(truncate)( table)?.*") && this.getPlatform().getName().equals("db2")) {
                            this.commit(true);
                        }
                        if (this.isDml(sql)) {
                            sql = this.replaceCteExpression(sql);
                        }
                        this.prepare(sql, data);
                        log.info("Running SQL event: {}", (Object)sql);
                        count += (long)this.prepareAndExecute(sql, data);
                        if (log.isDebugEnabled()) {
                            log.debug("{} rows updated when running: {}", (Object)count, (Object)sql);
                        }
                    }
                    Matcher alterMatcher = alterPattern.matcher(sql);
                    this.hasUncommittedDdl |= alterMatcher.matches();
                }
                catch (Error ex) {
                    log.error("Failed to run the following sql: {}", (Object)sql);
                    if (newTransaction != null) {
                        newTransaction.rollback();
                    }
                    if (this.writerSettings.isIgnoreSqlDataEventFailures()) continue;
                    throw ex;
                }
                catch (SqlException ex) {
                    String massagedSql;
                    log.info("Attempting to correct SQL statement failure", (Throwable)ex);
                    if (this.platform.getSqlTemplate().doesObjectAlreadyExist((Throwable)ex)) {
                        massagedSql = this.platform.massageForObjectAlreadyExists(sql);
                        if (!sql.equals(massagedSql)) {
                            if (massagedSql.contains("alter")) {
                                log.info("Changing the following sql to an alter because the created object already exists: {}", (Object)sql);
                            } else if (massagedSql.contains("create or replace") || massagedSql.contains("create or alter")) {
                                log.info("Changing the following sql to a create or replace because the created object already exists: {}", (Object)sql);
                            } else if (massagedSql.startsWith("drop")) {
                                log.info("Dropping the object before running the following sql because the created object already exists: {}", (Object)sql);
                            }
                            count = this.retryWithMassagedSql(massagedSql, newTransaction, data, captureChanges, count);
                            continue;
                        }
                        this.handleRuntimeException((RuntimeException)((Object)ex), sql, newTransaction);
                        continue;
                    }
                    if (this.platform.getSqlTemplate().doesObjectNotExist((Throwable)ex)) {
                        if (sql.trim().toUpperCase().startsWith("DROP")) {
                            log.info("Skipping the following sql because the dropped object does not exist: {}", (Object)sql);
                            if (newTransaction != null) {
                                newTransaction.rollback();
                                continue;
                            }
                            if (this.transaction == null) continue;
                            this.transaction.rollback();
                            continue;
                        }
                        massagedSql = this.platform.massageForObjectDoesNotExist(sql);
                        if (!sql.equals(massagedSql)) {
                            log.info("Changing the following sql to a create because the altered object does not exist: {}", (Object)sql);
                            count = this.retryWithMassagedSql(massagedSql, newTransaction, data, captureChanges, count);
                            continue;
                        }
                        this.handleRuntimeException((RuntimeException)((Object)ex), sql, newTransaction);
                        continue;
                    }
                    this.handleRuntimeException((RuntimeException)((Object)ex), sql, newTransaction);
                }
                catch (RuntimeException ex) {
                    this.handleRuntimeException(ex, sql, newTransaction);
                }
                finally {
                    if (newTransaction == null) continue;
                    newTransaction.close();
                }
            }
            ((Statistics)this.statistics.get(this.batch)).increment("SQLCOUNT");
            ((Statistics)this.statistics.get(this.batch)).increment("SQLROWSAFFECTEDCOUNT", count);
            boolean bl = true;
            return bl;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    private long retryWithMassagedSql(String sql, ISqlTransaction transaction, CsvData data, boolean captureChanges, long count) {
        try {
            if (captureChanges) {
                if (transaction == null) {
                    transaction = this.getPlatform().getSqlTemplate().startSqlTransaction();
                } else {
                    transaction.rollback();
                }
                transaction.prepare(sql);
                if (log.isDebugEnabled()) {
                    log.debug("About to run: {}", (Object)sql);
                }
                count += (long)transaction.prepareAndExecute(sql, new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug("{} rows updated when running: {}", (Object)count, (Object)sql);
                }
            } else {
                if (this.transaction != null) {
                    this.transaction.rollback();
                }
                this.prepare(sql, data);
                if (log.isDebugEnabled()) {
                    log.debug("About to run: {}", (Object)sql);
                }
                count += (long)this.prepareAndExecute(sql, data);
                if (log.isDebugEnabled()) {
                    log.debug("{} rows updated when running: {}", (Object)count, (Object)sql);
                }
            }
        }
        catch (Error ex) {
            log.error("Failed to run the following sql after changing it: {}", (Object)sql);
            if (transaction != null) {
                transaction.rollback();
            }
            if (!this.writerSettings.isIgnoreSqlDataEventFailures()) {
                throw ex;
            }
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex, sql, transaction);
        }
        return count;
    }

    private void handleRuntimeException(RuntimeException ex, String sql, ISqlTransaction transaction) throws RuntimeException {
        log.error("Failed to run the following sql: {}", (Object)sql);
        if (transaction != null) {
            transaction.rollback();
        }
        if (!this.writerSettings.isIgnoreSqlDataEventFailures()) {
            throw ex;
        }
    }

    protected boolean requireNewStatement(DmlStatement.DmlType currentType, CsvData data, boolean applyChangesOnly, boolean useConflictDetection, Conflict.DetectConflict detectType) {
        boolean requiresNew;
        boolean bl = requiresNew = this.currentDmlStatement == null || this.lastData == null || this.currentDmlStatement.getDmlType() != currentType || this.lastData.getDataEventType() != data.getDataEventType() || this.lastApplyChangesOnly != applyChangesOnly || this.lastUseConflictDetection != useConflictDetection;
        if (!requiresNew && currentType == DmlStatement.DmlType.UPDATE) {
            String lastChanges;
            String currentChanges = Arrays.toString(data.getChangedDataIndicators());
            boolean bl2 = requiresNew = !currentChanges.equals(lastChanges = Arrays.toString(this.lastData.getChangedDataIndicators()));
        }
        if (!requiresNew) {
            requiresNew |= this.containsNullLookupKeyDataSinceLastStatement(currentType, data, detectType);
        }
        return requiresNew;
    }

    protected boolean containsNullLookupKeyDataSinceLastStatement(DmlStatement.DmlType currentType, CsvData data, Conflict.DetectConflict detectType) {
        boolean foundNullValueChange;
        block3: {
            block4: {
                foundNullValueChange = false;
                if (currentType != DmlStatement.DmlType.UPDATE && currentType != DmlStatement.DmlType.DELETE) break block3;
                if (detectType == null || detectType != Conflict.DetectConflict.USE_CHANGED_DATA && detectType != Conflict.DetectConflict.USE_OLD_DATA) break block4;
                String[] lastOldData = this.lastData.getParsedData("oldData");
                String[] newOldData = data.getParsedData("oldData");
                if (lastOldData == null || newOldData == null) break block3;
                for (int i = 0; i < lastOldData.length && i < newOldData.length; ++i) {
                    String lastValue = lastOldData[i];
                    String value = newOldData[i];
                    if ((lastValue == null || value != null) && (value == null || lastValue != null)) continue;
                    foundNullValueChange = true;
                }
                break block3;
            }
            String[] lastpkData = this.lastData.getParsedData("pkData");
            String[] newpkData = data.getParsedData("pkData");
            if (lastpkData != null && newpkData != null) {
                for (int i = 0; i < lastpkData.length && i < newpkData.length; ++i) {
                    String lastValue = lastpkData[i];
                    String value = newpkData[i];
                    if ((lastValue == null || value != null) && (value == null || lastValue != null)) continue;
                    foundNullValueChange = true;
                }
            }
        }
        return foundNullValueChange;
    }

    @Override
    protected void targetTableWasChangedByFilter(Table oldTargetTable) {
        if (oldTargetTable != null) {
            this.allowInsertIntoAutoIncrementColumns(false, oldTargetTable);
        }
        this.allowInsertIntoAutoIncrementColumns(true, this.targetTable);
        this.currentDmlStatement = null;
    }

    private void removeExcludedColumns(Conflict conflict, List<Column> lookupColumns) {
        String[] excludedColumns;
        String excludedString = conflict.getDetectExpressionValue(Conflict.DetectExpressionKey.EXCLUDED_COLUMN_NAMES);
        if (!StringUtils.isBlank((CharSequence)excludedString) && (excludedColumns = excludedString.split(",")).length > 0) {
            Iterator<Column> iter = lookupColumns.iterator();
            block0: while (iter.hasNext()) {
                Column column = iter.next();
                for (String excludedColumn : excludedColumns) {
                    if (!excludedColumn.trim().equalsIgnoreCase(column.getName())) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
    }

    @Override
    protected void logFailureDetails(Throwable e, CsvData data, boolean logLastDmlDetails) {
        this.logFailureDetails(e, data, logLastDmlDetails, this.currentDmlValues);
    }

    @Override
    protected void logFailureDetails(Throwable e, CsvData data, boolean logLastDmlDetails, Object[] values) {
        StringBuilder failureMessage = new StringBuilder();
        failureMessage.append("Failed to process ");
        failureMessage.append(data.getDataEventType().toString().toLowerCase());
        failureMessage.append(" event in batch ");
        failureMessage.append(this.batch.getNodeBatchId());
        failureMessage.append(" on channel '");
        failureMessage.append(this.batch.getChannelId());
        failureMessage.append("'.\n");
        if (logLastDmlDetails && this.currentDmlStatement != null) {
            boolean shouldLogRawSql = true;
            if (this.writerSettings.isLogSqlParamsOnError()) {
                failureMessage.append("Failed sql was: ");
                String dynamicSQL = this.logSqlBuilder.buildDynamicSqlForLog(this.currentDmlStatement.getSql(), values, this.currentDmlStatement.getTypes());
                failureMessage.append(dynamicSQL);
                failureMessage.append("\n");
                boolean bl = shouldLogRawSql = !dynamicSQL.equals(this.currentDmlStatement.getSql());
            }
            if (shouldLogRawSql) {
                failureMessage.append("Failed raw sql was: ");
                failureMessage.append(this.currentDmlStatement.getSql());
            }
            failureMessage.append("\n");
        }
        if (logLastDmlDetails && values != null && this.currentDmlStatement != null) {
            if (this.writerSettings.isLogSqlParamsOnError()) {
                failureMessage.append("Failed sql parameters: ");
                failureMessage.append(StringUtils.abbreviate((String)("[" + this.dmlValuesToString(values, this.currentDmlStatement.getTypes()) + "]"), (int)32768));
                failureMessage.append("\n");
            }
            failureMessage.append("Failed sql parameters types: ");
            failureMessage.append("[" + TypeMap.getJdbcTypeDescriptions((int[])this.currentDmlStatement.getTypes()) + "]");
            failureMessage.append("\n");
        }
        if (logLastDmlDetails && e instanceof SqlException && e.getCause() instanceof SQLException) {
            SQLException se = (SQLException)e.getCause();
            failureMessage.append("Failed sql state and code: ").append(se.getSQLState());
            failureMessage.append(" (").append(se.getErrorCode()).append(")");
            failureMessage.append("\n");
        }
        if (e instanceof DataTruncationException) {
            this.logDataTruncation(data, failureMessage);
        }
        if (this.writerSettings.isLogSqlParamsOnError()) {
            data.writeCsvDataDetails(failureMessage);
        }
        log.warn(failureMessage.toString(), e);
    }

    protected void logDataTruncation(CsvData data, StringBuilder failureMessage) {
        String[] rowData = data.getParsedData("rowData");
        int rowIndex = 0;
        for (Column col : this.targetTable.getColumns()) {
            if (col.getJdbcTypeCode() == 12 && rowData[rowIndex] != null && rowData[rowIndex].length() > Integer.parseInt(col.getSize())) {
                failureMessage.append("Failed truncation column: ");
                failureMessage.append(col.getName());
                failureMessage.append(" with size of: ");
                failureMessage.append(Integer.parseInt(col.getSize()));
                failureMessage.append(" failed to load data: ");
                failureMessage.append(rowData[rowIndex]);
                failureMessage.append("\n");
            }
            ++rowIndex;
        }
    }

    protected String dmlValuesToString(Object[] dmlValues, int[] types) {
        StringBuilder buff = new StringBuilder();
        if (dmlValues == null || dmlValues.length == 0) {
            return "";
        }
        LogSqlBuilder logSqlBuilder = new LogSqlBuilder();
        for (int i = 0; i < dmlValues.length; ++i) {
            int type = i < types.length ? types[i] : -9999;
            buff.append(logSqlBuilder.formatValue(dmlValues[i], type));
            if (i >= dmlValues.length - 1) continue;
            buff.append(", ");
        }
        return buff.toString();
    }

    @Override
    protected void bindVariables(Map<String, Object> variables) {
        super.bindVariables(variables);
        ISqlTemplate template = this.getPlatform().getSqlTemplate();
        Class<?> templateClass = template.getClass();
        if (templateClass.getSimpleName().equals("JdbcSqlTemplate")) {
            try {
                Method method = templateClass.getMethod("getDataSource", new Class[0]);
                variables.put("DATASOURCE", method.invoke((Object)template, new Object[0]));
            }
            catch (Exception e) {
                log.warn("Had trouble looking up the datasource used by the sql template", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getSqlStatements(String script) {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        SqlScriptReader scriptReader = new SqlScriptReader((Reader)new StringReader(script));
        scriptReader.setStripOutComments(this.writerSettings.isStripOutCommentsInScripts());
        try {
            String sql = scriptReader.readSqlStatement();
            while (sql != null) {
                if (StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"delimiter")) {
                    String delimiter;
                    if (log.isDebugEnabled()) {
                        log.debug("Found delimiter line: " + sql);
                    }
                    if ((delimiter = StringUtils.trimToNull((String)sql.substring("delimiter".length()))) != null) {
                        scriptReader.setDelimiter(delimiter);
                    }
                } else {
                    sqlStatements.add(sql);
                }
                sql = scriptReader.readSqlStatement();
            }
            ArrayList<String> arrayList = sqlStatements;
            return arrayList;
        }
        finally {
            try {
                if (scriptReader != null) {
                    scriptReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected String preprocessSqlStatement(String sql) {
        Table table = this.targetTable != null ? this.targetTable : this.sourceTable;
        sql = FormatUtils.replace((String)"nodeId", (String)this.batch.getTargetNodeId(), (String)sql);
        if (table != null) {
            sql = FormatUtils.replace((String)"catalogName", (String)this.quoteString(table.getCatalog()), (String)sql);
            sql = FormatUtils.replace((String)"schemaName", (String)this.quoteString(table.getSchema()), (String)sql);
            sql = FormatUtils.replace((String)"tableName", (String)this.quoteString(table.getName()), (String)sql);
            DatabaseInfo info = this.getPlatform().getDatabaseInfo();
            String quote = this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? info.getDelimiterToken() : "";
            sql = FormatUtils.replace((String)"fullTableName", (String)table.getQualifiedTableName(quote, info.getCatalogSeparator(), info.getSchemaSeparator()), (String)sql);
            String old38CompatibilityTable = "sym_node";
            if ("reload".equals(this.batch.getChannelId()) && sql.matches("^(truncate)( table)?.*") && !table.getNameLowerCase().equals("sym_node")) {
                sql = this.getPlatform().getTruncateSql(table);
            } else if ("reload".equals(this.batch.getChannelId()) && sql.matches("^(delete from).*") && !sql.toUpperCase().contains("WHERE") && !table.getNameLowerCase().equals("sym_node")) {
                sql = this.getPlatform().getDeleteSql(table);
            }
        }
        sql = this.getPlatform().scrubSql(sql);
        sql = FormatUtils.replace((String)"sourceNodeId", (String)((String)this.context.get("sourceNodeId")), (String)sql);
        sql = FormatUtils.replace((String)"sourceNodeExternalId", (String)((String)this.context.get("sourceNodeExternalId")), (String)sql);
        sql = FormatUtils.replace((String)"sourceNodeGroupId", (String)((String)this.context.get("sourceNodeGroupId")), (String)sql);
        sql = FormatUtils.replace((String)"targetNodeId", (String)((String)this.context.get("targetNodeId")), (String)sql);
        sql = FormatUtils.replace((String)"targetNodeExternalId", (String)((String)this.context.get("targetNodeExternalId")), (String)sql);
        sql = FormatUtils.replace((String)"targetNodeGroupId", (String)((String)this.context.get("targetNodeGroupId")), (String)sql);
        return sql;
    }

    protected String quoteString(String string) {
        if (!StringUtils.isEmpty((CharSequence)string)) {
            String quote = this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? this.getPlatform().getDatabaseInfo().getDelimiterToken() : "";
            return String.format("%s%s%s", quote, string, quote);
        }
        return string;
    }

    protected boolean doesColumnNeedUpdated(int targetColumnIndex, Column column, CsvData data, String[] rowData, String[] oldData, boolean applyChangesOnly) {
        boolean needsUpdated = true;
        if (!this.getPlatform().getDatabaseInfo().isAutoIncrementUpdateAllowed() && column.isAutoIncrement()) {
            needsUpdated = false;
        } else if (oldData != null && applyChangesOnly) {
            boolean containsEmptyLobColumn = this.getPlatform().isLob(column) && StringUtils.isBlank((CharSequence)oldData[targetColumnIndex]);
            boolean bl = needsUpdated = !StringUtils.equals((CharSequence)rowData[targetColumnIndex], (CharSequence)oldData[targetColumnIndex]) || data.getParsedData("oldData") == null || containsEmptyLobColumn;
            if (containsEmptyLobColumn) {
                this.updateChangedDataIndicator(data, column, true);
            }
        } else {
            needsUpdated = !column.isPrimaryKey() || !StringUtils.equals((CharSequence)rowData[targetColumnIndex], (CharSequence)this.getPkDataFor(data, column));
            this.updateChangedDataIndicator(data, column, needsUpdated);
        }
        return needsUpdated;
    }

    protected void updateChangedDataIndicator(CsvData data, Column column, boolean needsUpdated) {
        boolean[] changeIndicators = data.getChangedDataIndicators();
        int index = this.sourceTable.getColumnIndex(column.getName());
        if (index != -1 && index < changeIndicators.length) {
            changeIndicators[index] = needsUpdated;
        } else if (index == -1) {
            log.warn("Unable to set change indicator because column {} not found on source table {}", (Object)column.getName(), (Object)this.sourceTable.getFullyQualifiedTableName());
        } else {
            log.warn("Unable to set change indicator because column {} is index {} on source table {}, but row data has only {} values", new Object[]{column.getName(), index, this.sourceTable.getFullyQualifiedTableName(), changeIndicators.length});
        }
    }

    protected void prepare() {
        this.getTransaction().prepare(this.currentDmlStatement.getSql());
    }

    protected void prepare(String sql, CsvData data) {
        this.getTransaction().prepare(sql);
    }

    protected int execute(CsvData data, String[] values) {
        this.currentDmlValues = this.getPlatform().getObjectValues(this.batch.getBinaryEncoding(), values, this.currentDmlStatement.getMetaData(), false, this.writerSettings.isFitToColumn());
        if (log.isDebugEnabled()) {
            log.debug("Submitting data [{}] with types [{}]", (Object)this.dmlValuesToString(this.currentDmlValues, this.currentDmlStatement.getTypes()), (Object)TypeMap.getJdbcTypeDescriptions((int[])this.currentDmlStatement.getTypes()));
        }
        return this.getTransaction().addRow((Object)data, this.currentDmlValues, this.currentDmlStatement.getTypes());
    }

    @Override
    protected Table lookupTableAtTarget(Table sourceTable) {
        Table table;
        block10: {
            String tableNameKey = this.getTableKey(sourceTable);
            table = this.lookupTableFromCache(sourceTable, tableNameKey);
            if (table == null) {
                try {
                    table = this.hasUncommittedDdl ? this.getPlatform(sourceTable).readTableFromDatabase(this.getTransaction(sourceTable), sourceTable.getCatalog(), sourceTable.getSchema(), sourceTable.getName()) : this.getPlatform(sourceTable).getTableFromCache(sourceTable.getCatalog(), sourceTable.getSchema(), sourceTable.getName(), false);
                    if (table != null) {
                        Column[] columns;
                        if ((table = table.copyAndFilterColumns(sourceTable.getColumnNames(), sourceTable.getPrimaryKeyColumnNames(), this.writerSettings.isUsePrimaryKeysFromSource(), false)).getPrimaryKeyColumnCount() == 0) {
                            table = this.getPlatform(table).makeAllColumnsPrimaryKeys(table);
                        }
                        if (this.writerSettings.isTreatDateTimeFieldsAsVarchar() && this.batch.getChannelId() != null && !this.batch.getChannelId().equals("config") && !this.batch.getChannelId().equals("monitor")) {
                            for (Column column : columns = table.getColumns()) {
                                int typeCode;
                                if (column == null || (typeCode = column.getMappedTypeCode()) != 91 && typeCode != 92 && typeCode != 93) continue;
                                column.setMappedTypeCode(12);
                            }
                        }
                        if (this.writerSettings.isTreatBitFieldsAsInteger() && this.batch.getChannelId() != null && !this.batch.getChannelId().equals("config") && !this.batch.getChannelId().equals("monitor")) {
                            for (Column column : columns = table.getColumns()) {
                                if (column == null || !column.getJdbcTypeName().equals("BIT") || column.getSizeAsInt() <= 1) continue;
                                column.setMappedTypeCode(4);
                            }
                        }
                        if (table.hasGeneratedColumns()) {
                            this.removeGeneratedColumns(table);
                        }
                        this.putTableInCache(tableNameKey, table);
                    }
                }
                catch (SqlException sqle) {
                    if (sqle.getMessage() != null && StringUtils.containsIgnoreCase((CharSequence)sqle.getMessage(), (CharSequence)"does not exist")) break block10;
                    throw sqle;
                }
            }
        }
        return table;
    }

    protected void removeGeneratedColumns(Table table) {
        ArrayList<Column> adjustedColumns = new ArrayList<Column>();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            Column col = table.getColumn(i);
            if (col.isGenerated()) continue;
            adjustedColumns.add(col);
        }
        table.removeAllColumns();
        table.addColumns(adjustedColumns);
    }

    protected String getTableKey(Table table) {
        return table.getTableKey();
    }

    protected Table lookupTableFromCache(Table sourceTable, String tableKey) {
        return (Table)this.targetTables.get(tableKey);
    }

    protected void putTableInCache(String tableKey, Table table) {
        this.targetTables.put(tableKey, table);
    }

    public DmlStatement getCurrentDmlStatement() {
        return this.currentDmlStatement;
    }

    @Override
    public DatabaseWriterSettings getWriterSettings() {
        return this.writerSettings;
    }

    public int prepareAndExecute(String sql, CsvData data) {
        return this.getTransaction().prepareAndExecute(sql, new Object[0]);
    }

    protected String getCurData(ISqlTransaction transaction) {
        String curVal = null;
        if (this.writerSettings.isSaveCurrentValueOnError()) {
            String[] existData;
            String[] keyNames = Table.getArrayColumns((Column[])this.context.getTable().getPrimaryKeyColumns());
            String[] columnNames = Table.getArrayColumns((Column[])this.context.getTable().getColumns());
            Table targetTable = this.getPlatform().getTableFromCache(this.context.getTable().getCatalog(), this.context.getTable().getSchema(), this.context.getTable().getName(), false);
            targetTable = targetTable.copyAndFilterColumns(columnNames, keyNames, true, false);
            String[] data = this.context.getData().getParsedData("oldData");
            if (data == null) {
                data = this.context.getData().getParsedData("rowData");
            }
            Column[] columns = targetTable.getColumns();
            Object[] objectValues = this.getPlatform().getObjectValues(this.context.getBatch().getBinaryEncoding(), data, columns);
            Map columnDataMap = CollectionUtils.toMap((String[])columnNames, (Object[])objectValues);
            Column[] pkColumns = targetTable.getPrimaryKeyColumns();
            Object[] args = new Object[pkColumns.length];
            for (int i = 0; i < pkColumns.length; ++i) {
                args[i] = columnDataMap.get(pkColumns[i].getName());
            }
            DmlStatement sqlStatement = this.getPlatform().createDmlStatement(DmlStatement.DmlType.SELECT, targetTable, this.writerSettings.getTextColumnExpression());
            Row row = null;
            List list = transaction.query(sqlStatement.getSql(), (ISqlRowMapper)new ISqlRowMapper<Row>(){

                public Row mapRow(Row row) {
                    return row;
                }
            }, args, null);
            if (list != null && list.size() > 0) {
                row = (Row)list.get(0);
            }
            if (row != null && (existData = this.getPlatform().getStringValues(this.context.getBatch().getBinaryEncoding(), columns, row, false, false)) != null) {
                curVal = CsvUtils.escapeCsvData(existData);
            }
        }
        return curVal;
    }

    @Override
    protected void allowInsertIntoAutoIncrementColumns(boolean value, Table table) {
        DatabaseInfo dbInfo = this.getPlatform(table).getDatabaseInfo();
        String quote = dbInfo.getDelimiterToken();
        String catalogSeparator = dbInfo.getCatalogSeparator();
        String schemaSeparator = dbInfo.getSchemaSeparator();
        this.getTransaction(table).allowInsertIntoAutoIncrementColumns(value, table, quote, catalogSeparator, schemaSeparator);
    }
}

