/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import com.google.gson.Gson;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DynamicDefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class KafkaWriter
extends DynamicDefaultDatabaseWriter {
    private static final Logger log = LoggerFactory.getLogger(KafkaWriter.class);
    private static final String TRUNCATE_PATTERN = "^(truncate)( table)?.*";
    private static final String DELETE_PATTERN = "^(delete from).*";
    protected final String KAFKA_TEXT_CACHE = "KAFKA_TEXT_CACHE" + this.hashCode();
    protected Map<String, List<ProducerRecord<String, Object>>> kafkaDataMap = new HashMap<String, List<ProducerRecord<String, Object>>>();
    protected String kafkaDataKey;
    private String url;
    private String producer;
    private String externalNodeID;
    private String outputFormat;
    private String topicBy;
    private String messageBy;
    private String confluentUrl;
    private String schemaPackage;
    private TypedProperties props;
    private String runtimeConfigTablePrefix;
    private String channelReload;
    private String[] parseDatePatterns = new String[]{"yyyy/MM/dd HH:mm:ss.SSSSSS", "yyyy-MM-dd HH:mm:ss", "ddMMMyyyy:HH:mm:ss.SSS Z", "ddMMMyyyy:HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSS", "ddMMMyyyy:HH:mm:ss.SSSSSS", "yyyy-MM-dd", "yyyy-MM-dd'T'HH:mmZZZZ", "yyyy-MM-dd'T'HH:mm:ssZZZZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZZZZ"};
    private List<String> schemaPackageClassNames = new ArrayList<String>();
    public static final String KAFKA_FORMAT_XML = "XML";
    public static final String KAFKA_FORMAT_JSON = "JSON";
    public static final String KAFKA_FORMAT_AVRO = "AVRO";
    public static final String KAFKA_FORMAT_CSV = "CSV";
    public static final String KAFKA_MESSAGE_BY_BATCH = "BATCH";
    public static final String KAFKA_MESSAGE_BY_ROW = "ROW";
    public static final String KAFKA_TOPIC_BY_TABLE = "TABLE";
    public static final String KAFKA_TOPIC_BY_CHANNEL = "CHANNEL";
    public static final String AVRO_CDC_SCHEMA = "{\"type\":\"record\",\"name\":\"cdc\",\"fields\":[  { \"name\":\"table\", \"type\":\"string\" },  { \"name\":\"eventType\", \"type\":\"string\" },  { \"name\":\"data\", \"type\":{     \"type\":\"array\", \"items\":{         \"name\":\"column\",         \"type\":\"record\",         \"fields\":[            {\"name\":\"name\", \"type\":\"string\"},            {\"name\":\"value\", \"type\":[\"null\", \"string\"]} ] }}}]}";
    public static final String KAFKA_SECURITY_PROTOCOL_PLAINTEXT = "PLAINTEXT";
    public static final String KAFKA_SECURITY_PROTOCOL_SASL_PLAINTEXT = "SASL_PLAINTEXT";
    public static final String KAFKA_SECURITY_PROTOCOL_SASL_SSL = "SASL_SSL";
    public static final String KAFKA_SECURITY_PROTOCOL_SSL = "SSL";
    Schema.Parser parser = new Schema.Parser();
    Schema schema = null;
    Map<String, Object> configs = new HashMap<String, Object>();
    Map<String, Class<?>> tableClassCache = new HashMap();
    Map<String, String> tableNameCache = new HashMap<String, String>();
    Map<String, Map<String, String>> tableColumnCache = new HashMap<String, Map<String, String>>();
    public KafkaProducer<String, Object> kafkaProducer;
    protected static Map<String, KafkaProducer<String, Object>> producerMap = new HashMap<String, KafkaProducer<String, Object>>();

    public KafkaWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix, IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings, String producer, String outputFormat, String topicBy, String messageBy, String confluentUrl, String schemaPackage, String externalNodeID, String url, String loadOnlyPrefix, TypedProperties props, String runtimeConfigTablePrefix, String channelReload) {
        super(symmetricPlatform, targetPlatform, prefix, conflictResolver, settings);
        this.schema = this.parser.parse(AVRO_CDC_SCHEMA);
        this.url = url;
        this.producer = producer;
        this.outputFormat = outputFormat;
        this.topicBy = topicBy;
        this.messageBy = messageBy;
        this.confluentUrl = confluentUrl;
        this.schemaPackage = schemaPackage;
        this.externalNodeID = externalNodeID;
        this.props = props;
        this.runtimeConfigTablePrefix = runtimeConfigTablePrefix;
        this.channelReload = channelReload;
        if (this.url == null) {
            throw new RuntimeException("Kakfa not configured properly, verify you have set the endpoint to kafka with the following property : " + loadOnlyPrefix + "db.url");
        }
        String clientID = this.producer + "-" + this.externalNodeID;
        if (producerMap.get(clientID) != null) {
            this.kafkaProducer = producerMap.get(clientID);
        } else {
            this.configs.put("bootstrap.servers", this.url);
            this.configs.put("value.serializer", StringSerializer.class.getName());
            this.configs.put("key.serializer", StringSerializer.class.getName());
            this.configs.put("client.id", this.producer);
            if (confluentUrl != null) {
                this.configs.put("value.serializer", KafkaAvroSerializer.class.getName());
                this.configs.put("key.serializer", StringSerializer.class.getName());
                this.configs.put("schema.registry.url", confluentUrl);
                this.configs.put("client.id", clientID);
            }
            for (Object key : this.props.keySet()) {
                if (!key.toString().startsWith("kafkaclient.")) continue;
                this.configs.put(key.toString().substring(12), this.props.get(key));
            }
            this.kafkaProducer = new KafkaProducer(this.configs);
            producerMap.put(clientID, this.kafkaProducer);
            log.debug("Kafka client config: {}", this.configs);
        }
    }

    @Override
    protected void prepare() {
        if (this.isSymmetricTable(this.targetTable != null ? this.targetTable.getName() : "")) {
            super.prepare();
        }
    }

    @Override
    protected void prepare(String sql, CsvData data) {
    }

    @Override
    public int prepareAndExecute(String sql, CsvData data) {
        return 1;
    }

    @Override
    protected int execute(CsvData data, String[] values) {
        int i;
        if (this.isSymmetricTable(this.targetTable != null ? this.targetTable.getName() : "")) {
            return super.execute(data, values);
        }
        Table table = this.sourceTable;
        String[] rowData = data.getParsedData("rowData");
        if (data.getDataEventType() == DataEventType.DELETE) {
            rowData = data.getParsedData("oldData");
        }
        StringBuilder kafkaText = new StringBuilder();
        String kafkaKey = null;
        if (this.messageBy.equals(KAFKA_MESSAGE_BY_ROW)) {
            StringBuilder sb = new StringBuilder();
            sb.append(table.getName()).append(":");
            for (i = 0; i < table.getPrimaryKeyColumnNames().length; ++i) {
                sb.append(":").append(rowData[i]);
            }
            kafkaKey = String.valueOf(sb.toString().hashCode());
        } else if (this.messageBy.equals(KAFKA_MESSAGE_BY_BATCH)) {
            String s = this.context.getBatch().getSourceNodeId() + "-" + this.context.getBatch().getBatchId();
            kafkaKey = String.valueOf(s.hashCode());
        }
        this.kafkaDataKey = this.topicBy.equals(KAFKA_TOPIC_BY_CHANNEL) ? this.context.getBatch().getChannelId() : table.getNameLowerCase();
        log.debug("Processing table {} for Kafka on topic {}", (Object)table, (Object)this.kafkaDataKey);
        if (this.kafkaDataMap.get(this.kafkaDataKey) == null) {
            this.kafkaDataMap.put(this.kafkaDataKey, new ArrayList());
        }
        List<ProducerRecord<String, Object>> kafkaDataList = this.kafkaDataMap.get(this.kafkaDataKey);
        if (this.outputFormat.equals(KAFKA_FORMAT_JSON)) {
            if (!kafkaDataList.isEmpty() && !this.messageBy.equals(KAFKA_MESSAGE_BY_ROW)) {
                kafkaText.append(", ");
            }
            kafkaText.append("{\"").append(table.getName()).append("\": {").append("\"eventType\": \"" + data.getDataEventType() + "\",").append("\"data\": { ");
            Gson gson = new Gson();
            for (int i2 = 0; i2 < table.getColumnNames().length; ++i2) {
                kafkaText.append("\"").append(table.getColumnNames()[i2]).append("\": ");
                kafkaText.append(gson.toJson((Object)rowData[i2]));
                if (i2 + 1 >= table.getColumnNames().length) continue;
                kafkaText.append(",");
            }
            kafkaText.append(" } } }");
        } else if (this.outputFormat.equals(KAFKA_FORMAT_CSV)) {
            kafkaText.append("\n\"TABLE\"").append(",\"").append(table.getName()).append("\",\"").append("EVENT").append("\",\"").append((Object)data.getDataEventType()).append("\",");
            for (i = 0; i < table.getColumnNames().length; ++i) {
                kafkaText.append("\"").append(StringUtils.replace((String)table.getColumnNames()[i], (String)"\"", (String)"\"\"")).append("\",");
                if (rowData[i] != null) {
                    kafkaText.append("\"").append(StringUtils.replace((String)rowData[i], (String)"\"", (String)"\"\"")).append("\"");
                }
                if (i + 1 >= table.getColumnNames().length) continue;
                kafkaText.append(",");
            }
        } else if (this.outputFormat.equals(KAFKA_FORMAT_XML)) {
            kafkaText.append("<row entity=\"").append(StringEscapeUtils.escapeXml11((String)table.getName())).append("\"").append(" dml=\"").append((Object)data.getDataEventType()).append("\">");
            for (i = 0; i < table.getColumnNames().length; ++i) {
                kafkaText.append("<data key=\"").append(StringEscapeUtils.escapeXml11((String)table.getColumnNames()[i])).append("\">").append(StringEscapeUtils.escapeXml11((String)rowData[i])).append("</data>");
            }
            kafkaText.append("</row>");
        } else if (this.outputFormat.equals(KAFKA_FORMAT_AVRO)) {
            if (this.confluentUrl != null) {
                String tableName = this.getTableName(table.getName());
                try {
                    Object pojo;
                    Class<?> curClass = this.getClassByTableName(tableName);
                    if (curClass != null) {
                        Constructor<?> defaultConstructor = curClass.getConstructor(new Class[0]);
                        pojo = defaultConstructor.newInstance(new Object[0]);
                        for (int i3 = 0; i3 < table.getColumnNames().length; ++i3) {
                            String colName = this.getColumnName(table.getName(), table.getColumnNames()[i3], pojo);
                            if (colName == null) continue;
                            Class propertyTypeClass = PropertyUtils.getPropertyType(pojo, (String)colName);
                            if (CharSequence.class.equals((Object)propertyTypeClass)) {
                                PropertyUtils.setSimpleProperty(pojo, (String)colName, (Object)rowData[i3]);
                                continue;
                            }
                            if (Long.class.equals((Object)propertyTypeClass)) {
                                Date date = null;
                                try {
                                    date = DateUtils.parseDate((String)rowData[i3], (String[])this.parseDatePatterns);
                                }
                                catch (Exception e) {
                                    log.debug(rowData[i3] + " was not a recognized date format so treating it as a long.");
                                }
                                BeanUtils.setProperty(pojo, (String)colName, (Object)(date != null ? Long.valueOf(date.getTime()) : rowData[i3]));
                                continue;
                            }
                            BeanUtils.setProperty(pojo, (String)colName, (Object)rowData[i3]);
                        }
                    } else {
                        throw new RuntimeException("Unable to find a POJO to load for AVRO based message onto Kafka for table : " + tableName);
                    }
                    this.sendKafkaMessage((ProducerRecord<String, Object>)new ProducerRecord(this.kafkaDataKey, (Object)kafkaKey, pojo));
                }
                catch (NoSuchMethodException e) {
                    log.info("Unable to find setter on POJO based on table " + table.getName(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    log.info("Unable to invoke a default constructor on POJO based on table " + tableName, (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    log.info("Unable to access a default constructor on POJO based on table " + tableName, (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    log.info("Unable to instantiate a constructor on POJO based on table " + tableName, (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            GenericData.Record avroRecord = new GenericData.Record(this.schema);
            avroRecord.put("table", (Object)table.getName());
            avroRecord.put("eventType", (Object)data.getDataEventType().toString());
            ArrayList<GenericData.Record> dataCollection = new ArrayList<GenericData.Record>();
            for (int i4 = 0; i4 < table.getColumnNames().length; ++i4) {
                GenericData.Record columnRecord = new GenericData.Record(this.schema.getField("data").schema().getElementType());
                columnRecord.put("name", (Object)table.getColumnNames()[i4]);
                columnRecord.put("value", (Object)rowData[i4]);
                dataCollection.add(columnRecord);
            }
            avroRecord.put("data", dataCollection);
            try {
                kafkaDataList.add((ProducerRecord<String, Object>)new ProducerRecord(this.kafkaDataKey, (Object)kafkaKey, (Object)KafkaWriter.datumToByteArray(this.schema, (GenericRecord)avroRecord)));
                return 1;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to convert row data to an Avro record", ioe);
            }
        }
        kafkaDataList.add((ProducerRecord<String, Object>)new ProducerRecord(this.kafkaDataKey, (Object)kafkaKey, (Object)kafkaText.toString()));
        return 1;
    }

    @Override
    protected AbstractDatabaseWriter.LoadStatus delete(CsvData data, boolean useConflictDetection) {
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        Table table = this.sourceTable;
        int successValue = 0;
        successValue = this.writeKafka(data, table);
        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        if (successValue == 1) {
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        return AbstractDatabaseWriter.LoadStatus.CONFLICT;
    }

    @Override
    protected AbstractDatabaseWriter.LoadStatus update(CsvData data, boolean applyChangesOnly, boolean useConflictDetection) {
        Table table = this.sourceTable;
        int successValue = 0;
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        if (table.getName().contains(this.runtimeConfigTablePrefix) || table.getName().contains("sym")) {
            return super.update(data, applyChangesOnly, useConflictDetection);
        }
        successValue = this.writeKafka(data, table);
        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        if (successValue == 1) {
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        return AbstractDatabaseWriter.LoadStatus.CONFLICT;
    }

    @Override
    protected boolean create(CsvData data) {
        String xml = null;
        try {
            String tempNonSymTable = "NON_SYM_TABLE";
            this.getTransaction(tempNonSymTable).commit();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            xml = data.getParsedData("rowData")[0];
            log.info("Creating Kafka Topic for the following xml:", (Object)xml);
            this.writeKafka(data, this.sourceTable);
            ((Statistics)this.statistics.get(this.batch)).increment("CREATECOUNT");
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException ex) {
            log.error("Failed to alter Kafka Topic using the following xml: " + xml, (Throwable)ex);
            throw ex;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sql(CsvData data) {
        try {
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            String[] parsedData = data.getParsedData("rowData");
            String script = parsedData[0];
            List<String> sqlStatements = this.getSqlStatements(script);
            long count = 0L;
            for (String sql : sqlStatements) {
                Object newTransaction = null;
                try {
                    Table table = this.targetTable != null ? this.targetTable : this.sourceTable;
                    sql = FormatUtils.replace((String)"nodeId", (String)this.batch.getTargetNodeId(), (String)sql);
                    if (table == null) continue;
                    sql = FormatUtils.replace((String)"catalogName", (String)this.quoteString(table.getCatalog()), (String)sql);
                    sql = FormatUtils.replace((String)"schemaName", (String)this.quoteString(table.getSchema()), (String)sql);
                    sql = FormatUtils.replace((String)"tableName", (String)this.quoteString(table.getName()), (String)sql);
                    DatabaseInfo info = this.getPlatform().getDatabaseInfo();
                    String quote = this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? info.getDelimiterToken() : "";
                    sql = FormatUtils.replace((String)"fullTableName", (String)table.getQualifiedTableName(quote, info.getCatalogSeparator(), info.getSchemaSeparator()), (String)sql);
                    String old38CompatibilityTable = "sym_node";
                    if ((!this.channelReload.equals(this.batch.getChannelId()) || !sql.matches(TRUNCATE_PATTERN) || table.getNameLowerCase().equals("sym_node")) && (!this.channelReload.equals(this.batch.getChannelId()) || !sql.matches(DELETE_PATTERN) || sql.toUpperCase().contains("WHERE") || table.getNameLowerCase().equals("sym_node"))) continue;
                    this.writeKafka(data, this.targetTable);
                }
                finally {
                    if (newTransaction == null) continue;
                    newTransaction.close();
                }
            }
            ((Statistics)this.statistics.get(this.batch)).increment("SQLCOUNT");
            ((Statistics)this.statistics.get(this.batch)).increment("SQLROWSAFFECTEDCOUNT", count);
            boolean bl = true;
            return bl;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    @Override
    protected void logFailureDetails(Throwable e, CsvData data, boolean logLastDmlDetails) {
    }

    @Override
    protected void allowInsertIntoAutoIncrementColumns(boolean value, Table table) {
    }

    @Override
    protected Table lookupTableAtTarget(Table sourceTable) {
        if (sourceTable != null && this.isSymmetricTable(sourceTable.getName())) {
            return super.lookupTableAtTarget(sourceTable);
        }
        return sourceTable;
    }

    @Override
    public void end(Batch batch, boolean inError) {
        this.lastData = null;
        if (batch.isIgnored()) {
            this.getStatistics().get(batch).increment("IGNORECOUNT");
        }
        if (!inError) {
            this.notifyFiltersBatchComplete();
            this.batchComplete(this.context);
            this.commit(false);
        } else {
            this.rollback();
        }
    }

    public String getTableName(String dbTableName) {
        String name = this.tableNameCache.get(dbTableName);
        if (name == null) {
            String[] split = dbTableName.split("_");
            StringBuilder tableName = new StringBuilder();
            for (String part : split) {
                tableName.append(StringUtils.capitalize((String)part.toLowerCase()));
            }
            this.tableNameCache.put(dbTableName, tableName.toString());
            name = tableName.toString();
        }
        return name;
    }

    public Class<?> getClassByTableName(String tableName) {
        Class<?> classMatch = this.tableClassCache.get(tableName);
        if (classMatch == null) {
            try {
                log.debug("Looking for an exact match for a POJO based on tableName " + tableName);
                classMatch = Class.forName(this.schemaPackage + "." + tableName);
            }
            catch (Exception e) {
                if (this.schemaPackageClassNames.size() == 0) {
                    this.scanSchemaPackage();
                }
                String fullTableName = this.schemaPackage + "." + tableName;
                for (String scannedName : this.schemaPackageClassNames) {
                    if (scannedName.indexOf("$") > 0) continue;
                    if (scannedName.startsWith(fullTableName)) {
                        try {
                            log.debug("Looking for a starts with match for a POJO based on tableName " + scannedName);
                            classMatch = Class.forName(scannedName);
                            break;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    if (!scannedName.toLowerCase().startsWith(fullTableName)) continue;
                    try {
                        log.debug("Looking for a starts with match all lower case for a POJO based on tableName " + scannedName);
                        classMatch = Class.forName(scannedName);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (classMatch != null) {
                this.tableClassCache.put(tableName, classMatch);
            }
        }
        return classMatch;
    }

    private void scanSchemaPackage() {
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            String packageSearchPath = "classpath*:" + this.resolveBasePackage(this.schemaPackage) + "/**/*.class";
            for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                this.schemaPackageClassNames.add(metadataReader.getClassMetadata().getClassName());
            }
            Collections.sort(this.schemaPackageClassNames, Collections.reverseOrder());
        }
        catch (Exception e) {
            log.warn("Unable to scan schema package : " + this.schemaPackage);
        }
    }

    private String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    public String getColumnName(String dbTableName, String dbColumnName, Object bean) {
        if (this.tableColumnCache.containsKey(dbColumnName) && this.tableColumnCache.get(dbTableName).containsKey(dbColumnName)) {
            return this.tableColumnCache.get(dbTableName).get(dbColumnName);
        }
        String columnName = null;
        if (!this.tableColumnCache.containsKey(dbColumnName)) {
            this.tableColumnCache.put(dbTableName, new HashMap());
        }
        String dbColumnNameSimple = dbColumnName.toLowerCase().replaceAll("[^a-z0-9]", "");
        for (PropertyDescriptor pd : PropertyUtils.getPropertyDescriptors((Object)bean)) {
            if (!pd.getName().toLowerCase().equals(dbColumnNameSimple)) continue;
            columnName = pd.getName();
            break;
        }
        if (columnName != null) {
            this.tableColumnCache.get(dbTableName).put(dbColumnName, columnName);
            return columnName;
        }
        return null;
    }

    public void sendKafkaMessage(ProducerRecord<String, Object> record) {
        log.debug("Sending message (topic={}) (key={}) {}", new Object[]{record.topic(), record.key(), record.value()});
        this.kafkaProducer.send(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] datumToByteArray(Schema schema, GenericRecord datum) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            byte[] byteData;
            BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)os, null);
            writer.write((Object)datum, (Encoder)e);
            e.flush();
            byte[] byArray = byteData = os.toByteArray();
            return byArray;
        }
    }

    public void batchComplete(DataContext context) {
        if (!context.getBatch().getChannelId().equals("heartbeat") && !context.getBatch().getChannelId().equals("config")) {
            String batchFileName = "batch-" + context.getBatch().getSourceNodeId() + "-" + context.getBatch().getBatchId();
            log.debug("Kafka client config: {}", this.configs);
            try {
                if (this.confluentUrl == null && this.kafkaDataMap.size() > 0) {
                    StringBuffer kafkaText = new StringBuffer();
                    String kafkaKey = null;
                    for (Map.Entry<String, List<ProducerRecord<String, Object>>> entry : this.kafkaDataMap.entrySet()) {
                        for (ProducerRecord<String, Object> record : entry.getValue()) {
                            if (this.messageBy.equals(KAFKA_MESSAGE_BY_ROW)) {
                                this.sendKafkaMessage(record);
                                continue;
                            }
                            kafkaKey = (String)record.key();
                            kafkaText.append(record.value());
                        }
                        if (!this.messageBy.equals(KAFKA_MESSAGE_BY_BATCH)) continue;
                        this.sendKafkaMessage((ProducerRecord<String, Object>)new ProducerRecord(entry.getKey(), (Object)kafkaKey, (Object)kafkaText.toString()));
                    }
                    this.kafkaDataMap = new HashMap<String, List<ProducerRecord<String, Object>>>();
                }
            }
            catch (Exception e) {
                log.warn("Unable to write batch to Kafka " + batchFileName, (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                context.put(this.KAFKA_TEXT_CACHE, new HashMap());
                this.tableNameCache.clear();
                this.tableColumnCache = new HashMap<String, Map<String, String>>();
            }
        }
    }

    public int writeKafka(CsvData data, Table table) {
        int i;
        String[] rowData = data.getParsedData("rowData");
        String[] oldData = data.getParsedData("oldData");
        if (data.getDataEventType() == DataEventType.DELETE && (rowData = data.getParsedData("oldData")) == null) {
            rowData = data.getParsedData("pkData");
        }
        StringBuilder kafkaText = new StringBuilder();
        String kafkaKey = null;
        if (this.messageBy.equals(KAFKA_MESSAGE_BY_ROW)) {
            StringBuilder sb = new StringBuilder();
            sb.append(table.getName()).append(":");
            for (i = 0; i < table.getPrimaryKeyColumnNames().length; ++i) {
                sb.append(":").append(rowData[i]);
            }
            kafkaKey = String.valueOf(sb.toString().hashCode());
        } else if (this.messageBy.equals(KAFKA_MESSAGE_BY_BATCH)) {
            String s = this.context.getBatch().getSourceNodeId() + "-" + this.context.getBatch().getBatchId();
            kafkaKey = String.valueOf(s.hashCode());
        }
        this.kafkaDataKey = this.topicBy.equals(KAFKA_TOPIC_BY_CHANNEL) ? this.context.getBatch().getChannelId() : table.getNameLowerCase();
        log.debug("Processing table {} for Kafka on topic {}", (Object)table, (Object)this.kafkaDataKey);
        if (this.kafkaDataMap.get(this.kafkaDataKey) == null) {
            this.kafkaDataMap.put(this.kafkaDataKey, new ArrayList());
        }
        List<ProducerRecord<String, Object>> kafkaDataList = this.kafkaDataMap.get(this.kafkaDataKey);
        if (rowData[0].matches(TRUNCATE_PATTERN) || rowData[0].matches(DELETE_PATTERN) || rowData[0].contains("xml version")) {
            return 1;
        }
        if (this.outputFormat.equals(KAFKA_FORMAT_JSON)) {
            kafkaText.append("{\"").append(table.getName()).append("\": {").append("\"eventType\": \"" + data.getDataEventType() + "\",").append("\"data\": { ");
            Gson gson = new Gson();
            if (oldData != null) {
                for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                    kafkaText.append("\"").append(table.getColumnNames()[i2]).append("\": ");
                    kafkaText.append(gson.toJson((Object)rowData[i2]));
                    if (i2 + 1 >= table.getColumnCount()) continue;
                    kafkaText.append(",");
                }
            } else {
                for (int i3 = 0; i3 < table.getPrimaryKeyColumnCount(); ++i3) {
                    kafkaText.append("\"").append(table.getColumnNames()[i3]).append("\": ");
                    kafkaText.append(gson.toJson((Object)rowData[i3]));
                    if (i3 + 1 >= table.getPrimaryKeyColumnCount()) continue;
                    kafkaText.append(",");
                }
            }
            kafkaText.append(" } } }");
        } else if (this.outputFormat.equals(KAFKA_FORMAT_CSV)) {
            kafkaText.append("\n\"TABLE\"").append(",\"").append(table.getName()).append("\",\"").append("EVENT").append("\",\"").append((Object)data.getDataEventType()).append("\",");
            if (oldData != null) {
                for (i = 0; i < table.getColumnNames().length; ++i) {
                    kafkaText.append("\"").append(StringUtils.replace((String)table.getColumnNames()[i], (String)"\"", (String)"\"\"")).append("\",");
                    if (rowData[i] != null) {
                        kafkaText.append("\"").append(StringUtils.replace((String)rowData[i], (String)"\"", (String)"\"\"")).append("\"");
                    }
                    if (i + 1 >= table.getColumnNames().length) continue;
                    kafkaText.append(",");
                }
            } else {
                for (i = 0; i < table.getPrimaryKeyColumnCount(); ++i) {
                    kafkaText.append("\"").append(StringUtils.replace((String)table.getPrimaryKeyColumnNames()[i], (String)"\"", (String)"\"\"")).append("\",");
                    if (rowData[i] != null) {
                        kafkaText.append("\"").append(StringUtils.replace((String)rowData[i], (String)"\"", (String)"\"\"")).append("\"");
                    }
                    if (i + 1 >= table.getColumnNames().length) continue;
                    kafkaText.append(",");
                }
            }
        } else if (this.outputFormat.equals(KAFKA_FORMAT_XML)) {
            kafkaText.append("<row entity=\"").append(StringEscapeUtils.escapeXml11((String)table.getName())).append("\"").append(" dml=\"").append((Object)data.getDataEventType()).append("\">");
            if (oldData != null) {
                for (i = 0; i < table.getColumnNames().length; ++i) {
                    kafkaText.append("<data key=\"").append(StringEscapeUtils.escapeXml11((String)table.getColumnNames()[i])).append("\">").append(StringEscapeUtils.escapeXml11((String)rowData[i])).append("</data>");
                }
            } else {
                for (i = 0; i < table.getPrimaryKeyColumnCount(); ++i) {
                    kafkaText.append("<data key=\"").append(StringEscapeUtils.escapeXml11((String)table.getPrimaryKeyColumnNames()[i])).append("\">").append(StringEscapeUtils.escapeXml11((String)rowData[i])).append("</data>");
                }
            }
            kafkaText.append("</row>");
        } else if (this.outputFormat.equals(KAFKA_FORMAT_AVRO)) {
            if (this.confluentUrl != null) {
                String tableName = this.getTableName(table.getName());
                try {
                    Object pojo;
                    Class<?> curClass = this.getClassByTableName(tableName);
                    if (curClass != null) {
                        Constructor<?> defaultConstructor = curClass.getConstructor(new Class[0]);
                        pojo = defaultConstructor.newInstance(new Object[0]);
                        if (oldData != null) {
                            for (int i4 = 0; i4 < table.getColumnNames().length; ++i4) {
                                String colName = this.getColumnName(table.getName(), table.getColumnNames()[i4], pojo);
                                if (colName == null) continue;
                                Class propertyTypeClass = PropertyUtils.getPropertyType(pojo, (String)colName);
                                if (CharSequence.class.equals((Object)propertyTypeClass)) {
                                    PropertyUtils.setSimpleProperty(pojo, (String)colName, (Object)rowData[i4]);
                                    continue;
                                }
                                if (Long.class.equals((Object)propertyTypeClass)) {
                                    Date date = null;
                                    try {
                                        date = DateUtils.parseDate((String)rowData[i4], (String[])this.parseDatePatterns);
                                    }
                                    catch (Exception e) {
                                        log.debug(rowData[i4] + " was not a recognized date format so treating it as a long.");
                                    }
                                    BeanUtils.setProperty(pojo, (String)colName, (Object)(date != null ? Long.valueOf(date.getTime()) : rowData[i4]));
                                    continue;
                                }
                                BeanUtils.setProperty(pojo, (String)colName, (Object)rowData[i4]);
                            }
                        } else {
                            for (int i5 = 0; i5 < table.getPrimaryKeyColumnCount(); ++i5) {
                                String colName = this.getColumnName(table.getName(), table.getPrimaryKeyColumnNames()[i5], pojo);
                                if (colName == null) continue;
                                Class propertyTypeClass = PropertyUtils.getPropertyType(pojo, (String)colName);
                                if (CharSequence.class.equals((Object)propertyTypeClass)) {
                                    PropertyUtils.setSimpleProperty(pojo, (String)colName, (Object)rowData[i5]);
                                    continue;
                                }
                                if (Long.class.equals((Object)propertyTypeClass)) {
                                    Date date = null;
                                    try {
                                        date = DateUtils.parseDate((String)rowData[i5], (String[])this.parseDatePatterns);
                                    }
                                    catch (Exception e) {
                                        log.debug(rowData[i5] + " was not a recognized date format so treating it as a long.");
                                    }
                                    BeanUtils.setProperty(pojo, (String)colName, (Object)(date != null ? Long.valueOf(date.getTime()) : rowData[i5]));
                                    continue;
                                }
                                BeanUtils.setProperty(pojo, (String)colName, (Object)rowData[i5]);
                            }
                        }
                    } else {
                        throw new RuntimeException("Unable to find a POJO to load for AVRO based message onto Kafka for table : " + tableName);
                    }
                    this.sendKafkaMessage((ProducerRecord<String, Object>)new ProducerRecord(this.kafkaDataKey, (Object)kafkaKey, pojo));
                }
                catch (NoSuchMethodException e) {
                    log.info("Unable to find setter on POJO based on table " + table.getName(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    log.info("Unable to invoke a default constructor on POJO based on table " + tableName, (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    log.info("Unable to access a default constructor on POJO based on table " + tableName, (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    log.info("Unable to instantiate a constructor on POJO based on table " + tableName, (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            GenericData.Record avroRecord = new GenericData.Record(this.schema);
            avroRecord.put("table", (Object)table.getName());
            avroRecord.put("eventType", (Object)data.getDataEventType().toString());
            ArrayList<GenericData.Record> dataCollection = new ArrayList<GenericData.Record>();
            for (int i6 = 0; i6 < table.getColumnNames().length; ++i6) {
                GenericData.Record columnRecord = new GenericData.Record(this.schema.getField("data").schema().getElementType());
                columnRecord.put("name", (Object)table.getColumnNames()[i6]);
                columnRecord.put("value", (Object)rowData[i6]);
                dataCollection.add(columnRecord);
            }
            avroRecord.put("data", dataCollection);
            try {
                kafkaDataList.add((ProducerRecord<String, Object>)new ProducerRecord(this.kafkaDataKey, (Object)kafkaKey, (Object)KafkaWriter.datumToByteArray(this.schema, (GenericRecord)avroRecord)));
                return 1;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to convert row data to an Avro record", ioe);
            }
        }
        kafkaDataList.add((ProducerRecord<String, Object>)new ProducerRecord(this.kafkaDataKey, (Object)kafkaKey, (Object)kafkaText.toString()));
        return 1;
    }
}

