/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.transform.IColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TargetDmlAction;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformColumnException;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.symmetric.io.data.writer.NestedDataWriter;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;

public class TransformWriter
extends NestedDataWriter {
    private static final Logger log = LoggerFactory.getLogger(TransformWriter.class);
    protected TransformPoint transformPoint;
    protected IDatabasePlatform platform;
    protected Map<String, List<TransformTable>> transformsBySourceTable;
    protected Table sourceTable;
    protected List<TransformTable> activeTransforms;
    protected Batch batch;
    protected Map<String, IColumnTransform<?>> columnTransforms;
    protected Table lastTransformedTable;

    public TransformWriter(IDatabasePlatform platform, TransformPoint transformPoint, IDataWriter targetWriter, Map<String, IColumnTransform<?>> columnTransforms, TransformTable ... transforms) {
        super(targetWriter);
        this.columnTransforms = columnTransforms;
        this.platform = platform;
        this.transformPoint = transformPoint == null ? TransformPoint.LOAD : transformPoint;
        this.transformsBySourceTable = this.toMap(transforms);
    }

    protected final Map<String, List<TransformTable>> toMap(TransformTable[] transforms) {
        HashMap<String, List<TransformTable>> transformsByTable = new HashMap<String, List<TransformTable>>();
        if (transforms != null) {
            for (TransformTable transformTable : transforms) {
                if (this.transformPoint != transformTable.getTransformPoint()) continue;
                String sourceTableName = transformTable.getFullyQualifiedSourceTableName().toLowerCase();
                ArrayList<TransformTable> tables = (ArrayList<TransformTable>)transformsByTable.get(sourceTableName);
                if (tables == null) {
                    tables = new ArrayList<TransformTable>();
                    transformsByTable.put(sourceTableName, tables);
                }
                tables.add(transformTable);
            }
        }
        return transformsByTable;
    }

    @Override
    public void start(Batch batch) {
        this.batch = batch;
        super.start(batch);
    }

    @Override
    public boolean start(Table table) {
        List<TransformTable> activeTransformsTemp = this.transformsBySourceTable.get(table.getFullyQualifiedTableNameLowerCase());
        if (activeTransformsTemp != null && activeTransformsTemp.size() > 0) {
            this.sourceTable = table;
            this.activeTransforms = new ArrayList<TransformTable>(activeTransformsTemp.size());
            for (TransformTable transformation : activeTransformsTemp) {
                this.activeTransforms.add(transformation.enhanceWithImpliedColumns(this.sourceTable.getPrimaryKeyColumnNames(), this.sourceTable.getColumnNames()));
            }
            return true;
        }
        this.sourceTable = null;
        return super.start(table);
    }

    protected boolean isTransformable(DataEventType eventType) {
        return eventType != null && (eventType == DataEventType.INSERT || eventType == DataEventType.UPDATE || eventType == DataEventType.DELETE || eventType == DataEventType.SQL);
    }

    @Override
    public void write(CsvData data) {
        DataEventType eventType = data.getDataEventType();
        if (this.activeTransforms != null && this.activeTransforms.size() > 0 && this.isTransformable(eventType)) {
            if (data.requiresTable() && this.sourceTable == null && this.context.getLastParsedTable() != null) {
                this.start(this.context.getLastParsedTable());
            }
            if (eventType == DataEventType.SQL) {
                List<TransformTable> transformTables = this.activeTransforms;
                for (TransformTable transformation : transformTables) {
                    Table transformedTable = new Table(transformation.getTargetCatalogName(), transformation.getTargetSchemaName(), transformation.getTargetTableName(), this.getTargetColumnNames(transformation.getTransformColumns()), this.getTargetColumnNames(transformation.getPrimaryKeyColumns()));
                    this.callWriter(transformedTable, data);
                }
                return;
            }
            Map<String, String> sourceValues = data.toColumnNameValuePairs(this.sourceTable.getColumnNames(), "rowData");
            Map<String, String> oldSourceValues = null;
            if (data.contains("oldData")) {
                oldSourceValues = data.toColumnNameValuePairs(this.sourceTable.getColumnNames(), "oldData");
            }
            Map<String, String> sourceKeyValues = null;
            if (data.contains("pkData")) {
                sourceKeyValues = data.toKeyColumnValuePairs(this.sourceTable);
            }
            if (eventType == DataEventType.DELETE && ((sourceValues = oldSourceValues) == null || sourceValues.size() == 0)) {
                sourceValues = sourceKeyValues;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} transformation(s) started because of {} on {}.  The original row data was: {}", new Object[]{this.activeTransforms.size(), eventType.toString(), this.sourceTable.getFullyQualifiedTableName(), sourceValues});
            }
            List<TransformTable> transformTables = this.activeTransforms;
            if (eventType == DataEventType.DELETE) {
                transformTables = new ArrayList<TransformTable>(this.activeTransforms);
                Collections.reverse(transformTables);
            }
            for (TransformTable transformation : transformTables) {
                DataEventType localEventType = eventType;
                if (localEventType == DataEventType.INSERT && transformation.isUpdateFirst()) {
                    localEventType = DataEventType.UPDATE;
                }
                List<TransformedData> dataThatHasBeenTransformed = this.transform(localEventType, this.context, transformation, sourceKeyValues, oldSourceValues, sourceValues);
                for (TransformedData transformedData : dataThatHasBeenTransformed) {
                    Table transformedTable = transformedData.buildTargetTable();
                    CsvData csvData = transformedData.buildTargetCsvData(data.getAttributes());
                    this.callWriter(transformedTable, csvData);
                }
            }
        } else {
            if (this.sourceTable != null) {
                super.start(this.sourceTable);
            }
            super.write(data);
            if (this.sourceTable != null) {
                super.end(this.sourceTable);
            }
        }
    }

    protected void callWriter(Table transformedTable, CsvData csvData) {
        boolean processData = true;
        if (this.lastTransformedTable == null || transformedTable == null || !this.lastTransformedTable.equalsByName(transformedTable)) {
            if (this.lastTransformedTable != null) {
                this.nestedWriter.end(this.lastTransformedTable);
            }
            this.lastTransformedTable = !(processData = this.nestedWriter.start(transformedTable)) ? null : transformedTable;
        }
        if (processData || !csvData.requiresTable()) {
            this.nestedWriter.write(csvData);
        }
    }

    protected String[] getTargetColumnNames(List<TransformColumn> columns) {
        String[] names = new String[columns.size()];
        int i = 0;
        for (TransformColumn column : columns) {
            names[i++] = column.getTargetColumnName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TransformedData> transform(DataEventType eventType, DataContext context, TransformTable transformation, Map<String, String> sourceKeyValues, Map<String, String> oldSourceValues, Map<String, String> sourceValues) {
        long ts = System.currentTimeMillis();
        try {
            List<TransformedData> dataToTransform = this.create(context, eventType, transformation, sourceKeyValues, oldSourceValues, sourceValues);
            ArrayList<TransformedData> dataThatHasBeenTransformed = new ArrayList<TransformedData>(dataToTransform.size());
            if (log.isDebugEnabled()) {
                log.debug("{} target data was created for the {} transformation.  The target table is {}", new Object[]{dataToTransform.size(), transformation.getTransformId(), transformation.getFullyQualifiedTargetTableName()});
            }
            int transformNumber = 0;
            for (TransformedData targetData : dataToTransform) {
                ++transformNumber;
                if (this.perform(context, targetData, transformation, sourceValues, oldSourceValues)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Data has been transformed to a {} for the #{} transform.  The mapped target columns are: {}. The mapped target values are: {}", new Object[]{targetData.getTargetDmlType().toString(), transformNumber, ArrayUtils.toString((Object)targetData.getColumnNames()), ArrayUtils.toString((Object)targetData.getColumnValues())});
                    }
                    dataThatHasBeenTransformed.add(targetData);
                    continue;
                }
                log.debug("Data has not been transformed for the #{} transform", (Object)transformNumber);
            }
            ArrayList<TransformedData> arrayList = dataThatHasBeenTransformed;
            return arrayList;
        }
        catch (IgnoreRowException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Transform indicated that the target row should be ignored with a target key of: {}", (Object)"unknown.  Transformation aborted during transformation of key");
            }
            ArrayList<TransformedData> arrayList = new ArrayList<TransformedData>(0);
            return arrayList;
        }
        finally {
            long transformTimeInMs = System.currentTimeMillis() - ts;
            Statistics stats = this.nestedWriter.getStatistics().get(this.batch);
            if (stats != null) {
                stats.increment("TRANSFORMMILLIS", transformTimeInMs);
            }
            ts = System.currentTimeMillis();
        }
    }

    protected boolean perform(DataContext context, TransformedData data, TransformTable transformation, Map<String, String> sourceValues, Map<String, String> oldSourceValues) throws IgnoreRowException {
        boolean persistData;
        block13: {
            persistData = false;
            try {
                DataEventType eventType = data.getSourceDmlType();
                for (TransformColumn transformColumn : transformation.getTransformColumns()) {
                    TransformColumn.IncludeOnType includeOn;
                    if (transformColumn.isPk() || !((includeOn = transformColumn.getIncludeOn()) == TransformColumn.IncludeOnType.ALL || includeOn == TransformColumn.IncludeOnType.INSERT && eventType == DataEventType.INSERT || includeOn == TransformColumn.IncludeOnType.UPDATE && eventType == DataEventType.UPDATE) && (includeOn != TransformColumn.IncludeOnType.DELETE || eventType != DataEventType.DELETE)) continue;
                    if (StringUtils.isBlank((CharSequence)transformColumn.getSourceColumnName()) || sourceValues.containsKey(transformColumn.getSourceColumnName())) {
                        try {
                            Object value = this.transformColumn(context, data, transformColumn, sourceValues, oldSourceValues);
                            if (value instanceof NewAndOldValue) {
                                data.put(transformColumn, ((NewAndOldValue)value).getNewValue(), oldSourceValues != null ? ((NewAndOldValue)value).getOldValue() : null, false);
                                continue;
                            }
                            if (value == null || value instanceof String) {
                                data.put(transformColumn, (String)value, null, false);
                                continue;
                            }
                            if (value instanceof List) {
                                throw new IllegalStateException(String.format("Column transform failed %s.%s. Transforms that multiply rows must be marked as part of the primary key", transformColumn.getTransformId(), transformColumn.getTargetColumnName()));
                            }
                            throw new IllegalStateException(String.format("Column transform failed %s.%s. It returned an unexpected type of %s", transformColumn.getTransformId(), transformColumn.getTargetColumnName(), value.getClass().getSimpleName()));
                        }
                        catch (IgnoreColumnException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("A transform indicated we should ignore the target column {}", (Object)transformColumn.getTargetColumnName());
                            continue;
                        }
                    }
                    if (eventType != DataEventType.DELETE) {
                        log.warn("Could not find a source column of {} for the transformation: {}", (Object)transformColumn.getSourceColumnName(), (Object)transformation.getTransformId());
                        continue;
                    }
                    log.debug("Could not find a source column of {} for the transformation: {}.  This is probably because this was a DELETE event and no old data was captured.", (Object)transformColumn.getSourceColumnName(), (Object)transformation.getTransformId());
                }
                TargetDmlAction targetAction = data.getTargetAction();
                if (targetAction != null && data.getColumnNames().length > 0 && targetAction != TargetDmlAction.NONE) {
                    persistData = true;
                } else if (log.isDebugEnabled()) {
                    log.debug("The {} transformation is not configured to delete row.  Not sending the delete through.", (Object)transformation.getTransformId());
                }
            }
            catch (IgnoreRowException ex) {
                if (!log.isDebugEnabled()) break block13;
                log.debug("Transform indicated that the target row should be ignored with a target key of: {}", (Object)ArrayUtils.toString((Object)data.getKeyValues()));
            }
        }
        return persistData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<TransformedData> create(DataContext context, DataEventType dataEventType, TransformTable transformation, Map<String, String> sourceKeyValues, Map<String, String> oldSourceValues, Map<String, String> sourceValues) throws IgnoreRowException {
        List<TransformColumn> columns = transformation.getPrimaryKeyColumns();
        if (columns == null || columns.size() == 0) {
            log.error("No primary key defined for the transformation: {}", (Object)transformation.getTransformId());
            return new ArrayList<TransformedData>(0);
        }
        ArrayList<TransformedData> datas = new ArrayList<TransformedData>();
        TransformedData data = new TransformedData(transformation, dataEventType, sourceKeyValues, oldSourceValues, sourceValues);
        datas.add(data);
        DataEventType eventType = data.getSourceDmlType();
        switch (data.getTargetDmlType()) {
            case INSERT: {
                data.setTargetAction(TargetDmlAction.INS_ROW);
                break;
            }
            case UPDATE: {
                data.setTargetAction(transformation.evaluateTargetDmlAction(context, data));
                break;
            }
            case DELETE: {
                data.setTargetAction(transformation.getDeleteAction());
                break;
            }
            default: {
                data.setTargetAction(TargetDmlAction.OTHER);
            }
        }
        switch (data.getTargetAction()) {
            case DEL_ROW: {
                data.setTargetDmlType(DataEventType.DELETE);
                break;
            }
            case UPDATE_COL: 
            case UPD_ROW: {
                data.setTargetDmlType(DataEventType.UPDATE);
                break;
            }
            case INS_ROW: {
                data.setTargetDmlType(DataEventType.INSERT);
                break;
            }
        }
        for (TransformColumn transformColumn : columns) {
            TransformColumn.IncludeOnType includeOn = transformColumn.getIncludeOn();
            if (!(includeOn == TransformColumn.IncludeOnType.ALL || includeOn == TransformColumn.IncludeOnType.INSERT && eventType == DataEventType.INSERT || includeOn == TransformColumn.IncludeOnType.UPDATE && eventType == DataEventType.UPDATE) && (includeOn != TransformColumn.IncludeOnType.DELETE || eventType != DataEventType.DELETE)) continue;
            ArrayList<TransformedData> newDatas = null;
            try {
                Object columnValue = this.transformColumn(context, data, transformColumn, sourceValues, oldSourceValues);
                if (columnValue instanceof List) {
                    List values = (List)columnValue;
                    if (values.size() <= 0) throw new IgnoreRowException();
                    data.put(transformColumn, (String)values.get(0), oldSourceValues != null ? (String)values.get(0) : null, true);
                    if (values.size() > 1) {
                        if (newDatas == null) {
                            newDatas = new ArrayList<TransformedData>(values.size() - 1);
                        }
                        for (int i = 1; i < values.size(); ++i) {
                            TransformedData newData = data.copy();
                            newData.put(transformColumn, (String)values.get(i), oldSourceValues != null ? (String)values.get(i) : null, true);
                            newDatas.add(newData);
                        }
                    }
                } else if (columnValue instanceof NewAndOldValue) {
                    data.put(transformColumn, ((NewAndOldValue)columnValue).getNewValue(), oldSourceValues != null ? ((NewAndOldValue)columnValue).getOldValue() : null, true);
                } else {
                    data.put(transformColumn, (String)columnValue, oldSourceValues != null ? (String)columnValue : null, true);
                }
            }
            catch (IgnoreColumnException ignoreColumnException) {
                // empty catch block
            }
            if (newDatas == null) continue;
            datas.addAll(newDatas);
            newDatas = null;
        }
        return datas;
    }

    protected Object transformColumn(DataContext context, TransformedData data, TransformColumn transformColumn, Map<String, String> sourceValues, Map<String, String> oldSourceValues) throws IgnoreRowException, IgnoreColumnException {
        IColumnTransform<?> transform;
        String value;
        String returnValue = null;
        returnValue = value = transformColumn.getSourceColumnName() != null ? sourceValues.get(transformColumn.getSourceColumnName()) : null;
        IColumnTransform<?> iColumnTransform = transform = this.columnTransforms != null ? this.columnTransforms.get(transformColumn.getTransformType()) : null;
        if (transform != null) {
            try {
                String oldValue = null;
                if (oldSourceValues != null) {
                    oldValue = oldSourceValues.get(transformColumn.getSourceColumnName());
                }
                returnValue = transform.transform(this.platform, context, transformColumn, data, sourceValues, value, oldValue);
            }
            catch (NestedRuntimeException nestedRuntimeException) {
                Throwable rootCause = nestedRuntimeException.getRootCause();
                if (rootCause instanceof IgnoreColumnException) {
                    throw (IgnoreColumnException)rootCause;
                }
                if (rootCause instanceof IgnoreRowException) {
                    throw (IgnoreRowException)rootCause;
                }
                throw nestedRuntimeException;
            }
            catch (RuntimeException ex) {
                log.warn("Column transform failed {}.{} ({}) for source values of {}", new Object[]{transformColumn.getTransformId(), transformColumn.getTargetColumnName(), transformColumn.getIncludeOn().name(), sourceValues.toString()});
                throw ex;
            }
        } else {
            throw new TransformColumnException(String.format("Could not locate a column transform of type '%s'", transformColumn.getTransformType()));
        }
        return returnValue;
    }

    @Override
    public void end(Table table) {
        if (this.lastTransformedTable != null) {
            this.nestedWriter.end(this.lastTransformedTable);
            this.lastTransformedTable = null;
        }
        if (this.activeTransforms != null && this.activeTransforms.size() > 0) {
            this.activeTransforms = null;
        } else {
            super.end(table);
        }
    }
}

