/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.stage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StagingFileLock {
    private static final Logger log = LoggerFactory.getLogger(StagingFileLock.class);
    boolean acquired = false;
    private File lockFile;
    private String lockFailureMessage;

    public long getLockAge() {
        if (this.lockFile != null) {
            try {
                FileTime lastModifiedTime = Files.getLastModifiedTime(this.lockFile.toPath(), new LinkOption[0]);
                long age = System.currentTimeMillis() - lastModifiedTime.toMillis();
                return age < 0L ? 42L : age;
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to get last modified time for file " + this.lockFile, (Throwable)ex);
                }
                return 0L;
            }
        }
        return 0L;
    }

    public boolean isAcquired() {
        return this.acquired;
    }

    public void setAcquired(boolean acquired) {
        this.acquired = acquired;
    }

    public File getLockFile() {
        return this.lockFile;
    }

    public void setLockFile(File lockFile) {
        this.lockFile = lockFile;
    }

    public String getLockFailureMessage() {
        return this.lockFailureMessage;
    }

    public void setLockFailureMessage(String lockFailureMessage) {
        this.lockFailureMessage = lockFailureMessage;
    }

    public void releaseLock() {
        int retries = 5;
        boolean ok = false;
        do {
            if (ok = this.lockFile.delete()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!ok && retries-- > 0);
        if (ok) {
            log.debug("Lock {} released successfully.", (Object)this.lockFile);
        } else {
            boolean exists = this.lockFile.exists();
            log.warn("Failed to release lock {} exists={}", (Object)this.lockFile, (Object)exists);
        }
    }

    public void breakLock() {
        if (this.lockFile.delete()) {
            log.info("Lock {} broken successfully.", (Object)this.lockFile);
        } else {
            log.warn("Failed to break lock {}", (Object)this.lockFile);
        }
    }

    public String toString() {
        return String.format("%s [%s]", super.toString(), this.lockFile);
    }
}

