/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.stage;

import java.util.HashMap;
import java.util.Map;

public class StagingPurgeContext {
    private Map<String, Object> context = new HashMap<String, Object>();
    private long startTime;
    private long lastLogTime;
    private long purgedFileCount = 0L;
    private long purgedFileSize = 0L;
    private long purgedMemCount = 0L;
    private long purgedMemSize = 0L;

    public void incrementPurgedFileCount() {
        ++this.purgedFileCount;
    }

    public void addPurgedFileBytes(long bytes) {
        this.purgedFileSize += bytes;
    }

    public void incrementPurgedMemoryCount() {
        ++this.purgedMemCount;
    }

    public void addPurgedMemoryBytes(long bytes) {
        this.purgedMemCount += bytes;
    }

    public long getPurgedFileCount() {
        return this.purgedFileCount;
    }

    public void setPurgedFileCount(long purgedFileCount) {
        this.purgedFileCount = purgedFileCount;
    }

    public long getPurgedFileSize() {
        return this.purgedFileSize;
    }

    public void setPurgedFileSize(long purgedFileSize) {
        this.purgedFileSize = purgedFileSize;
    }

    public long getPurgedMemCount() {
        return this.purgedMemCount;
    }

    public void setPurgedMemCount(long purgedMemCount) {
        this.purgedMemCount = purgedMemCount;
    }

    public long getPurgedMemSize() {
        return this.purgedMemSize;
    }

    public void setPurgedMemSize(long purgedMemSize) {
        this.purgedMemSize = purgedMemSize;
    }

    public Object getContextValue(String key) {
        return this.context.get(key);
    }

    public Object putContextValue(String key, Object value) {
        return this.context.put(key, value);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.getContextValue(key);
    }

    public long getLong(String key) {
        return (Long)this.getContextValue(key);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getLastLogTime() {
        return this.lastLogTime;
    }

    public void setLastLogTime(long lastLogTime) {
        this.lastLogTime = lastLogTime;
    }

    public boolean shouldLogStatus() {
        long now = System.currentTimeMillis();
        return now - this.startTime > 60000L && now - this.lastLogTime > 60000L;
    }
}

