/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jumpmind.symmetric.wrapper.WrapperException;
import org.jumpmind.symmetric.wrapper.WrapperService;
import org.jumpmind.symmetric.wrapper.jna.CLibrary;

@IgnoreJRERequirement
public class UnixService
extends WrapperService {
    private static final String[] RUN_LEVELS_START = new String[]{"2", "3", "5"};
    private static final String[] RUN_LEVELS_STOP = new String[]{"0", "1", "6"};
    private static final String RUN_SEQUENCE_START = "20";
    private static final String RUN_SEQUENCE_STOP = "80";
    private static final String RC_DIR = "/etc";
    private static final String INITD_DIR = "/etc/init.d";
    private static final String SYSTEMD_INSTALL_DIR = "/lib/systemd/system";
    private static final String SYSTEMD_ETC_DIR = "/etc/systemd/system";
    private static final String SYSTEMD_RUNTIME_DIR = "/run/systemd/system";
    private static final String INITD_SCRIPT_START = "start";
    private static final String INITD_SCRIPT_STOP = "stop";
    private static final String SYSTEMD_SCRIPT_START = "start";
    private static final String SYSTEMD_SCRIPT_STOP = "stop";
    private static final String SYSTEMD_SCRIPT_ENABLE = "enable";
    private static final String SYSTEMD_SCRIPT_DISABLE = "disable";

    @Override
    protected boolean setWorkingDirectory(String dir) {
        return CLibrary.INSTANCE.chdir(dir) == 0;
    }

    @Override
    public void install() {
        if (!this.isPrivileged()) {
            throw new WrapperException(14, 0, "Must be root to install");
        }
        System.out.println("Installing " + this.config.getName() + " ...");
        if (this.isSystemdRunning()) {
            this.installSystemd();
        } else {
            this.installInitd();
        }
        System.out.println("Done");
    }

    private boolean isSystemdRunning() {
        File systemddir = new File(SYSTEMD_RUNTIME_DIR);
        return systemddir.exists();
    }

    private void installSystemd() {
        String runFile = this.getSystemdScriptFile();
        try (FileWriter writer = new FileWriter(runFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/symmetricds.systemd")));){
            Object javaCommand = this.config.getJavaCommand();
            if (javaCommand == null) {
                javaCommand = "java";
            }
            if (!((String)javaCommand).startsWith(File.separator)) {
                if (!((String)javaCommand).contains(File.separator)) {
                    javaCommand = this.getAbsolutePath((String)javaCommand);
                } else {
                    String cwd = System.getProperty("user.dir");
                    javaCommand = cwd + File.separator + (String)javaCommand;
                }
            }
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll("\\$\\{wrapper.description}", this.config.getDescription());
                line = line.replaceAll("\\$\\{wrapper.pidfile}", this.getWrapperPidFile());
                line = line.replaceAll("\\$\\{wrapper.home}", this.config.getWorkingDirectory().getAbsolutePath());
                line = line.replaceAll("\\$\\{wrapper.jarfile}", this.config.getWrapperJarPath());
                line = line.replaceAll("\\$\\{wrapper.java.command}", (String)javaCommand);
                line = line.replaceAll("\\$\\{wrapper.run.as.user}", this.config.getRunAsUser() == null || this.config.getRunAsUser().length() == 0 ? "root" : this.config.getRunAsUser());
                writer.write(line + "\n");
            }
        }
        catch (IOException e) {
            throw new WrapperException(17, 0, "Failed while writing run file", e);
        }
        this.runServiceCommand(this.getSystemdCommand(SYSTEMD_SCRIPT_ENABLE, this.config.getName()));
    }

    private String getSystemdScriptFile() {
        String fileName = "/lib/systemd/system/" + this.config.getName() + ".service";
        if (!new File(fileName).exists()) {
            fileName = "/etc/systemd/system/" + this.config.getName() + ".service";
        }
        return fileName;
    }

    private String getInitdRunFile() {
        return "/etc/init.d/" + this.config.getName();
    }

    private String getWrapperPidFile() throws IOException {
        return this.config.getWrapperPidFile() != null && this.config.getWrapperPidFile().startsWith("/") ? this.config.getWrapperPidFile() : this.config.getWorkingDirectory().getCanonicalPath() + "/" + this.config.getWrapperPidFile();
    }

    private void installInitd() {
        String rcDir = this.getRunCommandDir();
        String runFile = this.getInitdRunFile();
        try {
            FileWriter writer = new FileWriter(runFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/symmetricds.initd")));
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll("\\$\\{wrapper.name}", this.config.getName());
                line = line.replaceAll("\\$\\{wrapper.displayname}", this.config.getDisplayName());
                line = line.replaceAll("\\$\\{wrapper.description}", this.config.getDescription());
                line = line.replaceAll("\\$\\{wrapper.home}", this.config.getWorkingDirectory().getAbsolutePath());
                line = line.replaceAll("\\$\\{wrapper.java.command}", this.config.getJavaCommand());
                line = line.replaceAll("\\$\\{wrapper.jarfile}", this.config.getWrapperJarPath());
                line = line.replaceAll("\\$\\{wrapper.run.as.user}", this.config.getRunAsUser());
                writer.write(line + "\n");
            }
            reader.close();
            writer.close();
        }
        catch (IOException e) {
            throw new WrapperException(17, 0, "Failed while writing run file", e);
        }
        new File(runFile).setExecutable(true, false);
        for (String runLevel : RUN_LEVELS_START) {
            CLibrary.INSTANCE.symlink(runFile, rcDir + "/rc" + runLevel + ".d/S20" + this.config.getName());
        }
        for (String runLevel : RUN_LEVELS_STOP) {
            CLibrary.INSTANCE.symlink(runFile, rcDir + "/rc" + runLevel + ".d/K80" + this.config.getName());
        }
    }

    @Override
    public void uninstall() {
        if (!this.isPrivileged()) {
            throw new WrapperException(14, 0, "Must be root to uninstall");
        }
        System.out.println("Uninstalling " + this.config.getName() + " ...");
        this.uninstallSystemd();
        this.uninstallInitd();
        System.out.println("Done");
    }

    private void uninstallSystemd() {
        this.runServiceCommand(this.getSystemdCommand(SYSTEMD_SCRIPT_DISABLE, this.config.getName()));
        String runFile = this.getSystemdScriptFile();
        new File(runFile).delete();
    }

    private void uninstallInitd() {
        String rcDir = this.getRunCommandDir();
        String runFile = this.getInitdRunFile();
        for (String runLevel : RUN_LEVELS_START) {
            new File(rcDir + "/rc" + runLevel + ".d/S20" + this.config.getName()).delete();
        }
        for (String runLevel : RUN_LEVELS_STOP) {
            new File(rcDir + "/rc" + runLevel + ".d/K80" + this.config.getName()).delete();
        }
        new File(runFile).delete();
    }

    protected String getRunCommandDir() {
        String rcDir = "";
        if (new File("/etc/init.d/rc0.d").exists()) {
            rcDir = INITD_DIR;
        } else if (new File("/etc/rc0.d").exists()) {
            rcDir = RC_DIR;
        } else {
            throw new WrapperException(15, 0, "Unable to locate run level folders");
        }
        return rcDir;
    }

    @Override
    public boolean isPrivileged() {
        return CLibrary.INSTANCE.geteuid() == 0;
    }

    @Override
    public boolean isInstalled() {
        return new File(this.getSystemdScriptFile()).exists() || new File(this.getInitdRunFile()).exists();
    }

    @Override
    protected boolean isPidRunning(int pid) {
        File procFile = new File("/proc/" + pid + "/cmdline");
        if (procFile.canRead()) {
            try {
                List<String> args = null;
                int cnt = 0;
                while (cnt < 10 && (args = this.readProcFile(procFile)).size() <= 0) {
                    ++cnt;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                for (String arg : args) {
                    if (!arg.contains(this.config.getJavaCommand())) continue;
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return pid != 0 && CLibrary.INSTANCE.kill(pid, 0) == 0;
    }

    private List<String> readProcFile(File procFile) throws IOException {
        FileInputStream in = new FileInputStream(procFile);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ArrayList<String> args = new ArrayList<String>();
        byte[] buffer = new byte[512];
        int len = 0;
        while ((len = in.read(buffer)) != -1) {
            for (int i = 0; i < len; ++i) {
                if (buffer[i] == 0) {
                    bout.flush();
                    args.add(new String(bout.toString()));
                    bout.reset();
                    continue;
                }
                bout.write(buffer[i]);
            }
        }
        in.close();
        return args;
    }

    @Override
    protected int getCurrentPid() {
        return CLibrary.INSTANCE.getpid();
    }

    @Override
    protected int getProcessPid(Process process) {
        int pid = 0;
        try {
            Method method = Process.class.getDeclaredMethod("pid", null);
            Object object = method.invoke((Object)process, new Object[0]);
            pid = ((Long)object).intValue();
        }
        catch (Exception e) {
            try {
                Field field = process.getClass().getDeclaredField("pid");
                field.setAccessible(true);
                pid = field.getInt(process);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pid;
    }

    @Override
    protected void killProcess(int pid, boolean isTerminate) {
        CLibrary.INSTANCE.kill(pid, isTerminate ? 9 : 1);
    }

    private ArrayList<String> getServiceCommand(String command) {
        ArrayList<String> s = new ArrayList<String>();
        String runFile = this.getInitdRunFile();
        s.add(runFile);
        s.add(command);
        return s;
    }

    private ArrayList<String> getSystemdCommand(String command, String serviceName) {
        ArrayList<String> s = new ArrayList<String>();
        s.add("systemctl");
        s.add(command);
        s.add(serviceName);
        return s;
    }

    @Override
    public void start() {
        if (this.isInstalled()) {
            if (!this.canRunService()) {
                throw new WrapperException(14, 0, "You must be root to start a service");
            }
            if (this.isRunning()) {
                throw new WrapperException(5, 0, "Server is already running");
            }
            this.stopProcesses(true);
            System.out.println("Waiting for server to start");
            if (this.isSystemdRunning() && new File(this.getSystemdScriptFile()).exists()) {
                boolean success = true;
                if (this.shouldRunService()) {
                    success = this.runServiceCommand(this.getSystemdCommand("start", this.config.getName()));
                } else {
                    super.start();
                }
                if (!success) {
                    throw new WrapperException(8, 0, "Server did not start");
                }
            } else {
                boolean success = true;
                if (this.shouldRunService()) {
                    success = this.runServiceCommand(this.getServiceCommand("start"));
                } else {
                    super.start();
                }
                if (!success) {
                    throw new WrapperException(8, 0, "Server did not start");
                }
            }
        } else {
            super.start();
        }
    }

    private boolean canRunService() {
        int uid;
        int euid;
        String runasuser;
        boolean ret = false;
        if (this.isPrivileged()) {
            ret = true;
        }
        if ((runasuser = this.config.getRunAsUser()) != null && runasuser.length() > 0 && (euid = CLibrary.INSTANCE.geteuid()) == (uid = this.getuid(runasuser))) {
            ret = true;
        }
        return ret;
    }

    private boolean shouldRunService() {
        boolean ret = true;
        String runasuser = this.config.getRunAsUser();
        if (runasuser != null && runasuser.length() > 0) {
            int uid;
            int euid = CLibrary.INSTANCE.geteuid();
            if (euid == (uid = this.getuid(runasuser))) {
                ret = false;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    private int getuid(String login) {
        int ret = -1;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("id");
        cmd.add("-u");
        cmd.add(login);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            process = pb.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        if (process != null) {
            ArrayList<String> cmdOutput = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    cmdOutput.add(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new WrapperException(8, 0, "Unable to read from command: " + cmd, e);
            }
            if (cmdOutput != null && cmdOutput.size() > 0) {
                ret = Integer.parseInt((String)cmdOutput.get(0));
            }
        }
        return ret;
    }

    private String getAbsolutePath(String command) {
        String ret = command;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("which");
        cmd.add(command);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            process = pb.start();
            process.waitFor();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        if (process != null) {
            ArrayList<String> cmdOutput = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    cmdOutput.add(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new WrapperException(8, 0, "Unable to read from command: " + cmd, e);
            }
            if (cmdOutput != null && cmdOutput.size() > 0) {
                ret = (String)cmdOutput.get(0);
            }
        }
        return ret;
    }

    @Override
    protected void stopProcesses(boolean isStopAbandoned) {
        if (this.isInstalled()) {
            if (!this.canRunService()) {
                throw new WrapperException(14, 0, "You must be root to stop a service");
            }
            int serverPid = this.readPidFromFile(this.config.getServerPidFile());
            int wrapperPid = this.readPidFromFile(this.config.getWrapperPidFile());
            boolean isServerRunning = this.isPidRunning(serverPid);
            boolean isWrapperRunning = this.isPidRunning(wrapperPid);
            if (!(isStopAbandoned || isServerRunning || isWrapperRunning)) {
                throw new WrapperException(6, 0, "Server is not running");
            }
            if (this.isSystemdRunning() && new File(this.getSystemdScriptFile()).exists()) {
                if (this.shouldRunService()) {
                    this.runServiceCommand(this.getSystemdCommand("stop", this.config.getName()));
                } else {
                    super.stopProcesses(isStopAbandoned);
                }
            } else if (this.shouldRunService()) {
                this.runServiceCommand(this.getServiceCommand("stop"));
            } else {
                super.stopProcesses(isStopAbandoned);
            }
        } else {
            super.stopProcesses(isStopAbandoned);
        }
    }

    private boolean runServiceCommand(ArrayList<String> cmd) {
        int ret = -1;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        System.out.println("Running " + pb.command());
        Process process = null;
        try {
            process = pb.start();
            ret = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            System.err.println(e.getMessage());
        }
        if (process != null) {
            ArrayList<String> cmdOutput = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    cmdOutput.add(line);
                }
            }
            catch (Exception e) {
                throw new WrapperException(8, 0, "Unable to read from service command: " + cmd, e);
            }
            if (cmdOutput.size() > 0) {
                System.err.println(this.commandToString(cmd));
                for (String line : cmdOutput) {
                    System.err.println(line);
                }
            }
        }
        return ret == 0;
    }
}

