/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

public class WrapperException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int errorCode;
    private int nativeErrorCode;
    private String message;
    private Throwable cause;

    public WrapperException(int errorCode, int nativeErrorCode, String message) {
        this.errorCode = errorCode;
        this.nativeErrorCode = nativeErrorCode;
        this.message = message;
    }

    public WrapperException(int errorCode, int nativeErrorCode, String message, Throwable cause) {
        this.cause = cause;
    }

    @Override
    public String toString() {
        String s = "Error " + this.errorCode + " [" + this.message + "]";
        if (this.nativeErrorCode > 0) {
            s = s + " with native error " + this.nativeErrorCode;
        }
        if (this.cause != null) {
            s = s + " caused by " + this.cause.getClass().getSimpleName() + " [" + this.cause.getMessage() + "]";
        }
        return s;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getNativeErrorCode() {
        return this.nativeErrorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }
}

