/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.cache.ConfigurationCache;
import org.jumpmind.symmetric.cache.DataLoaderCache;
import org.jumpmind.symmetric.cache.FileSyncCache;
import org.jumpmind.symmetric.cache.GroupletCache;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.cache.LoadFilterCache;
import org.jumpmind.symmetric.cache.NodeCache;
import org.jumpmind.symmetric.cache.OutgoingBatchCache;
import org.jumpmind.symmetric.cache.TransformCache;
import org.jumpmind.symmetric.cache.TriggerRouterCache;
import org.jumpmind.symmetric.cache.TriggerRouterRoutersCache;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Grouplet;
import org.jumpmind.symmetric.model.LoadFilter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupChannelWindow;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.impl.DataLoaderService;
import org.jumpmind.symmetric.service.impl.TransformService;

public class CacheManager
implements ICacheManager {
    private ISymmetricEngine engine;
    private volatile Object constructorCreator = new Object();
    private volatile TriggerRouterCache triggerRouterCache;
    private volatile NodeCache nodeCache;
    private volatile ConfigurationCache configurationCache;
    private volatile DataLoaderCache dataLoaderCache;
    private volatile FileSyncCache fileSyncCache;
    private volatile GroupletCache groupletCache;
    private volatile LoadFilterCache loadFilterCache;
    private volatile TransformCache transformCache;
    private volatile OutgoingBatchCache outgoingBatchCache;

    public CacheManager(ISymmetricEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTriggerRouterCache() {
        if (this.triggerRouterCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.triggerRouterCache == null) {
                    this.triggerRouterCache = new TriggerRouterCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNodeCache() {
        if (this.nodeCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.nodeCache == null) {
                    this.nodeCache = new NodeCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConfigurationCache() {
        if (this.configurationCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.configurationCache == null) {
                    this.configurationCache = new ConfigurationCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDataLoaderCache() {
        if (this.dataLoaderCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.dataLoaderCache == null) {
                    this.dataLoaderCache = new DataLoaderCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFileSyncCache() {
        if (this.fileSyncCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.fileSyncCache == null) {
                    this.fileSyncCache = new FileSyncCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeGroupletCache() {
        if (this.groupletCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.groupletCache == null) {
                    this.groupletCache = new GroupletCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLoadFilterCache() {
        if (this.loadFilterCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.loadFilterCache == null) {
                    this.loadFilterCache = new LoadFilterCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTransformCache() {
        if (this.transformCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.transformCache == null) {
                    this.transformCache = new TransformCache(this.engine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOutgoingBatchCache() {
        if (this.outgoingBatchCache == null) {
            Object object = this.constructorCreator;
            synchronized (object) {
                if (this.outgoingBatchCache == null) {
                    this.outgoingBatchCache = new OutgoingBatchCache(this.engine);
                }
            }
        }
    }

    @Override
    public List<TriggerRouter> getTriggerRouters(boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.getTriggerRouters(refreshCache);
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannel(String nodeGroupId, boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.getTriggerRoutersByChannel(nodeGroupId, refreshCache);
    }

    @Override
    public Map<String, Map<Integer, TriggerRouter>> getTriggerRoutersByTriggerHist(boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.getTriggerRoutersByTriggerHist(refreshCache);
    }

    @Override
    public Map<String, Trigger> getTriggers(boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.getTriggers(refreshCache);
    }

    @Override
    public Map<String, Router> getRouters(boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.getRouters(refreshCache);
    }

    @Override
    public Map<String, TriggerRouter> getTriggerRoutersById(boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.getTriggerRoutersById(refreshCache);
    }

    @Override
    public Map<String, TriggerRouterRoutersCache> getTriggerRoutersByNodeGroupId(boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.getTriggerRoutersByNodeGroupId(refreshCache);
    }

    @Override
    public boolean isUsingTargetExternalId(boolean refreshCache) {
        this.initializeTriggerRouterCache();
        return this.triggerRouterCache.isUsingTargetExternalId(refreshCache);
    }

    @Override
    public void flushTriggerRoutersByNodeGroupId() {
        this.initializeTriggerRouterCache();
        this.triggerRouterCache.flushTriggerRoutersByNodeGroupId();
    }

    @Override
    public void flushTriggerRoutersByChannel() {
        this.initializeTriggerRouterCache();
        this.triggerRouterCache.flushTriggerRoutersByChannel();
    }

    @Override
    public void flushTriggerRouters() {
        this.initializeTriggerRouterCache();
        this.triggerRouterCache.flushTriggerRouters();
    }

    @Override
    public void flushTriggerRoutersByTriggerHist() {
        this.initializeTriggerRouterCache();
        this.triggerRouterCache.flushTriggerRoutersByTriggerHist();
    }

    @Override
    public void flushTriggerRoutersById() {
        this.initializeTriggerRouterCache();
        this.triggerRouterCache.flushTriggerRoutersById();
    }

    @Override
    public void flushTriggers() {
        this.initializeTriggerRouterCache();
        this.triggerRouterCache.flushTriggers();
    }

    @Override
    public void flushRouters() {
        this.initializeTriggerRouterCache();
        this.triggerRouterCache.flushRouters();
    }

    @Override
    public void flushAllWithRouters() {
        this.flushTriggerRoutersByNodeGroupId();
        this.flushTriggerRoutersByChannel();
        this.flushTriggerRouters();
        this.flushTriggerRoutersByTriggerHist();
        this.flushTriggerRoutersById();
    }

    @Override
    public List<Node> getSourceNodesCache(NodeGroupLinkAction eventAction, Node node) {
        this.initializeNodeCache();
        return this.nodeCache.getSourceNodesCache(eventAction, node);
    }

    @Override
    public List<Node> getTargetNodesCache(NodeGroupLinkAction eventAction, Node node) {
        this.initializeNodeCache();
        return this.nodeCache.getTargetNodesCache(eventAction, node);
    }

    @Override
    public Collection<Node> getNodesByGroup(String nodeGroupId) {
        this.initializeNodeCache();
        return this.nodeCache.getNodesByGroup(nodeGroupId);
    }

    @Override
    public void flushSourceNodesCache() {
        this.initializeNodeCache();
        this.nodeCache.flushSourceNodesCache();
    }

    @Override
    public void flushTargetNodesCache() {
        this.initializeNodeCache();
        this.nodeCache.flushTargetNodesCache();
    }

    @Override
    public List<NodeChannel> getNodeChannels(String nodeId) {
        this.initializeConfigurationCache();
        return this.configurationCache.getNodeChannels(nodeId);
    }

    @Override
    public long getNodeChannelCacheTime() {
        this.initializeConfigurationCache();
        return this.configurationCache.getNodeChannelCacheTime();
    }

    @Override
    public Map<String, Channel> getChannels(boolean refreshCache) {
        this.initializeConfigurationCache();
        return this.configurationCache.getChannels(refreshCache);
    }

    @Override
    public Collection<String> getQueues(boolean refreshCache) {
        this.initializeConfigurationCache();
        return this.configurationCache.getQueues(refreshCache);
    }

    @Override
    public List<NodeGroupLink> getNodeGroupLinks(boolean refreshCache) {
        this.initializeConfigurationCache();
        return this.configurationCache.getNodeGroupLinks(refreshCache);
    }

    @Override
    public Map<String, List<NodeGroupChannelWindow>> getNodeGroupChannelWindows() {
        this.initializeConfigurationCache();
        return this.configurationCache.getNodeGroupChannelWindows();
    }

    @Override
    public void flushNodeChannels() {
        this.initializeConfigurationCache();
        this.configurationCache.flushNodeChannels();
    }

    @Override
    public void flushChannels() {
        this.initializeConfigurationCache();
        this.configurationCache.flushChannels();
    }

    @Override
    public void flushNodeGroupLinks() {
        this.initializeConfigurationCache();
        this.configurationCache.flushNodeGroupLinks();
    }

    @Override
    public void flushNodeGroupChannelWindows() {
        this.initializeConfigurationCache();
        this.configurationCache.flushNodeGroupChannelWindows();
    }

    @Override
    public List<DataLoaderService.ConflictNodeGroupLink> getConflictSettingsNodeGroupLinks(NodeGroupLink link, boolean refreshCache) {
        this.initializeDataLoaderCache();
        return this.dataLoaderCache.getConflictSettingsNodeGroupLinks(link, refreshCache);
    }

    @Override
    public void flushConflictSettingsNodeGroupLinks() {
        this.initializeDataLoaderCache();
        this.dataLoaderCache.clearDataLoaderCache();
    }

    @Override
    public List<FileTriggerRouter> getFileTriggerRouters(boolean refreshCache) {
        this.initializeFileSyncCache();
        return this.fileSyncCache.getFileTriggerRouters(refreshCache);
    }

    @Override
    public void flushFileTriggerRouters() {
        this.initializeFileSyncCache();
        this.fileSyncCache.flushFileTriggerRouters();
    }

    @Override
    public List<Grouplet> getGrouplets(boolean refreshCache) {
        this.initializeGroupletCache();
        return this.groupletCache.getGrouplets(refreshCache);
    }

    @Override
    public void flushGrouplets() {
        this.initializeGroupletCache();
        this.groupletCache.flushGrouplets();
    }

    @Override
    public Map<NodeGroupLink, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>>> findLoadFilters(NodeGroupLink nodeGroupLink, boolean useCache) {
        this.initializeLoadFilterCache();
        return this.loadFilterCache.findLoadFilters(nodeGroupLink, useCache);
    }

    @Override
    public void flushLoadFilters() {
        this.initializeLoadFilterCache();
        this.loadFilterCache.flushLoadFilterCache();
    }

    @Override
    public Map<NodeGroupLink, Map<TransformPoint, List<TransformService.TransformTableNodeGroupLink>>> getTransformCache() {
        this.initializeTransformCache();
        return this.transformCache.getTransformsCacheByNodeGroupLinkByTransformPoint();
    }

    @Override
    public void flushTransformCache() {
        this.initializeTransformCache();
        this.transformCache.flushTransformCache();
    }

    @Override
    public Map<String, Collection<String>> getReadyQueues(boolean refreshCache) {
        this.initializeOutgoingBatchCache();
        return this.outgoingBatchCache.getReadyQueues(refreshCache);
    }

    @Override
    public void flushReadyQueuesCache() {
        this.initializeOutgoingBatchCache();
        this.outgoingBatchCache.flushReadyQueuesCache();
    }
}

