/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ReadyChannels;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingBatchCache {
    private final Logger log = LoggerFactory.getLogger(OutgoingBatchCache.class);
    private IParameterService parameterService;
    private IConfigurationService configurationService;
    private IOutgoingBatchService outgoingBatchService;
    private Semaphore cacheLock = new Semaphore(1);
    private volatile Map<String, Collection<String>> readyQueuesCache = new HashMap<String, Collection<String>>();
    private volatile long readyQueuesCacheTime;

    public OutgoingBatchCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.configurationService = engine.getConfigurationService();
        this.outgoingBatchService = engine.getOutgoingBatchService();
    }

    public Map<String, Collection<String>> getReadyQueues(boolean refreshCache) {
        this.checkReadyQueuesCache(refreshCache);
        return this.readyQueuesCache;
    }

    public void flushReadyQueuesCache() {
        if (this.cacheLock.tryAcquire()) {
            this.readyQueuesCacheTime = 0L;
            this.cacheLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkReadyQueuesCache(boolean refreshCache) {
        long readyQueuesCacheTimeoutInMs = this.parameterService.getLong("cache.ready.queue.time.ms", 5000L);
        if ((System.currentTimeMillis() - this.readyQueuesCacheTime >= readyQueuesCacheTimeoutInMs || this.readyQueuesCache == null || refreshCache) && this.cacheLock.tryAcquire()) {
            try {
                this.populateReadyQueuesCache(readyQueuesCacheTimeoutInMs);
                this.readyQueuesCacheTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.log.error("Failed to retrieve ready queues", (Throwable)e);
            }
            finally {
                this.cacheLock.release();
            }
        }
    }

    protected void populateReadyQueuesCache(long readyQueuesCacheTimeoutInMs) {
        Map<String, Channel> channelMap = this.configurationService.getChannels(false);
        long ts = System.currentTimeMillis();
        Map<String, ReadyChannels> readyChannelMap = this.outgoingBatchService.getReadyChannelsFromDb();
        HashMap<String, Collection<String>> readyQueueMap = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, ReadyChannels> entry : readyChannelMap.entrySet()) {
            String nodeId = entry.getKey();
            ReadyChannels readyChannels = entry.getValue();
            for (String channelId : readyChannels.getChannelIds()) {
                Channel channel = channelMap.get(channelId);
                if (channel == null) continue;
                HashSet<Object> readyQueues = (HashSet<Object>)readyQueueMap.get(nodeId);
                if (readyQueues == null) {
                    readyQueues = new HashSet<Object>();
                    readyQueueMap.put(nodeId, readyQueues);
                }
                if ("reload".equals(channel.getQueue()) && readyChannels.getThreadIdCount() > 0) {
                    for (Integer threadId : readyChannels.getThreadIds()) {
                        readyQueues.add(channel.getQueue() + "!" + threadId);
                    }
                    continue;
                }
                readyQueues.add(channel.getQueue());
            }
        }
        long queryTime = System.currentTimeMillis() - ts;
        if (queryTime > readyQueuesCacheTimeoutInMs) {
            this.log.warn("Query time of {} ms exceeded cache time of {} ms for ready queues.  This means the query may run on the database constantly.", (Object)queryTime, (Object)readyQueuesCacheTimeoutInMs);
        }
        this.readyQueuesCache = readyQueueMap;
    }
}

