/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.ISoftwareUpgradeListener;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.util.ModuleException;
import org.jumpmind.symmetric.util.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftwareUpgradeListener
implements ISoftwareUpgradeListener,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    private static final Logger log = LoggerFactory.getLogger(SoftwareUpgradeListener.class);
    ISymmetricEngine engine;

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public void upgrade(String databaseVersion, String softwareVersion) {
        if (databaseVersion.equals("3.8.0")) {
            log.info("Detected an original value of 3.8.0 performing necessary upgrades.");
            String sql = "update  " + this.engine.getParameterService().getTablePrefix() + "_channel set max_batch_size = 10000 where reload_flag = 1 and max_batch_size = 1";
            this.engine.getSqlTemplate().update(sql, new Object[0]);
        }
        if (Version.isOlderThanVersion(databaseVersion, "3.13.0") && this.engine.getParameterService().is("cluster.lock.enabled")) {
            this.engine.getNodeService().deleteNodeHost(this.engine.getNodeService().findIdentityNodeId());
        }
        try {
            ModuleManager.getInstance().upgradeAll();
        }
        catch (ModuleException e) {
            throw new RuntimeException(e);
        }
    }
}

