/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.file;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.symmetric.file.FileSyncZipScript;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;

public class BashFileSyncZipScript
extends FileSyncZipScript {
    @Override
    public String getScriptFileName(Batch batch) {
        return "sync.sh";
    }

    @Override
    public void buildScriptStart(Batch batch) {
        this.appendln("#!/bin/bash");
        this.appendln();
        this.appendln("batchDir=$1");
        this.appendln("sourceNodeId=$2");
        this.appendln("outputFileName=$3");
        this.appendln();
    }

    @Override
    public void buildScriptFileSnapshot(Batch batch, FileSnapshot snapshot, FileTriggerRouter triggerRouter, FileTrigger fileTrigger, File file, String targetBaseDir, String targetFile) {
        FileSnapshot.LastEventType eventType = snapshot.getLastEventType();
        this.appendln("processFile=true");
        this.appendln(String.format("sourceFileName=\"%s\"", snapshot.getFileName()));
        this.append("targetRelativeDir=\"");
        if (!snapshot.getRelativeDir().equals(".")) {
            this.append(StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir()));
        }
        this.appendln("\"");
        this.appendln("targetFileName=$sourceFileName");
        this.appendln(String.format("sourceFilePath=\"%s\"", StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir())));
        this.appendln(String.format("targetBaseDir=\"%s\"", targetBaseDir));
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getBeforeCopyScript())) {
            this.appendln(fileTrigger.getBeforeCopyScript());
        }
        this.appendln("if [ \"$processFile\" = true ] ; then ");
        this.appendln("  echo \"#Processing " + snapshot.getFileName() + "\" >> \"$outputFileName\"");
        switch (eventType) {
            case CREATE: 
            case MODIFY: {
                if (!file.exists()) break;
                this.appendln("  mkdir -p \"$targetBaseDir\"");
                this.append("  sourceFile=\"$batchDir/");
                if (!snapshot.getRelativeDir().equals(".")) {
                    this.append("$sourceFilePath/");
                }
                this.append("$sourceFileName");
                this.appendln("\"");
                this.appendln("targetFile=\"$targetBaseDir/$targetRelativeDir/$targetFileName\"");
                this.appendln("targetDir=\"$targetBaseDir/$targetRelativeDir\"");
                this.appendln("  if [ -d \"$targetFile\" ]; then");
                this.appendln("    processFile=false");
                this.appendln("  fi");
                this.appendln("  if [ \"$processFile\" = true ] ; then");
                this.appendln("      cp -a \"$sourceFile\" \"$targetDir\"");
                this.appendln("      echo \"$targetBaseDir/$targetRelativeDir/$targetFileName=" + eventType.getCode() + "\" >> $outputFileName");
                this.appendln("  fi ");
                break;
            }
            case DELETE: {
                this.appendln("  if [ \"$processFile\" = true ] ; then");
                this.appendln("      rm -rf \"$targetBaseDir/$targetRelativeDir/$targetFileName\"");
                this.appendln("      echo \"$targetBaseDir/$targetRelativeDir/$targetFileName=D\" >> $outputFileName");
                this.appendln("  fi ");
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getAfterCopyScript())) {
            this.appendln(fileTrigger.getAfterCopyScript());
        }
        this.appendln("fi\n");
    }

    @Override
    public void buildScriptEnd(Batch batch) {
    }
}

