/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.DbCompareConfig;
import org.jumpmind.symmetric.io.data.transform.ColumnPolicy;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.service.impl.TransformService;

public class DbCompareTables {
    private Table sourceTable;
    private Table targetTable;
    private TransformService.TransformTableNodeGroupLink transform;
    private Map<Column, Column> columnMapping = new LinkedHashMap<Column, Column>();

    public DbCompareTables(Table sourceTable, Table targetTable) {
        this.sourceTable = sourceTable;
        this.targetTable = targetTable;
    }

    public Map<Column, Column> getColumnMapping() {
        return this.columnMapping;
    }

    public void setColumnMapping(Map<Column, Column> columnMapping) {
        this.columnMapping = columnMapping;
    }

    public void addColumnMapping(Column sourceColumn, Column targetColumn) {
        this.columnMapping.put(sourceColumn, targetColumn);
    }

    public void applyColumnMappings() {
        this.columnMapping.clear();
        if (this.transform != null && !CollectionUtils.isEmpty((Collection)this.transform.getTransformColumns())) {
            this.applyColumnMappingsFromTransform();
        } else {
            this.applyColumnMappingsDefault();
        }
    }

    protected void applyColumnMappingsFromTransform() {
        for (Column sourceColumn : this.sourceTable.getColumns()) {
            List sourceTransformColumns = this.transform.getTransformColumnFor(sourceColumn.getName());
            if (!sourceTransformColumns.isEmpty()) {
                TransformColumn transformColumn = (TransformColumn)sourceTransformColumns.get(0);
                Column targetColumn = this.targetTable.getColumnWithName(transformColumn.getTargetColumnName());
                if (transformColumn.isPk()) {
                    sourceColumn.setPrimaryKey(true);
                }
                this.columnMapping.put(sourceColumn, targetColumn);
                continue;
            }
            if (this.transform.getColumnPolicy() == ColumnPolicy.SPECIFIED) {
                this.sourceTable.removeColumn(sourceColumn);
                continue;
            }
            this.mapColumnDefault(sourceColumn);
        }
    }

    protected void applyColumnMappingsDefault() {
        for (Column sourceColumn : this.sourceTable.getColumns()) {
            this.mapColumnDefault(sourceColumn);
        }
    }

    protected void mapColumnDefault(Column sourceColumn) {
        for (Column targetColumn : this.targetTable.getColumns()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)sourceColumn.getName(), (CharSequence)targetColumn.getName())) continue;
            this.columnMapping.put(sourceColumn, targetColumn);
        }
    }

    public TransformService.TransformTableNodeGroupLink getTransform() {
        return this.transform;
    }

    public void setTransform(TransformService.TransformTableNodeGroupLink transform) {
        this.transform = transform;
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public void setSourceTable(Table sourceTable) {
        this.sourceTable = sourceTable;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    public void filterExcludedColumns(DbCompareConfig config) {
        this.filterExcludedColumns(config, this.sourceTable);
        this.filterExcludedColumns(config, this.targetTable);
    }

    private void filterExcludedColumns(DbCompareConfig config, Table table) {
        for (Column column : table.getColumnsAsList()) {
            if (config.shouldIncludeColumn(table.getName(), column.getName())) continue;
            if (table.getPrimaryKeyColumnsAsList().contains(column)) {
                throw new SymmetricException("Invalid config - cannot exclude a primary key column: " + column + " (Table " + table + ")", new Object[0]);
            }
            table.removeColumn(column);
        }
    }
}

