/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import bsh.Interpreter;
import bsh.TargetError;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformColumnException;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BshColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    final String INTERPRETER_KEY = String.format("%d.BshInterpreter", this.hashCode());
    public static final String NAME = "bsh";
    IParameterService parameterService;
    private static Map<String, Object> bshContext = new HashMap<String, Object>();

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public String getName() {
        return NAME;
    }

    public boolean isExtractColumnTransform() {
        return true;
    }

    public boolean isLoadColumnTransform() {
        return true;
    }

    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        try {
            Interpreter interpreter = this.getInterpreter((Context)context);
            interpreter.set("currentValue", (Object)newValue);
            interpreter.set("oldValue", (Object)oldValue);
            interpreter.set("channelId", (Object)context.getBatch().getChannelId());
            interpreter.set("includeOn", (Object)column.getIncludeOn());
            interpreter.set("sourceDmlType", (Object)data.getSourceDmlType());
            interpreter.set("sourceDmlTypeString", (Object)data.getSourceDmlType().toString());
            interpreter.set("transformedData", (Object)data);
            interpreter.set("transformColumn", (Object)column);
            Data csvData = (Data)context.get("csvData");
            if (csvData != null && csvData.getTriggerHistory() != null) {
                interpreter.set("sourceSchemaName", (Object)csvData.getTriggerHistory().getSourceSchemaName());
                interpreter.set("sourceCatalogName", (Object)csvData.getTriggerHistory().getSourceCatalogName());
                interpreter.set("sourceTableName", (Object)csvData.getTriggerHistory().getSourceTableName());
            }
            for (String columnName : sourceValues.keySet()) {
                interpreter.set(columnName.toUpperCase(), (Object)sourceValues.get(columnName));
            }
            String transformExpression = column.getTransformExpression();
            if (StringUtils.isEmpty((CharSequence)transformExpression)) {
                throw new SymmetricException("transformExpression cannot be empty. Check configuration for transform '" + column.getTransformId() + "'", new Object[0]);
            }
            String globalScript = this.parameterService.getString("bsh.transform.global.script");
            String methodName = String.format("transform_%d()", Math.abs(transformExpression.hashCode() + (globalScript == null ? 0 : globalScript.hashCode())));
            if (context.get(methodName) == null) {
                interpreter.set("log", (Object)this.log);
                interpreter.set("sqlTemplate", (Object)platform.getSqlTemplate());
                interpreter.set("context", (Object)context);
                interpreter.set("bshContext", bshContext);
                interpreter.set("engine", context.get("engine"));
                interpreter.set("targetNode", context.get("targetNode"));
                interpreter.set("targetNodeId", context.get("targetNodeId"));
                interpreter.set("targetNodeGroupId", context.get("targetNodeGroupId"));
                interpreter.set("targetNodeExternalId", context.get("targetNodeExternalId"));
                interpreter.set("sourceNode", context.get("sourceNode"));
                interpreter.set("sourceNodeId", context.get("sourceNodeId"));
                interpreter.set("sourceNodeGroupId", context.get("sourceNodeGroupId"));
                interpreter.set("sourceNodeExternalId", context.get("sourceNodeExternalId"));
                if (StringUtils.isNotBlank((CharSequence)globalScript)) {
                    interpreter.eval(globalScript);
                }
                interpreter.eval(String.format("%s {\n%s\n}", methodName, transformExpression));
                context.put(methodName, (Object)Boolean.TRUE);
            }
            Object result = interpreter.eval(methodName);
            if (csvData != null && csvData.getTriggerHistory() != null) {
                interpreter.unset("sourceSchemaName");
                interpreter.unset("sourceCatalogName");
                interpreter.unset("sourceTableName");
            }
            for (String columnName : sourceValues.keySet()) {
                interpreter.unset(columnName.toUpperCase());
            }
            if (result instanceof String) {
                if (data.getTargetDmlType().equals((Object)DataEventType.DELETE) && data.getOldSourceValues() != null) {
                    return new NewAndOldValue(null, (String)result);
                }
                return new NewAndOldValue((String)result, null);
            }
            if (result instanceof NewAndOldValue) {
                return (NewAndOldValue)result;
            }
            if (result != null) {
                return new NewAndOldValue(result.toString(), null);
            }
            return null;
        }
        catch (TargetError evalEx) {
            Throwable ex = evalEx.getTarget();
            if (ex instanceof IgnoreColumnException) {
                throw (IgnoreColumnException)ex;
            }
            if (ex instanceof IgnoreRowException) {
                throw (IgnoreRowException)ex;
            }
            throw new TransformColumnException(String.format("Beanshell script error on line %d for target column %s on transform %s", evalEx.getErrorLineNumber(), column.getTargetColumnName(), column.getTransformId()), ex);
        }
        catch (Exception ex) {
            if (ex instanceof IgnoreColumnException) {
                throw (IgnoreColumnException)ex;
            }
            if (ex instanceof IgnoreRowException) {
                throw (IgnoreRowException)ex;
            }
            this.log.error(String.format("Beanshell script error for target column %s on transform %s", column.getTargetColumnName(), column.getTransformId()), (Throwable)ex);
            throw new TransformColumnException((Throwable)ex);
        }
    }

    protected Interpreter getInterpreter(Context context) {
        Interpreter interpreter = (Interpreter)context.get(this.INTERPRETER_KEY);
        if (interpreter == null) {
            interpreter = new Interpreter();
            context.put(this.INTERPRETER_KEY, (Object)interpreter);
        }
        return interpreter;
    }
}

