/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.symmetric.service.IParameterService;

public class ParameterColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "parameter";
    IParameterService parameterService;

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public String getName() {
        return NAME;
    }

    public boolean isExtractColumnTransform() {
        return true;
    }

    public boolean isLoadColumnTransform() {
        return true;
    }

    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String paramName = column.getTransformExpression();
        String value = null;
        if (paramName != null) {
            value = this.parameterService.getString(paramName);
        }
        return new NewAndOldValue(column, data, value);
    }
}

