/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.IOfflineServerListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOfflineServerListener
implements IOfflineServerListener,
IBuiltInExtensionPoint {
    private static final Logger log = LoggerFactory.getLogger(DefaultOfflineServerListener.class);
    protected IStatisticManager statisticManager;
    protected INodeService nodeService;
    protected IOutgoingBatchService outgoingBatchService;

    public DefaultOfflineServerListener(IStatisticManager statisticManager, INodeService nodeService, IOutgoingBatchService outgoingBatchService) {
        this.statisticManager = statisticManager;
        this.nodeService = nodeService;
        this.outgoingBatchService = outgoingBatchService;
    }

    @Override
    public void clientNodeOffline(Node node) {
        log.warn("The '{}' node is offline.  Syncing will be disabled and node security deleted", new Object[]{node.getNodeId()});
        this.statisticManager.incrementNodesDisabled(1L);
        node.setSyncEnabled(false);
        this.nodeService.save(node);
        this.outgoingBatchService.markAllAsSentForNode(node.getNodeId(), true);
        this.nodeService.deleteNodeSecurity(node.getNodeId());
        this.nodeService.deleteNodeHost(node.getNodeId());
    }
}

