/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.load.BshDatabaseWriterFilter;
import org.jumpmind.symmetric.load.JavaDatabaseWriterFilter;
import org.jumpmind.symmetric.load.SQLDatabaseWriterFilter;
import org.jumpmind.symmetric.model.LoadFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicDatabaseWriterFilter
implements IDatabaseWriterFilter,
IDatabaseWriterErrorHandler,
IBuiltInExtensionPoint {
    private final String BATCH_COMPLETE_SCRIPTS_KEY = String.format("%d.BatchCompleteScripts", this.hashCode());
    private final String BATCH_COMMIT_SCRIPTS_KEY = String.format("%d.BatchCommitScripts", this.hashCode());
    private final String BATCH_ROLLBACK_SCRIPTS_KEY = String.format("%d.BatchRollbackScripts", this.hashCode());
    private final String FAIL_ON_ERROR_KEY = String.format("%d.FailOnError", this.hashCode());
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine = null;
    protected Map<String, List<LoadFilter>> loadFilters = null;

    public DynamicDatabaseWriterFilter(ISymmetricEngine engine, Map<String, List<LoadFilter>> loadFilters) {
        this.engine = engine;
        this.loadFilters = loadFilters;
    }

    public static List<DynamicDatabaseWriterFilter> getDatabaseWriterFilters(ISymmetricEngine engine, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>> loadFilters) {
        ArrayList<DynamicDatabaseWriterFilter> databaseWriterFilters = new ArrayList<DynamicDatabaseWriterFilter>();
        if (loadFilters != null) {
            for (Map.Entry<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>> entry : loadFilters.entrySet()) {
                if (entry.getKey().equals((Object)LoadFilter.LoadFilterType.BSH)) {
                    databaseWriterFilters.add(new BshDatabaseWriterFilter(engine, entry.getValue()));
                    continue;
                }
                if (entry.getKey().equals((Object)LoadFilter.LoadFilterType.JAVA)) {
                    databaseWriterFilters.add(new JavaDatabaseWriterFilter(engine, entry.getValue()));
                    continue;
                }
                if (!entry.getKey().equals((Object)LoadFilter.LoadFilterType.SQL)) continue;
                databaseWriterFilters.add(new SQLDatabaseWriterFilter(engine, entry.getValue()));
            }
        }
        return databaseWriterFilters;
    }

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        return this.processLoadFilters(context, table, data, null, WriteMethod.BEFORE_WRITE);
    }

    public void afterWrite(DataContext context, Table table, CsvData data) {
        this.processLoadFilters(context, table, data, null, WriteMethod.AFTER_WRITE);
    }

    public boolean handleError(DataContext context, Table table, CsvData data, Exception error) {
        return this.processLoadFilters(context, table, data, error, WriteMethod.HANDLE_ERROR);
    }

    public void earlyCommit(DataContext context) {
    }

    public void batchComplete(DataContext context) {
        this.executeScripts(context, this.BATCH_COMPLETE_SCRIPTS_KEY);
    }

    public void batchCommitted(DataContext context) {
        this.executeScripts(context, this.BATCH_COMMIT_SCRIPTS_KEY);
    }

    public void batchRolledback(DataContext context) {
        this.executeScripts(context, this.BATCH_ROLLBACK_SCRIPTS_KEY);
    }

    protected boolean processLoadFilters(DataContext context, Table table, CsvData data, Exception error, WriteMethod writeMethod) {
        boolean writeRow = true;
        if (table != null) {
            List<LoadFilter> foundFilters = null;
            if (!table.getName().toLowerCase().startsWith(this.engine.getTablePrefix() + "_")) {
                foundFilters = this.lookupFilters(foundFilters, table.getCatalog(), table.getSchema(), "*");
                foundFilters = this.lookupFilters(foundFilters, table.getCatalog(), "*", "*");
                foundFilters = this.lookupFilters(foundFilters, "*", table.getSchema(), "*");
                foundFilters = this.lookupFilters(foundFilters, "*", "*", "*");
            }
            foundFilters = this.lookupFilters(foundFilters, "*", "*", table.getName());
            foundFilters = this.lookupFilters(foundFilters, "*", table.getSchema(), table.getName());
            foundFilters = this.lookupFilters(foundFilters, table.getCatalog(), "*", table.getName());
            if ((foundFilters = this.lookupFilters(foundFilters, table.getCatalog(), table.getSchema(), table.getName())) != null) {
                for (LoadFilter filter : foundFilters) {
                    this.addBatchScriptsToContext(context, filter);
                }
                writeRow = this.processLoadFilters(context, table, data, error, writeMethod, foundFilters);
            }
        }
        return writeRow;
    }

    private List<LoadFilter> lookupFilters(List<LoadFilter> foundFilters, String catalogName, String schemaName, String tableName) {
        List<LoadFilter> filters;
        String fullyQualifiedTableName = Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName);
        if (this.isIgnoreCase()) {
            fullyQualifiedTableName = fullyQualifiedTableName.toUpperCase();
        }
        if ((filters = this.loadFilters.get(fullyQualifiedTableName)) != null) {
            if (foundFilters == null) {
                foundFilters = new ArrayList<LoadFilter>();
            }
            foundFilters.addAll(filters);
        }
        return foundFilters;
    }

    protected abstract boolean processLoadFilters(DataContext var1, Table var2, CsvData var3, Exception var4, WriteMethod var5, List<LoadFilter> var6);

    protected void addBatchScriptsToContext(DataContext context, LoadFilter filter) {
        this.addBatchScriptToContext(context, this.BATCH_COMPLETE_SCRIPTS_KEY, filter.getBatchCompleteScript());
        this.addBatchScriptToContext(context, this.BATCH_COMMIT_SCRIPTS_KEY, filter.getBatchCommitScript());
        this.addBatchScriptToContext(context, this.BATCH_ROLLBACK_SCRIPTS_KEY, filter.getBatchRollbackScript());
        if (filter.isFailOnError()) {
            context.put(this.FAIL_ON_ERROR_KEY, (Object)Boolean.TRUE);
        }
    }

    protected void addBatchScriptToContext(DataContext context, String key, String script) {
        if (StringUtils.isNotBlank((CharSequence)script)) {
            HashSet<String> scripts = (HashSet<String>)context.get(key);
            if (scripts == null) {
                scripts = new HashSet<String>();
                context.put(key, scripts);
            }
            scripts.add(script);
        }
    }

    protected void executeScripts(DataContext context, String key) {
        Set scripts = (Set)context.get(key);
        this.executeScripts(context, key, scripts, BooleanUtils.isTrue((Boolean)((Boolean)context.get(this.FAIL_ON_ERROR_KEY))));
    }

    protected abstract void executeScripts(DataContext var1, String var2, Set<String> var3, boolean var4);

    protected boolean isIgnoreCase() {
        return this.engine.getParameterService().is("db.metadata.ignore.case");
    }

    public boolean handlesMissingTable(DataContext context, Table table) {
        if (this.engine != null && this.engine.getParameterService() != null && this.engine.getParameterService().is("bsh.load.filter.handles.missing.tables")) {
            return true;
        }
        String tableName = table.getFullyQualifiedTableName();
        if (this.isIgnoreCase()) {
            tableName = tableName.toUpperCase();
        }
        return this.loadFilters.containsKey(tableName);
    }

    public static enum WriteMethod {
        BEFORE_WRITE,
        AFTER_WRITE,
        BATCH_COMPLETE,
        BATCH_COMMIT,
        BATCH_ROLLBACK,
        HANDLE_ERROR;

    }
}

