/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import bsh.TargetError;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.load.DynamicDatabaseWriterFilter;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.LoadFilter;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.LinkedCaseInsensitiveMap;

public class SQLDatabaseWriterFilter
extends DynamicDatabaseWriterFilter {
    protected static final ISqlRowMapper<Boolean> lookupColumnRowMapper = new ISqlRowMapper<Boolean>(){

        public Boolean mapRow(Row row) {
            boolean result = false;
            Iterator i = row.values().iterator();
            if (i.hasNext()) {
                Object val = i.next();
                if (val instanceof Boolean) {
                    result = (Boolean)val;
                } else if (val instanceof Number) {
                    result = ((Number)val).intValue() > 0;
                } else if (val instanceof String) {
                    result = !((String)val).equals("0") && !((String)val).equalsIgnoreCase("false");
                }
            }
            return result;
        }
    };
    private static final String OLD_ = "OLD_";

    public SQLDatabaseWriterFilter(ISymmetricEngine engine, Map<String, List<LoadFilter>> loadFilters) {
        super(engine, loadFilters);
    }

    @Override
    protected boolean processLoadFilters(DataContext context, Table table, CsvData data, Exception error, DynamicDatabaseWriterFilter.WriteMethod writeMethod, List<LoadFilter> loadFiltersForTable) {
        boolean writeRow = true;
        LoadFilter currentFilter = null;
        List values = null;
        try {
            LinkedCaseInsensitiveMap<Object> namedParams = null;
            Iterator<LoadFilter> iterator = loadFiltersForTable.iterator();
            while (iterator.hasNext()) {
                LoadFilter filter;
                currentFilter = filter = iterator.next();
                values = null;
                if (!(filter.isFilterOnDelete() && data.getDataEventType().equals((Object)DataEventType.DELETE) || filter.isFilterOnInsert() && data.getDataEventType().equals((Object)DataEventType.INSERT)) && (!filter.isFilterOnUpdate() || !data.getDataEventType().equals((Object)DataEventType.UPDATE))) continue;
                String sql = null;
                if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.BEFORE_WRITE) && filter.getBeforeWriteScript() != null) {
                    sql = this.doTokenReplacementOnSql(context, filter.getBeforeWriteScript());
                } else if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.AFTER_WRITE) && filter.getAfterWriteScript() != null) {
                    sql = this.doTokenReplacementOnSql(context, filter.getAfterWriteScript());
                } else if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.HANDLE_ERROR) && filter.getHandleErrorScript() != null) {
                    sql = this.doTokenReplacementOnSql(context, filter.getHandleErrorScript());
                }
                if (sql != null && !sql.trim().isEmpty()) {
                    if (namedParams == null) {
                        namedParams = this.getVariablesMap(table, data);
                    }
                    ISqlTransaction transaction = context.findTransaction();
                    values = transaction.query(sql, lookupColumnRowMapper, namedParams);
                }
                if (values == null || values.size() <= 0) continue;
                writeRow = (Boolean)values.get(0);
            }
        }
        catch (Exception ex) {
            this.processError(currentFilter, table, ex);
        }
        return writeRow;
    }

    private LinkedCaseInsensitiveMap<Object> getVariablesMap(Table table, CsvData data) {
        LinkedCaseInsensitiveMap namedParams = new LinkedCaseInsensitiveMap();
        if (data != null) {
            Map sourceValues = data.toColumnNameValuePairs(table.getColumnNames(), "rowData");
            if (sourceValues.size() > 0) {
                for (String columnName : sourceValues.keySet()) {
                    namedParams.put(columnName, sourceValues.get(columnName));
                    namedParams.put(columnName.toUpperCase(), sourceValues.get(columnName));
                }
            } else {
                Map pkValues = data.toColumnNameValuePairs(table.getPrimaryKeyColumnNames(), "pkData");
                for (String columnName : pkValues.keySet()) {
                    namedParams.put(columnName, pkValues.get(columnName));
                    namedParams.put(columnName.toUpperCase(), pkValues.get(columnName));
                }
            }
            Map oldValues = data.toColumnNameValuePairs(table.getColumnNames(), "oldData");
            for (String columnName : oldValues.keySet()) {
                namedParams.put(OLD_ + columnName, oldValues.get(columnName));
                namedParams.put(OLD_ + columnName.toUpperCase(), oldValues.get(columnName));
            }
        }
        return namedParams;
    }

    @Override
    protected void executeScripts(DataContext context, String key, Set<String> scripts, boolean isFailOnError) {
        if (scripts != null) {
            try {
                ISqlTransaction transaction = context.findTransaction();
                for (String script : scripts) {
                    String sql = this.doTokenReplacementOnSql(context, script);
                    transaction.query(sql, lookupColumnRowMapper, null);
                }
            }
            catch (Exception e) {
                if (isFailOnError) {
                    throw (RuntimeException)e;
                }
                this.log.error("Failed while executing sql script", (Throwable)e);
            }
        }
    }

    protected String doTokenReplacementOnSql(DataContext context, String sql) {
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            Data csvData = (Data)context.get("csvData");
            if (csvData != null && csvData.getTriggerHistory() != null) {
                sql = FormatUtils.replaceToken((String)sql, (String)"sourceCatalogName", (String)csvData.getTriggerHistory().getSourceCatalogName(), (boolean)true);
            }
            if (csvData != null && csvData.getTriggerHistory() != null) {
                sql = FormatUtils.replaceToken((String)sql, (String)"sourceSchemaName", (String)csvData.getTriggerHistory().getSourceSchemaName(), (boolean)true);
            }
        }
        return sql;
    }

    protected void processError(LoadFilter currentFilter, Table table, Throwable ex) {
        if (ex instanceof TargetError) {
            ex = ((TargetError)ex).getTarget();
        }
        String formattedMessage = String.format("Error executing sql script for load filter %s on table %s. The error was: %s", currentFilter != null ? currentFilter.getLoadFilterId() : "N/A", table.getName(), ex.getMessage());
        this.log.error(formattedMessage);
        if (currentFilter.isFailOnError()) {
            throw new SymmetricException(formattedMessage, ex);
        }
    }
}

