/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import org.jumpmind.symmetric.model.ProcessType;

public class ProcessInfoKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sourceNodeId;
    private String targetNodeId;
    private ProcessType processType;
    private String queue;

    public ProcessInfoKey(String sourceNodeId, String targetNodeId, ProcessType processType) {
        this.sourceNodeId = sourceNodeId;
        this.targetNodeId = targetNodeId;
        this.processType = processType;
        this.queue = null;
    }

    public ProcessInfoKey(String sourceNodeId, String queue, String targetNodeId, ProcessType processType) {
        this.sourceNodeId = sourceNodeId;
        this.targetNodeId = targetNodeId;
        this.processType = processType;
        this.queue = queue;
    }

    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public ProcessType getProcessType() {
        return this.processType;
    }

    public String getQueue() {
        return this.queue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.processType == null ? 0 : this.processType.hashCode());
        result = 31 * result + (this.sourceNodeId == null ? 0 : this.sourceNodeId.hashCode());
        result = 31 * result + (this.targetNodeId == null ? 0 : this.targetNodeId.hashCode());
        result = 31 * result + (this.queue == null ? 0 : this.queue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInfoKey other = (ProcessInfoKey)obj;
        if (this.processType != other.processType) {
            return false;
        }
        if (this.sourceNodeId == null ? other.sourceNodeId != null : !this.sourceNodeId.equals(other.sourceNodeId)) {
            return false;
        }
        if (this.targetNodeId == null ? other.targetNodeId != null : !this.targetNodeId.equals(other.targetNodeId)) {
            return false;
        }
        return !(this.queue == null ? other.queue != null : !this.queue.equals(other.queue));
    }

    public String toString() {
        return String.format("processType=%s,sourceNodeId=%s,targetNodeId=%s,queue=%s", this.processType.toString(), this.sourceNodeId, this.targetNodeId, this.queue);
    }
}

