/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.ConfigurationChangedHelper;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.NetworkedNode;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.ITriggerRouterService;

public class ConfigurationChangedDataRouter
extends AbstractDataRouter
implements IDataRouter,
IBuiltInExtensionPoint {
    public static final String ROUTER_TYPE = "configurationChanged";
    protected ISymmetricEngine engine;
    private ConfigurationChangedHelper helper;

    public ConfigurationChangedDataRouter(ISymmetricEngine engine) {
        this.engine = engine;
        this.helper = new ConfigurationChangedHelper(engine);
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext routingContext, DataMetaData dataMetaData, Set<Node> possibleTargetNodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        if (this.helper.isNewContext(routingContext)) {
            this.helper.setSyncTriggersAllowed(routingContext, this.engine.getParameterService().is("auto.sync.triggers") && this.engine.getParameterService().is("auto.sync.triggers.after.config.change"));
        }
        this.helper.handleChange(routingContext, dataMetaData.getTable(), dataMetaData.getData());
        HashSet<String> nodeIds = new HashSet<String>();
        Map<String, String> columnValues = this.getDataMap(dataMetaData, this.engine != null ? this.engine.getSymmetricDialect() : null);
        possibleTargetNodes = this.helper.filterNodes(possibleTargetNodes, dataMetaData.getTable().getNameLowerCase(), columnValues);
        Node me = this.findIdentity();
        if (me != null) {
            NetworkedNode rootNetworkedNode = this.getRootNetworkNodeFromContext(routingContext);
            if (this.tableMatches(dataMetaData, "node") && dataMetaData.getData().getDataEventType() == DataEventType.SQL) {
                if (dataMetaData.getData().getParsedData("rowData").length > 1 && dataMetaData.getData().getParsedData("rowData")[0].toUpperCase().contains("TABLE")) {
                    this.helper.setSyncTriggersNeeded(routingContext);
                }
                IConfigurationService configurationService = this.engine.getConfigurationService();
                for (Node routeToNode : possibleTargetNodes) {
                    if (!this.notRestClient(routeToNode)) continue;
                    NodeGroupLink link = configurationService.getNodeGroupLinkFor(me.getNodeGroupId(), routeToNode.getNodeGroupId(), false);
                    if (!initialLoad && (link == null || !link.isSyncSqlEnabled())) continue;
                    nodeIds.add(routeToNode.getNodeId());
                }
            } else if (this.tableMatches(dataMetaData, "node") || this.tableMatches(dataMetaData, "node_security") || this.tableMatches(dataMetaData, "node_host") || this.tableMatches(dataMetaData, "monitor_event")) {
                this.routeNodeTables(nodeIds, columnValues, rootNetworkedNode, me, routingContext, dataMetaData, possibleTargetNodes, initialLoad);
            } else if (this.tableMatches(dataMetaData, "table_reload_request") || this.tableMatches(dataMetaData, "table_reload_status") || this.tableMatches(dataMetaData, "compare_request") || this.tableMatches(dataMetaData, "compare_status") || this.tableMatches(dataMetaData, "compare_table_status")) {
                String sourceNodeId = columnValues.get("SOURCE_NODE_ID");
                String targetNodeId = columnValues.get("TARGET_NODE_ID");
                for (Node nodeThatMayBeRoutedTo : possibleTargetNodes) {
                    if (!this.notRestClient(nodeThatMayBeRoutedTo) || !nodeThatMayBeRoutedTo.getNodeId().equals(sourceNodeId) && !nodeThatMayBeRoutedTo.getNodeId().equals(targetNodeId)) continue;
                    nodeIds.add(nodeThatMayBeRoutedTo.getNodeId());
                }
            } else if (this.tableMatches(dataMetaData, "extract_request") || this.tableMatches(dataMetaData, "outgoing_error") || this.tableMatches(dataMetaData, "incoming_error")) {
                String targetNodeId = columnValues.get("NODE_ID");
                for (Node nodeThatMayBeRoutedTo : possibleTargetNodes) {
                    if (!this.notRestClient(nodeThatMayBeRoutedTo) || !nodeThatMayBeRoutedTo.getNodeId().equals(targetNodeId)) continue;
                    nodeIds.add(nodeThatMayBeRoutedTo.getNodeId());
                }
            } else {
                IConfigurationService configurationService = this.engine.getConfigurationService();
                for (Node nodeThatMayBeRoutedTo : possibleTargetNodes) {
                    if (!this.notRestClient(nodeThatMayBeRoutedTo) || !initialLoad && this.isSameNumberOfLinksAwayFromRoot(nodeThatMayBeRoutedTo, rootNetworkedNode, me)) continue;
                    NodeGroupLink link = configurationService.getNodeGroupLinkFor(me.getNodeGroupId(), nodeThatMayBeRoutedTo.getNodeGroupId(), false);
                    if (!initialLoad && (link == null || !link.isSyncConfigEnabled())) continue;
                    nodeIds.add(nodeThatMayBeRoutedTo.getNodeId());
                }
                if (this.tableMatches(dataMetaData, "node_group_link") && dataMetaData.getData().getDataEventType() == DataEventType.INSERT && !initialLoad && !this.isConfigDataMetaDataAlreadyHandled(dataMetaData, routingContext)) {
                    this.buildReloadEvents(dataMetaData, columnValues);
                    this.addConfigDataMetaData(dataMetaData, routingContext);
                }
            }
        }
        return nodeIds;
    }

    private boolean isConfigDataMetaDataAlreadyHandled(DataMetaData dataMetaData, SimpleRouterContext routingContext) {
        ChannelRouterContext channelRoutingContext;
        boolean ret = false;
        if (routingContext instanceof ChannelRouterContext && (channelRoutingContext = (ChannelRouterContext)routingContext).getConfigDataMetaData(dataMetaData.getData().getDataId()) != null) {
            ret = true;
        }
        return ret;
    }

    private void addConfigDataMetaData(DataMetaData dataMetaData, SimpleRouterContext routingContext) {
        if (routingContext instanceof ChannelRouterContext) {
            ChannelRouterContext channelRoutingContext = (ChannelRouterContext)routingContext;
            channelRoutingContext.addConfigDataMetaData(dataMetaData);
        }
    }

    private void buildReloadEvents(DataMetaData dataMetaData, Map<String, String> columnValues) {
        String symTablePrefix = this.engine.getTablePrefix();
        String tableName = dataMetaData.getTable().getName();
        if (TableConstants.getTableName(symTablePrefix, "node_group_link").equalsIgnoreCase(tableName) && this.engine.getParameterService().isRegistrationServer() && dataMetaData.getData().getDataEventType() == DataEventType.INSERT) {
            String initialLoadSelect;
            Node me = this.engine.getNodeService().findIdentity();
            String targetNodeGroupId = columnValues.get("TARGET_NODE_GROUP_ID");
            String sourceNodeGroupId = columnValues.get("SOURCE_NODE_GROUP_ID");
            this.log.info("Inserting reload events for sym_node and sym_node_security for source_node_group_id=" + sourceNodeGroupId + " and target_node_group_id=" + targetNodeGroupId);
            Collection<Node> targetNodes = this.engine.getNodeService().findEnabledNodesFromNodeGroup(targetNodeGroupId);
            Collection<Node> sourceNodes = this.engine.getNodeService().findEnabledNodesFromNodeGroup(sourceNodeGroupId);
            NodeGroupLink nodeGroupLink = new NodeGroupLink(sourceNodeGroupId, targetNodeGroupId);
            Date createTime = new Date();
            List<TriggerRouter> triggerRouterList = this.engine.getTriggerRouterService().buildTriggerRoutersForSymmetricTables(Version.version(), nodeGroupLink, new String[0]);
            TriggerRouter triggerRouter = this.findTriggerRouter(triggerRouterList, "node", symTablePrefix);
            if (triggerRouter != null) {
                initialLoadSelect = String.format(this.engine.getDataService().findNodeIdsByNodeGroupId(), "'" + sourceNodeGroupId + "'");
                this.insertReloadEvents(triggerRouter, initialLoadSelect, sourceNodeGroupId, targetNodeGroupId, createTime, me, targetNodes);
                initialLoadSelect = String.format(this.engine.getDataService().findNodeIdsByNodeGroupId(), "'" + targetNodeGroupId + "'");
                this.insertReloadEvents(triggerRouter, initialLoadSelect, sourceNodeGroupId, targetNodeGroupId, createTime, me, sourceNodes);
            }
            if ((triggerRouter = this.findTriggerRouter(triggerRouterList, "node_security", symTablePrefix)) != null) {
                initialLoadSelect = String.format(this.engine.getDataService().findNodeIdsByNodeGroupId(), "'" + sourceNodeGroupId + "'");
                this.insertReloadEvents(triggerRouter, initialLoadSelect, sourceNodeGroupId, targetNodeGroupId, createTime, me, targetNodes);
                initialLoadSelect = String.format(this.engine.getDataService().findNodeIdsByNodeGroupId(), "'" + targetNodeGroupId + "'");
                this.insertReloadEvents(triggerRouter, initialLoadSelect, sourceNodeGroupId, targetNodeGroupId, createTime, me, sourceNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertReloadEvents(TriggerRouter triggerRouter, String initialLoadSelect, String sourceNodeGroupId, String targetNodeGroupId, Date createTime, Node me, Collection<Node> targetNodes) {
        IDataService dataService = this.engine.getDataService();
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        List<TriggerHistory> triggerHistories = triggerRouterService.getActiveTriggerHistories(triggerRouter.getTrigger());
        if (triggerHistories.size() > 0) {
            TriggerHistory triggerHistory = triggerHistories.get(0);
            try (ISqlTransaction transaction = null;){
                transaction = this.engine.getDatabasePlatform().getSqlTemplate().startSqlTransaction();
                for (Node targetNode : targetNodes) {
                    if (me.getNodeId().equalsIgnoreCase(targetNode.getNodeId()) || !this.notRestClient(targetNode)) continue;
                    dataService.insertReloadEvent(transaction, targetNode, triggerRouter, triggerHistory, initialLoadSelect, false, -1L, "configRouter", AbstractBatch.Status.NE, 0L);
                }
                transaction.commit();
            }
        }
    }

    private TriggerRouter findTriggerRouter(List<TriggerRouter> triggerRouters, String tableName, String symTablePrefix) {
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (!TableConstants.getTableName(symTablePrefix, tableName).equalsIgnoreCase(triggerRouter.getTrigger().getSourceTableName())) continue;
            return triggerRouter;
        }
        return null;
    }

    protected void routeNodeTables(Set<String> nodeIds, Map<String, String> columnValues, NetworkedNode rootNetworkedNode, Node me, SimpleRouterContext routingContext, DataMetaData dataMetaData, Set<Node> possibleTargetNodes, boolean initialLoad) {
        String nodeIdForRecordBeingRouted = columnValues.get("NODE_ID");
        if (dataMetaData.getData().getDataEventType() == DataEventType.DELETE) {
            String createAtNodeId = columnValues.get("CREATED_AT_NODE_ID");
            for (Node nodeThatMayBeRoutedTo : possibleTargetNodes) {
                if (!this.notRestClient(nodeThatMayBeRoutedTo) || nodeIdForRecordBeingRouted.equals(nodeThatMayBeRoutedTo.getNodeId()) || nodeThatMayBeRoutedTo.getNodeId().equals(createAtNodeId) || nodeIdForRecordBeingRouted.equals(me.getNodeId()) || nodeThatMayBeRoutedTo.getCreatedAtNodeId() != null && nodeThatMayBeRoutedTo.getCreatedAtNodeId().equals(nodeIdForRecordBeingRouted)) continue;
                nodeIds.add(nodeThatMayBeRoutedTo.getNodeId());
            }
        } else {
            IConfigurationService configurationService = this.engine.getConfigurationService();
            List<NodeGroupLink> nodeGroupLinks = this.getNodeGroupLinksFromContext(routingContext);
            for (Node nodeThatMayBeRoutedTo : possibleTargetNodes) {
                if ((!this.notRestClient(nodeThatMayBeRoutedTo) || !this.isLinked(nodeIdForRecordBeingRouted, nodeThatMayBeRoutedTo, rootNetworkedNode, me, nodeGroupLinks) || this.isSameNumberOfLinksAwayFromRoot(nodeThatMayBeRoutedTo, rootNetworkedNode, me) && !configurationService.isMasterToMaster()) && (!nodeThatMayBeRoutedTo.getNodeId().equals(me.getNodeId()) || !initialLoad)) continue;
                nodeIds.add(nodeThatMayBeRoutedTo.getNodeId());
            }
            if (!initialLoad && nodeIds != null && dataMetaData.getData().getDataEventType() == DataEventType.INSERT) {
                nodeIds.remove(nodeIdForRecordBeingRouted);
            }
        }
    }

    protected Node findIdentity() {
        return this.engine.getNodeService().findIdentity();
    }

    protected List<NodeGroupLink> getNodeGroupLinksFromContext(SimpleRouterContext routingContext) {
        List<NodeGroupLink> list = (List<NodeGroupLink>)routingContext.get(NodeGroupLink.class.getName());
        if (list == null) {
            list = this.engine.getConfigurationService().getNodeGroupLinks(false);
            routingContext.put(NodeGroupLink.class.getName(), list);
        }
        return list;
    }

    protected NetworkedNode getRootNetworkNodeFromContext(SimpleRouterContext routingContext) {
        NetworkedNode root = (NetworkedNode)routingContext.get(NetworkedNode.class.getName());
        if (root == null) {
            root = this.engine.getNodeService().getRootNetworkedNode();
            routingContext.put(NetworkedNode.class.getName(), root);
        }
        return root;
    }

    private boolean isSameNumberOfLinksAwayFromRoot(Node nodeThatCouldBeRoutedTo, NetworkedNode root, Node me) {
        return me != null && root != null && root.getNumberOfLinksAwayFromRoot(nodeThatCouldBeRoutedTo.getNodeId()) == root.getNumberOfLinksAwayFromRoot(me.getNodeId());
    }

    private boolean isLinked(String nodeIdInQuestion, Node nodeThatCouldBeRoutedTo, NetworkedNode root, Node me, List<NodeGroupLink> allLinks) {
        if (root != null) {
            if (nodeIdInQuestion != null && nodeThatCouldBeRoutedTo != null && !nodeIdInQuestion.equals(nodeThatCouldBeRoutedTo.getNodeId())) {
                NetworkedNode networkedNodeInQuestion = root.findNetworkedNode(nodeIdInQuestion);
                NetworkedNode networkedNodeThatCouldBeRoutedTo = root.findNetworkedNode(nodeThatCouldBeRoutedTo.getNodeId());
                if (networkedNodeInQuestion != null) {
                    if (networkedNodeInQuestion.isInParentHierarchy(nodeThatCouldBeRoutedTo.getNodeId())) {
                        return true;
                    }
                    if (networkedNodeInQuestion.isInChildHierarchy(nodeThatCouldBeRoutedTo.getNodeId())) {
                        return true;
                    }
                    String createdAtNodeId = networkedNodeInQuestion.getNode().getCreatedAtNodeId();
                    if (createdAtNodeId != null && !createdAtNodeId.equals(me.getNodeId()) && !networkedNodeInQuestion.getNode().getNodeId().equals(me.getNodeId())) {
                        if (createdAtNodeId.equals(nodeThatCouldBeRoutedTo.getNodeId())) {
                            return true;
                        }
                        if (networkedNodeThatCouldBeRoutedTo != null) {
                            return networkedNodeThatCouldBeRoutedTo.isInChildHierarchy(createdAtNodeId);
                        }
                    }
                    String groupId = networkedNodeInQuestion.getNode().getNodeGroupId();
                    HashSet<String> groupsThatWillBeInterested = new HashSet<String>();
                    for (NodeGroupLink nodeGroupLink : allLinks) {
                        if (nodeGroupLink.getTargetNodeGroupId().equals(groupId)) {
                            groupsThatWillBeInterested.add(nodeGroupLink.getSourceNodeGroupId());
                            continue;
                        }
                        if (!nodeGroupLink.getSourceNodeGroupId().equals(groupId)) continue;
                        groupsThatWillBeInterested.add(nodeGroupLink.getTargetNodeGroupId());
                    }
                    return groupsThatWillBeInterested.contains(nodeThatCouldBeRoutedTo.getNodeGroupId());
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void contextCommitted(SimpleRouterContext routingContext) {
        this.helper.contextCommittedAndComplete(routingContext);
    }

    private boolean notRestClient(Node node) {
        return !"rest".equals(node.getDeploymentType());
    }

    private String tableName(String tableName) {
        return TableConstants.getTableName(this.engine != null ? this.engine.getTablePrefix() : "sym", tableName);
    }

    private boolean tableMatches(DataMetaData dataMetaData, String tableName) {
        boolean matches = false;
        if (dataMetaData.getTable().getName().equalsIgnoreCase(this.tableName(tableName))) {
            matches = true;
        }
        return matches;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean isDmlOnly() {
        return false;
    }
}

