/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Collections;
import java.util.Set;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;

public class JavaDataRouter
extends AbstractDataRouter
implements IBuiltInExtensionPoint {
    public static final String CODE_START = "import org.jumpmind.symmetric.route.*;\nimport org.jumpmind.symmetric.model.*;\nimport org.jumpmind.symmetric.service.*;\nimport java.util.*;\npublic class JavaDataRouterExt extends AbstractDataRouter { \n   public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes,\n      boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {\n\n";
    public static final String CODE_END = "\n\n   }\n}\n";
    protected ISymmetricEngine engine;
    protected ISymmetricDialect dialect;
    protected final String ROUTER_KEY = String.format("%d.JavaRouter", this.hashCode());

    public JavaDataRouter(ISymmetricEngine engine) {
        this.engine = engine;
        this.dialect = engine.getSymmetricDialect();
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        try {
            IDataRouter router = this.getCompiledClass(context, dataMetaData.getRouter());
            long ts = System.currentTimeMillis();
            Set<String> targetNodes = router.routeToNodes(context, dataMetaData, nodes, initialLoad, initialLoadSelectUsed, triggerRouter);
            context.incrementStat(System.currentTimeMillis() - ts, "javarouter.exec.ms");
            return targetNodes;
        }
        catch (Exception e) {
            this.log.error("Error in java router: " + dataMetaData.getRouter() + ".  Routing to nobody.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    protected IDataRouter getCompiledClass(SimpleRouterContext context, Router router) throws Exception {
        IDataRouter javaRouter = (IDataRouter)context.getContextCache().get(this.ROUTER_KEY);
        if (javaRouter == null) {
            long ts = System.currentTimeMillis();
            String javaCode = CODE_START + router.getRouterExpression() + CODE_END;
            javaRouter = (IDataRouter)this.engine.getExtensionService().getCompiledClass(javaCode);
            context.getContextCache().put(this.ROUTER_KEY, javaRouter);
            context.incrementStat(System.currentTimeMillis() - ts, "javarouter.compile.ms");
        }
        return javaRouter;
    }

    @Override
    public boolean isDmlOnly() {
        return false;
    }
}

