/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route.parse;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jumpmind.symmetric.route.parse.DBFException;
import org.jumpmind.symmetric.route.parse.DBFField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFReader {
    private static final Logger log = LoggerFactory.getLogger(DBFReader.class);
    private DataInputStream stream = null;
    private DBFField[] fields = null;
    private byte[] nextRecord = null;
    private int nFieldCount;
    private boolean validate;
    private int lineNumber;

    public DBFReader(String s, boolean validate) throws DBFException {
        this.nFieldCount = 0;
        this.validate = validate;
        try {
            this.init(new FileInputStream(s));
        }
        catch (FileNotFoundException filenotfoundexception) {
            throw new DBFException(filenotfoundexception);
        }
    }

    public DBFReader(InputStream inputstream, boolean validate) throws DBFException {
        this.validate = validate;
        this.init(inputstream);
    }

    private void init(InputStream inputstream) throws DBFException {
        try {
            this.stream = new DataInputStream(inputstream);
            int i = this.readHeader();
            this.fields = new DBFField[i];
            int j = 1;
            for (int k = 0; k < i; ++k) {
                this.fields[k] = this.readFieldHeader();
                if (this.fields[k] == null) continue;
                ++this.nFieldCount;
                j += this.fields[k].getLength();
            }
            this.nextRecord = new byte[j];
            try {
                this.stream.readFully(this.nextRecord);
            }
            catch (EOFException eofexception) {
                this.nextRecord = null;
                this.stream.close();
            }
            int pos = 0;
            boolean hasBegin = false;
            for (int p = 0; p < j; ++p) {
                if (this.nextRecord[p] != 32 && this.nextRecord[p] != 42) continue;
                hasBegin = true;
                pos = p;
                break;
            }
            if (pos > 0) {
                int p;
                byte[] others = new byte[pos];
                this.stream.readFully(others);
                for (p = 0; p < j - pos; ++p) {
                    this.nextRecord[p] = this.nextRecord[p + pos];
                }
                for (p = 0; p < pos; ++p) {
                    this.nextRecord[j - p - 1] = others[pos - p - 1];
                }
            }
        }
        catch (IOException ioexception) {
            throw new DBFException(ioexception);
        }
    }

    private int readHeader() throws IOException, DBFException {
        byte[] abyte0 = new byte[16];
        this.stream.readFully(abyte0);
        int i = abyte0[8];
        if (i < 0) {
            i += 256;
        }
        i += 256 * abyte0[9];
        --i;
        i /= 32;
        this.stream.readFully(abyte0);
        return --i;
    }

    private DBFField readFieldHeader() throws IOException, DBFException {
        byte[] abyte0 = new byte[16];
        this.stream.readFully(abyte0);
        if (abyte0[0] == 13 || abyte0[0] == 0) {
            this.stream.readFully(abyte0);
            return null;
        }
        StringBuilder stringbuffer = new StringBuilder(10);
        int i = 0;
        for (i = 0; i < 10 && abyte0[i] != 0; ++i) {
        }
        stringbuffer.append(new String(abyte0, 0, i));
        char c = (char)abyte0[11];
        this.stream.readFully(abyte0);
        int j = abyte0[0];
        int k = abyte0[1];
        if (j < 0) {
            j += 256;
        }
        if (k < 0) {
            k += 256;
        }
        return new DBFField(this.validate, stringbuffer.toString(), c, j, k);
    }

    public int getFieldCount() {
        return this.nFieldCount;
    }

    public DBFField getField(int i) {
        return this.fields[i];
    }

    public boolean hasNextRecord() {
        return this.nextRecord != null;
    }

    public Object[] nextRecord() throws DBFException {
        if (!this.hasNextRecord()) {
            throw new DBFException("No more records available.");
        }
        ++this.lineNumber;
        Object[] aobj = new Object[this.nFieldCount];
        int i = 1;
        for (int j = 0; j < aobj.length; ++j) {
            int k = this.fields[j].getLength();
            StringBuffer stringbuffer = new StringBuffer(k);
            stringbuffer.append(new String(this.nextRecord, i, k));
            try {
                aobj[j] = this.fields[j].parse(stringbuffer.toString());
            }
            catch (DBFException e) {
                log.error("Failed to parse field " + (j + 1) + " on line " + this.lineNumber + " with that had a value of " + stringbuffer);
                throw e;
            }
            i += this.fields[j].getLength();
        }
        try {
            this.stream.readFully(this.nextRecord);
        }
        catch (EOFException eofexception) {
            this.nextRecord = null;
        }
        catch (IOException ioexception) {
            throw new DBFException(ioexception);
        }
        return aobj;
    }

    public Object[] nextRecord(Charset charset) throws DBFException {
        if (!this.hasNextRecord()) {
            throw new DBFException("No more records available.");
        }
        Object[] aobj = new Object[this.nFieldCount];
        int i = 1;
        for (int j = 0; j < aobj.length; ++j) {
            int k = this.fields[j].getLength();
            StringBuilder stringbuffer = new StringBuilder(k);
            stringbuffer.append(new String(this.nextRecord, i, k, charset));
            aobj[j] = this.fields[j].parse(stringbuffer.toString());
            i += this.fields[j].getLength();
        }
        try {
            this.stream.readFully(this.nextRecord);
        }
        catch (EOFException eofexception) {
            this.nextRecord = null;
        }
        catch (IOException ioexception) {
            throw new DBFException(ioexception);
        }
        return aobj;
    }

    public void close() throws DBFException {
        this.nextRecord = null;
        try {
            this.stream.close();
        }
        catch (IOException ioexception) {
            throw new DBFException(ioexception);
        }
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }
}

