/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.exception.HttpException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.IOfflineClientListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IOfflineDetectorService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.InitialLoadPendingException;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationPendingException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.AuthenticationExpiredException;
import org.jumpmind.symmetric.transport.ConnectionDuplicateException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.NoReservationException;
import org.jumpmind.symmetric.transport.ServiceNotReadyException;
import org.jumpmind.symmetric.transport.ServiceUnavailableException;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.util.ExceptionUtils;

public abstract class AbstractOfflineDetectorService
extends AbstractService
implements IOfflineDetectorService {
    protected IExtensionService extensionService;
    private Map<String, Long> transportErrorTimeByNode = new HashMap<String, Long>();

    public AbstractOfflineDetectorService() {
    }

    public AbstractOfflineDetectorService(IParameterService parameterService, ISymmetricDialect symmetricDialect, IExtensionService extensionService) {
        super(parameterService, symmetricDialect);
        this.extensionService = extensionService;
    }

    protected void fireOnline(Node remoteNode, RemoteNodeStatus status) {
        this.transportErrorTimeByNode.remove(remoteNode.getNodeId());
        List<IOfflineClientListener> offlineListeners = this.extensionService.getExtensionPointList(IOfflineClientListener.class);
        if (offlineListeners != null) {
            for (IOfflineClientListener listener : offlineListeners) {
                listener.online(remoteNode);
            }
        }
    }

    protected void fireOffline(Exception exception, Node remoteNode, RemoteNodeStatus status) {
        String syncUrl;
        String string = syncUrl = remoteNode.getSyncUrl() == null ? this.parameterService.getRegistrationUrl() : remoteNode.getSyncUrl();
        if (this.isOffline(exception)) {
            this.logTransportMessage(remoteNode, "Could not communicate with {} at {} because exception {}", remoteNode, syncUrl, this.getExceptionMessage(exception));
            status.setStatus(RemoteNodeStatus.Status.OFFLINE);
        } else if (this.isServiceUnavailable(exception)) {
            ServiceUnavailableException e = (ServiceUnavailableException)((Object)exception);
            this.logTransportMessage(remoteNode, "Remote node {} at {} was unavailable {}", remoteNode, syncUrl, e.getMessage() == null ? "" : ": " + e.getMessage());
            status.setStatus(RemoteNodeStatus.Status.OFFLINE);
        } else if (this.isServiceNotReady(exception)) {
            this.logTransportMessage(remoteNode, "Remote node {} at {} service not ready", remoteNode, syncUrl);
            status.setStatus(RemoteNodeStatus.Status.OFFLINE);
        } else if (this.isBusy(exception)) {
            this.logTransportMessage(remoteNode, "Remote node {} at {} was busy", remoteNode, syncUrl);
            status.setStatus(RemoteNodeStatus.Status.BUSY);
        } else if (this.isDuplicateConnection(exception)) {
            this.logTransportMessage(remoteNode, "Remote node {} at {} already processing a connection from this node", remoteNode, syncUrl);
            status.setStatus(RemoteNodeStatus.Status.BUSY);
        } else if (this.isNoReservation(exception)) {
            this.log.warn("Missing reservation during push with {}", new Object[]{remoteNode});
            status.setStatus(RemoteNodeStatus.Status.BUSY);
        } else if (this.isNotAuthenticated(exception)) {
            this.log.warn("Authorization denied from {} at {}", new Object[]{remoteNode, syncUrl});
            status.setStatus(RemoteNodeStatus.Status.NOT_AUTHORIZED);
        } else if (this.isAuthenticationExpired(exception)) {
            this.log.info("Session expired, so will re-authenticate");
            status.setStatus(RemoteNodeStatus.Status.NOT_AUTHORIZED);
        } else if (this.isSyncDisabled(exception)) {
            this.log.warn("Sync was not enabled for {} at {}", new Object[]{remoteNode, syncUrl});
            status.setStatus(RemoteNodeStatus.Status.SYNC_DISABLED);
        } else if (this.isRegistrationNotOpen(exception)) {
            this.log.warn("Registration was not open at {} {}", new Object[]{remoteNode, syncUrl});
            status.setStatus(RemoteNodeStatus.Status.REGISTRATION_REQUIRED);
        } else if (this.isRegistrationRequired(exception)) {
            this.log.warn("Registration is needed before communicating with {} at {}", new Object[]{remoteNode, syncUrl});
            status.setStatus(RemoteNodeStatus.Status.REGISTRATION_REQUIRED);
        } else if (this.isRegistrationPending(exception)) {
            this.log.info("Registration is still pending");
            status.setStatus(RemoteNodeStatus.Status.REGISTRATION_REQUIRED);
        } else if (this.isInitialLoadPending(exception)) {
            this.log.info("Initial load is pending for node {}", new Object[]{remoteNode});
            status.setStatus(RemoteNodeStatus.Status.INITIAL_LOAD_PENDING);
        } else if (this.getHttpException(exception) != null) {
            HttpException http = this.getHttpException(exception);
            this.logTransportMessage(remoteNode, "Could not communicate with {} at {} because it returned HTTP code {} and exception {}", remoteNode, syncUrl, http.getCode(), this.getExceptionMessage(exception));
        } else {
            this.log.warn(String.format("Could not communicate with node '%s' at %s because of unexpected error", remoteNode, syncUrl), (Throwable)exception);
            status.setStatus(RemoteNodeStatus.Status.UNKNOWN_ERROR);
        }
        List<IOfflineClientListener> offlineListeners = this.extensionService.getExtensionPointList(IOfflineClientListener.class);
        if (offlineListeners != null) {
            for (IOfflineClientListener listener : offlineListeners) {
                if (this.isOffline(exception)) {
                    listener.offline(remoteNode);
                    continue;
                }
                if (this.isBusy(exception)) {
                    listener.busy(remoteNode);
                    continue;
                }
                if (this.isNotAuthenticated(exception)) {
                    listener.notAuthenticated(remoteNode);
                    continue;
                }
                if (this.isSyncDisabled(exception)) {
                    listener.syncDisabled(remoteNode);
                    continue;
                }
                if (this.isRegistrationRequired(exception)) {
                    listener.registrationRequired(remoteNode);
                    continue;
                }
                listener.unknownError(remoteNode, exception);
            }
        }
    }

    protected String getExceptionMessage(Exception e) {
        return e.getClass().getName() + (String)(e.getMessage() == null ? "" : ": " + e.getMessage());
    }

    protected void logTransportMessage(Node remoteNode, String message, Object ... args) {
        if (this.shouldLogTransportError(remoteNode.getNodeId())) {
            this.log.warn(message, args);
        } else {
            this.log.info(message, args);
        }
    }

    protected boolean shouldLogTransportError(String nodeId) {
        long maxErrorMillis = this.parameterService.getLong("transport.max.error.millis", 300000L);
        Long errorTime = this.transportErrorTimeByNode.get(nodeId);
        if (errorTime == null) {
            errorTime = System.currentTimeMillis();
            this.transportErrorTimeByNode.put(nodeId, errorTime);
        }
        return System.currentTimeMillis() - errorTime >= maxErrorMillis;
    }

    protected boolean isOffline(Exception ex) {
        return this.is(ex, SocketException.class, ConnectException.class, SocketTimeoutException.class, UnknownHostException.class);
    }

    protected boolean isNotAuthenticated(Exception ex) {
        return this.is(ex, AuthenticationException.class);
    }

    protected boolean isAuthenticationExpired(Exception ex) {
        return this.is(ex, AuthenticationExpiredException.class);
    }

    protected boolean isBusy(Exception ex) {
        return this.is(ex, ConnectionRejectedException.class);
    }

    protected boolean isDuplicateConnection(Exception ex) {
        return this.is(ex, ConnectionDuplicateException.class);
    }

    protected boolean isServiceUnavailable(Exception ex) {
        return this.is(ex, ServiceUnavailableException.class);
    }

    protected boolean isServiceNotReady(Exception ex) {
        return this.is(ex, ServiceNotReadyException.class);
    }

    protected boolean isSyncDisabled(Exception ex) {
        return this.is(ex, SyncDisabledException.class);
    }

    protected boolean isRegistrationRequired(Exception ex) {
        return this.is(ex, RegistrationRequiredException.class);
    }

    protected boolean isRegistrationPending(Exception ex) {
        return this.is(ex, RegistrationPendingException.class);
    }

    protected boolean isInitialLoadPending(Exception ex) {
        return this.is(ex, RegistrationPendingException.class, InitialLoadPendingException.class);
    }

    protected boolean isRegistrationNotOpen(Exception ex) {
        return this.is(ex, RegistrationNotOpenException.class);
    }

    protected boolean isNoReservation(Exception ex) {
        return this.is(ex, NoReservationException.class);
    }

    protected boolean is(Exception e, Class<?> ... exceptions) {
        return ExceptionUtils.is((Exception)e, (Class[])exceptions);
    }

    protected HttpException getHttpException(Exception ex) {
        HttpException exception = null;
        if (ex != null) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (cause instanceof HttpException) {
                exception = (HttpException)cause;
            } else if (ex instanceof HttpException) {
                exception = (HttpException)ex;
            }
        }
        return exception;
    }
}

