/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IService;
import org.jumpmind.symmetric.service.impl.AbstractSqlMap;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.jumpmind.symmetric.service.impl.OutgoingBatchService;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.web.WebConstants;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService
implements IService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IParameterService parameterService;
    protected ISymmetricDialect symmetricDialect;
    protected ISqlTemplate sqlTemplate;
    protected ISqlTemplate sqlTemplateDirty;
    protected IDatabasePlatform platform;
    protected String tablePrefix;
    private ISqlMap sqlMap;
    private Set<String> logOnce = new HashSet<String>();
    private static final Comparator<BatchAck> BATCH_ID_COMPARATOR = new Comparator<BatchAck>(){

        @Override
        public int compare(BatchAck batchInfo1, BatchAck batchInfo2) {
            Long batchId1 = batchInfo1.getBatchId();
            Long batchId2 = batchInfo2.getBatchId();
            return batchId1.compareTo(batchId2);
        }
    };

    public AbstractService() {
    }

    public AbstractService(IParameterService parameterService, ISymmetricDialect symmetricDialect) {
        this.symmetricDialect = symmetricDialect;
        this.parameterService = parameterService;
        this.tablePrefix = parameterService.getTablePrefix();
        this.platform = symmetricDialect.getPlatform();
        this.sqlTemplate = symmetricDialect.getPlatform().getSqlTemplate();
        this.sqlTemplateDirty = symmetricDialect.getPlatform().getSqlTemplateDirty();
    }

    protected Date maxDate(Date ... dates) {
        Date date = null;
        if (dates != null) {
            for (Date d : dates) {
                if (d == null || date != null && !d.after(date)) continue;
                date = d;
            }
        }
        return date;
    }

    protected void setSqlMap(ISqlMap sqlMap) {
        this.sqlMap = sqlMap;
    }

    public ISqlTemplate getJdbcTemplate() {
        return this.symmetricDialect.getPlatform().getSqlTemplate();
    }

    @Override
    public synchronized void synchronize(Runnable runnable) {
        runnable.run();
    }

    protected boolean isSet(Object value) {
        return value != null && value.toString().equals("1");
    }

    protected Map<String, String> createSqlReplacementTokens() {
        return AbstractSqlMap.mergeSqlReplacementTokens(this.symmetricDialect.getSqlReplacementTokens(), this.tablePrefix);
    }

    @Override
    public String getSql(String ... keys) {
        if (this.sqlMap != null) {
            return this.sqlMap.getSql(keys);
        }
        return null;
    }

    public IParameterService getParameterService() {
        return this.parameterService;
    }

    public ISymmetricDialect getSymmetricDialect() {
        return this.symmetricDialect;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    protected void close(ISqlTransaction transaction) {
        if (transaction != null) {
            transaction.close();
        }
    }

    protected Set<String> toNodeIds(Set<Node> nodes) {
        return this.toNodeIds(nodes, null);
    }

    protected Set<String> toNodeIds(Set<Node> nodes, Set<String> nodeIds) {
        nodeIds = nodeIds == null ? new HashSet<String>(nodes.size()) : nodeIds;
        for (Node node : nodes) {
            nodeIds.add(node.getNodeId());
        }
        return nodeIds;
    }

    protected boolean isCalledFromSymmetricAdminTool() {
        StackTraceElement[] trace;
        boolean adminTool = false;
        for (StackTraceElement stackTraceElement : trace = Thread.currentThread().getStackTrace()) {
            adminTool |= stackTraceElement.getClassName().equals("org.jumpmind.symmetric.SymmetricAdmin");
        }
        return adminTool;
    }

    protected String buildBatchWhere(List<String> nodeIds, List<String> channels, List<?> statuses, List<Long> loads, Date startAtLastUpdatedTime) {
        boolean containsErrorStatus = statuses.contains((Object)AbstractBatch.Status.ER);
        boolean containsIgnoreStatus = statuses.contains((Object)AbstractBatch.Status.IG);
        StringBuilder where = new StringBuilder();
        boolean needsAnd = false;
        if (nodeIds != null && nodeIds.size() > 0) {
            where.append("node_id in (:NODES)");
            needsAnd = true;
        }
        if (channels != null && channels.size() > 0) {
            if (needsAnd) {
                where.append(" and ");
            }
            where.append("channel_id in (:CHANNELS)");
            needsAnd = true;
        }
        if (loads != null && loads.size() > 0) {
            if (needsAnd) {
                where.append(" and ");
            }
            where.append("load_id in (:LOADS)");
            needsAnd = true;
        }
        if (statuses.size() > 0) {
            if (needsAnd) {
                where.append(" and ");
            }
            where.append("(status in (:STATUSES)");
            if (containsErrorStatus) {
                where.append(" or error_flag = 1 ");
            }
            if (containsIgnoreStatus) {
                where.append(" or ignore_count > 0 ");
            }
            where.append(")");
            needsAnd = true;
        }
        if (startAtLastUpdatedTime != null) {
            if (needsAnd) {
                where.append(" and ");
            }
            where.append("last_update_time >= :LAST_UPDATE_TIME");
            needsAnd = true;
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        return where.toString();
    }

    protected String buildBatchWhereFromFilter(List<FilterCriterion> filter) {
        StringBuilder where = new StringBuilder();
        boolean needsAnd = false;
        int id = 0;
        for (FilterCriterion criterion : filter) {
            if (needsAnd) {
                where.append(" and ");
            } else {
                needsAnd = true;
            }
            FilterCriterion.FilterOption option = criterion.getOption();
            String optionSql = option.toSql();
            String prefix = null;
            switch (criterion.getPropertyId()) {
                case "nodeId": {
                    prefix = "node_id " + optionSql;
                    break;
                }
                case "batchId": {
                    prefix = "batch_id " + optionSql;
                    break;
                }
                case "status": {
                    prefix = "status " + optionSql;
                    break;
                }
                case "channelId": {
                    prefix = "channel_id " + optionSql;
                    break;
                }
                case "createTime": {
                    prefix = "create_time " + optionSql;
                    break;
                }
                case "loadId": {
                    prefix = "load_id " + optionSql;
                    break;
                }
                case "lastUpdatedTime": {
                    prefix = "last_update_time " + optionSql;
                }
            }
            if (prefix == null) continue;
            if (option == FilterCriterion.FilterOption.IN_LIST || option == FilterCriterion.FilterOption.NOT_IN_LIST) {
                where.append(prefix + " (:" + id++ + ")");
                continue;
            }
            where.append(prefix + " :" + id++);
            if (option != FilterCriterion.FilterOption.BETWEEN) continue;
            where.append(" and :" + id++);
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        return where.toString();
    }

    protected Map<String, Object> buildBatchParams(List<FilterCriterion> filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int id = 0;
        block9: for (FilterCriterion criterion : filter) {
            FilterCriterion.FilterOption option = criterion.getOption();
            List<Object> values = criterion.getValues();
            switch (criterion.getPropertyId()) {
                case "status": {
                    ArrayList<String> statuses = new ArrayList<String>();
                    for (Object status : values) {
                        statuses.add(AbstractBatch.Status.getNameFromDescription((String)status));
                    }
                    params.put(String.valueOf(id++), statuses);
                    continue block9;
                }
                case "createTime": 
                case "lastUpdatedTime": {
                    if (option == FilterCriterion.FilterOption.IN_LIST || option == FilterCriterion.FilterOption.NOT_IN_LIST) {
                        params.put(String.valueOf(id++), values);
                        continue block9;
                    }
                    params.put(String.valueOf(id++), new Timestamp(((Date)values.get(0)).getTime()));
                    if (option != FilterCriterion.FilterOption.BETWEEN) continue block9;
                    params.put(String.valueOf(id++), new Timestamp(((Date)values.get(1)).getTime()));
                    continue block9;
                }
            }
            if (option == FilterCriterion.FilterOption.IN_LIST || option == FilterCriterion.FilterOption.NOT_IN_LIST) {
                params.put(String.valueOf(id++), values);
                continue;
            }
            if (option == FilterCriterion.FilterOption.CONTAINS || option == FilterCriterion.FilterOption.NOT_CONTAINS) {
                params.put(String.valueOf(id++), "%" + values.get(0) + "%");
                continue;
            }
            params.put(String.valueOf(id++), values.get(0));
            if (option != FilterCriterion.FilterOption.BETWEEN) continue;
            params.put(String.valueOf(id++), values.get(1));
        }
        return params;
    }

    protected String buildBatchOrderBy(String orderColumn, String orderDirection) {
        Object orderBy = " order by ";
        if (orderColumn == null) {
            orderBy = this instanceof OutgoingBatchService ? (String)orderBy + "batch_id desc, node_id desc" : (String)orderBy + "create_time desc";
        } else {
            orderColumn = orderColumn.equals("lastUpdatedTime") ? "last_update_time" : (orderColumn.equals("lastUpdatedHostName") ? "last_update_hostname" : orderColumn.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase());
            orderBy = (String)orderBy + orderColumn;
            if (orderDirection.equals("DESCENDING")) {
                orderBy = (String)orderBy + " desc";
            }
        }
        return orderBy;
    }

    protected void sendAck(Node remote, Node local, NodeSecurity localSecurity, List<IncomingBatch> list, ITransportManager transportManager, String queue) throws IOException {
        this.assertNotNull(remote, "Node remote cannot be null. Maybe there is a missing sym_node row.");
        this.assertNotNull(local, "Node local cannot be null. Maybe there is a missing sym_node row.");
        this.assertNotNull(localSecurity, "NodeSecurity localSecurity cannot be null. Maybe there is a missing sym_node_security row.");
        Exception exception = null;
        int statusCode = -1;
        int numberOfStatusSendRetries = this.parameterService.getInt("num.of.ack.retries");
        for (int i = 0; i < numberOfStatusSendRetries && statusCode != 200; ++i) {
            try {
                HashMap<String, String> requestProperties = null;
                if (StringUtils.isNotBlank((CharSequence)queue)) {
                    requestProperties = new HashMap<String, String>();
                    requestProperties.put("threadChannel", queue);
                }
                statusCode = transportManager.sendAcknowledgement(remote, list, local, localSecurity.getNodePassword(), requestProperties, this.parameterService.getRegistrationUrl());
                exception = null;
            }
            catch (Exception e) {
                exception = e;
            }
            if (statusCode == 200) continue;
            String httpMessage = WebConstants.getHttpMessage(statusCode);
            boolean retry = statusCode != 657 && statusCode != 667 && statusCode != 658 && statusCode != 659 && statusCode != 669;
            Object message = String.format("Ack was not sent successfully on try number %s of %s.", i + 1, numberOfStatusSendRetries);
            if (statusCode > 0) {
                message = (String)message + " httpCode=" + statusCode;
            }
            if (httpMessage != null) {
                message = (String)message + " httpMessage=" + httpMessage;
            }
            if (exception != null) {
                this.log.info((String)message + " " + exception.getClass().getName() + ": " + exception.getMessage());
            } else {
                this.log.info((String)message);
            }
            if (!retry) {
                this.log.info("Leaving ack loop to recover from HTTP code that should not be retried");
            }
            if (retry && i < numberOfStatusSendRetries - 1) {
                AppUtils.sleep((long)this.parameterService.getLong("time.between.ack.retries.ms"));
                continue;
            }
            this.log.warn("Ack was not sent successfully.");
            if (!retry) break;
        }
    }

    protected List<BatchAck> readAcks(List<OutgoingBatch> batches, IOutgoingWithResponseTransport transport, ITransportManager transportManager, IAcknowledgeService acknowledgeService, IDataExtractorService dataExtratorService) throws IOException {
        HashSet<Long> batchIds = new HashSet<Long>(batches.size());
        for (OutgoingBatch outgoingBatch : batches) {
            if (outgoingBatch.getStatus() != AbstractBatch.Status.LD) continue;
            batchIds.add(outgoingBatch.getBatchId());
        }
        BufferedReader reader = transport.readResponse();
        String ackString = reader.readLine();
        String ackExtendedString = reader.readLine();
        this.log.debug("Reading ack: {}", (Object)ackString);
        this.log.debug("Reading extend ack: {}", (Object)ackExtendedString);
        String line = null;
        do {
            if ((line = reader.readLine()) == null) continue;
            this.log.info("Read another unexpected line {}", (Object)line);
        } while (line != null);
        List<BatchAck> batchAcks = transportManager.readAcknowledgement(ackString, ackExtendedString);
        Collections.sort(batchAcks, BATCH_ID_COMPARATOR);
        long batchIdInError = Long.MAX_VALUE;
        for (BatchAck batchInfo : batchAcks) {
            batchIds.remove(batchInfo.getBatchId());
            if (!batchInfo.isOk()) {
                batchIdInError = batchInfo.getBatchId();
            }
            this.log.debug("Saving ack: {}, {}", (Object)batchInfo.getBatchId(), (Object)(batchInfo.isResend() ? "RS" : (batchInfo.isOk() ? "OK" : "ER")));
            acknowledgeService.ack(batchInfo);
        }
        for (Long batchId : batchIds) {
            if (batchId >= batchIdInError) continue;
            for (OutgoingBatch outgoingBatch : batches) {
                if (outgoingBatch.getBatchId() != batchId.longValue()) continue;
                StringBuilder message = new StringBuilder(128);
                message.append("Expected but did not receive an ack for batch ");
                message.append(outgoingBatch.getNodeBatchId()).append(". ");
                if (dataExtratorService != null) {
                    if (!outgoingBatch.isLoadFlag()) {
                        message.append("This could be because the batch is corrupt - removing the batch from staging.");
                        this.log.warn(message.toString());
                        dataExtratorService.removeBatchFromStaging(outgoingBatch);
                        continue;
                    }
                    message.append("This could be because the batch is corrupt. Not removing the batch because it was a load batch, but you may need to clear the batch from staging manually.");
                    this.log.warn(message.toString());
                    continue;
                }
                this.log.warn(message.toString());
            }
        }
        return batchAcks;
    }

    protected void logOnce(String message) {
        if (this.logOnce.add(message)) {
            this.log.info(message);
        }
    }

    protected boolean isStreamClosedByClient(Exception ex) {
        return ExceptionUtils.indexOfType((Throwable)ex, EOFException.class) >= 0;
    }

    protected void assertNotNull(Object o, String message) {
        if (o == null) {
            throw new SymmetricException(message, new Object[0]);
        }
    }

    protected ISymmetricDialect getTargetDialect() {
        return this.symmetricDialect.getTargetDialect();
    }

    protected boolean isSymmetricTable(String tableName) {
        return tableName.toUpperCase().startsWith(this.tablePrefix.toUpperCase());
    }

    protected IDatabasePlatform getTargetPlatform(String tableName) {
        return this.isSymmetricTable(tableName) ? this.symmetricDialect.getPlatform() : this.symmetricDialect.getTargetDialect().getPlatform();
    }

    protected IDatabasePlatform getTargetPlatform() {
        return this.symmetricDialect.getTargetDialect().getPlatform();
    }
}

