/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.jumpmind.util.FormatUtils;

public abstract class AbstractSqlMap
implements ISqlMap {
    private IDatabasePlatform platform;
    private Map<String, String> sql = new HashMap<String, String>();
    protected Map<String, String> replacementTokens;

    public AbstractSqlMap(IDatabasePlatform platform, String tablePrefix) {
        this.platform = platform;
        this.replacementTokens = AbstractSqlMap.mergeSqlReplacementTokens(null, tablePrefix);
    }

    public AbstractSqlMap(IDatabasePlatform platform, Map<String, String> replacementTokens) {
        this.platform = platform;
        this.replacementTokens = replacementTokens;
    }

    protected void putSql(String key, String sql) {
        if (this.replacementTokens != null) {
            sql = FormatUtils.replaceTokens((String)sql, this.replacementTokens, (boolean)true);
        }
        sql = sql.replaceAll("\\s+", " ");
        this.sql.put(key, this.platform != null ? this.platform.scrubSql(sql) : sql);
    }

    @Override
    public String getSql(String ... keys) {
        StringBuilder sqlBuffer = new StringBuilder();
        if (keys != null) {
            if (keys.length > 1) {
                for (String key : keys) {
                    if (key == null) continue;
                    String value = this.sql.get(key);
                    sqlBuffer.append(value == null ? key : value);
                    sqlBuffer.append(" ");
                }
            } else if (keys.length == 1) {
                sqlBuffer.append(this.sql.get(keys[0]));
            }
        }
        return sqlBuffer.toString();
    }

    public static Map<String, String> mergeSqlReplacementTokens(Map<String, String> replacementTokens, String tablePrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> tables = TableConstants.getTablesWithoutPrefix();
        for (String table : tables) {
            map.put(table, String.format("%s%s%s", tablePrefix, StringUtils.isNotBlank((CharSequence)tablePrefix) ? "_" : "", table));
        }
        if (replacementTokens != null) {
            map.putAll(replacementTokens);
        }
        return map;
    }
}

