/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.mapper.NumberMapper;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.BatchAckResult;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.AcknowledgeServiceSqlMap;
import org.jumpmind.symmetric.statistic.RouterStats;
import org.jumpmind.symmetric.transport.IAcknowledgeEventListener;

public class AcknowledgeService
extends AbstractService
implements IAcknowledgeService {
    private ISymmetricEngine engine;

    public AcknowledgeService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.setSqlMap(new AcknowledgeServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BatchAckResult ack(BatchAck batch) {
        AbstractBatch.Status status;
        IRegistrationService registrationService = this.engine.getRegistrationService();
        IOutgoingBatchService outgoingBatchService = this.engine.getOutgoingBatchService();
        BatchAckResult result = new BatchAckResult(batch);
        for (IAcknowledgeEventListener listener : this.engine.getExtensionService().getExtensionPointList(IAcknowledgeEventListener.class)) {
            listener.onAcknowledgeEvent(batch);
        }
        if (batch.getBatchId() == -9999L) {
            if (!batch.isOk()) return result;
            registrationService.markNodeAsRegistered(batch.getNodeId());
            return result;
        }
        if (batch.getBatchId() == -1L) return result;
        OutgoingBatch outgoingBatch = outgoingBatchService.findOutgoingBatch(batch.getBatchId(), batch.getNodeId());
        AbstractBatch.Status status2 = batch.isResend() ? AbstractBatch.Status.RS : (status = batch.isOk() ? AbstractBatch.Status.OK : AbstractBatch.Status.ER);
        if (outgoingBatch != null && outgoingBatch.getStatus() != AbstractBatch.Status.RQ) {
            if (outgoingBatch.getStatus() == AbstractBatch.Status.IG && status == AbstractBatch.Status.OK) {
                this.log.info("Ignoring batch {}", (Object)outgoingBatch.getNodeBatchId());
            } else if (outgoingBatch.getStatus() == AbstractBatch.Status.OK && status != AbstractBatch.Status.OK) {
                this.log.info("Setting status to ignore for batch {} because status was set to OK by user", (Object)outgoingBatch.getNodeBatchId());
                status = AbstractBatch.Status.IG;
            }
            boolean isFirstTimeAsOkStatus = outgoingBatch.getStatus() != AbstractBatch.Status.OK && status == AbstractBatch.Status.OK;
            boolean isFirstTimeAsErStatus = !outgoingBatch.isErrorFlag() && status == AbstractBatch.Status.ER;
            outgoingBatch.setStatus(status);
            outgoingBatch.setBulkLoaderFlag(batch.isBulkLoaderFlag());
            outgoingBatch.setErrorFlag(status == AbstractBatch.Status.ER);
            outgoingBatch.setNetworkMillis(batch.getNetworkMillis());
            outgoingBatch.setFilterMillis(batch.getFilterMillis());
            outgoingBatch.setLoadMillis(batch.getLoadMillis());
            outgoingBatch.setLoadStartTime(new Date(batch.getStartTime()));
            outgoingBatch.setSqlCode(batch.getSqlCode());
            outgoingBatch.setSqlState(batch.getSqlState());
            outgoingBatch.setSqlMessage(batch.getSqlMessage());
            outgoingBatch.setLoadRowCount(batch.getLoadRowCount());
            outgoingBatch.setLoadInsertRowCount(batch.getLoadInsertRowCount());
            outgoingBatch.setLoadUpdateRowCount(batch.getLoadUpdateRowCount());
            outgoingBatch.setTransformLoadMillis(batch.getTransformLoadMillis());
            outgoingBatch.setLoadDeleteRowCount(batch.getLoadDeleteRowCount());
            outgoingBatch.setFallbackInsertCount(batch.getFallbackInsertCount());
            outgoingBatch.setFallbackUpdateCount(batch.getFallbackUpdateCount());
            outgoingBatch.setConflictWinCount(batch.getConflictWinCount());
            outgoingBatch.setConflictLoseCount(batch.getConflictLoseCount());
            outgoingBatch.setIgnoreRowCount(batch.getIgnoreRowCount());
            outgoingBatch.setMissingDeleteCount(batch.getMissingDeleteCount());
            outgoingBatch.setSkipCount(batch.getSkipCount());
            if (batch.isIgnored()) {
                outgoingBatch.incrementIgnoreCount();
            }
            if (status == AbstractBatch.Status.OK) {
                outgoingBatch.setFailedDataId(0L);
                outgoingBatch.setFailedLineNumber(0L);
            }
            boolean isNewError = false;
            if (status == AbstractBatch.Status.ER && batch.getErrorLine() != 0L) {
                if (outgoingBatch.isLoadFlag()) {
                    isNewError = outgoingBatch.getSentCount() == 1L;
                } else if (batch.getErrorLine() != outgoingBatch.getFailedLineNumber()) {
                    Object sql = this.getSql("selectDataIdSql");
                    if (this.parameterService.is("oracle.sequence.noorder", false)) {
                        sql = this.getSql("selectDataIdByCreateTimeSql");
                    } else if (this.parameterService.is("routing.data.reader.order.by.gap.id.enabled", true)) {
                        sql = (String)sql + this.getSql("orderByDataId");
                    }
                    List ids = this.sqlTemplateDirty.query((String)sql, (ISqlRowMapper)new NumberMapper(), new Object[]{outgoingBatch.getBatchId()});
                    if ((long)ids.size() >= batch.getErrorLine()) {
                        long failedDataId = ((Number)ids.get((int)batch.getErrorLine() - 1)).longValue();
                        isNewError = outgoingBatch.getFailedDataId() == 0L || outgoingBatch.getFailedDataId() != failedDataId;
                        outgoingBatch.setFailedDataId(failedDataId);
                    }
                }
                outgoingBatch.setFailedLineNumber(batch.getErrorLine());
            }
            if (status == AbstractBatch.Status.ER) {
                boolean suppressError = false;
                if (isNewError) {
                    this.engine.getStatisticManager().incrementDataLoadedOutgoingErrors(outgoingBatch.getChannelId(), 1L);
                }
                if (isNewError && outgoingBatch.getSqlCode() == -900) {
                    if (!outgoingBatch.isLoadFlag() && outgoingBatch.getReloadRowCount() == 0L && this.parameterService.is("auto.resolve.foreign.key.violation")) {
                        try {
                            this.engine.getDataService().reloadMissingForeignKeyRows(outgoingBatch.getBatchId(), outgoingBatch.getNodeId(), outgoingBatch.getFailedDataId(), outgoingBatch.getFailedLineNumber());
                        }
                        catch (Exception e) {
                            this.log.error("Failed to request a reload of missing foreign key rows for batch " + outgoingBatch.getNodeBatchId() + " data ID " + outgoingBatch.getFailedDataId(), (Throwable)e);
                            outgoingBatch.setFailedLineNumber(0L);
                            outgoingBatch.setFailedDataId(0L);
                        }
                    }
                    if (outgoingBatch.isLoadFlag() && this.parameterService.is("auto.resolve.foreign.key.violation.reverse.reload")) {
                        suppressError = true;
                    }
                }
                if (outgoingBatch.getSqlCode() == -888 && "PROTOCOL".equals(outgoingBatch.getSqlState())) {
                    if (outgoingBatch.isLoadFlag()) {
                        this.log.info("The batch {} may be corrupt in staging. Not removing the batch because it was a load batch, but you may need to clear the batch from staging manually.", (Object)outgoingBatch.getNodeBatchId());
                    } else {
                        IStagedResource resource = this.engine.getStagingManager().find(new Object[]{"outgoing", outgoingBatch.getStagedLocation(), outgoingBatch.getBatchId()});
                        if (resource != null) {
                            this.log.info("The batch {} may be corrupt in staging, so removing it.", (Object)outgoingBatch.getNodeBatchId());
                            resource.delete();
                            suppressError = isNewError;
                        }
                    }
                }
                if (isNewError && (outgoingBatch.getSqlCode() == -911 || outgoingBatch.getSqlCode() == -999)) {
                    suppressError = true;
                }
                if (suppressError) {
                    outgoingBatch.setErrorFlag(false);
                } else {
                    this.log.error("The outgoing batch {} failed: {}{}", new Object[]{outgoingBatch.getNodeBatchId(), batch.getSqlCode() != 0 ? "[" + batch.getSqlState() + "," + batch.getSqlCode() + "] " : "", batch.getSqlMessage() != null ? batch.getSqlMessage() : "(no message)"});
                    RouterStats routerStats = this.engine.getStatisticManager().getRouterStatsByBatch(batch.getBatchId());
                    if (routerStats != null) {
                        this.log.info("Router stats for batch " + outgoingBatch.getBatchId() + ": " + routerStats);
                    }
                }
            } else if (status == AbstractBatch.Status.RS) {
                this.log.info("The outgoing batch {} received resend request", (Object)outgoingBatch.getNodeBatchId());
            }
            ISqlTransaction transaction = null;
            try {
                Channel channel;
                transaction = this.sqlTemplate.startSqlTransaction();
                outgoingBatchService.updateOutgoingBatch(transaction, outgoingBatch);
                if (status == AbstractBatch.Status.OK && outgoingBatch.getLoadId() > 0L) {
                    if (isFirstTimeAsOkStatus) {
                        this.engine.getDataExtractorService().updateExtractRequestLoadTime(transaction, new Date(), outgoingBatch);
                    } else {
                        this.log.info("Ignoring duplicate load status update for load ID {} with batch {}", (Object)outgoingBatch.getLoadId(), (Object)outgoingBatch.getNodeBatchId());
                    }
                } else if (status == AbstractBatch.Status.ER && isFirstTimeAsErStatus && outgoingBatch.getLoadId() > 0L) {
                    this.engine.getDataService().updateTableReloadStatusFailed(transaction, outgoingBatch.getLoadId(), this.engine.getNodeId(), outgoingBatch.getBatchId());
                }
                transaction.commit();
                if (status != AbstractBatch.Status.OK) return result;
                if (isFirstTimeAsOkStatus) {
                    this.engine.getStatisticManager().incrementDataLoadedOutgoing(outgoingBatch.getChannelId(), outgoingBatch.getLoadRowCount());
                    this.engine.getStatisticManager().incrementDataBytesLoadedOutgoing(outgoingBatch.getChannelId(), outgoingBatch.getByteCount());
                }
                if (this.parameterService.is("stream.to.file.enabled")) {
                    this.purgeBatchesFromStaging(outgoingBatch);
                }
                if ((channel = this.engine.getConfigurationService().getChannel(outgoingBatch.getChannelId())) != null && channel.isFileSyncFlag()) {
                    this.engine.getFileSyncService().acknowledgeFiles(outgoingBatch);
                }
                this.engine.getStatisticManager().removeRouterStatsByBatch(batch.getBatchId());
                return result;
            }
            catch (Error ex) {
                if (transaction == null) throw ex;
                transaction.rollback();
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction == null) throw ex;
                transaction.rollback();
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        }
        if (outgoingBatch != null) return result;
        this.log.error("Could not find batch {}-{} to acknowledge as {}", new Object[]{batch.getNodeId(), batch.getBatchId(), status.name()});
        result.setOk(false);
        return result;
    }

    protected void purgeBatchesFromStaging(OutgoingBatch outgoingBatch) {
        IStagedResource resource;
        long streamToFileThreshold;
        IStagedResource resource2;
        long threshold = this.parameterService.getLong("initial.load.purge.stage.immediate.threshold.rows");
        if (threshold >= 0L && outgoingBatch.isLoadFlag() && !outgoingBatch.isCommonFlag() && outgoingBatch.getDataRowCount() > threshold && (resource2 = this.engine.getStagingManager().find(new Object[]{"outgoing", outgoingBatch.getStagedLocation(), outgoingBatch.getBatchId()})) != null) {
            resource2.delete();
        }
        if ((streamToFileThreshold = this.parameterService.getLong("stream.to.file.threshold.bytes")) > 0L && !outgoingBatch.isCommonFlag() && outgoingBatch.getByteCount() <= streamToFileThreshold && (resource = this.engine.getStagingManager().find(new Object[]{"outgoing", outgoingBatch.getStagedLocation(), outgoingBatch.getBatchId()})) != null && resource.isMemoryResource() && !resource.isInUse()) {
            resource.delete();
        }
    }

    @Override
    public List<BatchAckResult> ack(List<BatchAck> batches) {
        ArrayList<BatchAckResult> results = new ArrayList<BatchAckResult>();
        for (BatchAck batch : batches) {
            results.add(this.ack(batch));
        }
        return results;
    }

    @Override
    public void checkMissingAck(List<BatchAck> acks, String queue) {
        boolean hasCorruptBatch = false;
        String nodeId = null;
        for (BatchAck batch : acks) {
            if (batch.getBatchId() != -1L) continue;
            hasCorruptBatch = true;
            nodeId = batch.getNodeId();
        }
        if (hasCorruptBatch && this.parameterService.is("stream.to.file.enabled")) {
            OutgoingBatch batch;
            OutgoingBatches batches = this.engine.getOutgoingBatchService().getOutgoingBatches(nodeId, queue, false);
            Iterator<OutgoingBatch> iter = batches.getBatches().iterator();
            while (iter.hasNext()) {
                batch = iter.next();
                if (batch.getStatus() != AbstractBatch.Status.RQ && batch.getStatus() != AbstractBatch.Status.NE) continue;
                iter.remove();
            }
            if (batches.containsBatches()) {
                batch = batches.getBatches().get(0);
                StringBuilder message = new StringBuilder(128);
                message.append("Expected but did not receive an ack for batch ");
                message.append(batch.getNodeBatchId()).append(". ");
                if (!batch.isLoadFlag()) {
                    message.append("This could be because the batch is corrupt - removing the batch from staging.");
                    this.log.warn(message.toString());
                    IStagedResource resource = this.engine.getStagingManager().find(new Object[]{"outgoing", batch.getStagedLocation(), batch.getBatchId()});
                    if (resource != null) {
                        resource.delete();
                    } else {
                        this.log.warn("Unable to find outgoing staging file for {} that has corrupt batch data", (Object)batch.getNodeBatchId());
                    }
                } else {
                    message.append("This could be because the batch is corrupt. Not removing the batch because it was a load batch, but you may need to clear the batch from staging manually.");
                    this.log.warn(message.toString());
                }
            } else {
                this.log.warn("Unable to find outgoing batch for node {} that has corrupt batch data", (Object)nodeId);
            }
        }
    }
}

