/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.model.NodeGroupChannelWindow;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.ConfigurationServiceSqlMap;

public class ConfigurationService
extends AbstractService
implements IConfigurationService {
    private INodeService nodeService;
    private Map<String, Channel> defaultChannels;
    private Date lastUpdateTime;
    private ICacheManager cacheManager;

    public ConfigurationService(ISymmetricEngine engine, ISymmetricDialect dialect) {
        super(engine.getParameterService(), dialect);
        this.nodeService = engine.getNodeService();
        this.cacheManager = engine.getCacheManager();
        this.createDefaultChannels();
        this.setSqlMap(new ConfigurationServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    protected final void createDefaultChannels() {
        Channel reloadChannel;
        LinkedHashMap<String, Channel> updatedDefaultChannels = new LinkedHashMap<String, Channel>();
        updatedDefaultChannels.put("config", new Channel("config", 0, 2000, 10, true, 0L, true, "system"));
        updatedDefaultChannels.put("system", new Channel("system", 0, 2000, 10, true, 0L, true, "system"));
        if (this.parameterService.is("initial.load.use.extract.job.enabled")) {
            reloadChannel = new Channel("reload", 1, 500000, 10, true, 0L, false, true, false);
            reloadChannel.setQueue("reload");
        } else {
            reloadChannel = new Channel("reload", 1, 1, 1, true, 0L, false, true, false);
        }
        reloadChannel.setDataLoaderType("bulk");
        updatedDefaultChannels.put("reload", reloadChannel);
        updatedDefaultChannels.put("monitor", new Channel("monitor", 2, 100, 10, true, 0L, true, "system"));
        updatedDefaultChannels.put("heartbeat", new Channel("heartbeat", 2, 100, 10, true, 0L, false, "system"));
        updatedDefaultChannels.put("default", new Channel("default", 500000, 1000, 10, true, 0L, false));
        updatedDefaultChannels.put("dynamic", new Channel("dynamic", 99999, 1000, 10, true, 0L, false));
        if (this.parameterService.is("file.sync.enable")) {
            updatedDefaultChannels.put("filesync", new Channel("filesync", 3, 100, 10, true, 0L, false, "nontransactional", false, true));
            updatedDefaultChannels.put("filesync_reload", new Channel("filesync_reload", 1, 100, 10, true, 0L, false, "nontransactional", true, true));
        }
        this.defaultChannels = updatedDefaultChannels;
    }

    @Override
    public boolean isBulkLoaderEnabled() {
        boolean enabled = false;
        for (Channel channel : this.getChannels(false).values()) {
            if (!channel.isReloadFlag() || !channel.getDataLoaderType().equals("bulk")) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    @Override
    public boolean isMasterToMaster() {
        boolean masterToMaster = false;
        Node me = this.nodeService.findIdentity();
        if (me != null) {
            NodeGroupLink nodeGroupLink = this.getNodeGroupLinkFor(me.getNodeGroupId(), me.getNodeGroupId(), false);
            masterToMaster = nodeGroupLink != null && nodeGroupLink.getDataEventAction() != NodeGroupLinkAction.R;
        }
        return masterToMaster;
    }

    @Override
    public boolean containsMasterToMaster() {
        boolean masterToMasterOnly = false;
        Node me = this.nodeService.findIdentity();
        if (me != null) {
            masterToMasterOnly = this.sqlTemplate.queryForInt(this.getSql("countGroupLinksForSql"), new Object[]{me.getNodeGroupId(), me.getNodeGroupId(), NodeGroupLinkAction.R.name()}) == 1;
        }
        return masterToMasterOnly;
    }

    @Override
    public boolean isMasterToMasterOnly() {
        Node me = this.nodeService.findIdentity();
        int masterCount = 0;
        int otherCount = 0;
        if (me != null) {
            for (NodeGroupLink nodeGroupLink : this.getNodeGroupLinksFor(me.getNodeGroupId(), false)) {
                if (nodeGroupLink.getTargetNodeGroupId().equals(me.getNodeGroupId()) && nodeGroupLink.getDataEventAction() != NodeGroupLinkAction.R) {
                    ++masterCount;
                    continue;
                }
                ++otherCount;
            }
        }
        return masterCount >= 1 && otherCount == 0;
    }

    @Override
    public boolean isUseSourceStagingEnabled(String nodeId) {
        if (this.isUseSourceStagingEnabled(this.parameterService)) {
            ISymmetricEngine targetEngine = AbstractSymmetricEngine.findEngineByNodeId(nodeId);
            return targetEngine != null && this.isUseSourceStagingEnabled(targetEngine.getParameterService());
        }
        return false;
    }

    private boolean isUseSourceStagingEnabled(IParameterService parameterService) {
        return parameterService.is("incoming.batches.use.source.staging") && !parameterService.is("node.offline") && parameterService.is("stream.to.file.enabled") && (!parameterService.is("cluster.lock.enabled") || parameterService.is("cluster.staging.enabled"));
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date3;
        Date date2;
        Date date1 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxChannelLastUpdateTime"), Date.class, new Object[0]);
        Date date = this.maxDate(date1, date2 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxNodeGroupLastUpdateTime"), Date.class, new Object[0]), date3 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxNodeGroupLinkLastUpdateTime"), Date.class, new Object[0]));
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer channel or group settings were detected");
            }
            this.lastUpdateTime = date;
            this.clearCache();
            return true;
        }
        return false;
    }

    @Override
    public void saveNodeGroupLink(NodeGroupLink link) {
        if (!this.doesNodeGroupExist(link.getSourceNodeGroupId())) {
            this.saveNodeGroup(new NodeGroup(link.getSourceNodeGroupId()));
        }
        if (!this.doesNodeGroupExist(link.getTargetNodeGroupId())) {
            this.saveNodeGroup(new NodeGroup(link.getTargetNodeGroupId()));
        }
        link.setLastUpdateTime(new Date());
        if (this.sqlTemplate.update(this.getSql("updateNodeGroupLinkSql"), new Object[]{link.getDataEventAction().name(), link.isSyncConfigEnabled() ? 1 : 0, link.isSyncSqlEnabled() ? 1 : 0, link.isReversible() ? 1 : 0, link.getLastUpdateTime(), link.getLastUpdateBy(), link.getSourceNodeGroupId(), link.getTargetNodeGroupId()}) <= 0) {
            link.setCreateTime(new Date());
            this.sqlTemplate.update(this.getSql("insertNodeGroupLinkSql"), new Object[]{link.getDataEventAction().name(), link.getSourceNodeGroupId(), link.getTargetNodeGroupId(), link.isSyncConfigEnabled() ? 1 : 0, link.isSyncSqlEnabled() ? 1 : 0, link.isReversible() ? 1 : 0, link.getLastUpdateTime(), link.getLastUpdateBy(), link.getCreateTime()});
        }
        this.clearCache();
    }

    @Override
    public void renameNodeGroupLink(String oldSourceId, String oldTargetId, NodeGroupLink link) {
        this.saveNodeGroupLink(link);
        ISqlTransaction transaction = null;
        try {
            boolean sourceChanged = !oldSourceId.equals(link.getSourceNodeGroupId());
            boolean targetChanged = !oldTargetId.equals(link.getTargetNodeGroupId());
            transaction = this.sqlTemplate.startSqlTransaction();
            if (sourceChanged && targetChanged) {
                transaction.prepareAndExecute(this.getSql("updateConflictGroupsSql"), new Object[]{link.getSourceNodeGroupId(), link.getTargetNodeGroupId(), oldSourceId, oldTargetId});
                transaction.prepareAndExecute(this.getSql("updateLoadFilterGroupsSql"), new Object[]{link.getSourceNodeGroupId(), link.getTargetNodeGroupId(), oldSourceId, oldTargetId});
                transaction.prepareAndExecute(this.getSql("updateRouterGroupsSql"), new Object[]{link.getSourceNodeGroupId(), link.getTargetNodeGroupId(), oldSourceId, oldTargetId});
                transaction.prepareAndExecute(this.getSql("updateTransformGroupsSql"), new Object[]{link.getSourceNodeGroupId(), link.getTargetNodeGroupId(), oldSourceId, oldTargetId});
            }
            if (sourceChanged) {
                transaction.prepareAndExecute(this.getSql("updateConflictSourceGroupSql"), new Object[]{link.getSourceNodeGroupId(), oldSourceId});
                transaction.prepareAndExecute(this.getSql("updateLoadFilterSourceGroupSql"), new Object[]{link.getSourceNodeGroupId(), oldSourceId});
                transaction.prepareAndExecute(this.getSql("updateRouterSourceGroupSql"), new Object[]{link.getSourceNodeGroupId(), oldSourceId});
                transaction.prepareAndExecute(this.getSql("updateTransformSourceGroupSql"), new Object[]{link.getSourceNodeGroupId(), oldSourceId});
            }
            if (targetChanged) {
                transaction.prepareAndExecute(this.getSql("updateConflictTargetGroupSql"), new Object[]{link.getTargetNodeGroupId(), oldTargetId});
                transaction.prepareAndExecute(this.getSql("updateLoadFilterTargetGroupSql"), new Object[]{link.getTargetNodeGroupId(), oldTargetId});
                transaction.prepareAndExecute(this.getSql("updateRouterTargetGroupSql"), new Object[]{link.getTargetNodeGroupId(), oldTargetId});
                transaction.prepareAndExecute(this.getSql("updateTransformTargetGroupSql"), new Object[]{link.getTargetNodeGroupId(), oldTargetId});
            }
            transaction.commit();
        }
        catch (Exception ex) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(transaction);
                throw throwable;
            }
        }
        this.close(transaction);
        this.deleteNodeGroupLink(oldSourceId, oldTargetId);
    }

    public boolean doesNodeGroupExist(String nodeGroupId) {
        boolean exists = false;
        List<NodeGroup> groups = this.getNodeGroups();
        for (NodeGroup nodeGroup : groups) {
            exists |= nodeGroup.getNodeGroupId().equals(nodeGroupId);
        }
        return exists;
    }

    @Override
    public void saveNodeGroup(NodeGroup group) {
        group.setLastUpdateTime(new Date());
        if (this.sqlTemplate.update(this.getSql("updateNodeGroupSql"), new Object[]{group.getDescription(), group.getLastUpdateTime(), group.getLastUpdateBy(), group.getNodeGroupId()}) <= 0) {
            group.setCreateTime(new Date());
            this.sqlTemplate.update(this.getSql("insertNodeGroupSql"), new Object[]{group.getDescription(), group.getNodeGroupId(), group.getLastUpdateTime(), group.getLastUpdateBy(), group.getCreateTime()});
        }
    }

    @Override
    public void deleteNodeGroup(String nodeGroupId) {
        this.sqlTemplate.update(this.getSql("deleteNodeGroupSql"), new Object[]{nodeGroupId});
    }

    @Override
    public void deleteNodeGroupLink(NodeGroupLink link) {
        this.deleteNodeGroupLink(link.getSourceNodeGroupId(), link.getTargetNodeGroupId());
    }

    private void deleteNodeGroupLink(String sourceId, String targetId) {
        this.sqlTemplate.update(this.getSql("deleteNodeGroupLinkSql"), new Object[]{sourceId, targetId});
    }

    @Override
    public void deleteAllNodeGroupLinks() {
        this.sqlTemplate.update(this.getSql("deleteAllNodeGroupLinksSql"), new Object[0]);
    }

    @Override
    public List<NodeGroup> getNodeGroups() {
        return this.sqlTemplate.query(this.getSql("selectNodeGroupsSql"), (ISqlRowMapper)new NodeGroupMapper(), new Object[0]);
    }

    @Override
    public List<NodeGroupLink> getNodeGroupLinks(boolean refreshCache) {
        if (refreshCache) {
            this.nodeService.flushNodeGroupCache();
        }
        return this.cacheManager.getNodeGroupLinks(refreshCache);
    }

    @Override
    public List<NodeGroupLink> getNodeGroupLinksFromDb() {
        String sql = this.getSql("groupsLinksCompatibleSql");
        Table table = this.platform.getTableFromCache(TableConstants.getTableName(this.parameterService.getTablePrefix(), "node_group_link"), false);
        if (table != null && table.findColumn("sync_sql_enabled") != null) {
            sql = this.getSql("groupsLinksSql");
        }
        return this.sqlTemplate.query(sql, (ISqlRowMapper)new NodeGroupLinkMapper(), new Object[0]);
    }

    @Override
    public List<NodeGroupLink> getNodeGroupLinksFor(String sourceNodeGroupId, boolean refreshCache) {
        List<NodeGroupLink> links = this.getNodeGroupLinks(refreshCache);
        ArrayList<NodeGroupLink> target = new ArrayList<NodeGroupLink>(links.size());
        for (NodeGroupLink nodeGroupLink : links) {
            if (!nodeGroupLink.getSourceNodeGroupId().equals(sourceNodeGroupId)) continue;
            target.add(nodeGroupLink);
        }
        return target;
    }

    @Override
    public NodeGroupLink getNodeGroupLinkFor(String sourceNodeGroupId, String targetNodeGroupId, boolean refreshCache) {
        List<NodeGroupLink> links = this.getNodeGroupLinks(refreshCache);
        for (NodeGroupLink nodeGroupLink : links) {
            if (!nodeGroupLink.getTargetNodeGroupId().equals(targetNodeGroupId) || !nodeGroupLink.getSourceNodeGroupId().equals(sourceNodeGroupId)) continue;
            return nodeGroupLink;
        }
        return null;
    }

    @Override
    public boolean isChannelInUse(String channelId) {
        return this.sqlTemplate.queryForInt(this.getSql("isChannelInUseSql"), new Object[]{channelId}) > 0;
    }

    @Override
    public void saveChannel(Channel channel, boolean reloadChannels) {
        channel.setLastUpdateTime(new Date());
        if (0 >= this.sqlTemplate.update(this.getSql("updateChannelSql"), new Object[]{channel.getProcessingOrder(), channel.getMaxBatchSize(), channel.getMaxBatchToSend(), channel.getMaxDataToRoute(), channel.isUseOldDataToRoute() ? 1 : 0, channel.isUseRowDataToRoute() ? 1 : 0, channel.isUsePkDataToRoute() ? 1 : 0, channel.isContainsBigLob() ? 1 : 0, channel.isEnabled() ? 1 : 0, channel.getBatchAlgorithm(), channel.getExtractPeriodMillis(), channel.getDataLoaderType(), channel.getLastUpdateTime(), channel.getLastUpdateBy(), channel.isReloadFlag() ? 1 : 0, channel.isFileSyncFlag() ? 1 : 0, channel.getQueue(), channel.getMaxKBytesPerSecond(), channel.getDataEventAction() == null ? null : channel.getDataEventAction().name(), channel.getDescription(), channel.getChannelId()})) {
            channel.setCreateTime(new Date());
            this.sqlTemplate.update(this.getSql("insertChannelSql"), new Object[]{channel.getChannelId(), channel.getProcessingOrder(), channel.getMaxBatchSize(), channel.getMaxBatchToSend(), channel.getMaxDataToRoute(), channel.isUseOldDataToRoute() ? 1 : 0, channel.isUseRowDataToRoute() ? 1 : 0, channel.isUsePkDataToRoute() ? 1 : 0, channel.isContainsBigLob() ? 1 : 0, channel.isEnabled() ? 1 : 0, channel.getBatchAlgorithm(), channel.getDescription(), channel.getExtractPeriodMillis(), channel.getDataLoaderType(), channel.getLastUpdateTime(), channel.getLastUpdateBy(), channel.getCreateTime(), channel.isReloadFlag() ? 1 : 0, channel.isFileSyncFlag() ? 1 : 0, channel.getQueue(), channel.getMaxKBytesPerSecond(), channel.getDataEventAction() == null ? null : channel.getDataEventAction().name()});
        }
        if (reloadChannels) {
            this.clearCache();
        }
    }

    @Override
    public void saveChannel(NodeChannel nodeChannel, boolean reloadChannels) {
        this.saveChannel(nodeChannel.getChannel(), reloadChannels);
    }

    @Override
    public void saveChannelAsCopy(Channel channel, boolean reloadChannels) {
        String newId = channel.getChannelId();
        List channels = this.sqlTemplate.query(this.getSql("selectChannelsSql", "whereChannelIdLikeSql"), (ISqlRowMapper)new ChannelMapper(), new Object[]{newId + "%"});
        List ids = channels.stream().map(Channel::getChannelId).collect(Collectors.toList());
        Object suffix = "";
        int i = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i;
            ++i;
        }
        channel.setChannelId(newId + (String)suffix);
        this.saveChannel(channel, reloadChannels);
    }

    @Override
    public void renameChannel(String oldId, Channel channel) {
        this.saveChannel(channel, true);
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            transaction.prepareAndExecute(this.getSql("updateConflictChannelSql"), new Object[]{channel.getChannelId(), oldId});
            transaction.prepareAndExecute(this.getSql("updateTriggerChannelSql"), new Object[]{channel.getChannelId(), oldId});
            transaction.prepareAndExecute(this.getSql("updateTriggerReloadChannelSql"), new Object[]{channel.getChannelId(), oldId});
            transaction.prepareAndExecute(this.getSql("updateFileTriggerChannelSql"), new Object[]{channel.getChannelId(), oldId});
            transaction.prepareAndExecute(this.getSql("updateFileTriggerReloadChannelSql"), new Object[]{channel.getChannelId(), oldId});
            transaction.commit();
        }
        catch (Exception ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
        this.deleteChannel(oldId);
    }

    @Override
    public void saveNodeChannel(NodeChannel nodeChannel, boolean reloadChannels) {
        this.saveChannel(nodeChannel.getChannel(), false);
        this.saveNodeChannelControl(nodeChannel, reloadChannels);
    }

    @Override
    public void saveNodeChannelControl(NodeChannel nodeChannel, boolean reloadChannels) {
        if (0 >= this.sqlTemplate.update(this.getSql("updateNodeChannelControlSql"), new Object[]{nodeChannel.isSuspendEnabled() ? 1 : 0, nodeChannel.isIgnoreEnabled() ? 1 : 0, nodeChannel.getLastExtractTime(), nodeChannel.getNodeId(), nodeChannel.getChannelId()})) {
            this.sqlTemplate.update(this.getSql("insertNodeChannelControlSql"), new Object[]{nodeChannel.getNodeId(), nodeChannel.getChannelId(), nodeChannel.isSuspendEnabled() ? 1 : 0, nodeChannel.isIgnoreEnabled() ? 1 : 0, nodeChannel.getLastExtractTime()});
        }
        if (reloadChannels) {
            this.clearCache();
        }
    }

    @Override
    public void deleteChannel(Channel channel) {
        this.deleteChannel(channel.getChannelId());
    }

    private void deleteChannel(String id) {
        this.sqlTemplate.update(this.getSql("deleteNodeChannelSql"), new Object[]{id});
        this.sqlTemplate.update(this.getSql("deleteChannelSql"), new Object[]{id});
        this.clearCache();
    }

    @Override
    public void deleteNodeChannelControl(String nodeId, String channelId) {
        this.sqlTemplate.update(this.getSql("deleteNodeChannelControlSql"), new Object[]{nodeId, channelId});
        this.clearCache();
    }

    @Override
    public void deleteAllChannels() {
        this.sqlTemplate.update(this.getSql("deleteAllChannelsSql"), new Object[0]);
        this.clearCache();
    }

    @Override
    public NodeChannel getNodeChannel(String channelId, boolean refreshExtractMillis) {
        return this.getNodeChannel(channelId, this.nodeService.findIdentityNodeId(), refreshExtractMillis);
    }

    @Override
    public NodeChannel getNodeChannel(String channelId, String nodeId, boolean refreshExtractMillis) {
        List<NodeChannel> channels = this.getNodeChannels(nodeId, refreshExtractMillis);
        for (NodeChannel nodeChannel : channels) {
            if (!nodeChannel.getChannelId().equals(channelId)) continue;
            return nodeChannel;
        }
        return null;
    }

    @Override
    public List<NodeChannel> getNodeChannels(boolean refreshExtractMillis) {
        return this.getNodeChannels(this.nodeService.findIdentityNodeId(), refreshExtractMillis);
    }

    @Override
    public List<NodeChannel> getNodeChannels(String nodeId, boolean refreshExtractMillis) {
        List<NodeChannel> nodeChannels;
        boolean loaded = false;
        if (nodeId != null) {
            long origNodeChannelCacheTime = this.cacheManager.getNodeChannelCacheTime();
            nodeChannels = this.cacheManager.getNodeChannels(nodeId);
            long nodeChannelCacheTime = this.cacheManager.getNodeChannelCacheTime();
            if (nodeChannelCacheTime != origNodeChannelCacheTime) {
                loaded = true;
            }
        } else {
            nodeChannels = new ArrayList<NodeChannel>(0);
        }
        if (!loaded && refreshExtractMillis) {
            final HashMap<String, NodeChannel> nodeChannelsMap = new HashMap<String, NodeChannel>();
            boolean usingExtractPeriod = false;
            for (NodeChannel nc : nodeChannels) {
                nodeChannelsMap.put(nc.getChannelId(), nc);
                usingExtractPeriod |= nc.getExtractPeriodMillis() > 0L;
            }
            if (usingExtractPeriod) {
                this.sqlTemplate.query(this.getSql("selectNodeChannelControlSql"), (ISqlRowMapper)new ISqlRowMapper<Object>(){

                    public Object mapRow(Row row) {
                        String channelId = row.getString("channel_id");
                        Date extractTime = row.getDateTime("last_extract_time");
                        NodeChannel nodeChannel = (NodeChannel)nodeChannelsMap.get(channelId);
                        if (nodeChannel != null) {
                            nodeChannel.setLastExtractTime(extractTime);
                        }
                        return nodeChannelsMap;
                    }
                }, new Object[]{nodeId});
            }
        }
        return nodeChannels;
    }

    @Override
    public List<NodeChannel> getNodeChannelsFromDb(String nodeId) {
        List nodeChannels = this.sqlTemplate.query(this.getSql("selectNodeChannelsSql"), (ISqlRowMapper)new NodeChannelMapper(nodeId), new Object[0]);
        List nodeChannelControls = this.sqlTemplate.query(this.getSql("selectNodeChannelControlSql"), (ISqlRowMapper)new ISqlRowMapper<NodeChannel>(){

            public NodeChannel mapRow(Row row) {
                NodeChannel nodeChannel = new NodeChannel();
                nodeChannel.setChannelId(row.getString("channel_id"));
                nodeChannel.setLastExtractTime(row.getDateTime("last_extract_time"));
                nodeChannel.setIgnoreEnabled(row.getBoolean("ignore_enabled"));
                nodeChannel.setSuspendEnabled(row.getBoolean("suspend_enabled"));
                return nodeChannel;
            }
        }, new Object[]{nodeId});
        for (NodeChannel nodeChannelControl : nodeChannelControls) {
            for (NodeChannel nodeChannel : nodeChannels) {
                if (!nodeChannel.getChannelId().equals(nodeChannelControl.getChannelId())) continue;
                nodeChannel.setIgnoreEnabled(nodeChannelControl.isIgnoreEnabled());
                nodeChannel.setSuspendEnabled(nodeChannelControl.isSuspendEnabled());
                nodeChannel.setLastExtractTime(nodeChannelControl.getLastExtractTime());
            }
        }
        return nodeChannels;
    }

    @Override
    public void clearCache() {
        this.cacheManager.flushNodeChannels();
        this.cacheManager.flushChannels();
        this.cacheManager.flushNodeGroupLinks();
        this.cacheManager.flushNodeGroupChannelWindows();
    }

    @Override
    public NodeGroupLinkAction getDataEventActionByGroupLinkId(String sourceGroupId, String targetGroupId) {
        String code = (String)this.sqlTemplate.queryForObject(this.getSql("selectDataEventActionsByIdSql"), String.class, new Object[]{sourceGroupId, targetGroupId});
        return NodeGroupLinkAction.fromCode(code);
    }

    @Override
    public void initDefaultChannels() {
        if (this.defaultChannels != null) {
            this.clearCache();
            this.createDefaultChannels();
            List<NodeChannel> channels = this.getNodeChannels(false);
            for (Channel defaultChannel : this.defaultChannels.values()) {
                Channel channel = defaultChannel.findInList(channels);
                if (channel == null) {
                    this.log.info("Auto-configuring {} channel", (Object)defaultChannel.getChannelId());
                    this.saveChannel(defaultChannel, true);
                    continue;
                }
                if (channel.getChannelId().equals("reload") && !channel.isReloadFlag()) {
                    this.log.info("Setting reload flag on reload channel");
                    channel.setReloadFlag(true);
                    this.saveChannel(channel, true);
                    continue;
                }
                if (channel.getChannelId().equals("filesync") && !channel.isFileSyncFlag()) {
                    this.log.info("Setting file sync flag on file sync channel");
                    channel.setFileSyncFlag(true);
                    this.saveChannel(channel, true);
                    continue;
                }
                if (!(!channel.getChannelId().equals("filesync_reload") || channel.isFileSyncFlag() && channel.isReloadFlag())) {
                    this.log.info("Setting reload and file sync flag on file sync reload channel");
                    channel.setFileSyncFlag(true);
                    this.saveChannel(channel, true);
                    continue;
                }
                this.log.debug("No need to create channel {}.  It already exists", (Object)defaultChannel.getChannelId());
            }
            this.clearCache();
        }
    }

    @Override
    public List<NodeGroupChannelWindow> getNodeGroupChannelWindows(String notUsed, String channelId) {
        return this.cacheManager.getNodeGroupChannelWindows().get(channelId);
    }

    @Override
    public Map<String, List<NodeGroupChannelWindow>> getNodeGroupChannelWindowsFromDb() {
        HashMap<String, List<NodeGroupChannelWindow>> channelWindowsByChannel = new HashMap<String, List<NodeGroupChannelWindow>>();
        String nodeGroupId = this.parameterService.getNodeGroupId();
        Set<String> channelIds = this.getChannels(false).keySet();
        for (String id : channelIds) {
            channelWindowsByChannel.put(id, this.sqlTemplate.query(this.getSql("selectNodeGroupChannelWindowSql"), (ISqlRowMapper)new NodeGroupChannelWindowMapper(), new Object[]{nodeGroupId, id}));
        }
        return channelWindowsByChannel;
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists(String nodeId) {
        ChannelMap map = new ChannelMap();
        List<NodeChannel> ncs = this.getNodeChannels(nodeId, true);
        if (ncs != null) {
            for (NodeChannel nc : ncs) {
                if (nc.isSuspendEnabled()) {
                    map.addSuspendChannels(nc.getChannelId());
                }
                if (!nc.isIgnoreEnabled()) continue;
                map.addIgnoreChannels(nc.getChannelId());
            }
        }
        return map;
    }

    @Override
    public List<Channel> getFileSyncChannels() {
        ArrayList<Channel> list = new ArrayList<Channel>(this.getChannels(false).values());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Channel channel = (Channel)it.next();
            if (channel.isFileSyncFlag()) continue;
            it.remove();
        }
        return list;
    }

    @Override
    public Map<String, Channel> getChannels(boolean refreshCache) {
        return this.cacheManager.getChannels(refreshCache);
    }

    @Override
    public Collection<String> getQueues(boolean refreshCache) {
        return this.cacheManager.getQueues(refreshCache);
    }

    @Override
    public Map<String, Channel> getChannelsFromDb() {
        HashMap<String, Channel> channels = new HashMap<String, Channel>();
        List list = this.sqlTemplate.query(this.getSql("selectChannelsSql", "orderChannelsBySql"), (ISqlRowMapper)new ChannelMapper(), new Object[0]);
        for (Channel channel : list) {
            channels.put(channel.getChannelId(), channel);
        }
        return channels;
    }

    @Override
    public Channel getChannel(String channelId) {
        NodeChannel nodeChannel = this.getNodeChannel(channelId, false);
        if (nodeChannel != null) {
            return nodeChannel.getChannel();
        }
        return null;
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists() {
        return this.getSuspendIgnoreChannelLists(this.nodeService.findIdentityNodeId());
    }

    @Override
    public Map<String, String> getRegistrationRedirectMap() {
        return this.sqlTemplate.queryForMap(this.getSql("getRegistrationRedirectSql"), "registrant_external_id", "registration_node_id", new Object[0]);
    }

    @Override
    public void updateLastExtractTime(NodeChannel channel) {
        this.sqlTemplate.update(this.getSql("updateNodeChannelLastExtractTime"), new Object[]{channel.getLastExtractTime(), channel.getChannelId(), channel.getNodeId()});
    }

    static class NodeGroupMapper
    implements ISqlRowMapper<NodeGroup> {
        NodeGroupMapper() {
        }

        public NodeGroup mapRow(Row row) {
            NodeGroup group = new NodeGroup();
            group.setNodeGroupId(row.getString("node_group_id"));
            group.setDescription(row.getString("description"));
            group.setCreateTime(row.getDateTime("create_time"));
            group.setLastUpdateBy(row.getString("last_update_by"));
            group.setLastUpdateTime(row.getDateTime("last_update_time"));
            return group;
        }
    }

    static class NodeGroupLinkMapper
    implements ISqlRowMapper<NodeGroupLink> {
        NodeGroupLinkMapper() {
        }

        public NodeGroupLink mapRow(Row row) {
            NodeGroupLink link = new NodeGroupLink();
            link.setSourceNodeGroupId(row.getString("source_node_group_id"));
            link.setTargetNodeGroupId(row.getString("target_node_group_id"));
            link.setDataEventAction(NodeGroupLinkAction.fromCode(row.getString("data_event_action")));
            link.setSyncConfigEnabled(row.getBoolean("sync_config_enabled"));
            if (row.containsKey((Object)"sync_sql_enabled")) {
                link.setSyncSqlEnabled(row.getBoolean("sync_sql_enabled"));
            }
            link.setReversible(row.getBoolean("is_reversible"));
            link.setCreateTime(row.getDateTime("create_time"));
            link.setLastUpdateBy(row.getString("last_update_by"));
            link.setLastUpdateTime(row.getDateTime("last_update_time"));
            return link;
        }
    }

    static class ChannelMapper
    implements ISqlRowMapper<Channel> {
        ChannelMapper() {
        }

        public Channel mapRow(Row row) {
            Channel channel = new Channel();
            channel.setChannelId(row.getString("channel_id"));
            channel.setProcessingOrder(row.getInt("processing_order"));
            channel.setMaxBatchSize(row.getInt("max_batch_size"));
            channel.setEnabled(row.getBoolean("enabled"));
            channel.setMaxBatchToSend(row.getInt("max_batch_to_send"));
            channel.setMaxDataToRoute(row.getInt("max_data_to_route"));
            channel.setUseOldDataToRoute(row.getBoolean("use_old_data_to_route"));
            channel.setUseRowDataToRoute(row.getBoolean("use_row_data_to_route"));
            channel.setUsePkDataToRoute(row.getBoolean("use_pk_data_to_route"));
            channel.setContainsBigLob(row.getBoolean("contains_big_lob"));
            channel.setBatchAlgorithm(row.getString("batch_algorithm"));
            channel.setExtractPeriodMillis(row.getLong("extract_period_millis"));
            channel.setDataLoaderType(row.getString("data_loader_type"));
            channel.setCreateTime(row.getDateTime("create_time"));
            channel.setLastUpdateBy(row.getString("last_update_by"));
            channel.setLastUpdateTime(row.getDateTime("last_update_time"));
            channel.setReloadFlag(row.getBoolean("reload_flag"));
            channel.setFileSyncFlag(row.getBoolean("file_sync_flag"));
            channel.setQueue(row.getString("queue"));
            channel.setMaxKBytesPerSecond(row.getBigDecimal("max_network_kbps"));
            channel.setDataEventAction(NodeGroupLinkAction.fromCode(row.getString("data_event_action")));
            if (row.containsKey((Object)"description")) {
                channel.setDescription(row.getString("description"));
            }
            return channel;
        }
    }

    static class NodeChannelMapper
    implements ISqlRowMapper<NodeChannel> {
        String nodeId;

        public NodeChannelMapper(String nodeId) {
            this.nodeId = nodeId;
        }

        public NodeChannel mapRow(Row row) {
            NodeChannel nodeChannel = new NodeChannel();
            nodeChannel.setChannelId(row.getString("channel_id"));
            nodeChannel.setNodeId(this.nodeId);
            nodeChannel.setProcessingOrder(row.getInt("processing_order"));
            nodeChannel.setMaxBatchSize(row.getInt("max_batch_size"));
            nodeChannel.setEnabled(row.getBoolean("enabled"));
            nodeChannel.setMaxBatchToSend(row.getInt("max_batch_to_send"));
            nodeChannel.setMaxDataToRoute(row.getInt("max_data_to_route"));
            nodeChannel.setUseOldDataToRoute(row.getBoolean("use_old_data_to_route"));
            nodeChannel.setUseRowDataToRoute(row.getBoolean("use_row_data_to_route"));
            nodeChannel.setUsePkDataToRoute(row.getBoolean("use_pk_data_to_route"));
            nodeChannel.setContainsBigLob(row.getBoolean("contains_big_lob"));
            nodeChannel.setBatchAlgorithm(row.getString("batch_algorithm"));
            nodeChannel.setExtractPeriodMillis(row.getLong("extract_period_millis"));
            nodeChannel.setDataLoaderType(row.getString("data_loader_type"));
            nodeChannel.setCreateTime(row.getDateTime("create_time"));
            nodeChannel.setLastUpdateBy(row.getString("last_update_by"));
            nodeChannel.setLastUpdateTime(row.getDateTime("last_update_time"));
            nodeChannel.setFileSyncFlag(row.getBoolean("file_sync_flag"));
            nodeChannel.setReloadFlag(row.getBoolean("reload_flag"));
            nodeChannel.setQueue(row.getString("queue"));
            nodeChannel.setMaxKBytesPerSecond(row.getBigDecimal("max_network_kbps"));
            nodeChannel.setDataEventAction(NodeGroupLinkAction.fromCode(row.getString("data_event_action")));
            return nodeChannel;
        }
    }

    static class NodeGroupChannelWindowMapper
    implements ISqlRowMapper<NodeGroupChannelWindow> {
        NodeGroupChannelWindowMapper() {
        }

        public NodeGroupChannelWindow mapRow(Row row) {
            NodeGroupChannelWindow window = new NodeGroupChannelWindow();
            window.setNodeGroupId(row.getString("node_group_id"));
            window.setChannelId(row.getString("channel_id"));
            window.setStartTime(row.getTime("start_time"));
            window.setEndTime(row.getTime("end_time"));
            window.setEnabled(row.getBoolean("enabled"));
            return window;
        }
    }
}

