/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.UniqueKeyException;
import org.jumpmind.db.sql.mapper.DateMapper;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.BatchId;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.IncomingBatchSummary;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.IncomingBatchServiceSqlMap;
import org.jumpmind.util.FormatUtils;

public class IncomingBatchService
extends AbstractService
implements IIncomingBatchService {
    protected IClusterService clusterService;
    protected Map<String, Collection<String>> readyQueuesCache = new HashMap<String, Collection<String>>();

    @Override
    public List<String> getNodesInError() {
        return this.sqlTemplate.query(this.getSql("selectNodesInErrorSql"), (ISqlRowMapper)new StringMapper(), new Object[0]);
    }

    public IncomingBatchService(IParameterService parameterService, ISymmetricDialect symmetricDialect, IClusterService clusterService) {
        super(parameterService, symmetricDialect);
        this.clusterService = clusterService;
        this.setSqlMap(new IncomingBatchServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public void refreshIncomingBatch(IncomingBatch batch) {
        this.sqlTemplate.queryForObject(this.getSql("selectIncomingBatchPrefixSql", "findIncomingBatchSql"), (ISqlRowMapper)new IncomingBatchMapper(batch), new Object[]{batch.getBatchId(), batch.getNodeId()});
    }

    @Override
    public IncomingBatch findIncomingBatch(long batchId, String nodeId) {
        if (nodeId != null) {
            return (IncomingBatch)this.sqlTemplate.queryForObject(this.getSql("selectIncomingBatchPrefixSql", "findIncomingBatchSql"), (ISqlRowMapper)new IncomingBatchMapper(), new Object[]{batchId, nodeId});
        }
        return (IncomingBatch)this.sqlTemplate.queryForObject(this.getSql("selectIncomingBatchPrefixSql", "findIncomingBatchByBatchIdSql"), (ISqlRowMapper)new IncomingBatchMapper(), new Object[]{batchId});
    }

    @Override
    public int countIncomingBatchesInError() {
        return this.sqlTemplateDirty.queryForInt(this.getSql("countIncomingBatchesErrorsSql"), new Object[0]);
    }

    @Override
    public int countIncomingBatchesInError(String channelId) {
        return this.sqlTemplateDirty.queryForInt(this.getSql("countIncomingBatchesErrorsOnChannelSql"), new Object[]{channelId});
    }

    @Override
    public Date getIncomingBatchesLatestUpdateSql() {
        return (Date)this.sqlTemplateDirty.queryForObject(this.getSql("getIncomingBatchesLatestUpdateSql"), Date.class, new Object[0]);
    }

    @Override
    public List<IncomingBatch> findIncomingBatchErrors(int maxRows) {
        return this.sqlTemplateDirty.query(this.getSql("selectIncomingBatchPrefixSql", "findIncomingBatchErrorsSql"), maxRows, (ISqlRowMapper)new IncomingBatchMapper(), new Object[0]);
    }

    @Override
    public void markIncomingBatchesOk(String nodeId) {
        List<IncomingBatch> batches = this.listIncomingBatchesInErrorFor(nodeId);
        for (IncomingBatch incomingBatch : batches) {
            if (this.isRecordOkBatchesEnabled()) {
                incomingBatch.setErrorFlag(false);
                incomingBatch.setStatus(AbstractBatch.Status.OK);
                this.updateIncomingBatch(incomingBatch);
                continue;
            }
            this.deleteIncomingBatch(incomingBatch);
        }
    }

    @Override
    public void removingIncomingBatches(String nodeId) {
        this.sqlTemplate.update(this.getSql("deleteIncomingBatchByNodeSql"), new Object[]{nodeId});
    }

    @Override
    public List<IncomingBatch> listIncomingBatchesInErrorFor(String nodeId) {
        return this.sqlTemplate.query(this.getSql("selectIncomingBatchPrefixSql", "listIncomingBatchesInErrorForNodeSql"), (ISqlRowMapper)new IncomingBatchMapper(), new Object[]{nodeId});
    }

    @Override
    public boolean isRecordOkBatchesEnabled() {
        boolean enabled = true;
        if (!this.parameterService.is("incoming.batches.record.ok.enabled", true)) {
            enabled = false;
        }
        if (this.parameterService.is("incoming.batch.delete.on.load", false)) {
            enabled = false;
        }
        return enabled;
    }

    @Override
    public List<Date> listIncomingBatchTimes(List<String> nodeIds, List<String> channels, List<AbstractBatch.Status> statuses, List<Long> loads, boolean ascending) {
        String whereClause = this.buildBatchWhere(nodeIds, channels, statuses, loads, null);
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
        params.put("NODES", nodeIds);
        params.put("CHANNELS", channels);
        params.put("STATUSES", this.toStringList(statuses));
        params.put("LOADS", loads);
        String sql = this.getSql("selectCreateTimePrefixSql", whereClause, ascending ? " order by create_time" : " order by create_time desc");
        return this.sqlTemplate.query(sql, (ISqlRowMapper)new DateMapper(), params);
    }

    @Override
    public List<IncomingBatch> listIncomingBatches(List<String> nodeIds, List<String> channels, List<AbstractBatch.Status> statuses, List<Long> loads, Date startAtCreateTime, Date startAtLastUpdateTime, int maxRowsToRetrieve, boolean ascending) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("NODES", nodeIds);
        params.put("CHANNELS", channels);
        params.put("STATUSES", this.toStringList(statuses));
        params.put("CREATE_TIME", startAtCreateTime);
        params.put("LAST_UPDATE_TIME", startAtLastUpdateTime);
        params.put("LOADS", loads);
        String where = this.buildBatchWhere(nodeIds, channels, statuses, loads, startAtLastUpdateTime);
        Object createTimeLimiter = "";
        if (startAtCreateTime != null) {
            if (StringUtils.isBlank((CharSequence)where)) {
                where = " where 1=1 ";
            }
            createTimeLimiter = " and create_time " + (ascending ? ">=" : "<=") + " :CREATE_TIME";
        }
        String sql = this.getSql(new String[]{"selectIncomingBatchPrefixSql", where, createTimeLimiter, ascending ? " order by create_time" : " order by create_time desc"});
        return this.sqlTemplateDirty.query(sql, maxRowsToRetrieve, (ISqlRowMapper)new IncomingBatchMapper(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IncomingBatch> listIncomingBatchesWithLimit(int offset, int limit, List<FilterCriterion> filter, String orderColumn, String orderDirection) {
        List batchList;
        String where = filter != null ? this.buildBatchWhereFromFilter(filter) : null;
        Map<Object, Object> params = filter != null ? this.buildBatchParams(filter) : new HashMap();
        String orderBy = this.buildBatchOrderBy(orderColumn, orderDirection);
        String sql = this.getSql("selectIncomingBatchPrefixSql", where, orderBy);
        if (this.platform.supportsLimitOffset()) {
            sql = this.platform.massageForLimitOffset(sql, limit, offset);
            batchList = this.sqlTemplateDirty.query(sql, Integer.MAX_VALUE, (ISqlRowMapper)new IncomingBatchMapper(), params);
        } else {
            try (ISqlReadCursor cursor = this.sqlTemplateDirty.queryForCursor(sql, (ISqlRowMapper)new IncomingBatchMapper(), params);){
                IncomingBatch next = null;
                batchList = new ArrayList();
                int rowCount = 0;
                do {
                    if ((next = (IncomingBatch)cursor.next()) != null) {
                        if (offset <= rowCount && rowCount < limit + offset) {
                            batchList.add((IncomingBatch)next);
                        }
                        ++rowCount;
                    }
                    if (rowCount < limit + offset) continue;
                    break;
                } while (next != null);
            }
        }
        int maxBatches = this.parameterService.getInt("batch.screen.max.to.select");
        int batchesToReturn = maxBatches - offset;
        if (maxBatches > 0 && limit + offset > maxBatches && batchesToReturn < batchList.size() - 1) {
            batchList = batchList.subList(0, batchesToReturn);
        }
        return batchList;
    }

    @Override
    public int countIncomingBatchesWithLimit(List<FilterCriterion> filter) {
        String where = filter != null ? this.buildBatchWhereFromFilter(filter) : null;
        Map<Object, Object> params = filter != null ? this.buildBatchParams(filter) : new HashMap();
        String sql = this.getSql("selectCountBatchesPrefixSql", where);
        int count = this.sqlTemplateDirty.queryForInt(sql, params);
        int maxBatches = this.parameterService.getInt("batch.screen.max.to.select");
        return maxBatches > 0 ? Math.min(count, maxBatches) : count;
    }

    protected boolean containsOnlyErrorStatus(List<AbstractBatch.Status> statuses) {
        return statuses.size() == 1 && statuses.get(0) == AbstractBatch.Status.ER;
    }

    protected List<String> toStringList(List<AbstractBatch.Status> statuses) {
        ArrayList<String> statusStrings = new ArrayList<String>(statuses.size());
        for (AbstractBatch.Status status : statuses) {
            statusStrings.add(status.name());
        }
        return statusStrings;
    }

    @Override
    public boolean acquireIncomingBatch(IncomingBatch batch) {
        boolean okayToProcess = true;
        if (batch.isPersistable()) {
            IncomingBatch existingBatch = null;
            if (this.isRecordOkBatchesEnabled()) {
                try {
                    this.insertIncomingBatch(batch);
                }
                catch (UniqueKeyException e) {
                    batch.setRetry(true);
                    existingBatch = this.findIncomingBatch(batch.getBatchId(), batch.getNodeId());
                }
            } else {
                existingBatch = this.findIncomingBatch(batch.getBatchId(), batch.getNodeId());
                if (existingBatch != null) {
                    batch.setRetry(true);
                }
            }
            if (batch.isRetry()) {
                if (existingBatch.getStatus() == AbstractBatch.Status.ER || existingBatch.getStatus() == AbstractBatch.Status.LD || existingBatch.getStatus() == AbstractBatch.Status.RS || !this.parameterService.is("incoming.batches.skip.duplicates")) {
                    okayToProcess = true;
                    batch.setErrorFlag(existingBatch.isErrorFlag());
                    batch.setFailedLineNumber(existingBatch.getFailedLineNumber());
                    batch.setFailedRowNumber(existingBatch.getFailedRowNumber());
                    existingBatch.setStatus(AbstractBatch.Status.LD);
                    this.log.info("Retrying batch {}", (Object)batch.getNodeBatchId());
                } else if (existingBatch.getStatus() == AbstractBatch.Status.IG) {
                    okayToProcess = false;
                    batch.setStatus(AbstractBatch.Status.OK);
                    batch.incrementIgnoreCount();
                    existingBatch.setStatus(AbstractBatch.Status.OK);
                    existingBatch.incrementIgnoreCount();
                    this.log.info("Ignoring batch {}", (Object)batch.getNodeBatchId());
                } else {
                    okayToProcess = false;
                    batch.setStatus(existingBatch.getStatus());
                    batch.setByteCount(existingBatch.getByteCount());
                    batch.setLoadMillis(existingBatch.getLoadMillis());
                    batch.setNetworkMillis(existingBatch.getNetworkMillis());
                    batch.setFilterMillis(existingBatch.getFilterMillis());
                    batch.setSkipCount(existingBatch.getSkipCount() + 1L);
                    batch.setLoadRowCount(existingBatch.getLoadRowCount());
                    existingBatch.setSkipCount(existingBatch.getSkipCount() + 1L);
                    this.log.info("Skipping batch {} that was already loaded", (Object)batch.getNodeBatchId());
                }
                this.updateIncomingBatch(existingBatch);
            }
        }
        return okayToProcess;
    }

    @Override
    public void insertIncomingBatch(ISqlTransaction transaction, IncomingBatch batch) {
        if (batch.isPersistable()) {
            boolean alreadyExists = false;
            if ((this.symmetricDialect.getName().equals("redshift") || this.symmetricDialect.getDriverName() != null && this.symmetricDialect.getDriverName().equalsIgnoreCase("openedge")) && this.findIncomingBatch(batch.getBatchId(), batch.getNodeId()) != null) {
                alreadyExists = true;
            }
            if (!alreadyExists) {
                batch.setLastUpdatedHostName(this.clusterService.getServerId());
                batch.setLastUpdatedTime(new Date());
                transaction.prepareAndExecute(this.getSql("insertIncomingBatchSql"), new Object[]{batch.getBatchId(), batch.getNodeId(), batch.getChannelId(), batch.getStatus().name(), batch.getNetworkMillis(), batch.getFilterMillis(), batch.getLoadMillis(), batch.getFailedRowNumber(), batch.getFailedLineNumber(), batch.getByteCount(), batch.getLoadRowCount(), batch.getFallbackInsertCount(), batch.getFallbackUpdateCount(), batch.getConflictWinCount(), batch.getConflictLoseCount(), batch.getIgnoreCount(), batch.getIgnoreRowCount(), batch.getMissingDeleteCount(), batch.getSkipCount(), batch.getSqlState(), batch.getSqlCode(), FormatUtils.abbreviateForLogging((String)batch.getSqlMessage()), batch.getLastUpdatedHostName(), new Date(), batch.getSummary(), new Date(), batch.isLoadFlag(), batch.getExtractCount(), batch.getSentCount(), batch.getLoadCount(), batch.getLoadId(), batch.isCommonFlag(), batch.getRouterMillis(), batch.getExtractMillis(), batch.getTransformExtractMillis(), batch.getTransformLoadMillis(), batch.getReloadRowCount(), batch.getOtherRowCount(), batch.getDataRowCount(), batch.getDataInsertRowCount(), batch.getDataUpdateRowCount(), batch.getDataDeleteRowCount(), batch.getExtractRowCount(), batch.getExtractInsertRowCount(), batch.getExtractUpdateRowCount(), batch.getLoadInsertRowCount(), batch.getLoadUpdateRowCount(), batch.getLoadDeleteRowCount(), batch.getExtractDeleteRowCount(), batch.getFailedDataId()}, new int[]{2, 12, 12, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 12, 2, 12, 12, 93, 12, 93, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2});
            }
        }
    }

    @Override
    public void insertIncomingBatch(IncomingBatch batch) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.insertIncomingBatch(transaction, batch);
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public int deleteIncomingBatch(IncomingBatch batch) {
        return this.sqlTemplate.update(this.getSql("deleteIncomingBatchSql"), new Object[]{batch.getBatchId(), batch.getNodeId()}, new int[]{this.symmetricDialect.getSqlTypeForIds(), 12});
    }

    @Override
    public int updateIncomingBatch(IncomingBatch batch) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            int count = this.updateIncomingBatch(transaction, batch);
            transaction.commit();
            int n = count;
            return n;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public int updateIncomingBatch(ISqlTransaction transaction, IncomingBatch batch) {
        int count = 0;
        if (batch.isPersistable()) {
            Object sql = this.getSql("updateIncomingBatchSql");
            if (batch.getStatus() == AbstractBatch.Status.OK) {
                batch.setErrorFlag(false);
                batch.setFailedDataId(0L);
                batch.setFailedLineNumber(0L);
                batch.setFailedRowNumber(0L);
            } else {
                sql = (String)sql + this.getSql("statusNotOk");
            }
            batch.setLastUpdatedHostName(this.clusterService.getServerId());
            count = transaction.prepareAndExecute((String)sql, new Object[]{batch.getStatus().name(), batch.isErrorFlag() ? 1 : 0, batch.getNetworkMillis(), batch.getFilterMillis(), batch.getLoadMillis(), batch.getFailedRowNumber(), batch.getFailedLineNumber(), batch.getByteCount(), batch.getLoadRowCount(), batch.getFallbackInsertCount(), batch.getFallbackUpdateCount(), batch.getConflictWinCount(), batch.getConflictLoseCount(), batch.getIgnoreCount(), batch.getIgnoreRowCount(), batch.getMissingDeleteCount(), batch.getSkipCount(), batch.getSqlState(), batch.getSqlCode(), FormatUtils.abbreviateForLogging((String)batch.getSqlMessage()), batch.getLastUpdatedHostName(), new Date(), batch.getSummary(), batch.isLoadFlag(), batch.getExtractCount(), batch.getSentCount(), batch.getLoadCount(), batch.getLoadId(), batch.isCommonFlag(), batch.getRouterMillis(), batch.getExtractMillis(), batch.getTransformExtractMillis(), batch.getTransformLoadMillis(), batch.getReloadRowCount(), batch.getOtherRowCount(), batch.getDataRowCount(), batch.getDataInsertRowCount(), batch.getDataUpdateRowCount(), batch.getDataDeleteRowCount(), batch.getExtractRowCount(), batch.getExtractInsertRowCount(), batch.getExtractUpdateRowCount(), batch.getExtractDeleteRowCount(), batch.getLoadInsertRowCount(), batch.getLoadUpdateRowCount(), batch.getLoadDeleteRowCount(), batch.getFailedDataId(), batch.isBulkLoaderFlag(), batch.getBatchId(), batch.getNodeId()}, new int[]{1, 5, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 12, 2, 12, 12, 93, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, this.symmetricDialect.getSqlTypeForIds(), 12});
        }
        return count;
    }

    @Override
    public Map<String, BatchId> findMaxBatchIdsByChannel() {
        HashMap<String, BatchId> ids = new HashMap<String, BatchId>();
        this.sqlTemplate.query(this.getSql("maxBatchIdsSql"), (ISqlRowMapper)new BatchIdMapper(ids), new Object[]{AbstractBatch.Status.OK.name()});
        return ids;
    }

    @Override
    public List<IncomingBatchSummary> findIncomingBatchSummaryByNode(String nodeId, Date sinceCreateTime, AbstractBatch.Status ... statuses) {
        Object[] args = new Object[statuses.length + 1];
        args[args.length - 1] = nodeId;
        StringBuilder inList = this.buildStatusList(args, statuses);
        String sql = this.getSql("selectIncomingBatchSummaryPrefixSql", "selectIncomingBatchSummaryStatsPrefixSql", "whereStatusAndNodeGroupByStatusSql").replace(":STATUS_LIST", inList.substring(0, inList.length() - 1));
        return this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new IncomingBatchSummaryMapper(false, false), args);
    }

    protected StringBuilder buildStatusList(Object[] args, AbstractBatch.Status ... statuses) {
        StringBuilder inList = new StringBuilder();
        for (int i = 0; i < statuses.length; ++i) {
            args[i] = statuses[i].name();
            inList.append("?,");
        }
        return inList;
    }

    @Override
    public List<IncomingBatchSummary> findIncomingBatchSummaryByChannel(AbstractBatch.Status ... statuses) {
        Object[] args = new Object[statuses.length];
        StringBuilder inList = this.buildStatusList(args, statuses);
        String sql = this.getSql("selectIncomingBatchSummaryByNodeAndChannelPrefixSql", "selectIncomingBatchSummaryStatsPrefixSql", "whereStatusGroupByStatusAndNodeAndChannelSql").replace(":STATUS_LIST", inList.substring(0, inList.length() - 1));
        return this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new IncomingBatchSummaryMapper(true, true), args);
    }

    @Override
    public List<IncomingBatchSummary> findIncomingBatchSummary(AbstractBatch.Status ... statuses) {
        Object[] args = new Object[statuses.length];
        StringBuilder inList = this.buildStatusList(args, statuses);
        String sql = this.getSql("selectIncomingBatchSummaryByNodePrefixSql", "selectIncomingBatchSummaryStatsPrefixSql", "whereStatusGroupByStatusAndNodeSql").replace(":STATUS_LIST", inList.substring(0, inList.length() - 1));
        return this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new IncomingBatchSummaryMapper(true, false), args);
    }

    @Override
    public List<IncomingBatchSummary> findIncomingBatchSummaryByNodeAndChannel(String nodeId, String channelId, Date sinceCreateTime, AbstractBatch.Status ... statuses) {
        Object[] args = new Object[statuses.length + 2];
        args[args.length - 1] = nodeId;
        args[args.length - 2] = channelId;
        StringBuilder inList = this.buildStatusList(args, statuses);
        String sql = this.getSql("selectIncomingBatchSummaryPrefixSql", "selectIncomingBatchSummaryStatsPrefixSql", "whereStatusAndNodeAndChannelGroupByStatusSql").replace(":STATUS_LIST", inList.substring(0, inList.length() - 1));
        return this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new IncomingBatchSummaryMapper(false, false), args);
    }

    @Override
    public Map<String, Date> findLastUpdatedByChannel() {
        HashMap<String, Date> captureMap = new HashMap<String, Date>();
        LastCaptureByChannelMapper mapper = new LastCaptureByChannelMapper(captureMap);
        this.sqlTemplate.query(this.getSql("lastUpdateByChannelSql"), (ISqlRowMapper)mapper, new Object[0]);
        return mapper.getCaptureMap();
    }

    @Override
    public List<BatchId> getAllBatches() {
        return this.sqlTemplateDirty.query(this.getSql("getAllBatchesSql"), (ISqlRowMapper)new BatchIdMapper(), new Object[0]);
    }

    @Override
    public Collection<String> getReadyQueues(String sourceNodeId) {
        Collection<String> queues = this.readyQueuesCache.get(sourceNodeId);
        if (queues == null) {
            queues = new HashSet<String>();
        }
        return queues;
    }

    @Override
    public void setReadyQueues(String sourceNodeId, Collection<String> queues) {
        this.readyQueuesCache.put(sourceNodeId, queues);
    }

    static class IncomingBatchMapper
    implements ISqlRowMapper<IncomingBatch> {
        IncomingBatch batchToRefresh = null;

        public IncomingBatchMapper(IncomingBatch batchToRefresh) {
            this.batchToRefresh = batchToRefresh;
        }

        public IncomingBatchMapper() {
        }

        public IncomingBatch mapRow(Row rs) {
            IncomingBatch batch = this.batchToRefresh != null ? this.batchToRefresh : new IncomingBatch();
            batch.setBatchId(rs.getLong("batch_id"));
            batch.setNodeId(rs.getString("node_id"));
            batch.setChannelId(rs.getString("channel_id"));
            batch.setStatusFromString(rs.getString("status"));
            batch.setRouterMillis(rs.getLong("router_millis"));
            batch.setNetworkMillis(rs.getLong("network_millis"));
            batch.setFilterMillis(rs.getLong("filter_millis"));
            batch.setLoadMillis(rs.getLong("load_millis"));
            batch.setExtractMillis(rs.getLong("extract_millis"));
            batch.setTransformExtractMillis(rs.getLong("transform_extract_millis"));
            batch.setTransformLoadMillis(rs.getLong("transform_load_millis"));
            batch.setFailedRowNumber(rs.getLong("failed_row_number"));
            batch.setFailedLineNumber(rs.getLong("failed_line_number"));
            batch.setByteCount(rs.getLong("byte_count"));
            batch.setLoadFlag(rs.getBoolean("load_flag"));
            batch.setExtractCount(rs.getLong("extract_count"));
            batch.setSentCount(rs.getLong("sent_count"));
            batch.setLoadCount(rs.getLong("load_count"));
            batch.setDataRowCount(rs.getLong("data_row_count"));
            batch.setLoadRowCount(rs.getLong("load_row_count"));
            batch.setExtractRowCount(rs.getLong("extract_row_count"));
            batch.setReloadRowCount(rs.getLong("reload_row_count"));
            batch.setDataInsertRowCount(rs.getLong("data_insert_row_count"));
            batch.setDataUpdateRowCount(rs.getLong("data_update_row_count"));
            batch.setDataDeleteRowCount(rs.getLong("data_delete_row_count"));
            batch.setLoadInsertRowCount(rs.getLong("load_insert_row_count"));
            batch.setLoadUpdateRowCount(rs.getLong("load_update_row_count"));
            batch.setLoadDeleteRowCount(rs.getLong("load_delete_row_count"));
            batch.setExtractInsertRowCount(rs.getLong("extract_insert_row_count"));
            batch.setExtractUpdateRowCount(rs.getLong("extract_update_row_count"));
            batch.setExtractDeleteRowCount(rs.getLong("extract_delete_row_count"));
            batch.setOtherRowCount(rs.getLong("other_row_count"));
            batch.setFallbackInsertCount(rs.getLong("fallback_insert_count"));
            batch.setFallbackUpdateCount(rs.getLong("fallback_update_count"));
            batch.setConflictWinCount(rs.getLong("conflict_win_count"));
            batch.setConflictLoseCount(rs.getLong("conflict_lose_count"));
            batch.setIgnoreCount(rs.getLong("ignore_count"));
            batch.setIgnoreRowCount(rs.getLong("ignore_row_count"));
            batch.setMissingDeleteCount(rs.getLong("missing_delete_count"));
            batch.setSkipCount(rs.getLong("skip_count"));
            batch.setSqlState(rs.getString("sql_state"));
            batch.setSqlCode(rs.getInt("sql_code"));
            batch.setSqlMessage(rs.getString("sql_message"));
            batch.setLastUpdatedHostName(rs.getString("last_update_hostname"));
            batch.setLastUpdatedTime(rs.getDateTime("last_update_time"));
            batch.setCreateTime(rs.getDateTime("create_time"));
            batch.setErrorFlag(rs.getBoolean("error_flag"));
            batch.setSummary(rs.getString("summary"));
            batch.setLoadId(rs.getLong("load_id"));
            batch.setCommonFlag(rs.getBoolean("common_flag"));
            batch.setFailedDataId(rs.getLong("failed_data_id"));
            batch.setBulkLoaderFlag(rs.getBoolean("bulk_loader_flag"));
            return batch;
        }
    }

    static class BatchIdMapper
    implements ISqlRowMapper<BatchId> {
        Map<String, BatchId> ids;

        public BatchIdMapper() {
        }

        public BatchIdMapper(Map<String, BatchId> ids) {
            this.ids = ids;
        }

        public BatchId mapRow(Row rs) {
            BatchId batch = new BatchId();
            batch.setBatchId(rs.getLong("batch_id"));
            batch.setNodeId(rs.getString("node_id"));
            if (this.ids != null) {
                this.ids.put(rs.getString("channel_id"), batch);
            }
            return batch;
        }
    }

    static class IncomingBatchSummaryMapper
    implements ISqlRowMapper<IncomingBatchSummary> {
        boolean withNode = false;
        boolean withChannel = false;

        public IncomingBatchSummaryMapper(boolean withNode, boolean withChannel) {
            this.withNode = withNode;
            this.withChannel = withChannel;
        }

        public IncomingBatchSummary mapRow(Row rs) {
            IncomingBatchSummary summary = new IncomingBatchSummary();
            if (this.withNode) {
                summary.setNodeId(rs.getString("node_id"));
            }
            if (this.withChannel) {
                summary.setChannel(rs.getString("channel_id"));
            }
            summary.setBatchCount(rs.getInt("batches"));
            summary.setDataCount(rs.getInt("data"));
            summary.setStatus(AbstractBatch.Status.valueOf(rs.getString("status")));
            summary.setOldestBatchCreateTime(rs.getDateTime("oldest_batch_time"));
            summary.setLastBatchUpdateTime(rs.getDateTime("last_update_time"));
            summary.setTotalBytes(rs.getLong("total_bytes"));
            summary.setTotalMillis(rs.getLong("total_millis"));
            summary.setErrorFlag(rs.getBoolean("error_flag"));
            summary.setMinBatchId(rs.getLong("batch_id"));
            summary.setInsertCount(rs.getInt("insert_event_count"));
            summary.setUpdateCount(rs.getInt("update_event_count"));
            summary.setDeleteCount(rs.getInt("delete_event_count"));
            summary.setOtherCount(rs.getInt("other_event_count"));
            summary.setOtherCount(rs.getInt("reload_event_count"));
            summary.setRouterMillis(rs.getLong("total_router_millis"));
            summary.setExtractMillis(rs.getLong("total_extract_millis"));
            summary.setTransferMillis(rs.getLong("total_network_millis"));
            summary.setLoadMillis(rs.getLong("total_load_millis"));
            return summary;
        }
    }

    static class LastCaptureByChannelMapper
    implements ISqlRowMapper<String> {
        private Map<String, Date> captureMap;

        public LastCaptureByChannelMapper(Map<String, Date> map) {
            this.captureMap = map;
        }

        public Map<String, Date> getCaptureMap() {
            return this.captureMap;
        }

        public String mapRow(Row row) {
            this.captureMap.put(row.getString("CHANNEL_ID"), row.getDateTime("LAST_UPDATE_TIME"));
            return null;
        }
    }
}

