/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IPullService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.impl.AbstractOfflineDetectorService;

public class PullService
extends AbstractOfflineDetectorService
implements IPullService,
INodeCommunicationService.INodeCommunicationExecutor {
    private INodeService nodeService;
    private IRegistrationService registrationService;
    private IClusterService clusterService;
    private INodeCommunicationService nodeCommunicationService;
    private IDataLoaderService dataLoaderService;
    private IIncomingBatchService incomingBatchService;
    private IConfigurationService configurationService;

    public PullService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect(), engine.getExtensionService());
        this.nodeService = engine.getNodeService();
        this.registrationService = engine.getRegistrationService();
        this.clusterService = engine.getClusterService();
        this.nodeCommunicationService = engine.getNodeCommunicationService();
        this.dataLoaderService = engine.getDataLoaderService();
        this.incomingBatchService = engine.getIncomingBatchService();
        this.configurationService = engine.getConfigurationService();
    }

    @Override
    public synchronized RemoteNodeStatuses pullData(boolean force) {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses(this.configurationService.getChannels(false));
        Node identity = this.nodeService.findIdentity();
        if (identity == null || identity.isSyncEnabled()) {
            long minimumPeriodMs = this.parameterService.getLong("pull.period.minimum.ms", -1L);
            if (force || !this.clusterService.isInfiniteLocked("Pull")) {
                if (!this.registrationService.registerWithServer()) {
                    identity = this.nodeService.findIdentity();
                    if (identity != null) {
                        List<NodeCommunication> nodes = this.nodeCommunicationService.list(NodeCommunication.CommunicationType.PULL);
                        int availableThreads = this.nodeCommunicationService.getAvailableThreads(NodeCommunication.CommunicationType.PULL);
                        boolean m2mLoadInProgress = this.configurationService.isMasterToMaster() && this.nodeService.isDataLoadStarted();
                        nodes = this.filterForReadyQueues(nodes);
                        for (NodeCommunication nodeCommunication : nodes) {
                            NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(nodeCommunication.getNodeId(), true);
                            boolean meetsMinimumTime = true;
                            if (minimumPeriodMs > 0L && nodeCommunication.getLastLockTime() != null && System.currentTimeMillis() - nodeCommunication.getLastLockTime().getTime() < minimumPeriodMs) {
                                meetsMinimumTime = false;
                            }
                            boolean m2mLockout = false;
                            if (m2mLoadInProgress) {
                                boolean bl = m2mLockout = identity.getCreatedAtNodeId() != null && "registration".equals(nodeSecurity.getInitialLoadCreateBy()) && !identity.getCreatedAtNodeId().equals(nodeCommunication.getNodeId());
                                if (m2mLockout) {
                                    this.log.debug("Not pulling from node {} until initial load from {} is complete", (Object)nodeCommunication.getNodeId(), (Object)identity.getCreatedAtNodeId());
                                }
                            }
                            if (availableThreads > 0 && meetsMinimumTime && !m2mLockout && nodeSecurity != null && !nodeSecurity.isRegistrationEnabled() && this.nodeCommunicationService.execute(nodeCommunication, statuses, this)) {
                                --availableThreads;
                            }
                            nodeCommunication.setBatchToSendCount(0L);
                        }
                    }
                } else {
                    identity = this.nodeService.findIdentity();
                    this.log.info("Node {}:{} just registered, not pulling yet", (Object)(identity != null ? identity.getNodeGroupId() : ""), (Object)(identity != null ? identity.getNodeId() : ""));
                }
            } else {
                this.log.debug("Did not run the pull process because it has been stopped");
            }
        }
        return statuses;
    }

    protected List<NodeCommunication> filterForReadyQueues(List<NodeCommunication> nodes) {
        List<NodeCommunication> filteredNodes = nodes;
        if (this.parameterService.is("sync.use.ready.queues") && this.configurationService.getQueues(false).size() > 1 && !this.parameterService.is("route.on.extract")) {
            filteredNodes = new ArrayList<NodeCommunication>();
            for (NodeCommunication nodeCommunication : nodes) {
                Collection<String> readyQueues = this.incomingBatchService.getReadyQueues(nodeCommunication.getNodeId());
                if (!nodeCommunication.getQueue().equals("default") && !readyQueues.contains(nodeCommunication.getQueue())) continue;
                filteredNodes.add(nodeCommunication);
            }
        }
        return filteredNodes;
    }

    @Override
    public void execute(NodeCommunication nodeCommunication, RemoteNodeStatus status) {
        Node node = nodeCommunication.getNode();
        boolean immediatePullIfDataFound = this.parameterService.is("pull.immediate.if.data.found", false);
        if (StringUtils.isNotBlank((CharSequence)node.getSyncUrl()) || !this.parameterService.isRegistrationServer()) {
            long lastBatchesProcessed = 0L;
            long lastDataProcessed = 0L;
            long cumulativeBatchesProcessed = 0L;
            long cumulativeDataProcessed = 0L;
            do {
                this.log.debug("Pull requested for {}", (Object)node);
                if (lastBatchesProcessed > 0L) {
                    if (this.nodeService.isDataLoadStarted()) {
                        this.log.info("Immediate pull requested while in reload mode");
                    } else {
                        this.log.debug("Immediate pull requested while data found");
                    }
                }
                try {
                    this.dataLoaderService.loadDataFromPull(node, status);
                    this.fireOnline(node, status);
                }
                catch (Exception ex) {
                    this.fireOffline(ex, node, status);
                }
                lastBatchesProcessed = status.getBatchesProcessed() - cumulativeBatchesProcessed;
                lastDataProcessed = status.getDataProcessed() - cumulativeDataProcessed;
                if (!(status.failed() || lastDataProcessed <= 0L && lastBatchesProcessed <= 0L)) {
                    this.log.info("Pull data received from {} on queue {}. {} rows and {} batches were processed. ({})", new Object[]{node.toString(), nodeCommunication.getQueue(), lastDataProcessed, lastBatchesProcessed, status.getTableSummary()});
                } else if (status.failed()) {
                    this.log.debug("There was a failure while pulling data from {} on queue {}. {} rows and {} batches were processed. ({})", new Object[]{node.toString(), nodeCommunication.getQueue(), lastDataProcessed, lastBatchesProcessed, status.getTableSummary()});
                }
                cumulativeDataProcessed = status.getDataProcessed();
                cumulativeBatchesProcessed = status.getBatchesProcessed();
                status.resetTableSummary();
                if (!Thread.interrupted()) continue;
                throw new SymmetricException("Thread was interrupted", new Object[0]);
            } while ((immediatePullIfDataFound || this.nodeService.isDataLoadStarted()) && !status.failed() && lastBatchesProcessed > 0L);
        } else {
            this.log.warn("Cannot pull node '{}' in the group '{}'.  The sync url is blank", (Object)node.getNodeId(), (Object)node.getNodeGroupId());
        }
    }

    @Override
    public RemoteNodeStatus pullConfigData(boolean force) {
        Node local = this.nodeService.findIdentity();
        RemoteNodeStatus status = null;
        if (this.parameterService.is("auto.sync.config.after.upgrade", true) && !this.parameterService.isRegistrationServer() && local != null && (force || !Version.version().equals(local.getConfigVersion()))) {
            Node remote = new Node();
            remote.setSyncUrl(this.parameterService.getRegistrationUrl());
            status = new RemoteNodeStatus(remote.getNodeId(), "config", this.configurationService.getChannels(false));
            try {
                this.dataLoaderService.loadDataFromConfig(remote, status, force);
            }
            catch (Exception e) {
                this.fireOffline(e, remote, status);
            }
        }
        return status;
    }
}

