/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.exception.SecurityException;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.file.FileTransportManager;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.symmetric.transport.http.SelfSignedX509TrustManager;
import org.jumpmind.symmetric.transport.http.SimpleHostnameVerifier;
import org.jumpmind.symmetric.transport.internal.InternalTransportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(TransportManagerFactory.class);
    private static boolean isStaticInitialized;
    private ISymmetricEngine symmetricEngine;

    public TransportManagerFactory(ISymmetricEngine symmetricEngine) {
        this.symmetricEngine = symmetricEngine;
    }

    public static synchronized void initHttps(String httpSslVerifiedServerNames, boolean allowSelfSignedCerts, boolean enableHttps2) {
        try {
            if (!isStaticInitialized) {
                if (!StringUtils.isBlank((CharSequence)httpSslVerifiedServerNames)) {
                    SimpleHostnameVerifier hostnameVerifier = new SimpleHostnameVerifier(httpSslVerifiedServerNames);
                    HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
                }
                if (allowSelfSignedCerts) {
                    TransportManagerFactory.initSelfSignedSocketFactory(enableHttps2);
                }
                isStaticInitialized = true;
            }
        }
        catch (GeneralSecurityException ex) {
            throw new SecurityException(ex);
        }
    }

    public ITransportManager create() {
        return this.create(this.symmetricEngine.getParameterService().getString("transport.type"));
    }

    public ITransportManager create(String transport) {
        if ("http".equalsIgnoreCase(transport)) {
            String httpSslVerifiedServerNames = this.symmetricEngine.getParameterService().getString("https.verified.server.names");
            boolean allowSelfSignedCerts = this.symmetricEngine.getParameterService().is("https.allow.self.signed.certs", false);
            boolean https2Enabled = this.symmetricEngine.getParameterService().is("https2.enable", false);
            TransportManagerFactory.initHttps(httpSslVerifiedServerNames, allowSelfSignedCerts, https2Enabled);
            return this.createHttpTransportManager(this.symmetricEngine);
        }
        if ("file".equalsIgnoreCase(transport)) {
            return new FileTransportManager(this.symmetricEngine);
        }
        if ("internal".equalsIgnoreCase(transport)) {
            return new InternalTransportManager(this.symmetricEngine);
        }
        throw new IllegalStateException("An invalid transport type of " + transport + " was specified.");
    }

    protected HttpTransportManager createHttpTransportManager(ISymmetricEngine symmetricEngine) {
        String impl = symmetricEngine.getParameterService().getString("http.transport.manager.class");
        if (StringUtils.isEmpty((CharSequence)impl)) {
            return new HttpTransportManager(symmetricEngine);
        }
        String className = impl.trim();
        try {
            Class clazz = ClassUtils.getClass((String)className);
            HttpTransportManager httpTransportManager = null;
            for (Constructor<?> c : clazz.getConstructors()) {
                if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(ISymmetricEngine.class)) continue;
                httpTransportManager = (HttpTransportManager)c.newInstance(symmetricEngine);
            }
            if (httpTransportManager == null) {
                httpTransportManager = (HttpTransportManager)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return httpTransportManager;
        }
        catch (Exception ex) {
            throw new SymmetricException("Failed to create custom HttpTransportManager impl '" + impl + "'", ex);
        }
    }

    private static void initSelfSignedSocketFactory(boolean enableHttps2) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext context = SSLContext.getInstance("TLS");
        ISecurityService securityService = SecurityServiceFactory.create();
        KeyStore trustStore = null;
        try {
            trustStore = securityService.getTrustStore();
        }
        catch (Exception e) {
            log.warn("No trust store found: " + e.getMessage());
        }
        SelfSignedX509TrustManager trustManager = new SelfSignedX509TrustManager(trustStore);
        KeyManager[] keyManagers = null;
        try {
            keyManagers = securityService.getKeyManagerFactory().getKeyManagers();
        }
        catch (Exception e) {
            log.warn("No key managers found: " + e.getMessage());
        }
        context.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
    }
}

