/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.transport.BatchBufferedWriter;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;

public class FileOutgoingTransport
implements IOutgoingWithResponseTransport {
    String fileName;
    BatchBufferedWriter writer;
    OutputStream out;
    boolean open = true;
    Node remoteNode;
    String outgoingDir;
    private List<OutgoingBatch> processedBatches;

    public FileOutgoingTransport(Node remoteNode, Node localNode, String outgoingDir) {
        this.outgoingDir = outgoingDir;
        this.fileName = outgoingDir + File.separator + localNode.getNodeGroupId() + "-" + localNode.getNodeId() + "_to_" + remoteNode.getNodeGroupId() + "-" + remoteNode.getNodeId() + "_" + System.currentTimeMillis();
        this.remoteNode = remoteNode;
    }

    public String getOutgoingDir() {
        return this.outgoingDir;
    }

    @Override
    public BufferedWriter openWriter() {
        try {
            this.writer = new BatchBufferedWriter(new FileWriter(this.fileName + ".tmp"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.writer;
    }

    @Override
    public BufferedWriter getWriter() {
        return this.writer;
    }

    @Override
    public OutputStream openStream() {
        try {
            this.out = new FileOutputStream(this.fileName + ".tmp");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.out;
    }

    @Override
    public BufferedReader readResponse() throws IOException {
        List<Object> batchIds = new ArrayList();
        if (this.processedBatches != null) {
            for (OutgoingBatch processedBatch : this.processedBatches) {
                batchIds.add(processedBatch.getBatchId());
            }
        } else if (this.writer != null) {
            batchIds = this.writer.getBatchIds();
        }
        StringBuilder resp = new StringBuilder();
        for (Long l : batchIds) {
            resp.append("batch-").append(l).append("=").append("ok").append("&");
            resp.append("nodeId-").append(l).append("=").append(this.remoteNode.getNodeId()).append("&");
        }
        return new BufferedReader(new StringReader(resp.toString()));
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists(IConfigurationService configurationService, String queue, Node targetNode) {
        return configurationService.getSuspendIgnoreChannelLists();
    }

    public void complete(boolean success) {
        if (!success) {
            new File(this.fileName + ".tmp").delete();
        } else if (this.writer != null) {
            new File(this.fileName + ".tmp").renameTo(new File(this.fileName + ".csv"));
        } else {
            new File(this.fileName + ".tmp").renameTo(new File(this.fileName + ".zip"));
        }
    }

    public List<OutgoingBatch> getProcessedBatches() {
        return this.processedBatches;
    }

    public void setProcessedBatches(List<OutgoingBatch> processedBatches) {
        this.processedBatches = processedBatches;
    }
}

