/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.file;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.file.FileIncomingTransport;
import org.jumpmind.symmetric.transport.file.FileOutgoingTransport;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.util.FormatUtils;

public class FileTransportManager
extends HttpTransportManager
implements ITransportManager {
    protected IParameterService parameterService;

    public FileTransportManager(ISymmetricEngine engine) {
        super(engine);
        this.parameterService = engine.getParameterService();
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, String registrationUrl) throws IOException {
        return 200;
    }

    @Override
    public void writeAcknowledgement(OutputStream out, Node remote, List<IncomingBatch> list, Node local, String securityToken) throws IOException {
    }

    @Override
    public IIncomingTransport getFilePullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        return this.getPullTransport(remote, local, securityToken, requestProperties, registrationUrl);
    }

    @Override
    public IOutgoingWithResponseTransport getFilePushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        return this.getPushTransport(remote, local, securityToken, registrationUrl);
    }

    @Override
    public IIncomingTransport getPullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        return new FileIncomingTransport(remote, local, this.getDirName("node.offline.incoming.dir", local), this.getDirName("node.offline.archive.dir", local), this.getDirName("node.offline.error.dir", local));
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        return new FileOutgoingTransport(remote, local, this.getDirName("node.offline.outgoing.dir", local));
    }

    protected String getDirName(String paramName, Node localNode) {
        File dir;
        String dirName = this.parameterService.getString(paramName);
        dirName = FormatUtils.replace((String)"nodeGroupId", (String)localNode.getNodeGroupId(), (String)dirName);
        dirName = FormatUtils.replace((String)"nodeId", (String)localNode.getNodeId(), (String)dirName);
        if (StringUtils.isNotBlank((CharSequence)dirName) && !(dir = new File(dirName)).exists()) {
            dir.mkdirs();
        }
        return dirName;
    }
}

