/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jumpmind.exception.HttpException;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationPendingException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.AuthenticationExpiredException;
import org.jumpmind.symmetric.transport.ConnectionDuplicateException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.NoContentException;
import org.jumpmind.symmetric.transport.ServiceNotReadyException;
import org.jumpmind.symmetric.transport.ServiceUnavailableException;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;

public class HttpIncomingTransport
implements IIncomingTransport {
    private HttpTransportManager httpTransportManager;
    private HttpConnection connection;
    private BufferedReader reader;
    private InputStream is;
    private IParameterService parameterService;
    private int httpTimeout;
    private String redirectionUrl;
    private String nodeId;
    private String securityToken;
    private Map<String, String> requestProperties;

    public HttpIncomingTransport(HttpTransportManager httpTransportManager, HttpConnection connection, IParameterService parameterService) {
        this.httpTransportManager = httpTransportManager;
        this.connection = connection;
        this.parameterService = parameterService;
        this.httpTimeout = parameterService.getInt("http.timeout.ms");
    }

    public HttpIncomingTransport(HttpTransportManager httpTransportManager, HttpConnection connection, IParameterService parameterService, Map<String, String> requestProperties) {
        this(httpTransportManager, connection, parameterService);
        this.requestProperties = requestProperties;
    }

    public HttpIncomingTransport(HttpTransportManager httpTransportManager, HttpConnection connection, IParameterService parameterService, String nodeId, String securityToken) {
        this(httpTransportManager, connection, parameterService);
        this.nodeId = nodeId;
        this.securityToken = securityToken;
    }

    @Override
    public String getUrl() {
        return this.connection.getURL().toExternalForm();
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.reader != null;
    }

    @Override
    public String getRedirectionUrl() {
        return this.redirectionUrl;
    }

    @Override
    public InputStream openStream() throws IOException {
        this.applyRequestProperties();
        boolean manualRedirects = this.parameterService.is("http.manual.redirects.enabled", true);
        if (manualRedirects) {
            this.connection = this.openConnectionCheckRedirects();
        }
        int code = this.connection.getResponseCode();
        switch (code) {
            case 656: {
                throw new RegistrationNotOpenException();
            }
            case 657: {
                throw new RegistrationRequiredException();
            }
            case 667: {
                throw new RegistrationPendingException();
            }
            case 658: {
                throw new SyncDisabledException();
            }
            case 670: {
                throw new ConnectionRejectedException();
            }
            case 605: {
                throw new ConnectionDuplicateException();
            }
            case 660: {
                throw new ServiceUnavailableException();
            }
            case 671: {
                throw new ServiceNotReadyException();
            }
            case 659: {
                this.httpTransportManager.clearSession(this.connection);
                throw new AuthenticationException();
            }
            case 669: {
                this.httpTransportManager.clearSession(this.connection);
                throw new AuthenticationExpiredException();
            }
            case 204: {
                throw new NoContentException();
            }
            case 200: {
                this.httpTransportManager.updateSession(this.connection);
                this.is = HttpTransportManager.getInputStreamFrom(this.connection);
                return this.is;
            }
        }
        throw new HttpException(code, "Received an unexpected response code of " + code + " from the server");
    }

    @Override
    public BufferedReader openReader() throws IOException {
        InputStream stream = this.openStream();
        this.reader = TransportUtils.toReader(stream);
        return this.reader;
    }

    @Override
    public Map<String, String> getHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (String name : this.connection.getHeaderFields().keySet()) {
            if (name == null) continue;
            headers.put(name, this.connection.getHeaderField(name));
        }
        return headers;
    }

    private HttpConnection openConnectionCheckRedirects() throws IOException {
        boolean redir;
        int redirects = 0;
        do {
            this.connection.setInstanceFollowRedirects(false);
            redir = false;
            int stat = this.connection.getResponseCode();
            if (stat < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = this.connection.getURL();
            this.redirectionUrl = this.connection.getHeaderField("Location");
            URL target = null;
            if (this.redirectionUrl != null) {
                target = new URL(base, this.redirectionUrl);
            }
            this.connection.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            this.connection = this.httpTransportManager.openConnection(target, this.nodeId, this.securityToken);
            this.connection.setConnectTimeout(this.httpTimeout);
            this.connection.setReadTimeout(this.httpTimeout);
            this.applyRequestProperties();
            ++redirects;
        } while (redir);
        return this.connection;
    }

    protected void applyRequestProperties() throws IOException {
        if (this.requestProperties != null) {
            this.connection.setRequestMethod("POST");
            this.connection.setDoOutput(true);
            try (OutputStream os = this.connection.getOutputStream();){
                this.httpTransportManager.writeRequestProperties(this.requestProperties, os);
            }
        }
    }

    public HttpConnection getConnection() {
        return this.connection;
    }

    public Map<String, String> getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }
}

