/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.internal.InternalIncomingTransport;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingWithResponseTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTransportManager
extends AbstractTransportManager
implements ITransportManager {
    private static final Logger log = LoggerFactory.getLogger(InternalTransportManager.class);
    protected ISymmetricEngine symmetricEngine;

    public InternalTransportManager(ISymmetricEngine engine) {
        super(engine.getExtensionService());
        this.symmetricEngine = engine;
    }

    @Override
    public IIncomingTransport getFilePullTransport(Node remote, final Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        final PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        this.runAtClient(remote.getSyncUrl(), null, respOs, new IClientRunnable(){

            @Override
            public void run(ISymmetricEngine engine, InputStream is, OutputStream os) throws Exception {
                InternalOutgoingTransport transport = new InternalOutgoingTransport(respOs, null);
                ProcessInfo processInfo = engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(engine.getNodeService().findIdentityNodeId(), local.getNodeId(), ProcessType.FILE_SYNC_PULL_HANDLER));
                try {
                    engine.getFileSyncService().sendFiles(processInfo, local, transport);
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                catch (RuntimeException ex) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                    throw ex;
                }
                transport.close();
            }
        });
        return new InternalIncomingTransport(respIs);
    }

    @Override
    public IIncomingTransport getPullTransport(Node remote, final Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        final PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        final ChannelMap suspendIgnoreChannels = this.symmetricEngine.getConfigurationService().getSuspendIgnoreChannelLists(remote.getNodeId());
        this.runAtClient(remote.getSyncUrl(), null, respOs, new IClientRunnable(){

            @Override
            public void run(ISymmetricEngine engine, InputStream is, OutputStream os) throws Exception {
                InternalOutgoingTransport transport = new InternalOutgoingTransport(respOs, suspendIgnoreChannels, StandardCharsets.UTF_8.name());
                ProcessInfo processInfo = engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(engine.getNodeService().findIdentityNodeId(), local.getNodeId(), ProcessType.PULL_HANDLER_EXTRACT));
                try {
                    engine.getDataExtractorService().extract(processInfo, local, transport);
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                catch (RuntimeException ex) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                    throw ex;
                }
                transport.close();
            }
        });
        return new InternalIncomingTransport(respIs);
    }

    @Override
    public IIncomingTransport getPingTransport(Node remote, Node local, String registrationUrl) throws IOException {
        return null;
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node targetNode, Node sourceNode, String securityToken, String registrationUrl) throws IOException {
        return this.getPushTransport(targetNode, sourceNode, securityToken, null, registrationUrl);
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, final Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        PipedOutputStream pushOs = new PipedOutputStream();
        final PipedInputStream pushIs = new PipedInputStream(pushOs);
        final PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        this.runAtClient(remote.getSyncUrl(), pushIs, respOs, new IClientRunnable(){

            @Override
            public void run(ISymmetricEngine engine, InputStream is, OutputStream os) throws Exception {
                engine.getDataLoaderService().loadDataFromPush(local, pushIs, respOs);
            }
        });
        return new InternalOutgoingWithResponseTransport(pushOs, respIs);
    }

    @Override
    public IOutgoingWithResponseTransport getFilePushTransport(Node targetNode, final Node sourceNode, String securityToken, String registrationUrl) throws IOException {
        PipedOutputStream pushOs = new PipedOutputStream();
        PipedInputStream pushIs = new PipedInputStream(pushOs);
        PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        this.runAtClient(targetNode.getSyncUrl(), pushIs, respOs, new IClientRunnable(){

            @Override
            public void run(ISymmetricEngine engine, InputStream is, OutputStream os) {
                engine.getFileSyncService().loadFilesFromPush(sourceNode.getNodeId(), is, os);
            }
        });
        return new InternalOutgoingWithResponseTransport(pushOs, respIs);
    }

    @Override
    public IIncomingTransport getRegisterTransport(Node client, String registrationUrl) throws IOException {
        return this.getRegisterTransport(client, registrationUrl, null);
    }

    @Override
    public IIncomingTransport getRegisterTransport(final Node client, String registrationUrl, Map<String, String> requestProperties) throws IOException {
        PipedOutputStream respOs = new PipedOutputStream();
        PipedInputStream respIs = new PipedInputStream(respOs);
        this.runAtClient(registrationUrl, null, respOs, new IClientRunnable(){

            @Override
            public void run(ISymmetricEngine engine, InputStream is, OutputStream os) throws Exception {
                engine.getRegistrationService().registerNode(client, os, false);
            }
        });
        return new InternalIncomingTransport(respIs);
    }

    @Override
    public IOutgoingWithResponseTransport getRegisterPushTransport(Node remote, Node local) throws IOException {
        return null;
    }

    @Override
    public int sendCopyRequest(Node local) throws IOException {
        return -1;
    }

    @Override
    public int sendStatusRequest(Node local, Map<String, String> statuses) throws IOException {
        return -1;
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, String registrationUrl) throws IOException {
        return this.sendAcknowledgement(remote, list, local, securityToken, null, registrationUrl);
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        try {
            if (list != null && list.size() > 0) {
                ISymmetricEngine remoteEngine = this.getTargetEngine(remote.getSyncUrl());
                String ackData = this.getAcknowledgementData(remote.requires13Compatiblity(), local.getNodeId(), list);
                List<BatchAck> batches = this.readAcknowledgement(ackData);
                for (BatchAck batchInfo : batches) {
                    remoteEngine.getAcknowledgeService().ack(batchInfo);
                }
            }
            return 200;
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return -1;
        }
    }

    @Override
    public void writeAcknowledgement(OutputStream out, Node remote, List<IncomingBatch> list, Node local, String securityToken) throws IOException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
        pw.println(this.getAcknowledgementData(remote.requires13Compatiblity(), local.getNodeId(), list));
        pw.close();
    }

    private void runAtClient(final String url, final InputStream is, final OutputStream os, final IClientRunnable runnable) {
        new Thread(){

            @Override
            public void run() {
                try {
                    ISymmetricEngine engine = InternalTransportManager.this.getTargetEngine(url);
                    runnable.run(engine, is, os);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
    }

    private ISymmetricEngine getTargetEngine(String url) {
        ISymmetricEngine engine = AbstractSymmetricEngine.findEngineByUrl(url);
        if (engine == null) {
            throw new NullPointerException("Could not find the engine reference for the following url: " + url);
        }
        return engine;
    }

    @Override
    public IIncomingTransport getConfigTransport(Node remote, Node local, String securityToken, String symmetricVersion, String configVersion, String registrationUrl) throws IOException {
        return null;
    }

    @Override
    public IOutgoingWithResponseTransport getBandwidthPushTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        return null;
    }

    @Override
    public IIncomingTransport getComparePullTransport(Node remote, Node local, String securityToken, String registrationUrl, Map<String, String> requestParameters) throws IOException {
        return null;
    }

    @Override
    public IOutgoingWithResponseTransport getComparePushTransport(Node remote, Node local, String securityToken, String registrationUrl, Map<String, String> requestParameters) throws IOException {
        return null;
    }

    static interface IClientRunnable {
        public void run(ISymmetricEngine var1, InputStream var2, OutputStream var3) throws Exception;
    }
}

