/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.DefaultParameterParser;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.util.TypedPropertiesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreTypedPropertiesFactory
extends TypedPropertiesFactory {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<String> keystoreParametersList;
    private Map<String, DefaultParameterParser.ParameterMetaData> parameterMetaData = ParameterConstants.getParameterMetaData();
    private ISecurityService securityService = SecurityServiceFactory.create();
    private String engineName;

    @Override
    public void init(File propertiesFile, Properties properties) {
        super.init(propertiesFile, properties);
        String keystoreParameters = System.getProperty("symmetric.parameters.saved.in.keystore");
        if (keystoreParameters != null && keystoreParameters.length() > 0) {
            this.keystoreParametersList = Arrays.asList(keystoreParameters.split(","));
        }
        if (this.keystoreParametersList != null) {
            for (String param : this.keystoreParametersList) {
                DefaultParameterParser.ParameterMetaData metaData = this.parameterMetaData.get(param.trim());
                if (metaData == null || !metaData.isDatabaseOverridable()) continue;
                this.log.error("Parameter {} is set up as a keystore parameter, but only startup parameters can be configured that way");
                throw new IllegalStateException("Parameter " + param + " is set up as a keystore parameter, but only startup parameters can be configured that way.");
            }
        }
    }

    @Override
    public TypedProperties reload() {
        TypedProperties typedProperties = super.reload();
        if (typedProperties.containsKey((Object)"engine.name")) {
            this.engineName = typedProperties.get("engine.name");
        }
        return this.getKeystoreValues(typedProperties);
    }

    @Override
    public TypedProperties reload(File propFile) {
        TypedProperties typedProperties = super.reload(propFile);
        if (typedProperties.containsKey((Object)"engine.name")) {
            this.engineName = typedProperties.get("engine.name");
        }
        return this.getKeystoreValues(typedProperties);
    }

    @Override
    public TypedProperties reload(Properties properties) {
        TypedProperties typedProperties = super.reload(properties);
        if (typedProperties.containsKey((Object)"engine.name")) {
            this.engineName = typedProperties.get("engine.name").toString();
        }
        return typedProperties;
    }

    @Override
    public void save(Properties properties, File propFile, String comments) throws IOException {
        for (Object key : properties.keySet()) {
            String keyString = key == null ? "" : key.toString();
            if (!this.isParameterSavedInKeystore(keyString)) continue;
            Object value = properties.get(key);
            Object valueString = value == null ? "" : value.toString();
            String keystoreKey = this.getKeystoreParameterKey(keyString);
            if (((String)valueString).length() > 0) {
                try {
                    this.securityService.setKeystoreEntry(keystoreKey, (String)valueString);
                    valueString = "ks:" + keystoreKey;
                    properties.put(key, valueString);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            try {
                this.securityService.deleteKeystoreEntry(keystoreKey);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        super.save(properties, propFile, comments);
    }

    private TypedProperties getKeystoreValues(TypedProperties typedProperties) {
        for (Object key : typedProperties.keySet()) {
            Object value;
            String valueString;
            String keyString = key == null ? "" : key.toString();
            if (!this.isParameterSavedInKeystore(keyString) || !StringUtils.startsWith((CharSequence)(valueString = (value = typedProperties.get(key)) == null ? "" : value.toString()), (CharSequence)"ks:")) continue;
            String keystoreKey = this.getKeystoreParameterKey(keyString);
            try {
                valueString = this.securityService.getKeystoreEntry(keystoreKey);
                typedProperties.put(key, (Object)valueString);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return typedProperties;
    }

    private boolean isParameterSavedInKeystore(String key) {
        return this.keystoreParametersList != null && this.keystoreParametersList.contains(key);
    }

    private String getKeystoreParameterKey(String key) {
        return (String)(this.engineName != null ? this.engineName + "." : "") + key;
    }
}

