/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.jumpmind.db.platform.AbstractDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;

public abstract class AbstractJdbcDatabasePlatform
extends AbstractDatabasePlatform {
    protected DataSource dataSource;
    protected ISqlTemplate sqlTemplate;
    protected ISqlTemplate sqlTemplateDirty;

    public AbstractJdbcDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(settings);
        this.dataSource = dataSource;
        this.ddlBuilder = this.createDdlBuilder();
        this.sqlTemplate = this.createSqlTemplate();
        this.sqlTemplateDirty = this.createSqlTemplateDirty();
        this.ddlReader = this.createDdlReader();
    }

    protected abstract IDdlBuilder createDdlBuilder();

    protected abstract IDdlReader createDdlReader();

    protected ISqlTemplate createSqlTemplate() {
        return new JdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    protected ISqlTemplate createSqlTemplateDirty() {
        JdbcSqlTemplate sqlTemplateDirty = new JdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
        sqlTemplateDirty.setIsolationLevel(1);
        return sqlTemplateDirty;
    }

    public ISqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    public ISqlTemplate getSqlTemplateDirty() {
        return this.sqlTemplateDirty;
    }

    public <T> T getDataSource() {
        return (T)this.dataSource;
    }

    public void resetDataSource() {
        if (this.dataSource instanceof BasicDataSource) {
            BasicDataSource dbcp = (BasicDataSource)this.dataSource;
            try {
                dbcp.close();
            }
            catch (SQLException e) {
                throw this.sqlTemplate.translate((Throwable)e);
            }
        }
    }
}

